/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CGC;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.internal.swing.DisabledStatePanel;
import org.eclipse.swt.internal.swing.NullGraphics2D;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    public Container handle;
    Composite parent;
    Menu menu;
    Object layoutData;
    Accessible accessible;
    Image backgroundImage;
    private DisabledStatePanel disabledStatePanel;
    String toolTipText;
    private volatile long mouseHoverTimeStamp;
    private volatile Thread mouseHoverThread;
    private MouseEvent mouseHoverEvent;
    boolean isTraversing;
    int lastPressedKeyCode;
    char lastPressedKeyChar;
    static Runnable focusLostRunnable;
    boolean isAdjustingSize;
    static boolean isDragging;
    static final Point DEFAULT_EVENT_OFFSET;

    Control() {
    }

    public Control(Composite composite, int n2) {
        super(composite, n2);
        this.parent = composite;
        this.createWidget();
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(focusListener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseListener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseTrackListener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseMoveListener);
        this.addListener(5, typedListener);
    }

    public void addPaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(paintListener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(traverseListener);
        this.addListener(31, typedListener);
    }

    public Point computeSize(int n2, int n3) {
        return this.computeSize(n2, n3, true);
    }

    public Point computeSize(int n2, int n3, boolean bl) {
        this.checkWidget();
        Container container = ((CControl)((Object)this.handle)).getClientArea();
        Dimension dimension = this.handle.getPreferredSize();
        Dimension dimension2 = container.getPreferredSize();
        if (container != this.handle) {
            Insets insets = container.getInsets();
            dimension2.width -= insets.left + insets.right;
            dimension2.height -= insets.top + insets.bottom;
        }
        int n4 = dimension.width;
        int n5 = dimension.height;
        if (n2 != -1) {
            n4 = n2 + n4 - dimension2.width;
        }
        if (n3 != -1) {
            n5 = n3 + n5 - dimension2.height;
        }
        return new Point(n4, n5);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control computeTabRoot() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            int n2;
            for (n2 = 0; n2 < controlArray.length && controlArray[n2] != this; ++n2) {
            }
            if (n2 == controlArray.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    void createHandleInit() {
    }

    Container createHandle() {
        if (this.handle != null) {
            return this.handle;
        }
        this.error(2);
        return null;
    }

    boolean autoAddChildren() {
        return true;
    }

    void createWidget() {
        Serializable serializable;
        this.checkOrientation(this.parent);
        this.createHandleInit();
        this.handle = this.createHandle();
        if (!(this.handle instanceof CControl)) {
            throw new IllegalStateException("The widget should implement the CComponent interface!");
        }
        if (this.handle instanceof Window) {
            serializable = ((Window)this.handle).getSize();
            ((Window)this.handle).pack();
            this.handle.setSize((Dimension)serializable);
        }
        if (this.parent != null && !(this.handle instanceof Window) && this.parent.autoAddChildren()) {
            serializable = ((CControl)((Object)this.parent.handle)).getClientArea();
            if (!this.parent.isLayoutManaged()) {
                ((Container)serializable).setLayout(null);
            }
            ((Container)serializable).add(this.handle);
            this.updateBackgroundMode();
            ((JComponent)serializable).revalidate();
            ((Component)serializable).repaint();
        }
        this.register();
    }

    void deregister() {
        this.display.removeControl(this.handle);
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    char findMnemonic(String string) {
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return '\u0000';
            }
            if (string.charAt(n2) != '&') {
                return string.charAt(n2);
            }
            if (++n2 >= n3) break;
        }
        return '\u0000';
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        shell2.fixShell(shell, this);
        decorations2.fixDecorations(decorations, this, menuArray);
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.handle.isFocusable()) {
            return false;
        }
        if (!this.isVisible()) {
            Window window = SwingUtilities.getWindowAncestor(this.handle);
            if (window != null && !window.isVisible()) {
                this.getShell().setInitialFocusedControl(this);
                return true;
            }
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        Window window = SwingUtilities.getWindowAncestor(this.handle);
        if (window != null) {
            window.setFocusableWindowState(true);
        }
        this.handle.requestFocus();
        return true;
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        return Color.swing_new(this.display, ((CControl)((Object)this.handle)).getUserAttributeHandler().getBackground());
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        return this.backgroundImage;
    }

    public int getBorderWidth() {
        this.checkWidget();
        Rectangle rectangle = this.handle.getBounds();
        Rectangle rectangle2 = ((CControl)((Object)this.handle)).getClientArea().getBounds();
        return Math.max((rectangle.width - rectangle2.width + 1) / 2, (rectangle.height - rectangle2.height + 1) / 2);
    }

    public org.eclipse.swt.graphics.Rectangle getBounds() {
        this.checkWidget();
        Rectangle rectangle = this.handle.getBounds();
        Point point = this.parent == null ? new Point(0, 0) : this.parent.getInternalOffset();
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x + point.x, rectangle.y + point.y, rectangle.width, rectangle.height);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.handle.isEnabled();
    }

    public Font getFont() {
        this.checkWidget();
        return Font.swing_new(this.display, ((CControl)((Object)this.handle)).getUserAttributeHandler().getFont());
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.swing_new(this.display, ((CControl)((Object)this.handle)).getUserAttributeHandler().getForeground());
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        java.awt.Point point = this.handle.getLocation();
        Point point2 = this.parent == null ? new Point(0, 0) : this.parent.getInternalOffset();
        return new Point(point.x + point2.x, point.y + point2.y);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        GraphicsConfiguration graphicsConfiguration = this.handle.getGraphicsConfiguration();
        Monitor monitor = new Monitor();
        monitor.handle = graphicsConfiguration;
        Rectangle rectangle = graphicsConfiguration.getBounds();
        monitor.x = rectangle.x;
        monitor.y = rectangle.y;
        monitor.width = rectangle.width;
        monitor.height = rectangle.height;
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        monitor.clientX = rectangle.x + insets.left;
        monitor.clientY = rectangle.y + insets.top;
        monitor.clientWidth = rectangle.width - insets.left - insets.right;
        monitor.clientHeight = rectangle.height - insets.top - insets.bottom;
        return monitor;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int n2 = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++n2;
            control = control.parent;
        }
        control = this;
        Control[] controlArray = new Control[n2];
        while (control != shell) {
            controlArray[--n2] = control;
            control = control.parent;
        }
        return controlArray;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        Dimension dimension = this.handle.getSize();
        return new Point(dimension.width, dimension.height);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.handle.isVisible();
    }

    public CGC internal_new_GC(GCData gCData) {
        this.checkWidget();
        if (gCData != null) {
            int n2 = 0x6000000;
            if ((gCData.style & n2) != 0) {
                gCData.layout = (gCData.style & 0x4000000) == 0;
            } else {
                gCData.style = !this.handle.getComponentOrientation().isLeftToRight() ? (gCData.style |= 0xC000000) : (gCData.style |= 0x2000000);
            }
            gCData.device = this.display;
            gCData.foreground = this.handle.getForeground();
            gCData.background = this.handle.getBackground();
            gCData.hFont = this.handle.getFont();
        }
        return new CGC.CGCGraphics2D(){
            protected Graphics2D internalSwingGraphics2D;
            protected Graphics2D graphics2D;
            protected boolean isAdjusting;

            public Graphics2D getGraphics() {
                if (this.isAdjusting) {
                    return this.graphics2D;
                }
                Container clientArea = ((CControl)((Object)Control.this.handle)).getClientArea();
                Graphics2D sGraphics2D = clientArea instanceof JComponent ? (Graphics2D)((JComponent)clientArea).getClientProperty("SWTSwingGraphics2DClientProperty") : null;
                boolean resetClip = false;
                if (this.internalSwingGraphics2D != sGraphics2D || sGraphics2D == null || this.graphics2D == null || this.graphics2D instanceof NullGraphics2D) {
                    Graphics2D newGraphics2D = (Graphics2D)clientArea.getGraphics();
                    if (newGraphics2D == null) {
                        newGraphics2D = new NullGraphics2D();
                        newGraphics2D.setBackground(clientArea.getBackground());
                        newGraphics2D.setColor(clientArea.getForeground());
                        newGraphics2D.setFont(clientArea.getFont());
                    }
                    Point internalOffset = Control.this.getInternalOffset();
                    newGraphics2D.translate(-internalOffset.x, -internalOffset.y);
                    if (this.graphics2D != null) {
                        resetClip = true;
                        newGraphics2D.setBackground(this.graphics2D.getBackground());
                        newGraphics2D.setColor(this.graphics2D.getColor());
                        newGraphics2D.setComposite(this.graphics2D.getComposite());
                        newGraphics2D.setFont(this.graphics2D.getFont());
                        newGraphics2D.setPaint(this.graphics2D.getPaint());
                        newGraphics2D.setRenderingHints(this.graphics2D.getRenderingHints());
                        newGraphics2D.setStroke(this.graphics2D.getStroke());
                        newGraphics2D.setTransform(this.graphics2D.getTransform());
                    }
                    this.graphics2D = newGraphics2D;
                    this.internalSwingGraphics2D = sGraphics2D;
                }
                if (resetClip) {
                    this.isAdjusting = true;
                    this.setUserClip(this.getUserClip());
                    this.isAdjusting = false;
                }
                return this.graphics2D;
            }

            public Dimension getDeviceSize() {
                return ((CControl)((Object)Control.this.handle)).getClientArea().getSize();
            }
        };
    }

    public void internal_dispose_GC(CGC cGC, GCData gCData) {
        this.checkWidget();
        cGC.dispose();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.display.findControl(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == this;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isTabGroup() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                if (controlArray[i2] != this) continue;
                return true;
            }
        }
        return this.handle.isFocusable();
    }

    boolean isTabItem() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                if (controlArray[i2] != this) continue;
                return false;
            }
        }
        return !this.isTabGroup();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.handle.isShowing();
    }

    void markLayout(boolean bl, boolean bl2) {
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char c2) {
        return false;
    }

    boolean mnemonicMatch(char c2) {
        return false;
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        Container container = this.handle.getParent();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.handle == control.handle) {
                return;
            }
            if (this.parent != control.parent) {
                return;
            }
            if (!Compatibility.IS_JAVA_5_OR_GREATER) {
                boolean bl = false;
                for (int i2 = container.getComponentCount() - 1; i2 >= 0; --i2) {
                    boolean bl2 = bl = control.handle == this.handle;
                    if (container.getComponent(i2) != control.handle) continue;
                    container.remove(this.handle);
                    container.add((Component)this.handle, bl ? i2 : i2 - 1);
                    this.handle.invalidate();
                    container.validate();
                    container.repaint();
                    break;
                }
                return;
            }
            int n2 = container.getComponentZOrder(control.handle);
            int n3 = container.getComponentZOrder(this.handle);
            if (n3 < n2) {
                --n2;
            }
            container.setComponentZOrder(this.handle, n2);
        } else {
            if (!Compatibility.IS_JAVA_5_OR_GREATER) {
                container.remove(this.handle);
                container.add((Component)this.handle, 0);
                this.handle.invalidate();
                container.validate();
                container.repaint();
                return;
            }
            container.setComponentZOrder(this.handle, 0);
        }
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        Container container = this.handle.getParent();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.handle == control.handle) {
                return;
            }
            if (this.parent != control.parent) {
                return;
            }
            if (!Compatibility.IS_JAVA_5_OR_GREATER) {
                boolean bl = false;
                for (int i2 = container.getComponentCount() - 1; i2 >= 0; --i2) {
                    boolean bl2 = bl = control.handle == this.handle;
                    if (container.getComponent(i2) != control.handle) continue;
                    container.remove(this.handle);
                    container.add((Component)this.handle, bl ? i2 : i2 + 1);
                    this.handle.invalidate();
                    container.validate();
                    container.repaint();
                    break;
                }
                return;
            }
            int n2 = container.getComponentZOrder(control.handle);
            int n3 = container.getComponentZOrder(this.handle);
            if (n3 < n2) {
                --n2;
            }
            container.setComponentZOrder(this.handle, n2 + 1);
        } else {
            if (!Compatibility.IS_JAVA_5_OR_GREATER) {
                container.remove(this.handle);
                container.add(this.handle);
                this.handle.invalidate();
                container.validate();
                container.repaint();
                return;
            }
            container.setComponentZOrder(this.handle, container.getComponentCount() - 1);
        }
    }

    Accessible new_Accessible(Control control) {
        return Accessible.internal_new_Accessible(this);
    }

    GC new_GC(GCData gCData) {
        return GC.swing_new(this, gCData);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean bl) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, bl));
    }

    public void redraw() {
        this.checkWidget();
        this.handle.repaint();
    }

    public void redraw(int n2, int n3, int n4, int n5, boolean bl) {
        this.checkWidget();
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        ((CControl)((Object)this.handle)).getClientArea().repaint(n2 - 1, n3 - 1, n4 + 2, n5 + 2);
    }

    void register() {
        this.display.addControl(this.handle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = null;
        this.parent = null;
    }

    void releaseParent() {
        Container container = this.handle.getParent();
        if (container != null) {
            container.remove(this.handle);
            ((JComponent)container).revalidate();
            container.repaint();
        }
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        if (focusLostRunnable != null && this.getShell().getActiveControl() == this) {
            focusLostRunnable.run();
        }
        super.releaseWidget();
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.deregister();
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        if (this.disabledStatePanel != null) {
            this.disabledStatePanel.release();
            this.disabledStatePanel = null;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, focusListener);
        this.eventTable.unhook(16, focusListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    public void removeMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, mouseTrackListener);
        this.eventTable.unhook(7, mouseTrackListener);
        this.eventTable.unhook(32, mouseTrackListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, mouseListener);
        this.eventTable.unhook(4, mouseListener);
        this.eventTable.unhook(8, mouseListener);
    }

    public void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, mouseMoveListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, paintListener);
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, traverseListener);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            ((CControl)((Object)this.handle)).getUserAttributeHandler().setBackground(color.handle);
        } else {
            ((CControl)((Object)this.handle)).getUserAttributeHandler().setBackground(null);
        }
        this.handle.repaint();
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            if (image.type != 0) {
                this.error(5);
            }
        }
        if (this.backgroundImage == image) {
            return;
        }
        this.backgroundImage = image;
        ((CControl)((Object)this.handle)).setBackgroundImage(this.backgroundImage == null ? null : this.backgroundImage.handle);
        this.handle.repaint();
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        Point point = this.parent == null ? new Point(0, 0) : this.parent.getInternalOffset();
        Rectangle rectangle = this.handle.getBounds();
        if (rectangle.x == (n2 -= point.x) && rectangle.y == (n3 -= point.y) && rectangle.width == n4 && rectangle.height == n5) {
            return;
        }
        this.handle.setBounds(n2, n3, n4, n5);
        if (rectangle.width != n4 || rectangle.height != n5) {
            ((CControl)((Object)this.handle)).getClientArea().invalidate();
            this.handle.validate();
            this.processEvent(new ComponentEvent(this.handle, 101));
        }
        if (rectangle.x != n2 || rectangle.y != n3) {
            this.processEvent(new ComponentEvent(this.handle, 100));
        }
        this.handle.repaint();
    }

    public void setBounds(org.eclipse.swt.graphics.Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setCapture(boolean bl) {
        this.checkWidget();
        if (bl) {
            Utils.capturedControl = this;
        } else if (Utils.capturedControl == this) {
            Utils.capturedControl = null;
        }
    }

    void sendMouseEvent(int n2, Event event) {
        if (Utils.capturedControl == null || Utils.capturedControl == this) {
            this.sendEvent(n2, event);
            return;
        }
        Control control = Utils.capturedControl;
        switch (n2) {
            case 3: 
            case 4: {
                Utils.capturedControl = null;
            }
        }
        java.awt.Point point = SwingUtilities.convertPoint(this.handle, event.x, event.y, control.handle);
        event.x = point.x;
        event.y = point.y;
        control.sendEvent(n2, event);
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null) {
            if (cursor.isDisposed()) {
                SWT.error(5);
            }
            ((CControl)((Object)this.handle)).getUserAttributeHandler().setCursor(cursor.handle);
        } else {
            ((CControl)((Object)this.handle)).getUserAttributeHandler().setCursor(null);
        }
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.handle.setEnabled(bl);
        if (bl) {
            if (this.disabledStatePanel != null) {
                this.disabledStatePanel.release();
                this.disabledStatePanel = null;
            }
        } else if (this.disabledStatePanel == null) {
            this.disabledStatePanel = new DisabledStatePanel(this);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null) {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            ((CControl)((Object)this.handle)).getUserAttributeHandler().setFont(font.handle);
        } else {
            ((CControl)((Object)this.handle)).getUserAttributeHandler().setFont(null);
        }
        this.handle.repaint();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            ((CControl)((Object)this.handle)).getUserAttributeHandler().setForeground(color.handle);
        } else {
            ((CControl)((Object)this.handle)).getUserAttributeHandler().setForeground(null);
        }
        this.handle.repaint();
    }

    public void setLayoutData(Object object) {
        this.checkWidget();
        this.layoutData = object;
    }

    public void setLocation(int n2, int n3) {
        this.checkWidget();
        Point point = this.parent == null ? new Point(0, 0) : this.parent.getInternalOffset();
        java.awt.Point point2 = this.handle.getLocation();
        if (point2.x == (n2 -= point.x) && point2.y == (n3 -= point.y)) {
            return;
        }
        this.handle.setLocation(n2, n3);
        if (point2.x != n2 || point2.y != n3) {
            this.processEvent(new ComponentEvent(this.handle, 100));
        }
        this.handle.repaint();
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    boolean setRadioFocus() {
        return false;
    }

    boolean setRadioSelection(boolean bl) {
        return false;
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        this.handle.setIgnoreRepaint(!bl);
    }

    public void setSize(int n2, int n3) {
        this.checkWidget();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        Dimension dimension = this.handle.getSize();
        this.handle.setSize(n2, n3);
        if (dimension.width != n2 || dimension.height != n3) {
            ((CControl)((Object)this.handle)).getClientArea().invalidate();
            this.handle.validate();
            this.processEvent(new ComponentEvent(this.handle, 101));
        }
        this.handle.repaint();
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.handle.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        ((CControl)((Object)this.handle)).setToolTipText(Utils.convertStringToHTML(string));
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        this.handle.setVisible(bl);
    }

    void sort(int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = n2 / 2; i2 > 0; i2 /= 2) {
            for (int i3 = i2; i3 < n2; ++i3) {
                for (int i4 = i3 - i2; i4 >= 0; i4 -= i2) {
                    if (nArray[i4] > nArray[i4 + i2]) continue;
                    int n3 = nArray[i4];
                    nArray[i4] = nArray[i4 + i2];
                    nArray[i4 + i2] = n3;
                }
            }
        }
    }

    public Point toControl(int n2, int n3) {
        this.checkWidget();
        java.awt.Point point = new java.awt.Point(n2, n3);
        Container container = this.handle;
        if (container instanceof RootPaneContainer) {
            container = ((RootPaneContainer)((Object)container)).getContentPane();
        }
        SwingUtilities.convertPointFromScreen(point, container);
        return new Point(point.x, point.y);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int n2, int n3) {
        this.checkWidget();
        java.awt.Point point = new java.awt.Point(n2, n3);
        Container container = this.handle;
        if (container instanceof RootPaneContainer) {
            container = ((RootPaneContainer)((Object)container)).getContentPane();
        }
        SwingUtilities.convertPointToScreen(point, container);
        return new Point(point.x, point.y);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    public boolean traverse(int n2) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = n2;
        return this.traverse(event);
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean bl) {
        int n2;
        int n3;
        Control control = this.computeTabRoot();
        Control control2 = this.computeTabGroup();
        Control[] controlArray = control.computeTabList();
        int n4 = controlArray.length;
        for (n3 = 0; n3 < n4 && controlArray[n3] != control2; ++n3) {
        }
        if (n3 == n4) {
            return false;
        }
        int n5 = n3;
        int n6 = n2 = bl ? 1 : -1;
        while ((n3 = (n3 + n2 + n4) % n4) != n5) {
            Control control3 = controlArray[n3];
            if (control3.isDisposed() || !control3.setTabGroupFocus()) continue;
            return true;
        }
        if (control2.isDisposed()) {
            return false;
        }
        return control2.setTabGroupFocus();
    }

    boolean traverseItem(boolean bl) {
        int n2;
        int n3;
        Control[] controlArray = this.parent._getChildren();
        int n4 = controlArray.length;
        for (n3 = 0; n3 < n4 && controlArray[n3] != this; ++n3) {
        }
        if (n3 == n4) {
            return false;
        }
        int n5 = n3;
        int n6 = n2 = bl ? 1 : -1;
        while ((n3 = (n3 + n2 + n4) % n4) != n5) {
            Control control = controlArray[n3];
            if (control.isDisposed() || !control.isTabItem() || !control.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseMnemonic(char c2) {
        return this.mnemonicHit(c2);
    }

    boolean traversePage(boolean bl) {
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    public void update() {
        this.checkWidget();
        Utils.paintComponentImmediately(this.handle);
    }

    void updateBackgroundMode() {
        switch (this.parent.getBackgroundMode()) {
            case 0: {
                ((CControl)((Object)this.handle)).setBackgroundInheritance(0);
                break;
            }
            case 1: {
                ((CControl)((Object)this.handle)).setBackgroundInheritance(1);
                break;
            }
            case 2: {
                ((CControl)((Object)this.handle)).setBackgroundInheritance(2);
            }
        }
        this.handle.repaint();
    }

    void updateLayout(boolean bl, boolean bl2) {
    }

    public boolean setParent(Composite composite) {
        this.checkWidget();
        if (composite == null) {
            this.error(4);
        }
        if (composite.isDisposed()) {
            SWT.error(5);
        }
        if (this.parent == composite) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        this.releaseParent();
        Shell shell = composite.getShell();
        Shell shell2 = this.getShell();
        Decorations decorations = composite.menuShell();
        Decorations decorations2 = this.menuShell();
        if (shell2 != shell || decorations2 != decorations) {
            Menu[] menuArray = shell2.findMenus(this);
            this.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        }
        ((CControl)((Object)composite.handle)).getClientArea().add(this.handle);
        this.updateBackgroundMode();
        return true;
    }

    void adjustMouseHoverState(MouseEvent mouseEvent) {
        this.mouseHoverTimeStamp = System.currentTimeMillis() + 500L;
        this.mouseHoverEvent = mouseEvent;
        if (this.mouseHoverThread == null) {
            this.mouseHoverThread = new Thread("Mouse Hover Thread"){

                public void run() {
                    while (Control.this.mouseHoverThread == this) {
                        try {
                            2.sleep(Math.max(50L, Control.this.mouseHoverTimeStamp - System.currentTimeMillis()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (Control.this.mouseHoverThread != this) {
                            return;
                        }
                        if (Control.this.mouseHoverTimeStamp - System.currentTimeMillis() >= 0L) continue;
                        2 t2 = this;
                        SwingUtilities.invokeLater(new Runnable(this, t2){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ Thread val$t;
                            {
                                this.this$1 = var1_1;
                                this.val$t = thread;
                            }

                            public void run() {
                                if (this.this$1.Control.this.mouseHoverThread != this.val$t) {
                                    return;
                                }
                                if (this.this$1.Control.this.mouseHoverTimeStamp - System.currentTimeMillis() < 0L) {
                                    this.this$1.Control.this.mouseHoverThread = null;
                                    MouseEvent me = this.this$1.Control.this.mouseHoverEvent;
                                    this.this$1.Control.this.mouseHoverEvent = null;
                                    if (!this.this$1.Control.this.isDisposed() && me.getComponent().contains(me.getPoint())) {
                                        UIThreadUtils.startExclusiveSection(this.this$1.Control.this.getDisplay());
                                        if (this.this$1.Control.this.isDisposed()) {
                                            UIThreadUtils.stopExclusiveSection();
                                            return;
                                        }
                                        try {
                                            try {
                                                this.this$1.Control.this.sendMouseEvent(32, this.this$1.Control.this.createMouseEvent(me, false));
                                            }
                                            catch (Throwable t2) {
                                                UIThreadUtils.storeException(t2);
                                            }
                                        }
                                        finally {
                                            UIThreadUtils.stopExclusiveSection();
                                        }
                                    }
                                }
                            }
                        });
                    }
                }
            };
            this.mouseHoverThread.setDaemon(true);
            this.mouseHoverThread.start();
        }
    }

    public void processEvent(EventObject eventObject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processEvent(AWTEvent aWTEvent) {
        Object object;
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 500: {
                object = (MouseEvent)aWTEvent;
                if (((MouseEvent)object).getClickCount() != 2) {
                    return;
                }
                if (Utils.capturedControl != null || this.hooks(8)) break;
                return;
            }
            case 800: {
                if (this.hooks(9)) break;
                return;
            }
            case 506: {
                if (Utils.capturedControl != null || this.hooks(29) || this.hooks(5) || this.hooks(32)) break;
                return;
            }
            case 503: {
                if (Utils.capturedControl != null || this.hooks(5) || this.hooks(32)) break;
                return;
            }
            case 501: {
                if (Utils.capturedControl != null || this.hooks(3) || this.menu != null) break;
                if (!this.hooks(35)) return;
                if (((MouseEvent)aWTEvent).isPopupTrigger()) break;
                return;
            }
            case 502: {
                isDragging = false;
                if (Utils.capturedControl != null || this.hooks(4) || this.menu != null) break;
                if (!this.hooks(35)) return;
                if (((MouseEvent)aWTEvent).isPopupTrigger()) break;
                return;
            }
            case 507: {
                Component component;
                Container container;
                if (Utils.capturedControl != null || this.hooks(37)) break;
                Object object2 = aWTEvent.getSource();
                if (object2 instanceof Component && !(object2 instanceof Window) && (container = (component = (Component)object2).getParent()) != null) {
                    MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
                    container.dispatchEvent(new MouseWheelEvent((Component)container, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), mouseWheelEvent.getX() + container.getX(), mouseWheelEvent.getY() + container.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
                    mouseWheelEvent.consume();
                }
                this.adjustMouseHoverState((MouseEvent)aWTEvent);
                return;
            }
            case 504: {
                if (this.hooks(6)) break;
                return;
            }
            case 505: {
                if (this.hooks(7)) break;
                this.mouseHoverThread = null;
                return;
            }
            case 401: {
                break;
            }
            case 402: {
                if (this.hooks(2)) break;
                this.lastPressedKeyCode = -1;
                this.lastPressedKeyChar = '\u0000';
                return;
            }
            case 400: {
                if (this.hooks(1)) break;
                this.isTraversing = false;
                return;
            }
            case 101: {
                if (this.hooks(11)) break;
                return;
            }
            case 100: {
                if (this.hooks(10)) break;
                return;
            }
            case 102: {
                if (this.hooks(22)) break;
                return;
            }
            case 103: {
                if (this.hooks(23)) break;
                return;
            }
            case 1004: {
                break;
            }
            case 1005: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.isDisposed()) {
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            return;
        }
        try {
            switch (n2) {
                case 800: {
                    object = new Event();
                    ((Event)object).gc = new GC(this);
                    org.eclipse.swt.graphics.Rectangle rectangle = this.getBounds();
                    ((Event)object).width = rectangle.width;
                    ((Event)object).height = rectangle.height;
                    this.sendEvent(9, (Event)object);
                    if (!(this instanceof Canvas)) return;
                    Canvas canvas = (Canvas)this;
                    if (canvas.caret == null) return;
                    canvas.caret.paintCaret(((Event)object).gc);
                    return;
                }
                case 506: {
                    if (!isDragging) {
                        isDragging = true;
                        object = (MouseEvent)aWTEvent;
                        this.sendEvent(29, this.createMouseEvent((MouseEvent)object, false));
                    }
                }
                case 503: {
                    object = (MouseEvent)aWTEvent;
                    this.sendMouseEvent(5, this.createMouseEvent((MouseEvent)object, false));
                    this.adjustMouseHoverState((MouseEvent)object);
                    return;
                }
                case 501: {
                    object = (MouseEvent)aWTEvent;
                    Event event = this.createMouseEvent((MouseEvent)object, true);
                    this.sendMouseEvent(3, event);
                    if (this.menu == null) {
                        if (!this.hooks(35)) return;
                    }
                    if (!((MouseEvent)object).isPopupTrigger()) return;
                    java.awt.Point point = new java.awt.Point(event.x, event.y);
                    SwingUtilities.convertPointToScreen(point, ((ComponentEvent)object).getComponent());
                    event.x = point.x;
                    event.y = point.y;
                    this.sendEvent(35, event);
                    this.showPopup((MouseEvent)object);
                    return;
                }
                case 502: {
                    object = (MouseEvent)aWTEvent;
                    Event event = this.createMouseEvent((MouseEvent)object, true);
                    this.sendMouseEvent(4, event);
                    if (this.menu == null) {
                        if (!this.hooks(35)) return;
                    }
                    if (!((MouseEvent)object).isPopupTrigger()) return;
                    java.awt.Point point = new java.awt.Point(event.x, event.y);
                    SwingUtilities.convertPointToScreen(point, ((ComponentEvent)object).getComponent());
                    event.x = point.x;
                    event.y = point.y;
                    this.sendEvent(35, event);
                    this.showPopup((MouseEvent)object);
                    return;
                }
                case 500: {
                    this.sendMouseEvent(8, this.createMouseEvent((MouseEvent)aWTEvent, false));
                    return;
                }
                case 507: {
                    this.sendMouseEvent(37, this.createMouseEvent((MouseEvent)aWTEvent, false));
                    this.adjustMouseHoverState((MouseEvent)aWTEvent);
                    return;
                }
                case 504: {
                    this.sendEvent(6, this.createMouseEvent((MouseEvent)aWTEvent, false));
                    return;
                }
                case 505: {
                    this.mouseHoverThread = null;
                    this.sendEvent(7, this.createMouseEvent((MouseEvent)aWTEvent, false));
                    return;
                }
                case 400: {
                    object = (KeyEvent)aWTEvent;
                    if ((((InputEvent)object).getModifiers() & 0x20) != 0) {
                        if (this.hooks(1)) {
                            KeyEvent keyEvent = new KeyEvent(((ComponentEvent)object).getComponent(), 402, ((InputEvent)object).getWhen(), ((InputEvent)object).getModifiers(), this.lastPressedKeyCode, ((KeyEvent)object).getKeyChar(), ((KeyEvent)object).getKeyLocation());
                            Event event = this.createKeyEvent(keyEvent);
                            event.stateMask |= 0x50000;
                            this.sendEvent(1, event);
                        }
                        this.lastPressedKeyChar = ((KeyEvent)object).getKeyChar();
                    }
                    this.isTraversing = false;
                    return;
                }
                case 401: {
                    int n3;
                    object = (KeyEvent)aWTEvent;
                    int n4 = ((KeyEvent)object).getKeyCode();
                    if (n4 == this.lastPressedKeyCode) {
                        n3 = 0;
                        switch (n4) {
                            case 16: 
                            case 17: 
                            case 18: {
                                n3 = 1;
                                break;
                            }
                        }
                        if (n3 != 0) {
                            return;
                        }
                    }
                    this.lastPressedKeyCode = n4;
                    n3 = 10;
                    if ((((InputEvent)object).getModifiers() & n3) == n3) {
                        boolean bl = true;
                        switch (n4) {
                            case 16: 
                            case 17: 
                            case 18: {
                                bl = false;
                                break;
                            }
                        }
                        if (bl) {
                            return;
                        }
                    }
                    this.lastPressedKeyChar = ((KeyEvent)object).getKeyChar();
                    if (this.isTraversalKey((KeyEvent)object)) {
                        this.isTraversing = this.processTraversalKey((KeyEvent)object);
                    }
                    if (this.isTraversing) return;
                    if (!this.hooks(1)) return;
                    this.sendEvent(1, this.createKeyEvent((KeyEvent)object));
                    return;
                }
                case 402: {
                    object = (KeyEvent)aWTEvent;
                    int n5 = 10;
                    boolean bl = true;
                    if ((((InputEvent)object).getModifiers() & n5) == n5) {
                        KeyEvent keyEvent = new KeyEvent(((ComponentEvent)object).getComponent(), 402, ((InputEvent)object).getWhen(), ((InputEvent)object).getModifiers(), this.lastPressedKeyCode, this.lastPressedKeyChar, ((KeyEvent)object).getKeyLocation());
                        this.sendEvent(2, this.createKeyEvent(keyEvent));
                        bl = false;
                    }
                    this.lastPressedKeyCode = -1;
                    this.lastPressedKeyChar = '\u0000';
                    if (!bl) return;
                    if (this.isTraversing) return;
                    this.sendEvent(2, this.createKeyEvent((KeyEvent)object));
                    return;
                }
                case 101: {
                    if (this.isAdjustingSize) return;
                    this.sendEvent(11);
                    return;
                }
                case 100: {
                    this.sendEvent(10);
                    return;
                }
                case 102: {
                    this.sendEvent(22);
                    return;
                }
                case 103: {
                    this.sendEvent(23);
                    return;
                }
                case 1004: {
                    if (focusLostRunnable != null) {
                        focusLostRunnable.run();
                    }
                    if (!((Widget)(object = this.getShell())).isDisposed()) {
                        ((Shell)object).setActiveControl(this);
                    }
                    this.sendEvent(15);
                    return;
                }
                case 1005: {
                    focusLostRunnable = object = new /* invalid duplicate definition of identical inner class */;
                    return;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
            return;
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }

    Point getInternalOffset() {
        Container container = ((CControl)((Object)this.handle)).getClientArea();
        if (container != this.handle && container.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)container.getParent();
            int n2 = 0;
            int n3 = 0;
            java.awt.Point point = jViewport.getViewPosition();
            n2 -= point.x;
            n3 -= point.y;
            JViewport jViewport2 = ((JScrollPane)jViewport.getParent()).getColumnHeader();
            if (jViewport2 != null && jViewport2.isVisible()) {
                n3 += jViewport2.getHeight();
            }
            return new Point(n2, n3);
        }
        return DEFAULT_EVENT_OFFSET;
    }

    protected boolean isTraversalKey(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 9: {
                return true;
            }
        }
        return false;
    }

    protected int getTraversalKeyDetail(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 9: {
                if ((keyEvent.getModifiersEx() & 0x40) != 0) {
                    return 8;
                }
                return 16;
            }
        }
        return -1;
    }

    protected boolean getTraversalKeyDefault(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 9: {
                return true;
            }
        }
        return false;
    }

    private boolean processTraversalKey(KeyEvent keyEvent) {
        Event event = this.createKeyEvent(keyEvent);
        event.detail = this.getTraversalKeyDetail(keyEvent);
        if (event.detail < 0) {
            throw new IllegalArgumentException("The traversal key does not define its action type!");
        }
        event.doit = this.getTraversalKeyDefault(keyEvent);
        if (this.hooks(31)) {
            event.doit = false;
            this.sendEvent(31, event);
        }
        this.validateTraversalKey(keyEvent, event);
        return event.doit;
    }

    protected void validateTraversalKey(KeyEvent keyEvent, Event event) {
        if (!event.doit) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 9: {
                keyEvent.consume();
                if ((keyEvent.getModifiersEx() & 0x40) != 0) {
                    this.traverse(8);
                    break;
                }
                this.traverse(16);
            }
        }
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (this.menu != null) {
            java.awt.Point point = new java.awt.Point(mouseEvent.getPoint());
            SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
            this.menu.setLocation(new Point(point.x, point.y));
            this.menu.setVisible(true);
        }
    }

    Event createMouseEvent(MouseEvent mouseEvent, boolean bl) {
        if (mouseEvent == null) {
            return null;
        }
        Event event = new Event();
        Container container = this.handle;
        java.awt.Point point = mouseEvent.getPoint();
        Component component = mouseEvent.getComponent();
        if (container instanceof RootPaneContainer) {
            container = ((RootPaneContainer)((Object)container)).getContentPane();
            point = SwingUtilities.convertPoint(component, point, container);
        } else {
            point = SwingUtilities.convertPoint(component, point, ((CControl)((Object)this.handle)).getClientArea());
        }
        Point point2 = this.getInternalOffset();
        event.x = point.x + point2.x;
        event.y = point.y + point2.y;
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            event.button = 1;
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            event.button = 2;
        } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            event.button = 3;
        }
        event.stateMask = bl ? Display.getPreviousInputState() : Display.getInputState();
        return event;
    }

    Event createKeyEvent(KeyEvent keyEvent) {
        int n2;
        int n3;
        if (keyEvent == null) {
            return null;
        }
        Event event = new Event();
        Container container = this.handle;
        if (container instanceof RootPaneContainer) {
            container = ((RootPaneContainer)((Object)container)).getContentPane();
        }
        if (((n3 = keyEvent.getModifiersEx()) & 0x400) != 0) {
            event.button = 1;
        } else if ((n3 & 0x800) != 0) {
            event.button = 2;
        } else if ((n3 & 0x1000) != 0) {
            event.button = 3;
        }
        char c2 = keyEvent.getKeyChar();
        if (c2 == '\uffff') {
            c2 = '\u0000';
        }
        if ((n2 = keyEvent.getKeyCode()) >= 65 && n2 <= 90) {
            event.keyCode = (char)(32 + n2);
        } else if (n2 >= 48 && n2 <= 57) {
            event.keyCode = (char)(0 + n2);
        }
        if (keyEvent.getKeyLocation() != 4) {
            switch (keyEvent.getKeyCode()) {
                case 18: {
                    event.keyCode = 65536;
                    break;
                }
                case 16: {
                    event.keyCode = 131072;
                    break;
                }
                case 17: {
                    event.keyCode = 262144;
                    break;
                }
                case 524: {
                    event.keyCode = 0x400000;
                    break;
                }
                case 38: {
                    event.keyCode = 0x1000001;
                    break;
                }
                case 40: {
                    event.keyCode = 0x1000002;
                    break;
                }
                case 37: {
                    event.keyCode = 0x1000003;
                    break;
                }
                case 39: {
                    event.keyCode = 0x1000004;
                    break;
                }
                case 33: {
                    event.keyCode = 0x1000005;
                    break;
                }
                case 34: {
                    event.keyCode = 0x1000006;
                    break;
                }
                case 36: {
                    event.keyCode = 0x1000007;
                    break;
                }
                case 35: {
                    event.keyCode = 0x1000008;
                    break;
                }
                case 155: {
                    event.keyCode = 0x1000009;
                    break;
                }
                case 8: {
                    event.keyCode = 8;
                    break;
                }
                case 10: {
                    event.keyCode = 13;
                    break;
                }
                case 127: {
                    event.keyCode = 127;
                    break;
                }
                case 27: {
                    event.keyCode = 27;
                    break;
                }
                case 9: {
                    event.keyCode = 9;
                    break;
                }
                case 112: {
                    event.keyCode = 0x100000A;
                    break;
                }
                case 113: {
                    event.keyCode = 0x100000B;
                    break;
                }
                case 114: {
                    event.keyCode = 0x100000C;
                    break;
                }
                case 115: {
                    event.keyCode = 0x100000D;
                    break;
                }
                case 116: {
                    event.keyCode = 0x100000E;
                    break;
                }
                case 117: {
                    event.keyCode = 0x100000F;
                    break;
                }
                case 118: {
                    event.keyCode = 0x1000010;
                    break;
                }
                case 119: {
                    event.keyCode = 0x1000011;
                    break;
                }
                case 120: {
                    event.keyCode = 0x1000012;
                    break;
                }
                case 121: {
                    event.keyCode = 0x1000013;
                    break;
                }
                case 122: {
                    event.keyCode = 0x1000014;
                    break;
                }
                case 123: {
                    event.keyCode = 0x1000015;
                    break;
                }
                case 61440: {
                    event.keyCode = 0x1000016;
                    break;
                }
                case 61441: {
                    event.keyCode = 0x1000017;
                    break;
                }
                case 61442: {
                    event.keyCode = 0x1000018;
                    break;
                }
                case 20: {
                    event.keyCode = 16777298;
                    break;
                }
                case 144: {
                    event.keyCode = 16777299;
                    break;
                }
                case 145: {
                    event.keyCode = 16777300;
                    break;
                }
                case 19: {
                    event.keyCode = 0x1000055;
                    break;
                }
                case 3: {
                    event.keyCode = 16777302;
                    break;
                }
                case 154: {
                    event.keyCode = 16777303;
                    break;
                }
                case 156: {
                    event.keyCode = 0x1000051;
                }
            }
        } else {
            switch (keyEvent.getKeyCode()) {
                case 106: {
                    event.keyCode = 16777258;
                    break;
                }
                case 107: {
                    event.keyCode = 16777259;
                    break;
                }
                case 10: {
                    event.keyCode = 0x1000050;
                    break;
                }
                case 109: {
                    event.keyCode = 16777261;
                    break;
                }
                case 110: {
                    event.keyCode = 16777262;
                    break;
                }
                case 111: {
                    event.keyCode = 16777263;
                    break;
                }
                case 96: {
                    event.keyCode = 0x1000030;
                    break;
                }
                case 97: {
                    event.keyCode = 0x1000031;
                    break;
                }
                case 98: {
                    event.keyCode = 16777266;
                    break;
                }
                case 99: {
                    event.keyCode = 0x1000033;
                    break;
                }
                case 100: {
                    event.keyCode = 16777268;
                    break;
                }
                case 101: {
                    event.keyCode = 16777269;
                    break;
                }
                case 102: {
                    event.keyCode = 16777270;
                    break;
                }
                case 103: {
                    event.keyCode = 16777271;
                    break;
                }
                case 104: {
                    event.keyCode = 16777272;
                    break;
                }
                case 105: {
                    event.keyCode = 16777273;
                    break;
                }
                case 61: {
                    event.keyCode = 16777277;
                }
            }
        }
        event.character = c2;
        event.stateMask = Display.getInputState();
        switch (event.keyCode) {
            case 65536: 
            case 131072: 
            case 262144: {
                if (keyEvent.getID() == 401) {
                    event.stateMask &= ~event.keyCode;
                    break;
                }
                event.stateMask |= event.keyCode;
            }
        }
        return event;
    }

    static /* synthetic */ Thread access$000(Control control) {
        return control.mouseHoverThread;
    }

    static /* synthetic */ long access$100(Control control) {
        return control.mouseHoverTimeStamp;
    }

    static /* synthetic */ Thread access$002(Control control, Thread thread) {
        control.mouseHoverThread = thread;
        return control.mouseHoverThread;
    }

    static /* synthetic */ MouseEvent access$300(Control control) {
        return control.mouseHoverEvent;
    }

    static /* synthetic */ MouseEvent access$302(Control control, MouseEvent mouseEvent) {
        control.mouseHoverEvent = mouseEvent;
        return control.mouseHoverEvent;
    }

    static {
        DEFAULT_EVENT_OFFSET = new Point(0, 0);
    }
}

