/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class FormLayout
extends Layout {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int marginLeft = 0;
    public int marginTop = 0;
    public int marginRight = 0;
    public int marginBottom = 0;
    public int spacing = 0;

    int computeHeight(Control control, FormData formData, boolean bl) {
        FormAttachment formAttachment = formData.getTopAttachment(control, this.spacing, bl);
        FormAttachment formAttachment2 = formData.getBottomAttachment(control, this.spacing, bl);
        FormAttachment formAttachment3 = formAttachment2.minus(formAttachment);
        if (formAttachment3.numerator == 0) {
            if (formAttachment2.numerator == 0) {
                return formAttachment2.offset;
            }
            if (formAttachment2.numerator == formAttachment2.denominator) {
                return -formAttachment.offset;
            }
            if (formAttachment2.offset <= 0) {
                return -formAttachment.offset * formAttachment.denominator / formAttachment2.numerator;
            }
            int n2 = formAttachment2.denominator - formAttachment2.numerator;
            return formAttachment2.denominator * formAttachment2.offset / n2;
        }
        return formAttachment3.solveY(formData.getHeight(control, bl));
    }

    protected Point computeSize(Composite composite, int n2, int n3, boolean bl) {
        Point point = this.layout(composite, false, 0, 0, n2, n3, bl);
        if (n2 != -1) {
            point.x = n2;
        }
        if (n3 != -1) {
            point.y = n3;
        }
        return point;
    }

    protected boolean flushCache(Control control) {
        Object object = control.getLayoutData();
        if (object != null) {
            ((FormData)object).flushCache();
        }
        return true;
    }

    String getName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, string.length());
    }

    int computeWidth(Control control, FormData formData, boolean bl) {
        FormAttachment formAttachment = formData.getLeftAttachment(control, this.spacing, bl);
        FormAttachment formAttachment2 = formData.getRightAttachment(control, this.spacing, bl);
        FormAttachment formAttachment3 = formAttachment2.minus(formAttachment);
        if (formAttachment3.numerator == 0) {
            if (formAttachment2.numerator == 0) {
                return formAttachment2.offset;
            }
            if (formAttachment2.numerator == formAttachment2.denominator) {
                return -formAttachment.offset;
            }
            if (formAttachment2.offset <= 0) {
                return -formAttachment.offset * formAttachment.denominator / formAttachment.numerator;
            }
            int n2 = formAttachment2.denominator - formAttachment2.numerator;
            return formAttachment2.denominator * formAttachment2.offset / n2;
        }
        return formAttachment3.solveY(formData.getWidth(control, bl));
    }

    protected void layout(Composite composite, boolean bl) {
        Rectangle rectangle = composite.getClientArea();
        int n2 = rectangle.x + this.marginLeft + this.marginWidth;
        int n3 = rectangle.y + this.marginTop + this.marginHeight;
        int n4 = Math.max(0, rectangle.width - this.marginLeft - 2 * this.marginWidth - this.marginRight);
        int n5 = Math.max(0, rectangle.height - this.marginTop - 2 * this.marginHeight - this.marginBottom);
        this.layout(composite, true, n2, n3, n4, n5, bl);
    }

    Point layout(Composite composite, boolean bl, int n2, int n3, int n4, int n5, boolean bl2) {
        FormData formData;
        Control control;
        int n6;
        Rectangle[] rectangleArray;
        Control[] controlArray = composite.getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            rectangleArray = controlArray[i2];
            FormData formData2 = (FormData)rectangleArray.getLayoutData();
            if (formData2 == null) {
                formData2 = new FormData();
                rectangleArray.setLayoutData(formData2);
            }
            if (bl2) {
                formData2.flushCache();
            }
            formData2.cacheBottom = null;
            formData2.cacheTop = null;
            formData2.cacheRight = null;
            formData2.cacheLeft = null;
        }
        boolean[] blArray = null;
        rectangleArray = null;
        int n7 = 0;
        int n8 = 0;
        for (n6 = 0; n6 < controlArray.length; ++n6) {
            control = controlArray[n6];
            formData = (FormData)control.getLayoutData();
            if (n4 != -1) {
                formData.needed = false;
                FormAttachment formAttachment = formData.getLeftAttachment(control, this.spacing, bl2);
                FormAttachment formAttachment2 = formData.getRightAttachment(control, this.spacing, bl2);
                int n9 = formAttachment.solveX(n4);
                int n10 = formAttachment2.solveX(n4);
                if (formData.height == -1 && !formData.needed) {
                    int n11 = 0;
                    if (control instanceof Scrollable) {
                        Rectangle rectangle = ((Scrollable)control).computeTrim(0, 0, 0, 0);
                        n11 = rectangle.width;
                    } else {
                        n11 = control.getBorderWidth() * 2;
                    }
                    formData.cacheHeight = -1;
                    formData.cacheWidth = -1;
                    int n12 = Math.max(0, n10 - n9 - n11);
                    formData.computeSize(control, n12, formData.height, bl2);
                    if (blArray == null) {
                        blArray = new boolean[controlArray.length];
                    }
                    blArray[n6] = true;
                }
                n7 = Math.max(n10, n7);
                if (!bl) continue;
                if (rectangleArray == null) {
                    rectangleArray = new Rectangle[controlArray.length];
                }
                rectangleArray[n6] = new Rectangle(0, 0, 0, 0);
                rectangleArray[n6].x = n2 + n9;
                rectangleArray[n6].width = n10 - n9;
                continue;
            }
            n7 = Math.max(this.computeWidth(control, formData, bl2), n7);
        }
        for (n6 = 0; n6 < controlArray.length; ++n6) {
            control = controlArray[n6];
            formData = (FormData)control.getLayoutData();
            if (n5 != -1) {
                int n13 = formData.getTopAttachment(control, this.spacing, bl2).solveX(n5);
                int n14 = formData.getBottomAttachment(control, this.spacing, bl2).solveX(n5);
                n8 = Math.max(n14, n8);
                if (!bl) continue;
                ((Rectangle)((Object)rectangleArray[n6])).y = n3 + n13;
                ((Rectangle)((Object)rectangleArray[n6])).height = n14 - n13;
                continue;
            }
            n8 = Math.max(this.computeHeight(control, formData, bl2), n8);
        }
        for (n6 = 0; n6 < controlArray.length; ++n6) {
            control = controlArray[n6];
            formData = (FormData)control.getLayoutData();
            if (blArray != null && blArray[n6] != false) {
                formData.cacheHeight = -1;
                formData.cacheWidth = -1;
            }
            formData.cacheBottom = null;
            formData.cacheTop = null;
            formData.cacheRight = null;
            formData.cacheLeft = null;
        }
        if (bl) {
            for (n6 = 0; n6 < controlArray.length; ++n6) {
                controlArray[n6].setBounds((Rectangle)((Object)rectangleArray[n6]));
            }
        }
        return new Point(n7 += this.marginLeft + this.marginWidth * 2 + this.marginRight, n8 += this.marginTop + this.marginHeight * 2 + this.marginBottom);
    }

    public String toString() {
        String string = this.getName() + " {";
        if (this.marginWidth != 0) {
            string = string + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = string + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string = string + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginRight != 0) {
            string = string + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginTop != 0) {
            string = string + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginBottom != 0) {
            string = string + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.spacing != 0) {
            string = string + "spacing=" + this.spacing + " ";
        }
        string = string.trim();
        string = string + "}";
        return string;
    }
}

