/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public class DrawData {
    public int style;
    public int[] state = new int[1];
    public Rectangle clientArea;
    public static final int SELECTED = 2;
    public static final int FOCUSED = 4;
    public static final int PRESSED = 8;
    public static final int ACTIVE = 16;
    public static final int DISABLED = 32;
    public static final int HOT = 64;
    public static final int DEFAULTED = 128;
    public static final int GRAYED = 256;
    public static final int DRAW_LEFT = 16;
    public static final int DRAW_TOP = 32;
    public static final int DRAW_RIGHT = 64;
    public static final int DRAW_BOTTOM = 128;
    public static final int DRAW_HCENTER = 256;
    public static final int DRAW_VCENTER = 512;
    public static final int WIDGET_NOWHERE = -1;
    public static final int WIDGET_WHOLE = 0;
    public static final int SCROLLBAR_UP_ARROW = 1;
    public static final int SCROLLBAR_DOWN_ARROW = 2;
    public static final int SCROLLBAR_LEFT_ARROW = 1;
    public static final int SCROLLBAR_RIGHT_ARROW = 2;
    public static final int SCROLLBAR_UP_TRACK = 3;
    public static final int SCROLLBAR_DOWN_TRACK = 4;
    public static final int SCROLLBAR_LEFT_TRACK = 3;
    public static final int SCROLLBAR_RIGHT_TRACK = 4;
    public static final int SCROLLBAR_THUMB = 5;
    public static final int SCALE_UP_TRACK = 1;
    public static final int SCALE_LEFT_TRACK = 1;
    public static final int SCALE_DOWN_TRACK = 2;
    public static final int SCALE_RIGHT_TRACK = 2;
    public static final int SCALE_THUMB = 3;
    public static final int TOOLITEM_ARROW = 1;
    public static final int COMBO_ARROW = 1;
    static final char[] EDIT = new char[]{'E', 'D', 'I', 'T', '\u0000'};
    static final char[] COMBOBOX = new char[]{'C', 'O', 'M', 'B', 'O', 'B', 'O', 'X', '\u0000'};
    static final char[] BUTTON = new char[]{'B', 'U', 'T', 'T', 'O', 'N', '\u0000'};
    static final char[] PROGRESS = new char[]{'P', 'R', 'O', 'G', 'R', 'E', 'S', 'S', '\u0000'};
    static final char[] SCROLLBAR = new char[]{'S', 'C', 'R', 'O', 'L', 'L', 'B', 'A', 'R', '\u0000'};
    static final char[] TAB = new char[]{'T', 'A', 'B', '\u0000'};
    static final char[] TRACKBAR = new char[]{'T', 'R', 'A', 'C', 'K', 'B', 'A', 'R', '\u0000'};
    static final char[] TOOLBAR = new char[]{'T', 'O', 'O', 'L', 'B', 'A', 'R', '\u0000'};
    static final char[] TREEVIEW = new char[]{'T', 'R', 'E', 'E', 'V', 'I', 'E', 'W', '\u0000'};

    Rectangle computeTrim(Theme theme, GC gC) {
        return new Rectangle(this.clientArea.x, this.clientArea.y, this.clientArea.width, this.clientArea.height);
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
    }

    void drawImage(Theme theme, Image image, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            Rectangle rectangle2 = image.getBounds();
            gC.drawImage(image, 0, 0, rectangle2.width, rectangle2.height, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    void drawText(Theme theme, String string, int n2, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n3 = OS.OpenThemeData((int)0, (char[])this.getClassId());
            char[] cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
            int n4 = 32;
            if ((n2 & 0x10) != 0) {
                n4 |= 0;
            }
            if ((n2 & 0x100) != 0) {
                n4 |= 1;
            }
            if ((n2 & 0x40) != 0) {
                n4 |= 2;
            }
            if ((n2 & 0x20) != 0) {
                n4 |= 0;
            }
            if ((n2 & 0x80) != 0) {
                n4 |= 8;
            }
            if ((n2 & 0x200) != 0) {
                n4 |= 4;
            }
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rectangle.x + rectangle.width;
            rECT.top = rectangle.y;
            rECT.bottom = rectangle.y + rectangle.height;
            int[] nArray = this.getPartId(0);
            int n5 = nArray[0];
            int n6 = nArray[1];
            OS.DrawThemeText((int)n3, (int)gC.handle, (int)n5, (int)n6, (char[])cArray, (int)cArray.length, (int)n4, (int)0, (RECT)rECT);
            OS.CloseThemeData((int)n3);
        }
    }

    char[] getClassId() {
        return BUTTON;
    }

    int[] getPartId(int n2) {
        return new int[]{0, 0};
    }

    Rectangle getBounds(int n2, Rectangle rectangle) {
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        return -1;
    }

    Rectangle measureText(Theme theme, String string, int n2, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n3 = OS.OpenThemeData((int)0, (char[])this.getClassId());
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n4 = 0;
        if ((this.style & 0x4000) != 0) {
            n4 |= 0;
        }
        if ((this.style & 0x1000000) != 0) {
            n4 |= 1;
        }
        if ((this.style & 0x20000) != 0) {
            n4 |= 2;
        }
        RECT rECT = new RECT();
        RECT rECT2 = null;
        if (rectangle != null) {
            rECT2 = new RECT();
            rECT2.left = rectangle.x;
            rECT2.right = rectangle.x + rectangle.width;
            rECT2.top = rectangle.y;
            rECT2.bottom = rectangle.y + rectangle.height;
        }
        int[] nArray = this.getPartId(0);
        int n5 = nArray[0];
        int n6 = nArray[1];
        OS.GetThemeTextExtent((int)n3, (int)gC.handle, (int)n5, (int)n6, (char[])cArray, (int)cArray.length, (int)n4, (RECT)rECT2, (RECT)rECT);
        OS.CloseThemeData((int)n3);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }
}

