/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public class ComboDrawData
extends DrawData {
    public ComboDrawData() {
        this.state = new int[2];
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n2 = OS.OpenThemeData((int)0, (char[])EDIT);
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rectangle.x + rectangle.width;
            rECT.top = rectangle.y;
            rECT.bottom = rectangle.y + rectangle.height;
            int[] nArray = this.getPartId(0);
            OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
            RECT rECT2 = new RECT();
            OS.GetThemeBackgroundContentRect((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, (RECT)rECT2);
            Rectangle rectangle2 = this.clientArea;
            if (rectangle2 != null) {
                rectangle2.x = rECT2.left;
                rectangle2.y = rECT2.top;
                rectangle2.width = rECT2.right - rECT2.left;
                rectangle2.height = rECT2.bottom - rECT2.top;
            }
            OS.CloseThemeData((int)n2);
            n2 = OS.OpenThemeData((int)0, (char[])this.getClassId());
            int n3 = OS.GetThemeSysSize((int)n2, (int)2);
            rECT.left = rECT2.right - n3;
            rECT.top = rECT2.top;
            rECT.right = rECT2.right;
            rECT.bottom = rECT2.bottom;
            nArray = this.getPartId(1);
            OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
            OS.CloseThemeData((int)n2);
            if (rectangle2 != null) {
                rectangle2.width -= n3;
            }
        }
    }

    char[] getClassId() {
        return COMBOBOX;
    }

    int[] getPartId(int n2) {
        int n3 = this.state[n2];
        int n4 = 0;
        int n5 = 0;
        switch (n2) {
            case 0: {
                n4 = 1;
                n5 = 1;
                if ((n3 & 0x20) == 0) break;
                n5 = 4;
                break;
            }
            case 1: {
                n4 = 1;
                n5 = 1;
                if ((n3 & 0x20) != 0) {
                    n5 = 4;
                }
                if ((n3 & 0x40) != 0) {
                    n5 = 2;
                }
                if ((n3 & 8) == 0) break;
                n5 = 3;
            }
        }
        return new int[]{n4, n5};
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            return -1;
        }
        if (!rectangle.contains(point)) {
            return -1;
        }
        int n2 = OS.OpenThemeData((int)0, (char[])EDIT);
        int[] nArray = this.getPartId(0);
        int n3 = nArray[0];
        int n4 = nArray[1];
        RECT rECT = new RECT();
        rECT.left = rectangle.x;
        rECT.right = rectangle.x + rectangle.width;
        rECT.top = rectangle.y;
        rECT.bottom = rectangle.y + rectangle.height;
        RECT rECT2 = new RECT();
        OS.GetThemeBackgroundContentRect((int)n2, (int)0, (int)n3, (int)n4, (RECT)rECT, (RECT)rECT2);
        OS.CloseThemeData((int)n2);
        n2 = OS.OpenThemeData((int)0, (char[])this.getClassId());
        int n5 = OS.GetThemeSysSize((int)n2, (int)2);
        OS.CloseThemeData((int)n2);
        Rectangle rectangle2 = new Rectangle(rECT2.right - n5, rECT2.top, rECT2.bottom - rECT2.top, n5);
        if (rectangle2.contains(point)) {
            return 1;
        }
        return 0;
    }
}

