/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Display;

public class UIThreadUtils {
    protected static Throwable exception;
    protected static Thread mainThread;
    public static SwingEventQueue swingEventQueue;
    public static int exclusiveSectionCount;
    public static final Object UI_LOCK;
    public static volatile Thread fakeDispatchingEDT;
    static /* synthetic */ Class array$Ljava$lang$String;

    protected UIThreadUtils() {
    }

    public static void storeException(Throwable throwable) {
        exception = throwable;
    }

    public static void throwStoredException() {
        Throwable throwable = exception;
        exception = null;
        Utils.throwUncheckedException(throwable);
    }

    public static void setMainThread(Thread thread) {
        mainThread = thread;
        if (Compatibility.IS_JAVA_5_OR_GREATER) {
            new Compatibility.ProtectedCode(){
                {
                    if (!UIThreadUtils.isRealDispatch()) {
                        mainThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void uncaughtException(Thread thread, Throwable t2) {
                                t2.printStackTrace();
                                UIThreadUtils.monitorShutdown();
                            }
                        });
                    }
                }
            };
        }
    }

    protected static void pushQueue() {
        EventQueue eventQueue;
        if (UIThreadUtils.isRealDispatch() && (eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue()) != swingEventQueue) {
            ++exclusiveSectionCount;
            eventQueue.push(swingEventQueue);
        }
    }

    public static void popQueue() {
        EventQueue eventQueue;
        if (UIThreadUtils.isRealDispatch() && (eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue()) == swingEventQueue) {
            swingEventQueue.pop();
            swingEventQueue = null;
            --exclusiveSectionCount;
        }
    }

    public static boolean isRealDispatch() {
        return swingEventQueue != null;
    }

    public static void main(String[] stringArray) {
        UIThreadUtils.swtExec((Runnable)((Object)new /* invalid duplicate definition of identical inner class */));
    }

    public static void swtExec(Runnable runnable) {
        if (swingEventQueue == null) {
            Runnable runnable2 = runnable;
            swingEventQueue = new SwingEventQueue();
            runnable = new Runnable(runnable2){

                public void run() {
                    try {
                        Class<?> clazz = Class.forName(args[0]);
                        Class[] classArray = new Class[1];
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$0 = Class.forName("[Ljava.lang.String;");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[0] = clazz2;
                        Method method = clazz.getDeclaredMethod("main", classArray);
                        String[] newArgs = new String[args.length - 1];
                        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
                        method.invoke(null, new Object[]{newArgs});
                    }
                    catch (Throwable t2) {
                        t2.printStackTrace();
                    }
                }
            };
        }
        UIThreadUtils.pushQueue();
        SwingUtilities.invokeLater(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void swtSync(Display display, Runnable runnable) {
        try {
            UIThreadUtils.startExclusiveSection(display);
            runnable.run();
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startExclusiveSection(Display display) {
        if (UIThreadUtils.isRealDispatch() || !SwingUtilities.isEventDispatchThread()) {
            ++exclusiveSectionCount;
            return;
        }
        while (exception != null || !mainThread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        Object object = UI_LOCK;
        synchronized (object) {
            if (++exclusiveSectionCount == 1) {
                try {
                    display.wake();
                    UI_LOCK.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopExclusiveSection() {
        if (UIThreadUtils.isRealDispatch() || !SwingUtilities.isEventDispatchThread()) {
            --exclusiveSectionCount;
            return;
        }
        Object object = UI_LOCK;
        synchronized (object) {
            if (--exclusiveSectionCount == 0) {
                UI_LOCK.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wakeUIThread() {
        if (fakeDispatchingEDT != null) {
            fakeDispatchingEDT.interrupt();
            return;
        }
        Object object = UI_LOCK;
        synchronized (object) {
            UI_LOCK.notify();
        }
    }

    protected static void monitorShutdown() {
        while (true) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            UIThreadUtils.exitSystemIfNoThreads();
        }
    }

    protected static void exitSystemIfNoThreads() {
        Thread thread;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        Thread[] threadArray = new Thread[threadGroup.activeCount() + 10];
        threadGroup.enumerate(threadArray);
        boolean bl = true;
        int n2 = 3;
        for (int i2 = 0; i2 < threadArray.length && (thread = threadArray[i2]) != null; ++i2) {
            if (!bl || !thread.isAlive() || thread.isDaemon()) continue;
            if (n2 > 0) {
                --n2;
                continue;
            }
            bl = false;
        }
        if (bl) {
            System.exit(0);
        }
    }

    static {
        exclusiveSectionCount = 0;
        UI_LOCK = new Object();
    }

    public static class SwingEventQueue
    extends EventQueue {
        protected AWTEvent event;

        public boolean sleep() {
            this.event = null;
            try {
                this.event = this.getNextEvent();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.event != null;
        }

        public boolean dispatchEvent() {
            if (this.event != null) {
                AWTEvent theEvent = this.event;
                this.event = null;
                try {
                    this.dispatchEvent(theEvent);
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
            return false;
        }

        public void pop() {
            super.pop();
        }
    }
}

