/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CToolBar;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;

class CToolBarImplementation
extends JToolBar
implements CToolBar {
    protected ToolBar handle;
    protected CControl.UserAttributeHandler userAttributeHandler;

    public Container getSwingComponent() {
        return this;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CToolBarImplementation(ToolBar toolBar, int n2) {
        super((n2 & 0x200) != 0 ? 1 : 0);
        this.handle = toolBar;
        this.userAttributeHandler = new CControl.UserAttributeHandler(this);
        this.init(n2);
    }

    protected void init(int n2) {
        this.setFloatable(false);
        if ((n2 & 0x800) != 0) {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
        if ((n2 & 0x40) != 0) {
            this.setLayout(new FlowLayout(0, 0, 0));
        }
        Utils.installMouseListener(this, this.handle);
        Utils.installKeyListener(this, this.handle);
        Utils.installFocusListener(this, this.handle);
        Utils.installComponentListener(this, this.handle);
    }

    public Container getClientArea() {
        return this;
    }

    public JScrollBar getHorizontalScrollBar() {
        return null;
    }

    public JScrollBar getVerticalScrollBar() {
        return null;
    }

    public Color getBackground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.background != null ? this.userAttributeHandler.background : super.getBackground();
    }

    public Color getForeground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.foreground != null ? this.userAttributeHandler.foreground : super.getForeground();
    }

    public Font getFont() {
        return this.userAttributeHandler != null && this.userAttributeHandler.font != null ? this.userAttributeHandler.font : super.getFont();
    }

    public Cursor getCursor() {
        if (Utils.globalCursor != null) {
            return Utils.globalCursor;
        }
        return this.userAttributeHandler != null && this.userAttributeHandler.cursor != null ? this.userAttributeHandler.cursor : super.getCursor();
    }

    public void setBackgroundImage(Image image) {
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: {
                this.setOpaque(true);
                break;
            }
            case 1: 
            case 2: {
                this.setOpaque(false);
            }
        }
    }

    public void reshape(int n2, int n3, int n4, int n5) {
        super.reshape(n2, n3, n4, this.getComponentCount() == 0 ? n5 : this.getPreferredSize().height);
    }
}

