/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CSpinner;
import org.eclipse.swt.internal.swing.TextFilterEvent;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

class CSpinnerImplementation
extends JSpinner
implements CSpinner {
    protected Spinner handle;
    protected SpinnerNumberModel model;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected KeyEvent keyEvent = null;
    protected int minimum = 0;
    protected int maximum = 100;
    protected int digitCount;

    public Container getSwingComponent() {
        return this;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CSpinnerImplementation(Spinner spinner, int n2) {
        this.handle = spinner;
        this.userAttributeHandler = new CControl.UserAttributeHandler(this);
        this.model = new SpinnerNumberModel(0.0, (double)this.minimum, (double)this.maximum, 1.0);
        this.setModel(this.model);
        this.model.setMinimum(new Comparable(){

            public int compareTo(Object o2) {
                return CSpinnerImplementation.this.minimum - Math.round(((Number)o2).floatValue() * (float)((int)Math.pow(10.0, CSpinnerImplementation.this.digitCount)));
            }
        });
        this.model.setMaximum(new Comparable(){

            public int compareTo(Object o2) {
                return CSpinnerImplementation.this.maximum - Math.round(((Number)o2).floatValue() * (float)((int)Math.pow(10.0, CSpinnerImplementation.this.digitCount)));
            }
        });
        this.init(n2);
    }

    protected void init(int n2) {
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        if ((n2 & 8) != 0) {
            jFormattedTextField.setEditable(false);
        }
        Utils.installMouseListener(this, this.handle);
        Utils.installKeyListener(this, this.handle);
        Utils.installFocusListener(this, this.handle);
        Utils.installComponentListener(this, this.handle);
        jFormattedTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e2) {
                CSpinnerImplementation.this.keyEvent = e2;
            }

            public void keyReleased(KeyEvent e2) {
                CSpinnerImplementation.this.keyEvent = null;
            }
        });
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                CSpinnerImplementation.this.handle.processEvent(e2);
            }
        });
        AbstractDocument abstractDocument = (AbstractDocument)jFormattedTextField.getDocument();
        abstractDocument.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e2) {
                CSpinnerImplementation.this.handle.processEvent(e2);
            }

            public void insertUpdate(DocumentEvent e2) {
                CSpinnerImplementation.this.handle.processEvent(e2);
            }

            public void removeUpdate(DocumentEvent e2) {
                CSpinnerImplementation.this.handle.processEvent(e2);
            }
        });
        abstractDocument.setDocumentFilter(new DocumentFilter(){

            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                TextFilterEvent filterEvent = new TextFilterEvent(this, text, offset, length, CSpinnerImplementation.this.keyEvent);
                CSpinnerImplementation.this.handle.processEvent(filterEvent);
                String s2 = filterEvent.getText();
                if (s2 != null) {
                    super.replace(fb, offset, length, s2, attrs);
                }
            }

            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                TextFilterEvent filterEvent = new TextFilterEvent(this, "", offset, length, CSpinnerImplementation.this.keyEvent);
                CSpinnerImplementation.this.handle.processEvent(filterEvent);
                String s2 = filterEvent.getText();
                if (s2 != null) {
                    super.replace(fb, offset, length, s2, null);
                }
            }
        });
    }

    public Container getClientArea() {
        return this;
    }

    public int getStepSize() {
        return Math.round(this.model.getStepSize().floatValue() * (float)((int)Math.pow(10.0, this.digitCount)));
    }

    public void setStepSize(int n2) {
        this.model.setStepSize(new Float((float)n2 / (float)((int)Math.pow(10.0, this.digitCount))));
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMinimum(int n2) {
        this.minimum = n2;
    }

    public void setMaximum(int n2) {
        this.maximum = n2;
    }

    public void setSelectedValue(int n2) {
        this.model.setValue(new Float((float)n2 / (float)((int)Math.pow(10.0, this.digitCount))));
    }

    public int getSelectedValue() {
        return Math.round(((Number)this.model.getValue()).floatValue() * (float)((int)Math.pow(10.0, this.digitCount)));
    }

    public void copy() {
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().copy();
    }

    public void cut() {
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().cut();
    }

    public void paste() {
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().paste();
    }

    public void setDigitCount(int n2) {
        if (n2 == this.digitCount) {
            return;
        }
        this.digitCount = n2;
    }

    public int getDigitCount() {
        return this.digitCount;
    }

    public Color getBackground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.background != null ? this.userAttributeHandler.background : super.getBackground();
    }

    public Color getForeground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.foreground != null ? this.userAttributeHandler.foreground : super.getForeground();
    }

    public Font getFont() {
        return this.userAttributeHandler != null && this.userAttributeHandler.font != null ? this.userAttributeHandler.font : super.getFont();
    }

    public Cursor getCursor() {
        if (Utils.globalCursor != null) {
            return Utils.globalCursor;
        }
        return this.userAttributeHandler != null && this.userAttributeHandler.cursor != null ? this.userAttributeHandler.cursor : super.getCursor();
    }

    public void setBackgroundImage(Image image) {
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: {
                this.setOpaque(true);
                break;
            }
            case 1: 
            case 2: {
                this.setOpaque(false);
            }
        }
    }
}

