/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;

public final class TextLayout
extends Resource {
    Device device;
    Font font;
    String text;
    int lineSpacing;
    int ascent;
    int descent;
    int alignment;
    int wrapWidth;
    int orientation;
    int indent;
    boolean justify;
    int[] tabs;
    int[] segments;
    StyleItem[] styles;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.descent = -1;
        this.ascent = -1;
        this.wrapWidth = -1;
        this.lineSpacing = 0;
        this.orientation = 0x2000000;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.text = "";
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns(GC gC) {
        StyleItem[] styleItemArray;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl;
        if (this.runs != null) {
            return;
        }
        boolean bl2 = bl = gC == null;
        if (bl) {
            gC = new GC(this.device);
        }
        StyleItem[] styleItemArray2 = this.itemize();
        for (n6 = 0; n6 < styleItemArray2.length - 1; ++n6) {
            StyleItem styleItem = styleItemArray2[n6];
            gC.setFont(this.getItemFont(styleItem));
            this.place(gC, styleItem);
        }
        n6 = 0;
        int n7 = 0;
        int n8 = 1;
        for (n5 = 0; n5 < styleItemArray2.length - 1; ++n5) {
            int n9;
            int n10;
            StyleItem styleItem = styleItemArray2[n5];
            if (styleItem.length == 1) {
                n4 = this.text.charAt(styleItem.start);
                switch (n4) {
                    case 9: {
                        styleItem.tab = true;
                        if (this.tabs == null) break;
                        n3 = this.tabs.length;
                        for (n10 = 0; n10 < n3; ++n10) {
                            if (this.tabs[n10] <= n6) continue;
                            styleItem.width = this.tabs[n10] - n6;
                            break;
                        }
                        if (n10 != n3) break;
                        int n11 = n9 = n3 > 1 ? this.tabs[n3 - 1] - this.tabs[n3 - 2] : this.tabs[0];
                        if (n9 <= 0) break;
                        for (n2 = this.tabs[n3 - 1]; n2 <= n6; n2 += n9) {
                        }
                        styleItem.width = n2 - n6;
                        break;
                    }
                    case 10: {
                        styleItem.lineBreak = true;
                        styleItem.width = 0;
                        break;
                    }
                    case 13: {
                        styleItem.lineBreak = true;
                        styleItem.width = 0;
                        StyleItem styleItem2 = styleItemArray2[n5 + 1];
                        if (styleItem2.length == 0 || this.text.charAt(styleItem2.start) != '\n') break;
                        ++styleItem.length;
                        ++n5;
                    }
                }
            }
            if (this.wrapWidth != -1 && n6 + styleItem.width > this.wrapWidth && !styleItem.tab) {
                n4 = 0;
                gC.setFont(this.getItemFont(styleItem));
                char[] cArray = new char[styleItem.length];
                this.text.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
                if (styleItem.style == null || styleItem.style.metrics == null) {
                    n10 = 0;
                    n2 = this.wrapWidth - n6;
                    n9 = gC.stringExtent((String)String.valueOf((char)cArray[n4])).x;
                    while (n10 + n9 < n2) {
                        n10 += n9;
                        n9 = gC.stringExtent((String)String.valueOf((char)cArray[++n4])).x;
                    }
                }
                n10 = n4;
                n2 = n5;
                while (n5 >= n7) {
                    cArray = new char[styleItem.length];
                    this.text.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
                    while (n4 >= 0 && !Compatibility.isSpaceChar(cArray[n4]) && !Compatibility.isWhitespace(cArray[n4])) {
                        --n4;
                    }
                    if (n4 >= 0 || n5 == n7) break;
                    styleItem = styleItemArray2[--n5];
                    n4 = styleItem.length - 1;
                }
                if (n4 == 0 && n5 != n7) {
                    styleItem = styleItemArray2[--n5];
                } else if (n4 <= 0 && n5 == n7) {
                    n5 = n2;
                    styleItem = styleItemArray2[n5];
                    n4 = Math.max(1, n10);
                }
                cArray = new char[styleItem.length];
                this.text.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
                while (n4 < styleItem.length && Compatibility.isWhitespace(cArray[n4])) {
                    ++n4;
                }
                if (0 < n4 && n4 < styleItem.length) {
                    StyleItem styleItem3 = new StyleItem();
                    styleItem3.start = styleItem.start + n4;
                    styleItem3.length = styleItem.length - n4;
                    styleItem3.style = styleItem.style;
                    styleItem.length = n4;
                    gC.setFont(this.getItemFont(styleItem));
                    this.place(gC, styleItem);
                    this.place(gC, styleItem3);
                    styleItemArray = new StyleItem[styleItemArray2.length + 1];
                    System.arraycopy(styleItemArray2, 0, styleItemArray, 0, n5 + 1);
                    System.arraycopy(styleItemArray2, n5 + 1, styleItemArray, n5 + 2, styleItemArray2.length - n5 - 1);
                    styleItemArray2 = styleItemArray;
                    styleItemArray2[n5 + 1] = styleItem3;
                }
                if (n5 != styleItemArray2.length - 2) {
                    styleItem.lineBreak = true;
                    styleItem.softBreak = true;
                }
            }
            n6 += styleItem.width;
            if (!styleItem.lineBreak) continue;
            n7 = n5 + 1;
            n6 = 0;
            ++n8;
        }
        n6 = 0;
        this.runs = new StyleItem[n8][];
        this.lineOffset = new int[n8 + 1];
        this.lineY = new int[n8 + 1];
        this.lineWidth = new int[n8];
        n5 = 0;
        int n12 = 0;
        n4 = Math.max(0, this.ascent);
        n3 = Math.max(0, this.descent);
        StyleItem[] styleItemArray3 = new StyleItem[styleItemArray2.length];
        for (n2 = 0; n2 < styleItemArray2.length; ++n2) {
            StyleItem styleItem = styleItemArray2[n2];
            styleItemArray3[n5++] = styleItem;
            n6 += styleItem.width;
            n4 = Math.max(n4, styleItem.ascent);
            n3 = Math.max(n3, styleItem.descent);
            if (!styleItem.lineBreak && n2 != styleItemArray2.length - 1) continue;
            if (n5 == 1 && n2 == styleItemArray2.length - 1) {
                gC.setFont(this.getItemFont(styleItem));
                styleItemArray = gC.getFontMetrics();
                styleItem.ascent = styleItemArray.getAscent() + styleItemArray.getLeading();
                styleItem.descent = styleItemArray.getDescent();
                n4 = Math.max(n4, styleItem.ascent);
                n3 = Math.max(n3, styleItem.descent);
            }
            this.runs[n12] = new StyleItem[n5];
            System.arraycopy(styleItemArray3, 0, this.runs[n12], 0, n5);
            styleItemArray = this.runs[n12][n5 - 1];
            this.lineWidth[n12] = n6;
            this.lineY[++n12] = this.lineY[n12 - 1] + n4 + n3 + this.lineSpacing;
            this.lineOffset[n12] = styleItemArray.start + styleItemArray.length;
            n6 = 0;
            n5 = 0;
            n4 = Math.max(0, this.ascent);
            n3 = Math.max(0, this.descent);
        }
        if (bl) {
            gC.dispose();
        }
    }

    public void dispose() {
        if (this.device == null) {
            return;
        }
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.tabs = null;
        this.styles = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void draw(GC gC, int n2, int n3) {
        this.draw(gC, n2, n3, -1, -1, null, null);
    }

    public void draw(GC gC, int n2, int n3, int n4, int n5, Color color, Color color2) {
        boolean bl;
        int n6;
        this.checkLayout();
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        if ((n6 = this.text.length()) == 0) {
            return;
        }
        this.computeRuns(gC);
        boolean bl2 = bl = n4 <= n5 && n4 != -1 && n5 != -1;
        if (bl) {
            n4 = Math.min(Math.max(0, n4), n6 - 1);
            n5 = Math.min(Math.max(0, n5), n6 - 1);
            if (color == null) {
                color = this.device.getSystemColor(27);
            }
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
        }
        Color color3 = gC.getForeground();
        Color color4 = gC.getBackground();
        Font font = gC.getFont();
        Rectangle rectangle = gC.getClipping();
        block0: for (int i2 = 0; i2 < this.runs.length; ++i2) {
            int n7;
            int n8 = n2 + this.getLineIndent(i2);
            int n9 = n3 + this.lineY[i2];
            StyleItem[] styleItemArray = this.runs[i2];
            if (n8 > rectangle.x + rectangle.width || n8 + this.lineWidth[i2] < rectangle.x) continue;
            int n10 = Math.max(0, this.ascent);
            for (n7 = 0; n7 < styleItemArray.length; ++n7) {
                n10 = Math.max(n10, styleItemArray[n7].ascent);
            }
            n7 = this.lineY[i2 + 1] - this.lineY[i2];
            Font font2 = null;
            Font font3 = null;
            int n11 = 0;
            for (int i3 = 0; i3 < styleItemArray.length; ++i3) {
                StyleItem styleItem = styleItemArray[i3];
                if (styleItem.length == 0) continue;
                if (n8 > rectangle.x + rectangle.width) continue block0;
                if (n8 + styleItem.width >= rectangle.x && (!styleItem.lineBreak || styleItem.softBreak)) {
                    Object object;
                    boolean bl3;
                    font3 = this.getItemFont(styleItem);
                    if (!font3.equals(font2)) {
                        gC.setFont(font3);
                        font2 = font3;
                    }
                    n11 = n9 + (n10 - styleItem.ascent);
                    int n12 = styleItem.start + styleItem.length - 1;
                    boolean bl4 = bl3 = bl && n4 <= styleItem.start && n5 >= n12;
                    if (bl3) {
                        gC.setBackground(color2);
                        gC.fillRectangle(n8, n9, styleItem.width, n7);
                        if (!(styleItem.tab || styleItem.style != null && styleItem.style.metrics != null)) {
                            int n13;
                            gC.setForeground(color);
                            object = this.text.substring(styleItem.start, styleItem.start + styleItem.length);
                            gC.drawString((String)object, n8, n11, true);
                            if (styleItem.style != null && styleItem.style.underline) {
                                n13 = n11 + styleItem.ascent + 1 - styleItem.style.rise;
                                gC.drawLine(n8, n13, n8 + styleItem.width, n13);
                            }
                            if (styleItem.style != null && styleItem.style.strikeout) {
                                n13 = n11 + (styleItem.ascent + styleItem.descent) - (styleItem.ascent + styleItem.descent) / 2 - 1;
                                gC.drawLine(n8, n13, n8 + styleItem.width, n13);
                            }
                        }
                    } else {
                        if (styleItem.style != null && styleItem.style.background != null) {
                            object = styleItem.style.background;
                            gC.setBackground((Color)object);
                            gC.fillRectangle(n8, n11, styleItem.width, styleItem.ascent + styleItem.descent);
                        }
                        if (!styleItem.tab) {
                            int n14;
                            object = color3;
                            if (styleItem.style != null && styleItem.style.foreground != null) {
                                object = styleItem.style.foreground;
                            }
                            gC.setForeground((Color)object);
                            String string = this.text.substring(styleItem.start, styleItem.start + styleItem.length);
                            if (styleItem.style == null || styleItem.style.metrics == null) {
                                gC.drawString(string, n8, n11, true);
                                if (styleItem.style != null && styleItem.style.underline) {
                                    n14 = n11 + styleItem.ascent + 1 - styleItem.style.rise;
                                    gC.drawLine(n8, n14, n8 + styleItem.width, n14);
                                }
                                if (styleItem.style != null && styleItem.style.strikeout) {
                                    n14 = n11 + (styleItem.ascent + styleItem.descent) - (styleItem.ascent + styleItem.descent) / 2 - 1;
                                    gC.drawLine(n8, n14, n8 + styleItem.width, n14);
                                }
                            }
                            int n15 = n14 = bl && n4 <= n12 && styleItem.start <= n5 ? 1 : 0;
                            if (n14 != 0) {
                                int n16 = Math.max(n4, styleItem.start);
                                int n17 = Math.min(n5, n12);
                                string = this.text.substring(styleItem.start, n16);
                                int n18 = n8 + gC.stringExtent((String)string).x;
                                string = this.text.substring(n16, n17 + 1);
                                int n19 = gC.stringExtent((String)string).x;
                                gC.setBackground(color2);
                                gC.fillRectangle(n18, n9, n19, n7);
                                if (object != color && (styleItem.style == null || styleItem.style.metrics == null)) {
                                    int n20;
                                    gC.setForeground(color);
                                    gC.drawString(string, n18, n11, true);
                                    if (styleItem.style != null && styleItem.style.underline) {
                                        n20 = n11 + styleItem.ascent + 1 - styleItem.style.rise;
                                        gC.drawLine(n18, n20, n18 + n19, n20);
                                    }
                                    if (styleItem.style != null && styleItem.style.strikeout) {
                                        n20 = n11 + (styleItem.ascent + styleItem.descent) - (styleItem.ascent + styleItem.descent) / 2 - 1;
                                        gC.drawLine(n18, n20, n18 + n19, n20);
                                    }
                                }
                            }
                        }
                    }
                }
                n8 += styleItem.width;
            }
        }
        gC.setForeground(color3);
        gC.setBackground(color4);
        gC.setFont(font);
    }

    void freeRuns() {
        this.runs = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = 0;
        if (this.wrapWidth != -1) {
            n2 = this.wrapWidth;
        } else {
            for (int i2 = 0; i2 < this.runs.length; ++i2) {
                n2 = Math.max(n2, this.lineWidth[i2] + this.getLineIndent(i2));
            }
        }
        return new Rectangle(0, 0, n2, this.lineY[this.lineY.length - 1]);
    }

    public Rectangle getBounds(int n2, int n3) {
        this.checkLayout();
        int n4 = this.text.length();
        if (n4 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n2 > n3) {
            return new Rectangle(0, 0, 0, 0);
        }
        n2 = Math.min(Math.max(0, n2), n4 - 1);
        n3 = Math.min(Math.max(0, n3), n4 - 1);
        this.computeRuns(null);
        int n5 = this.getLineIndex(n2);
        int n6 = this.getLineIndex(n3);
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        rectangle.y = this.lineY[n5];
        rectangle.height = this.lineY[n6 + 1] - rectangle.y - this.lineSpacing;
        if (n5 == n6) {
            rectangle.x = this.getLocation((int)n2, (boolean)false).x;
            rectangle.width = this.getLocation((int)n3, (boolean)true).x - rectangle.x;
        } else {
            while (n5 <= n6) {
                rectangle.width = Math.max(rectangle.width, this.lineWidth[n5++]);
            }
        }
        return rectangle;
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    public int getLevel(int n2) {
        this.checkLayout();
        int n3 = this.text.length();
        if (0 > n2 || n2 > n3) {
            SWT.error(6);
        }
        return 0;
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] nArray = new int[this.lineOffset.length];
        System.arraycopy(this.lineOffset, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public Rectangle getLineBounds(int n2) {
        this.checkLayout();
        this.computeRuns(null);
        if (0 > n2 || n2 >= this.runs.length) {
            SWT.error(6);
        }
        int n3 = this.getLineIndent(n2);
        int n4 = this.lineY[n2];
        int n5 = this.lineWidth[n2];
        int n6 = this.lineY[n2 + 1] - n4 - this.lineSpacing;
        return new Rectangle(n3, n4, n5, n6);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    int getLineIndent(int n2) {
        boolean bl;
        int n3 = 0;
        if (n2 == 0) {
            n3 = this.indent;
        } else {
            StyleItem[] styleItemArray = this.runs[n2 - 1];
            StyleItem styleItem = styleItemArray[styleItemArray.length - 1];
            if (styleItem.lineBreak && !styleItem.softBreak) {
                n3 = this.indent;
            }
        }
        if (this.wrapWidth != -1 && (bl = true)) {
            int n4 = this.lineWidth[n2] + n3;
            switch (this.alignment) {
                case 0x1000000: {
                    n3 += (this.wrapWidth - n4) / 2;
                    break;
                }
                case 131072: {
                    n3 += this.wrapWidth - n4;
                }
            }
        }
        return n3;
    }

    public int getLineIndex(int n2) {
        this.checkLayout();
        int n3 = this.text.length();
        if (0 > n2 || n2 > n3) {
            SWT.error(6);
        }
        this.computeRuns(null);
        for (int i2 = 0; i2 < this.runs.length; ++i2) {
            if (this.lineOffset[i2 + 1] <= n2) continue;
            return i2;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int n2) {
        this.checkLayout();
        this.computeRuns(null);
        if (0 > n2 || n2 >= this.runs.length) {
            SWT.error(6);
        }
        GC gC = new GC(this.device);
        gC.setFont(this.font != null ? this.font : this.device.getSystemFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n3 = Math.max(fontMetrics.getAscent(), this.ascent);
        int n4 = Math.max(fontMetrics.getDescent(), this.descent);
        if (this.text.length() != 0) {
            StyleItem[] styleItemArray = this.runs[n2];
            for (int i2 = 0; i2 < styleItemArray.length; ++i2) {
                StyleItem styleItem = styleItemArray[i2];
                if (styleItem.style == null) continue;
                int n5 = 0;
                int n6 = 0;
                if (styleItem.style.metrics != null) {
                    GlyphMetrics glyphMetrics = styleItem.style.metrics;
                    n5 = glyphMetrics.ascent;
                    n6 = glyphMetrics.descent;
                } else if (styleItem.style.font != null) {
                    gC.setFont(styleItem.style.font);
                    fontMetrics = gC.getFontMetrics();
                    n5 = fontMetrics.getAscent();
                    n6 = fontMetrics.getDescent();
                }
                n3 = Math.max(n3, n5 + styleItem.style.rise);
                n4 = Math.max(n4, n6 - styleItem.style.rise);
            }
        }
        gC.dispose();
        return FontMetrics.internal_new(n3, n4, 0, 0, n3 + n4);
    }

    public Point getLocation(int n2, boolean bl) {
        int n3;
        this.checkLayout();
        int n4 = this.text.length();
        if (0 > n2 || n2 > n4) {
            SWT.error(6);
        }
        this.computeRuns(null);
        for (n3 = 0; n3 < this.runs.length && this.lineOffset[n3 + 1] <= n2; ++n3) {
        }
        n3 = Math.min(n3, this.runs.length - 1);
        StyleItem[] styleItemArray = this.runs[n3];
        Point point = null;
        if (n2 == n4) {
            point = new Point(this.lineWidth[n3], this.lineY[n3]);
        } else {
            int n5 = 0;
            for (int i2 = 0; i2 < styleItemArray.length; ++i2) {
                StyleItem styleItem = styleItemArray[i2];
                int n6 = styleItem.start + styleItem.length;
                if (styleItem.start <= n2 && n2 < n6) {
                    if (styleItem.tab) {
                        if (bl || n2 == n4) {
                            n5 += styleItem.width;
                        }
                    } else {
                        if (bl) {
                            ++n2;
                        }
                        if (styleItem.style != null && styleItem.style.metrics != null) {
                            GlyphMetrics glyphMetrics = styleItem.style.metrics;
                            n5 += glyphMetrics.width * (n2 - styleItem.start);
                        } else {
                            String string = this.text.substring(styleItem.start, n2);
                            GC gC = new GC(this.device);
                            gC.setFont(this.getItemFont(styleItem));
                            n5 += gC.stringExtent((String)string).x;
                            gC.dispose();
                        }
                    }
                    point = new Point(n5, this.lineY[n3]);
                    break;
                }
                n5 += styleItem.width;
            }
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        point.x += this.getLineIndent(n3);
        return point;
    }

    Font getItemFont(StyleItem styleItem) {
        if (styleItem.style != null && styleItem.style.font != null) {
            return styleItem.style.font;
        }
        if (this.font != null) {
            return this.font;
        }
        return this.device.getSystemFont();
    }

    public int getNextOffset(int n2, int n3) {
        int n4;
        this.checkLayout();
        this.computeRuns(null);
        int n5 = this.text.length();
        if (0 > n2 || n2 > n5) {
            SWT.error(6);
        }
        if (n2 == n5) {
            return n5;
        }
        if ((n3 & 3) != 0) {
            return n2 + 1;
        }
        int n6 = 0;
        for (n4 = 1; n4 < this.lineOffset.length; ++n4) {
            if (this.lineOffset[n4] <= n2) continue;
            n6 = Math.max(this.lineOffset[n4 - 1], this.lineOffset[n4] - 1);
            if (n4 != this.runs.length) break;
            ++n6;
            break;
        }
        n4 = !Compatibility.isLetterOrDigit(this.text.charAt(n2)) ? 1 : 0;
        ++n2;
        while (n2 < n6) {
            int n7;
            int n8 = n7 = !Compatibility.isLetterOrDigit(this.text.charAt(n2)) ? 1 : 0;
            if (n7 == 0 && n4 != 0) break;
            n4 = n7;
            ++n2;
        }
        return n2;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n2, int n3, int[] nArray) {
        int n4;
        this.checkLayout();
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        this.computeRuns(null);
        int n5 = this.runs.length;
        for (n4 = 0; n4 < n5 && this.lineY[n4 + 1] <= n3; ++n4) {
        }
        if ((n2 -= this.getLineIndent(n4 = Math.min(n4, this.runs.length - 1))) >= this.lineWidth[n4]) {
            n2 = this.lineWidth[n4] - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        StyleItem[] styleItemArray = this.runs[n4];
        int n6 = 0;
        for (int i2 = 0; i2 < styleItemArray.length; ++i2) {
            StyleItem styleItem = styleItemArray[i2];
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return styleItem.start;
            }
            if (n6 + styleItem.width > n2) {
                Object object;
                int n7;
                if (styleItem.style != null && styleItem.style.metrics != null) {
                    n7 = n2 - n6;
                    object = styleItem.style.metrics;
                    if (((GlyphMetrics)object).width > 0) {
                        if (nArray != null) {
                            nArray[0] = n7 % ((GlyphMetrics)object).width < ((GlyphMetrics)object).width / 2 ? 0 : 1;
                        }
                        return styleItem.start + n7 / ((GlyphMetrics)object).width;
                    }
                }
                if (styleItem.tab) {
                    if (nArray != null) {
                        nArray[0] = n2 < n6 + styleItem.width / 2 ? 0 : 1;
                    }
                    return styleItem.start;
                }
                n7 = 0;
                object = new GC(this.device);
                ((GC)object).setFont(this.getItemFont(styleItem));
                char[] cArray = new char[styleItem.length];
                this.text.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
                for (n7 = 0; n7 < cArray.length; ++n7) {
                    int n8 = ((GC)object).stringExtent((String)String.valueOf((char)cArray[n7])).x;
                    if (n6 + n8 > n2) {
                        if (nArray == null) break;
                        nArray[0] = n2 < n6 + n8 / 2 ? 0 : 1;
                        break;
                    }
                    n6 += n8;
                }
                ((GC)object).dispose();
                return styleItem.start + n7;
            }
            n6 += styleItem.width;
        }
        if (nArray != null) {
            nArray[0] = 0;
        }
        return this.lineOffset[n4 + 1];
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int n2, int n3) {
        int n4;
        int n5;
        this.checkLayout();
        this.computeRuns(null);
        int n6 = this.text.length();
        if (0 > n2 || n2 > n6) {
            SWT.error(6);
        }
        if (n2 == 0) {
            return 0;
        }
        if ((n3 & 3) != 0) {
            return n2 - 1;
        }
        int n7 = 0;
        for (n5 = 0; n5 < this.lineOffset.length - 1; ++n5) {
            n4 = this.lineOffset[n5 + 1];
            if (n5 == this.runs.length - 1) {
                ++n4;
            }
            if (n4 <= n2) continue;
            n7 = this.lineOffset[n5];
            break;
        }
        int n8 = n5 = !Compatibility.isLetterOrDigit(this.text.charAt(--n2)) ? 1 : 0;
        while (n7 < n2) {
            int n9 = n4 = !Compatibility.isLetterOrDigit(this.text.charAt(n2 - 1)) ? 1 : 0;
            if (n4 != 0 && n5 == 0) break;
            --n2;
            n5 = n4;
        }
        return n2;
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.styles.length * 2];
        int n2 = 0;
        for (int i2 = 0; i2 < this.styles.length - 1; ++i2) {
            if (this.styles[i2].style == null) continue;
            nArray[n2++] = this.styles[i2].start;
            nArray[n2++] = this.styles[i2 + 1].start - 1;
        }
        if (n2 != nArray.length) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray = nArray2;
        }
        return nArray;
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public TextStyle getStyle(int n2) {
        this.checkLayout();
        int n3 = this.text.length();
        if (0 > n2 || n2 >= n3) {
            SWT.error(6);
        }
        for (int i2 = 1; i2 < this.styles.length; ++i2) {
            StyleItem styleItem = this.styles[i2];
            if (styleItem.start <= n2) continue;
            return this.styles[i2 - 1].style;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        int n2 = 0;
        for (int i2 = 0; i2 < this.styles.length; ++i2) {
            if (this.styles[i2].style == null) continue;
            textStyleArray[n2++] = this.styles[i2].style;
        }
        if (n2 != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n2];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n2);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        int n2;
        int n3 = this.text.length();
        if (n3 == 0) {
            return new StyleItem[]{new StyleItem(), new StyleItem()};
        }
        int n4 = 0;
        int n5 = 0;
        StyleItem[] styleItemArray = new StyleItem[n3];
        char[] cArray = this.text.toCharArray();
        for (n2 = 0; n2 < n3; ++n2) {
            StyleItem styleItem;
            char c2 = cArray[n2];
            if (c2 != '\t' && c2 != '\r' && c2 != '\n') continue;
            if (n2 != n5) {
                styleItem = new StyleItem();
                styleItem.start = n5;
                styleItemArray[n4++] = styleItem;
            }
            styleItem = new StyleItem();
            styleItem.start = n2;
            styleItemArray[n4++] = styleItem;
            n5 = n2 + 1;
        }
        n2 = cArray[n3 - 1];
        if (n2 != 9 && n2 != 13 && n2 != 10) {
            StyleItem styleItem = new StyleItem();
            styleItem.start = n5;
            styleItemArray[n4++] = styleItem;
        }
        if (n4 != n3) {
            StyleItem[] styleItemArray2 = new StyleItem[n4];
            System.arraycopy(styleItemArray, 0, styleItemArray2, 0, n4);
            styleItemArray = styleItemArray2;
        }
        styleItemArray = this.merge(styleItemArray, n4);
        return styleItemArray;
    }

    StyleItem[] merge(StyleItem[] styleItemArray, int n2) {
        StyleItem styleItem;
        int n3 = this.text.length();
        int n4 = 0;
        int n5 = 0;
        int n6 = n3;
        int n7 = 0;
        int n8 = 0;
        StyleItem[] styleItemArray2 = new StyleItem[n2 + this.styles.length];
        while (n5 < n6) {
            int n9;
            styleItem = new StyleItem();
            styleItem.start = n5;
            styleItem.style = this.styles[n8].style;
            styleItemArray2[n4++] = styleItem;
            int n10 = n7 + 1 < styleItemArray.length ? styleItemArray[n7 + 1].start : n3;
            int n11 = n9 = n8 + 1 < this.styles.length ? this.styles[n8 + 1].start : n3;
            if (n9 <= n10) {
                ++n8;
                n5 = n9;
            }
            if (n10 <= n9) {
                ++n7;
                n5 = n10;
            }
            styleItem.length = n5 - styleItem.start;
        }
        styleItem = new StyleItem();
        styleItem.start = n6;
        styleItemArray2[n4++] = styleItem;
        if (styleItemArray2.length != n4) {
            StyleItem[] styleItemArray3 = new StyleItem[n4];
            System.arraycopy(styleItemArray2, 0, styleItemArray3, 0, n4);
            return styleItemArray3;
        }
        return styleItemArray2;
    }

    void place(GC gC, StyleItem styleItem) {
        if (styleItem.style != null && styleItem.style.metrics != null) {
            GlyphMetrics glyphMetrics = styleItem.style.metrics;
            styleItem.ascent = glyphMetrics.ascent;
            styleItem.descent = glyphMetrics.descent;
            styleItem.width = glyphMetrics.width * styleItem.length;
        } else {
            String string = this.text.substring(styleItem.start, styleItem.start + styleItem.length);
            Point point = gC.stringExtent(string);
            FontMetrics fontMetrics = gC.getFontMetrics();
            styleItem.width = point.x;
            styleItem.ascent = fontMetrics.getAscent() + fontMetrics.getLeading();
            styleItem.descent = fontMetrics.getDescent();
        }
        if (styleItem.style != null) {
            styleItem.ascent += styleItem.style.rise;
            styleItem.descent -= styleItem.style.rise;
        }
    }

    public void setAlignment(int n2) {
        this.checkLayout();
        int n3 = 16924672;
        if ((n2 &= n3) == 0) {
            return;
        }
        if ((n2 & 0x4000) != 0) {
            n2 = 16384;
        }
        if ((n2 & 0x20000) != 0) {
            n2 = 131072;
        }
        this.freeRuns();
        this.alignment = n2;
    }

    public void setAscent(int n2) {
        this.checkLayout();
        if (n2 < -1) {
            SWT.error(5);
        }
        if (this.ascent == n2) {
            return;
        }
        this.freeRuns();
        this.ascent = n2;
    }

    public void setDescent(int n2) {
        this.checkLayout();
        if (n2 < -1) {
            SWT.error(5);
        }
        if (this.descent == n2) {
            return;
        }
        this.freeRuns();
        this.descent = n2;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.freeRuns();
        this.font = font;
    }

    public void setIndent(int n2) {
        this.checkLayout();
        if (n2 < 0) {
            return;
        }
        if (this.indent == n2) {
            return;
        }
        this.freeRuns();
        this.indent = n2;
    }

    public void setJustify(boolean bl) {
        this.checkLayout();
        if (this.justify == bl) {
            return;
        }
        this.freeRuns();
        this.justify = bl;
    }

    public void setOrientation(int n2) {
        this.checkLayout();
        int n3 = 0x6000000;
        if ((n2 &= n3) == 0) {
            return;
        }
        if ((n2 & 0x2000000) != 0) {
            n2 = 0x2000000;
        }
        this.orientation = n2;
    }

    public void setSpacing(int n2) {
        this.checkLayout();
        if (n2 < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == n2) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = n2;
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n2;
            for (n2 = 0; n2 < nArray.length && this.segments[n2] == nArray[n2]; ++n2) {
            }
            if (n2 == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setStyle(TextStyle textStyle, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        this.checkLayout();
        int n7 = this.text.length();
        if (n7 == 0) {
            return;
        }
        if (n2 > n3) {
            return;
        }
        n2 = Math.min(Math.max(0, n2), n7 - 1);
        n3 = Math.min(Math.max(0, n3), n7 - 1);
        int n8 = -1;
        int n9 = this.styles.length;
        while (n9 - n8 > 1) {
            int n10 = (n9 + n8) / 2;
            if (this.styles[n10 + 1].start > n2) {
                n9 = n10;
                continue;
            }
            n8 = n10;
        }
        if (0 <= n9 && n9 < this.styles.length) {
            StyleItem styleItem = this.styles[n9];
            if (styleItem.start == n2 && this.styles[n9 + 1].start - 1 == n3 && (textStyle == null ? styleItem.style == null : textStyle.equals(styleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        for (n6 = n5 = n9; n6 < this.styles.length && this.styles[n6 + 1].start <= n3; ++n6) {
        }
        if (n5 == n6) {
            n4 = this.styles[n5].start;
            int n11 = this.styles[n6 + 1].start - 1;
            if (n4 == n2 && n11 == n3) {
                this.styles[n5].style = textStyle;
                return;
            }
            if (n4 != n2 && n11 != n3) {
                StyleItem[] styleItemArray = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, styleItemArray, 0, n5 + 1);
                StyleItem styleItem = new StyleItem();
                styleItem.start = n2;
                styleItem.style = textStyle;
                styleItemArray[n5 + 1] = styleItem;
                styleItem = new StyleItem();
                styleItem.start = n3 + 1;
                styleItem.style = this.styles[n5].style;
                styleItemArray[n5 + 2] = styleItem;
                System.arraycopy(this.styles, n6 + 1, styleItemArray, n6 + 3, this.styles.length - n6 - 1);
                this.styles = styleItemArray;
                return;
            }
        }
        if (n2 == this.styles[n5].start) {
            --n5;
        }
        if (n3 == this.styles[n6 + 1].start - 1) {
            ++n6;
        }
        n4 = this.styles.length + 1 - (n6 - n5 - 1);
        StyleItem[] styleItemArray = new StyleItem[n4];
        System.arraycopy(this.styles, 0, styleItemArray, 0, n5 + 1);
        StyleItem styleItem = new StyleItem();
        styleItem.start = n2;
        styleItem.style = textStyle;
        styleItemArray[n5 + 1] = styleItem;
        this.styles[n6].start = n3 + 1;
        System.arraycopy(this.styles, n6, styleItemArray, n5 + 2, this.styles.length - n6);
        this.styles = styleItemArray;
    }

    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            int n2;
            for (n2 = 0; n2 < nArray.length && this.tabs[n2] == nArray[n2]; ++n2) {
            }
            if (n2 == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = nArray;
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = string.length();
    }

    public void setWidth(int n2) {
        this.checkLayout();
        if (n2 < -1 || n2 == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == n2) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = n2;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    static class StyleItem {
        TextStyle style;
        int start;
        int length;
        int width;
        int ascent;
        int descent;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

