/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;

public final class Region
extends Resource {
    public Area handle;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = new Area();
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    Region(Device device, Shape shape) {
        this.device = device;
        this.handle = new Area(shape);
    }

    public void add(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        int[] nArray2 = new int[nArray.length / 2];
        int[] nArray3 = new int[nArray2.length];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray2[i2] = nArray[i2 * 2];
            nArray3[i2] = nArray[i2 * 2 + 1];
        }
        this.handle.add(new Area(new Polygon(nArray2, nArray3, nArray2.length)));
    }

    public void add(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.add(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void add(int n2, int n3, int n4, int n5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n4 < 0 || n5 < 0) {
            SWT.error(5);
        }
        this.handle.add(new Area(new java.awt.Rectangle(n2, n3, n4, n5)));
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        this.handle.add(region.handle);
    }

    public boolean contains(int n2, int n3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.contains(new java.awt.Point(n2, n3));
    }

    public boolean contains(Point point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        return this.contains(point.x, point.y);
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        this.handle = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        java.awt.Rectangle rectangle = this.handle.getBounds();
        return new Rectangle((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    public int hashCode() {
        return this.handle == null ? 0 : this.handle.hashCode();
    }

    public void intersect(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void intersect(int n2, int n3, int n4, int n5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n4 < 0 || n5 < 0) {
            SWT.error(5);
        }
        this.handle.intersect(new Area(new java.awt.Rectangle(n2, n3, n4, n5)));
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        this.handle.intersect(region.handle);
    }

    public boolean intersects(int n2, int n3, int n4, int n5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.intersects(n2, n3, n4, n5);
    }

    public boolean intersects(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.isEmpty();
    }

    public void subtract(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        int[] nArray2 = new int[nArray.length / 2];
        int[] nArray3 = new int[nArray2.length];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray2[i2] = nArray[i2 * 2];
            nArray3[i2] = nArray[i2 * 2 + 1];
        }
        this.handle.subtract(new Area(new Polygon(nArray2, nArray3, nArray2.length)));
    }

    public void subtract(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.subtract(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void subtract(int n2, int n3, int n4, int n5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n4 < 0 || n5 < 0) {
            SWT.error(5);
        }
        this.handle.subtract(new Area(new java.awt.Rectangle(n2, n3, n4, n5)));
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        this.handle.subtract(region.handle);
    }

    public void translate(int n2, int n3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.handle.transform(AffineTransform.getTranslateInstance(n2, n3));
    }

    public void translate(Point point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        this.translate(point.x, point.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

