/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;

class StyledTextRenderer {
    Device device;
    StyledText styledText;
    StyledTextContent content;
    Font regularFont;
    Font boldFont;
    Font italicFont;
    Font boldItalicFont;
    int tabWidth;
    int ascent;
    int descent;
    int lineEndSpaceWidth;
    int averageCharWidth;
    int topIndex = -1;
    TextLayout[] layouts;
    int lineCount;
    int[] lineWidth;
    int[] lineHeight;
    LineInfo[] lines;
    int maxWidth;
    int maxWidthLineIndex;
    boolean idleRunning;
    Bullet[] bullets;
    int[] bulletsIndices;
    int[] redrawLines;
    int[] ranges;
    int styleCount;
    StyleRange[] styles;
    StyleRange[] stylesSet;
    int stylesSetCount = 0;
    static final int BULLET_MARGIN = 8;
    static final boolean COMPACT_STYLES = true;
    static final boolean MERGE_STYLES = true;
    static final int GROW = 32;
    static final int IDLE_TIME = 50;
    static final int CACHE_SIZE = 128;
    static final int BACKGROUND = 1;
    static final int ALIGNMENT = 2;
    static final int INDENT = 4;
    static final int JUSTIFY = 8;
    static final int SEGMENTS = 32;

    StyledTextRenderer(Device device, StyledText styledText) {
        this.device = device;
        this.styledText = styledText;
    }

    int addMerge(int[] nArray, StyleRange[] styleRangeArray, int n2, int n3, int n4) {
        int n5;
        int n6 = this.styleCount << 1;
        StyleRange styleRange = null;
        int n7 = 0;
        int n8 = 0;
        if (n4 < n6) {
            styleRange = this.styles[n4 >> 1];
            n7 = this.ranges[n4];
            n8 = this.ranges[n4 + 1];
        }
        if (n6 + (n5 = n2 - (n4 - n3)) >= this.ranges.length) {
            int[] nArray2 = new int[this.ranges.length + n5 + 64];
            System.arraycopy(this.ranges, 0, nArray2, 0, n3);
            StyleRange[] styleRangeArray2 = new StyleRange[this.styles.length + (n5 >> 1) + 32];
            System.arraycopy(this.styles, 0, styleRangeArray2, 0, n3 >> 1);
            if (n6 > n4) {
                System.arraycopy(this.ranges, n4, nArray2, n3 + n2, n6 - n4);
                System.arraycopy(this.styles, n4 >> 1, styleRangeArray2, n3 + n2 >> 1, this.styleCount - (n4 >> 1));
            }
            this.ranges = nArray2;
            this.styles = styleRangeArray2;
        } else if (n6 > n4) {
            System.arraycopy(this.ranges, n4, this.ranges, n3 + n2, n6 - n4);
            System.arraycopy(this.styles, n4 >> 1, this.styles, n3 + n2 >> 1, this.styleCount - (n4 >> 1));
        }
        int n9 = n3;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (n9 > 0 && this.ranges[n9 - 2] + this.ranges[n9 - 1] == nArray[i2] && styleRangeArray[i2 >> 1].similarTo(this.styles[n9 - 2 >> 1])) {
                int n10 = n9 - 1;
                this.ranges[n10] = this.ranges[n10] + nArray[i2 + 1];
                continue;
            }
            this.styles[n9 >> 1] = styleRangeArray[i2 >> 1];
            this.ranges[n9++] = nArray[i2];
            this.ranges[n9++] = nArray[i2 + 1];
        }
        if (styleRange != null && this.ranges[n9 - 2] + this.ranges[n9 - 1] == n7 && styleRange.similarTo(this.styles[n9 - 2 >> 1])) {
            int n11 = n9 - 1;
            this.ranges[n11] = this.ranges[n11] + n8;
            n4 += 2;
            n2 += 2;
        }
        if (n6 > n4) {
            System.arraycopy(this.ranges, n3 + n2, this.ranges, n9, n6 - n4);
            System.arraycopy(this.styles, n3 + n2 >> 1, this.styles, n9 >> 1, this.styleCount - (n4 >> 1));
        }
        n5 = n9 - n3 - (n4 - n3);
        this.styleCount += n5 >> 1;
        return n5;
    }

    int addMerge(StyleRange[] styleRangeArray, int n2, int n3, int n4) {
        int n5 = n2 - (n4 - n3);
        StyleRange styleRange = null;
        if (n4 < this.styleCount) {
            styleRange = this.styles[n4];
        }
        if (this.styleCount + n5 >= this.styles.length) {
            StyleRange[] styleRangeArray2 = new StyleRange[this.styles.length + n5 + 32];
            System.arraycopy(this.styles, 0, styleRangeArray2, 0, n3);
            if (this.styleCount > n4) {
                System.arraycopy(this.styles, n4, styleRangeArray2, n3 + n2, this.styleCount - n4);
            }
            this.styles = styleRangeArray2;
        } else if (this.styleCount > n4) {
            System.arraycopy(this.styles, n4, this.styles, n3 + n2, this.styleCount - n4);
        }
        int n6 = n3;
        for (int i2 = 0; i2 < n2; ++i2) {
            StyleRange styleRange2 = styleRangeArray[i2];
            if (n6 > 0) {
                StyleRange styleRange3 = this.styles[n6 - 1];
                if (styleRange3.start + styleRange3.length == styleRange2.start && styleRange2.similarTo(styleRange3)) {
                    styleRange3.length += styleRange2.length;
                    continue;
                }
            }
            this.styles[n6++] = styleRange2;
        }
        StyleRange styleRange4 = this.styles[n6 - 1];
        if (styleRange != null && styleRange4.start + styleRange4.length == styleRange.start && styleRange.similarTo(styleRange4)) {
            styleRange4.length += styleRange.length;
            ++n4;
            ++n2;
        }
        if (this.styleCount > n4) {
            System.arraycopy(this.styles, n3 + n2, this.styles, n6, this.styleCount - n4);
        }
        n5 = n6 - n3 - (n4 - n3);
        this.styleCount += n5;
        return n5;
    }

    void calculate(int n2, int n3) {
        int n4 = n2 + n3;
        if (n2 < 0 || n4 > this.lineWidth.length) {
            return;
        }
        int n5 = this.styledText.leftMargin + this.styledText.rightMargin + this.styledText.getCaretWidth();
        for (int i2 = n2; i2 < n4; ++i2) {
            if (this.lineWidth[i2] == -1 || this.lineHeight[i2] == -1) {
                TextLayout textLayout = this.getTextLayout(i2);
                Rectangle rectangle = textLayout.getBounds();
                this.lineWidth[i2] = rectangle.width + n5;
                this.lineHeight[i2] = rectangle.height;
                this.disposeTextLayout(textLayout);
            }
            if (this.lineWidth[i2] <= this.maxWidth) continue;
            this.maxWidth = this.lineWidth[i2];
            this.maxWidthLineIndex = i2;
        }
    }

    void calculateClientArea() {
        int n2 = this.styledText.getTopIndex();
        int n3 = this.content.getLineCount();
        int n4 = this.styledText.getClientArea().height;
        for (int i2 = 0; n4 > i2 && n3 > n2; i2 += this.lineHeight[n2++]) {
            this.calculate(n2, 1);
        }
    }

    void calculateIdle() {
        if (this.idleRunning) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (StyledTextRenderer.this.styledText == null) {
                    return;
                }
                long start = System.currentTimeMillis();
                int i2 = 0;
                while (i2 < StyledTextRenderer.this.lineCount) {
                    if (StyledTextRenderer.this.lineHeight[i2] == -1 || StyledTextRenderer.this.lineWidth[i2] == -1) {
                        StyledTextRenderer.this.calculate(i2, 1);
                        if (System.currentTimeMillis() - start > 50L) break;
                    }
                    ++i2;
                }
                if (i2 < StyledTextRenderer.this.lineCount) {
                    Display display = StyledTextRenderer.this.styledText.getDisplay();
                    display.asyncExec(this);
                } else {
                    StyledTextRenderer.this.idleRunning = false;
                    StyledTextRenderer.this.styledText.setScrollBars(true);
                    ScrollBar bar = StyledTextRenderer.this.styledText.getVerticalBar();
                    if (bar != null) {
                        bar.setSelection(StyledTextRenderer.this.styledText.getVerticalScrollOffset());
                    }
                }
            }
        };
        Display display = this.styledText.getDisplay();
        display.asyncExec(runnable);
        this.idleRunning = true;
    }

    void clearLineBackground(int n2, int n3) {
        if (this.lines == null) {
            return;
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            LineInfo lineInfo = this.lines[i2];
            if (lineInfo == null) continue;
            lineInfo.flags &= 0xFFFFFFFE;
            lineInfo.background = null;
            if (lineInfo.flags != 0) continue;
            this.lines[i2] = null;
        }
    }

    void clearLineStyle(int n2, int n3) {
        if (this.lines == null) {
            return;
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            LineInfo lineInfo = this.lines[i2];
            if (lineInfo == null) continue;
            lineInfo.flags &= 0xFFFFFFF1;
            if (lineInfo.flags != 0) continue;
            this.lines[i2] = null;
        }
    }

    void copyInto(StyledTextRenderer styledTextRenderer) {
        int n2;
        Object[] objectArray;
        if (this.ranges != null) {
            styledTextRenderer.ranges = new int[this.styleCount << 1];
            objectArray = styledTextRenderer.ranges;
            System.arraycopy(this.ranges, 0, objectArray, 0, objectArray.length);
        }
        if (this.styles != null) {
            styledTextRenderer.styles = new StyleRange[this.styleCount];
            objectArray = styledTextRenderer.styles;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                objectArray[n2] = (int)((StyleRange)this.styles[n2].clone());
            }
            styledTextRenderer.styleCount = this.styleCount;
        }
        if (this.lines != null) {
            styledTextRenderer.lines = new LineInfo[this.lineCount];
            objectArray = styledTextRenderer.lines;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                objectArray[n2] = (int)new LineInfo(this.lines[n2]);
            }
            styledTextRenderer.lineCount = this.lineCount;
        }
    }

    void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        if (this.italicFont != null) {
            this.italicFont.dispose();
        }
        if (this.boldItalicFont != null) {
            this.boldItalicFont.dispose();
        }
        this.boldItalicFont = null;
        this.italicFont = null;
        this.boldFont = null;
        this.reset();
        this.content = null;
        this.device = null;
        this.styledText = null;
    }

    void disposeTextLayout(TextLayout textLayout) {
        if (this.layouts != null) {
            for (int i2 = 0; i2 < this.layouts.length; ++i2) {
                if (this.layouts[i2] != textLayout) continue;
                return;
            }
        }
        textLayout.dispose();
    }

    void drawBullet(Bullet bullet, GC gC, int n2, int n3, int n4, int n5, int n6) {
        StyleRange styleRange = bullet.style;
        GlyphMetrics glyphMetrics = styleRange.metrics;
        Color color = styleRange.foreground;
        if (color != null) {
            gC.setForeground(color);
        }
        if ((bullet.type & 1) != 0 && StyledText.IS_MOTIF) {
            int n7 = Math.max(4, (n5 + n6) / 4);
            if ((n7 & 1) == 0) {
                ++n7;
            }
            if (color == null) {
                Display display = this.styledText.getDisplay();
                color = display.getSystemColor(2);
            }
            gC.setBackground(color);
            int n8 = n2 + Math.max(0, glyphMetrics.width - n7 - 8);
            gC.fillArc(n8, n3 + n7, n7 + 1, n7 + 1, 0, 360);
            return;
        }
        Font font = styleRange.font;
        if (font != null) {
            gC.setFont(font);
        }
        String string = "";
        int n9 = bullet.type & 0xF;
        switch (n9) {
            case 1: {
                string = "\u2022";
                break;
            }
            case 2: {
                string = String.valueOf(n4);
                break;
            }
            case 4: {
                string = String.valueOf((char)(n4 % 26 + 97));
                break;
            }
            case 8: {
                string = String.valueOf((char)(n4 % 26 + 65));
            }
        }
        if ((bullet.type & 0x10) != 0) {
            string = string + bullet.text;
        }
        Display display = this.styledText.getDisplay();
        TextLayout textLayout = new TextLayout(display);
        textLayout.setText(string);
        textLayout.setAscent(n5);
        textLayout.setDescent(n6);
        styleRange = (StyleRange)styleRange.clone();
        styleRange.metrics = null;
        if (styleRange.font == null) {
            styleRange.font = this.getFont(styleRange.fontStyle);
        }
        textLayout.setStyle(styleRange, 0, string.length());
        int n10 = n2 + Math.max(0, glyphMetrics.width - textLayout.getBounds().width - 8);
        textLayout.draw(gC, n10, n3);
        textLayout.dispose();
    }

    int drawLine(int n2, int n3, int n4, GC gC, Color color, Color color2) {
        int n5;
        int n6;
        Object object;
        int n7;
        int n8;
        boolean bl;
        TextLayout textLayout = this.getTextLayout(n2);
        String string = this.content.getLine(n2);
        int n9 = this.content.getOffsetAtLine(n2);
        int n10 = string.length();
        Point point = this.styledText.getSelection();
        int n11 = point.x;
        int n12 = point.y;
        Rectangle rectangle = this.styledText.getClientArea();
        Color color3 = this.getLineBackground(n2, color);
        StyledTextEvent styledTextEvent = this.styledText.getLineBackgroundData(n9, string);
        if (styledTextEvent != null && styledTextEvent.lineBackground != null) {
            color3 = styledTextEvent.lineBackground;
        }
        boolean bl2 = bl = (this.styledText.getStyle() & 0x10000) != 0;
        if (!bl || n11 > n9 || n12 <= n9 + n10) {
            gC.setBackground(color3);
            this.styledText.drawBackground(gC, rectangle.x, n4, rectangle.width, textLayout.getBounds().height);
        }
        if (n11 != n12) {
            int n13;
            n8 = n4;
            gC.setBackground(this.styledText.getSelectionBackground());
            n7 = textLayout.getLineCount();
            if (bl) {
                object = textLayout.getLineOffsets();
                for (n13 = 0; n13 < n7 - 1 && (n6 = object[n13]) < n12 - n9; ++n13) {
                    n5 = object[n13 + 1];
                    Rectangle rectangle2 = textLayout.getLineBounds(n13);
                    if (n11 - n9 <= n5 && n5 <= n12 - n9) {
                        int n14 = n3 + rectangle2.x + rectangle2.width;
                        gC.fillRectangle(n14, n8, rectangle.width - n14, rectangle2.height);
                    }
                    n8 += rectangle2.height + textLayout.getSpacing();
                }
            }
            if (n11 - n9 <= n10 && n10 < n12 - n9) {
                object = textLayout.getLineBounds(n7 - 1);
                n13 = n3 + object.x + object.width;
                if (bl) {
                    gC.fillRectangle(n13, n4 + object.y, rectangle.width - this.styledText.rightMargin - n13, object.height);
                } else {
                    gC.fillRectangle(n13, n4 + object.y, this.lineEndSpaceWidth, object.height);
                }
            }
        }
        gC.setForeground(color2);
        gC.setBackground(color3);
        if (n11 == n12 || n12 <= n9 && n11 > n9 + n10 - 1) {
            textLayout.draw(gC, n3, n4);
        } else {
            n8 = Math.max(0, n11 - n9);
            n7 = Math.min(n10, n12 - n9);
            object = this.styledText.getSelectionForeground();
            Color color4 = this.styledText.getSelectionBackground();
            textLayout.draw(gC, n3, n4, n8, n7 - 1, (Color)object, color4);
        }
        Bullet bullet = null;
        n7 = -1;
        if (this.bullets != null) {
            if (this.bulletsIndices != null) {
                int n15 = n2 - this.topIndex;
                if (0 <= n15 && n15 < 128) {
                    bullet = this.bullets[n15];
                    n7 = this.bulletsIndices[n15];
                }
            } else {
                for (int i2 = 0; i2 < this.bullets.length && (n7 = (bullet = this.bullets[i2]).indexOf(n2)) == -1; ++i2) {
                }
            }
        }
        if (n7 != -1 && bullet != null) {
            FontMetrics fontMetrics = textLayout.getLineMetrics(0);
            int n16 = fontMetrics.getAscent() + fontMetrics.getLeading();
            if (bullet.type == 32) {
                bullet.style.start = n9;
                this.styledText.paintObject(gC, n3, n4, n16, fontMetrics.getDescent(), bullet.style, bullet, n7);
            } else {
                this.drawBullet(bullet, gC, n3, n4, n7, n16, fontMetrics.getDescent());
            }
        }
        TextStyle[] textStyleArray = textLayout.getStyles();
        int[] nArray = null;
        for (n6 = 0; n6 < textStyleArray.length; ++n6) {
            if (textStyleArray[n6].metrics == null) continue;
            if (nArray == null) {
                nArray = textLayout.getRanges();
            }
            n5 = nArray[n6 << 1];
            int n17 = nArray[(n6 << 1) + 1] - n5;
            Point point2 = textLayout.getLocation(n5, false);
            FontMetrics fontMetrics = textLayout.getLineMetrics(textLayout.getLineIndex(n5));
            StyleRange styleRange = (StyleRange)((StyleRange)textStyleArray[n6]).clone();
            styleRange.start = n5 + n9;
            styleRange.length = n17;
            int n18 = fontMetrics.getAscent() + fontMetrics.getLeading();
            this.styledText.paintObject(gC, point2.x + n3, point2.y + n4, n18, fontMetrics.getDescent(), styleRange, null, 0);
        }
        n6 = textLayout.getBounds().height;
        this.disposeTextLayout(textLayout);
        return n6;
    }

    int getBaseline() {
        return this.ascent;
    }

    Font getFont(int n2) {
        switch (n2) {
            case 1: {
                if (this.boldFont != null) {
                    return this.boldFont;
                }
                this.boldFont = new Font(this.device, this.getFontData(n2));
                return this.boldFont;
            }
            case 2: {
                if (this.italicFont != null) {
                    return this.italicFont;
                }
                this.italicFont = new Font(this.device, this.getFontData(n2));
                return this.italicFont;
            }
            case 3: {
                if (this.boldItalicFont != null) {
                    return this.boldItalicFont;
                }
                this.boldItalicFont = new Font(this.device, this.getFontData(n2));
                return this.boldItalicFont;
            }
        }
        return this.regularFont;
    }

    FontData[] getFontData(int n2) {
        FontData[] fontDataArray = this.regularFont.getFontData();
        for (int i2 = 0; i2 < fontDataArray.length; ++i2) {
            fontDataArray[i2].setStyle(n2);
        }
        return fontDataArray;
    }

    int getHeight() {
        int n2 = this.getLineHeight();
        if (this.styledText.isFixedLineHeight()) {
            return this.lineCount * n2;
        }
        int n3 = 0;
        int n4 = this.styledText.getWrapWidth();
        for (int i2 = 0; i2 < this.lineCount; ++i2) {
            int n5 = this.lineHeight[i2];
            if (n5 == -1) {
                if (n4 > 0) {
                    int n6 = this.content.getLine(i2).length();
                    n5 = (n6 * this.averageCharWidth / n4 + 1) * n2;
                } else {
                    n5 = n2;
                }
            }
            n3 += n5;
        }
        return n3 + this.styledText.topMargin + this.styledText.bottomMargin;
    }

    int getLineAlignment(int n2, int n3) {
        if (this.lines == null) {
            return n3;
        }
        LineInfo lineInfo = this.lines[n2];
        if (lineInfo != null && (lineInfo.flags & 2) != 0) {
            return lineInfo.alignment;
        }
        return n3;
    }

    Color getLineBackground(int n2, Color color) {
        if (this.lines == null) {
            return color;
        }
        LineInfo lineInfo = this.lines[n2];
        if (lineInfo != null && (lineInfo.flags & 1) != 0) {
            return lineInfo.background;
        }
        return color;
    }

    Bullet getLineBullet(int n2, Bullet bullet) {
        if (this.bullets == null) {
            return bullet;
        }
        if (this.bulletsIndices != null) {
            return bullet;
        }
        for (int i2 = 0; i2 < this.bullets.length; ++i2) {
            Bullet bullet2 = this.bullets[i2];
            if (bullet2.indexOf(n2) == -1) continue;
            return bullet2;
        }
        return bullet;
    }

    int getLineEndSpace() {
        return this.lineEndSpaceWidth;
    }

    int getLineHeight() {
        return this.ascent + this.descent;
    }

    int getLineHeight(int n2) {
        if (this.lineHeight[n2] == -1) {
            this.calculate(n2, 1);
        }
        return this.lineHeight[n2];
    }

    int getLineIndent(int n2, int n3) {
        if (this.lines == null) {
            return n3;
        }
        LineInfo lineInfo = this.lines[n2];
        if (lineInfo != null && (lineInfo.flags & 4) != 0) {
            return lineInfo.indent;
        }
        return n3;
    }

    boolean getLineJustify(int n2, boolean bl) {
        if (this.lines == null) {
            return bl;
        }
        LineInfo lineInfo = this.lines[n2];
        if (lineInfo != null && (lineInfo.flags & 8) != 0) {
            return lineInfo.justify;
        }
        return bl;
    }

    int[] getLineSegments(int n2, int[] nArray) {
        if (this.lines == null) {
            return nArray;
        }
        LineInfo lineInfo = this.lines[n2];
        if (lineInfo != null && (lineInfo.flags & 0x20) != 0) {
            return lineInfo.segments;
        }
        return nArray;
    }

    int getRangeIndex(int n2, int n3, int n4) {
        if (this.styleCount == 0) {
            return 0;
        }
        if (this.ranges != null) {
            while (n4 - n3 > 2) {
                int n5 = (n4 + n3) / 2 / 2 * 2;
                int n6 = this.ranges[n5] + this.ranges[n5 + 1];
                if (n6 > n2) {
                    n4 = n5;
                    continue;
                }
                n3 = n5;
            }
        } else {
            while (n4 - n3 > 1) {
                int n7 = (n4 + n3) / 2;
                int n8 = this.styles[n7].start + this.styles[n7].length;
                if (n8 > n2) {
                    n4 = n7;
                    continue;
                }
                n3 = n7;
            }
        }
        return n4;
    }

    int[] getRanges(int n2, int n3) {
        int[] nArray;
        int n4 = n2 + n3 - 1;
        if (this.ranges != null) {
            int n5 = this.styleCount << 1;
            int n6 = this.getRangeIndex(n2, -1, n5);
            if (n6 >= n5) {
                return null;
            }
            if (this.ranges[n6] > n4) {
                return null;
            }
            int n7 = Math.min(n5 - 2, this.getRangeIndex(n4, n6 - 1, n5) + 1);
            nArray = new int[n7 - n6 + 2];
            System.arraycopy(this.ranges, n6, nArray, 0, nArray.length);
        } else {
            int n8 = this.getRangeIndex(n2, -1, this.styleCount);
            if (n8 >= this.styleCount) {
                return null;
            }
            if (this.styles[n8].start > n4) {
                return null;
            }
            int n9 = Math.min(this.styleCount - 1, this.getRangeIndex(n4, n8 - 1, this.styleCount));
            nArray = new int[n9 - n8 + 1 << 1];
            int n10 = n8;
            int n11 = 0;
            while (n10 <= n9) {
                StyleRange styleRange = this.styles[n10];
                nArray[n11] = styleRange.start;
                nArray[n11 + 1] = styleRange.length;
                ++n10;
                n11 += 2;
            }
        }
        if (n2 > nArray[0]) {
            nArray[1] = nArray[0] + nArray[1] - n2;
            nArray[0] = n2;
        }
        if (n4 < nArray[nArray.length - 2] + nArray[nArray.length - 1] - 1) {
            nArray[nArray.length - 1] = n4 - nArray[nArray.length - 2];
        }
        return nArray;
    }

    StyleRange[] getStyleRanges(int n2, int n3, boolean bl) {
        StyleRange[] styleRangeArray;
        int n4;
        int n5 = n2 + n3 - 1;
        if (this.ranges != null) {
            n4 = this.styleCount << 1;
            int n6 = this.getRangeIndex(n2, -1, n4);
            if (n6 >= n4) {
                return null;
            }
            if (this.ranges[n6] > n5) {
                return null;
            }
            int n7 = Math.min(n4 - 2, this.getRangeIndex(n5, n6 - 1, n4) + 1);
            styleRangeArray = new StyleRange[(n7 - n6 >> 1) + 1];
            if (bl) {
                int n8 = n6;
                int n9 = 0;
                while (n8 <= n7) {
                    styleRangeArray[n9] = (StyleRange)this.styles[n8 >> 1].clone();
                    styleRangeArray[n9].start = this.ranges[n8];
                    styleRangeArray[n9].length = this.ranges[n8 + 1];
                    n8 += 2;
                    ++n9;
                }
            } else {
                System.arraycopy(this.styles, n6 >> 1, styleRangeArray, 0, styleRangeArray.length);
            }
        } else {
            n4 = this.getRangeIndex(n2, -1, this.styleCount);
            if (n4 >= this.styleCount) {
                return null;
            }
            if (this.styles[n4].start > n5) {
                return null;
            }
            int n10 = Math.min(this.styleCount - 1, this.getRangeIndex(n5, n4 - 1, this.styleCount));
            styleRangeArray = new StyleRange[n10 - n4 + 1];
            System.arraycopy(this.styles, n4, styleRangeArray, 0, styleRangeArray.length);
        }
        StyleRange styleRange = styleRangeArray[0];
        if (n2 > styleRange.start) {
            if (!bl || this.ranges == null) {
                styleRangeArray[0] = styleRange = (StyleRange)styleRange.clone();
            }
            styleRange.length = styleRange.start + styleRange.length - n2;
            styleRange.start = n2;
        }
        styleRange = styleRangeArray[styleRangeArray.length - 1];
        if (n5 < styleRange.start + styleRange.length - 1) {
            if (!bl || this.ranges == null) {
                styleRangeArray[styleRangeArray.length - 1] = styleRange = (StyleRange)styleRange.clone();
            }
            styleRange.length = n5 - styleRange.start + 1;
        }
        return styleRangeArray;
    }

    StyleRange getStyleRange(StyleRange styleRange) {
        if (styleRange.start == 0 && styleRange.length == 0 && styleRange.fontStyle == 0) {
            return styleRange;
        }
        StyleRange styleRange2 = (StyleRange)styleRange.clone();
        styleRange2.length = 0;
        styleRange2.start = 0;
        styleRange2.fontStyle = 0;
        if (styleRange2.font == null) {
            styleRange2.font = this.getFont(styleRange.fontStyle);
        }
        return styleRange2;
    }

    TextLayout getTextLayout(int n2) {
        return this.getTextLayout(n2, this.styledText.getOrientation(), this.styledText.getWrapWidth(), this.styledText.lineSpacing);
    }

    TextLayout getTextLayout(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        TextLayout textLayout = null;
        if (this.styledText != null) {
            int n12;
            int n13;
            int n14 = n13 = this.styledText.topIndex > 0 ? this.styledText.topIndex - 1 : 0;
            if (this.layouts == null || n13 != this.topIndex) {
                int n15;
                TextLayout[] textLayoutArray = new TextLayout[128];
                if (this.layouts != null) {
                    for (n15 = 0; n15 < this.layouts.length; ++n15) {
                        if (this.layouts[n15] == null) continue;
                        n11 = n15 + this.topIndex - n13;
                        if (0 <= n11 && n11 < textLayoutArray.length) {
                            textLayoutArray[n11] = this.layouts[n15];
                            continue;
                        }
                        this.layouts[n15].dispose();
                    }
                }
                if (this.bullets != null && this.bulletsIndices != null && n13 != this.topIndex) {
                    n15 = n13 - this.topIndex;
                    if (n15 > 0) {
                        if (n15 < this.bullets.length) {
                            System.arraycopy(this.bullets, n15, this.bullets, 0, this.bullets.length - n15);
                            System.arraycopy(this.bulletsIndices, n15, this.bulletsIndices, 0, this.bulletsIndices.length - n15);
                        }
                        for (n10 = n11 = Math.max(0, this.bullets.length - n15); n10 < this.bullets.length; ++n10) {
                            this.bullets[n10] = null;
                        }
                    } else {
                        if (-n15 < this.bullets.length) {
                            System.arraycopy(this.bullets, 0, this.bullets, -n15, this.bullets.length + n15);
                            System.arraycopy(this.bulletsIndices, 0, this.bulletsIndices, -n15, this.bulletsIndices.length + n15);
                        }
                        n11 = Math.min(this.bullets.length, -n15);
                        for (n10 = 0; n10 < n11; ++n10) {
                            this.bullets[n10] = null;
                        }
                    }
                }
                this.topIndex = n13;
                this.layouts = textLayoutArray;
            }
            if (this.layouts != null && 0 <= (n12 = n2 - n13) && n12 < this.layouts.length) {
                textLayout = this.layouts[n12];
                if (textLayout != null) {
                    if (this.lineWidth[n2] != -1) {
                        return textLayout;
                    }
                } else {
                    textLayout = this.layouts[n12] = new TextLayout(this.device);
                }
            }
        }
        if (textLayout == null) {
            textLayout = new TextLayout(this.device);
        }
        String string = this.content.getLine(n2);
        int n16 = this.content.getOffsetAtLine(n2);
        int[] nArray = null;
        n11 = 0;
        n10 = 16384;
        boolean bl = false;
        Bullet bullet = null;
        int[] nArray2 = null;
        StyleRange[] styleRangeArray = null;
        int n17 = 0;
        int n18 = 0;
        StyledTextEvent styledTextEvent = null;
        if (this.styledText != null) {
            styledTextEvent = this.styledText.getLineStyleData(n16, string);
            nArray = this.styledText.getBidiSegments(n16, string);
            n11 = this.styledText.indent;
            n10 = this.styledText.alignment;
            bl = this.styledText.justify;
        }
        if (styledTextEvent != null) {
            int n19;
            n11 = styledTextEvent.indent;
            n10 = styledTextEvent.alignment;
            bl = styledTextEvent.justify;
            bullet = styledTextEvent.bullet;
            nArray2 = styledTextEvent.ranges;
            styleRangeArray = styledTextEvent.styles;
            if (styleRangeArray != null) {
                n18 = styleRangeArray.length;
                if (this.styledText.isFixedLineHeight()) {
                    for (n19 = 0; n19 < n18; ++n19) {
                        if (!styleRangeArray[n19].isVariableHeight()) continue;
                        this.styledText.verticalScrollOffset = -1;
                        this.styledText.setVariableLineHeight();
                        this.styledText.redraw();
                        break;
                    }
                }
            }
            if (this.bullets == null || this.bulletsIndices == null) {
                this.bullets = new Bullet[128];
                this.bulletsIndices = new int[128];
            }
            if (0 <= (n19 = n2 - this.topIndex) && n19 < 128) {
                this.bullets[n19] = bullet;
                this.bulletsIndices[n19] = styledTextEvent.bulletIndex;
            }
        } else {
            LineInfo lineInfo;
            if (this.lines != null && (lineInfo = this.lines[n2]) != null) {
                if ((lineInfo.flags & 4) != 0) {
                    n11 = lineInfo.indent;
                }
                if ((lineInfo.flags & 2) != 0) {
                    n10 = lineInfo.alignment;
                }
                if ((lineInfo.flags & 8) != 0) {
                    bl = lineInfo.justify;
                }
                if ((lineInfo.flags & 0x20) != 0) {
                    nArray = lineInfo.segments;
                }
            }
            if (this.bulletsIndices != null) {
                this.bullets = null;
                this.bulletsIndices = null;
            }
            if (this.bullets != null) {
                for (int i2 = 0; i2 < this.bullets.length; ++i2) {
                    if (this.bullets[i2].indexOf(n2) == -1) continue;
                    bullet = this.bullets[i2];
                    break;
                }
            }
            nArray2 = this.ranges;
            styleRangeArray = this.styles;
            n18 = this.styleCount;
            n17 = nArray2 != null ? this.getRangeIndex(n16, -1, n18 << 1) : this.getRangeIndex(n16, -1, n18);
        }
        if (bullet != null) {
            StyleRange styleRange = bullet.style;
            GlyphMetrics glyphMetrics = styleRange.metrics;
            n11 += glyphMetrics.width;
        }
        textLayout.setFont(this.regularFont);
        textLayout.setAscent(this.ascent);
        textLayout.setDescent(this.descent);
        textLayout.setText(string);
        textLayout.setOrientation(n3);
        textLayout.setSegments(nArray);
        textLayout.setWidth(n4);
        textLayout.setSpacing(n5);
        textLayout.setTabs(new int[]{this.tabWidth});
        textLayout.setIndent(n11);
        textLayout.setAlignment(n10);
        textLayout.setJustify(bl);
        int n20 = 0;
        int n21 = string.length();
        if (styleRangeArray != null) {
            if (nArray2 != null) {
                n9 = n18 << 1;
                for (n8 = n17; n8 < n9; n8 += 2) {
                    if (n16 > nArray2[n8]) {
                        n7 = 0;
                        n6 = Math.min(n21, nArray2[n8 + 1] - n16 + nArray2[n8]);
                    } else {
                        n7 = nArray2[n8] - n16;
                        n6 = Math.min(n21, n7 + nArray2[n8 + 1]);
                    }
                    if (n7 < n21) {
                        if (n20 < n7) {
                            textLayout.setStyle(null, n20, n7 - 1);
                        }
                        textLayout.setStyle(this.getStyleRange(styleRangeArray[n8 >> 1]), n7, n6);
                        n20 = Math.max(n20, n6);
                        continue;
                    }
                    break;
                }
            } else {
                for (n9 = n17; n9 < n18; ++n9) {
                    if (n16 > styleRangeArray[n9].start) {
                        n8 = 0;
                        n7 = Math.min(n21, styleRangeArray[n9].length - n16 + styleRangeArray[n9].start);
                    } else {
                        n8 = styleRangeArray[n9].start - n16;
                        n7 = Math.min(n21, n8 + styleRangeArray[n9].length);
                    }
                    if (n8 < n21) {
                        if (n20 < n8) {
                            textLayout.setStyle(null, n20, n8 - 1);
                        }
                        textLayout.setStyle(this.getStyleRange(styleRangeArray[n9]), n8, n7);
                        n20 = Math.max(n20, n7);
                        continue;
                    }
                    break;
                }
            }
        }
        if (n20 < n21) {
            textLayout.setStyle(null, n20, n21);
        }
        if (this.styledText != null && this.styledText.isFixedLineHeight()) {
            int n22;
            n9 = -1;
            n8 = textLayout.getLineCount();
            n7 = this.getLineHeight();
            for (n6 = 0; n6 < n8; ++n6) {
                n22 = textLayout.getLineBounds((int)n6).height;
                if (n22 <= n7) continue;
                n7 = n22;
                n9 = n6;
            }
            if (n9 != -1) {
                FontMetrics fontMetrics = textLayout.getLineMetrics(n9);
                this.ascent = fontMetrics.getAscent() + fontMetrics.getLeading();
                this.descent = fontMetrics.getDescent();
                if (this.layouts != null) {
                    for (n22 = 0; n22 < this.layouts.length; ++n22) {
                        if (this.layouts[n22] == null || this.layouts[n22] == textLayout) continue;
                        this.layouts[n22].setAscent(this.ascent);
                        this.layouts[n22].setDescent(this.descent);
                    }
                }
                if (this.styledText.verticalScrollOffset != 0) {
                    n22 = this.styledText.topIndex;
                    int n23 = this.styledText.topIndexY;
                    int n24 = this.getLineHeight();
                    this.styledText.verticalScrollOffset = n23 >= 0 ? (n22 - 1) * n24 + n24 - n23 : n22 * n24 - n23;
                }
                this.styledText.calculateScrollBars();
                if (this.styledText.isBidiCaret()) {
                    this.styledText.createCaretBitmaps();
                }
                this.styledText.caretDirection = 0;
                this.styledText.setCaretLocation();
                this.styledText.redraw();
            }
        }
        return textLayout;
    }

    int getWidth() {
        return this.maxWidth;
    }

    void reset() {
        if (this.layouts != null) {
            for (int i2 = 0; i2 < this.layouts.length; ++i2) {
                TextLayout textLayout = this.layouts[i2];
                if (textLayout == null) continue;
                textLayout.dispose();
            }
            this.layouts = null;
        }
        this.topIndex = -1;
        this.lineCount = 0;
        this.styleCount = 0;
        this.stylesSetCount = 0;
        this.ranges = null;
        this.styles = null;
        this.stylesSet = null;
        this.lines = null;
        this.lineWidth = null;
        this.lineHeight = null;
        this.bullets = null;
        this.bulletsIndices = null;
        this.redrawLines = null;
    }

    void reset(int n2, int n3) {
        int n4;
        int n5 = n2 + n3;
        if (n2 < 0 || n5 > this.lineWidth.length) {
            return;
        }
        for (n4 = n2; n4 < n5; ++n4) {
            this.lineWidth[n4] = -1;
            this.lineHeight[n4] = -1;
        }
        if (n2 <= this.maxWidthLineIndex && this.maxWidthLineIndex < n5) {
            this.maxWidth = 0;
            this.maxWidthLineIndex = -1;
            if (n3 != this.lineCount) {
                for (n4 = 0; n4 < this.lineCount; ++n4) {
                    if (this.lineWidth[n4] <= this.maxWidth) continue;
                    this.maxWidth = this.lineWidth[n4];
                    this.maxWidthLineIndex = n4;
                }
            }
        }
    }

    void setContent(StyledTextContent styledTextContent) {
        this.reset();
        this.content = styledTextContent;
        this.lineCount = styledTextContent.getLineCount();
        this.lineWidth = new int[this.lineCount];
        this.lineHeight = new int[this.lineCount];
        this.reset(0, this.lineCount);
    }

    void setFont(Font font, int n2) {
        Object object;
        TextLayout textLayout = new TextLayout(this.device);
        textLayout.setFont(this.regularFont);
        if (font != null) {
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            if (this.italicFont != null) {
                this.italicFont.dispose();
            }
            if (this.boldItalicFont != null) {
                this.boldItalicFont.dispose();
            }
            this.boldItalicFont = null;
            this.italicFont = null;
            this.boldFont = null;
            this.regularFont = font;
            textLayout.setText("    ");
            textLayout.setFont(font);
            textLayout.setStyle(new TextStyle(this.getFont(0), null, null), 0, 0);
            textLayout.setStyle(new TextStyle(this.getFont(1), null, null), 1, 1);
            textLayout.setStyle(new TextStyle(this.getFont(2), null, null), 2, 2);
            textLayout.setStyle(new TextStyle(this.getFont(3), null, null), 3, 3);
            object = textLayout.getLineMetrics(0);
            this.ascent = ((FontMetrics)object).getAscent() + ((FontMetrics)object).getLeading();
            this.descent = ((FontMetrics)object).getDescent();
            this.lineEndSpaceWidth = textLayout.getBounds((int)0, (int)0).width;
            this.boldFont.dispose();
            this.italicFont.dispose();
            this.boldItalicFont.dispose();
            this.boldItalicFont = null;
            this.italicFont = null;
            this.boldFont = null;
        }
        textLayout.dispose();
        textLayout = new TextLayout(this.device);
        textLayout.setFont(this.regularFont);
        object = new StringBuffer(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            ((StringBuffer)object).append(' ');
        }
        textLayout.setText(((StringBuffer)object).toString());
        this.tabWidth = textLayout.getBounds().width;
        textLayout.dispose();
    }

    void setLineAlignment(int n2, int n3, int n4) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (this.lines[i2] == null) {
                this.lines[i2] = new LineInfo();
            }
            this.lines[i2].flags |= 2;
            this.lines[i2].alignment = n4;
        }
    }

    void setLineBackground(int n2, int n3, Color color) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (this.lines[i2] == null) {
                this.lines[i2] = new LineInfo();
            }
            this.lines[i2].flags |= 1;
            this.lines[i2].background = color;
        }
    }

    void setLineBullet(int n2, int n3, Bullet bullet) {
        int n4;
        if (this.bulletsIndices != null) {
            this.bulletsIndices = null;
            this.bullets = null;
        }
        if (this.bullets == null) {
            if (bullet == null) {
                return;
            }
            this.bullets = new Bullet[1];
            this.bullets[0] = bullet;
        }
        for (n4 = 0; n4 < this.bullets.length && bullet != this.bullets[n4]; ++n4) {
        }
        if (bullet != null) {
            if (n4 == this.bullets.length) {
                Bullet[] bulletArray = new Bullet[this.bullets.length + 1];
                System.arraycopy(this.bullets, 0, bulletArray, 0, this.bullets.length);
                bulletArray[n4] = bullet;
                this.bullets = bulletArray;
            }
            bullet.addIndices(n2, n3);
        } else {
            this.updateBullets(n2, n3, 0, false);
            this.styledText.redrawLinesBullet(this.redrawLines);
            this.redrawLines = null;
        }
    }

    void setLineIndent(int n2, int n3, int n4) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (this.lines[i2] == null) {
                this.lines[i2] = new LineInfo();
            }
            this.lines[i2].flags |= 4;
            this.lines[i2].indent = n4;
        }
    }

    void setLineJustify(int n2, int n3, boolean bl) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (this.lines[i2] == null) {
                this.lines[i2] = new LineInfo();
            }
            this.lines[i2].flags |= 8;
            this.lines[i2].justify = bl;
        }
    }

    void setLineSegments(int n2, int n3, int[] nArray) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (this.lines[i2] == null) {
                this.lines[i2] = new LineInfo();
            }
            this.lines[i2].flags |= 0x20;
            this.lines[i2].segments = nArray;
        }
    }

    void setStyleRanges(int[] nArray, StyleRange[] styleRangeArray) {
        int n2;
        int n3;
        int n4;
        if (styleRangeArray == null) {
            this.styleCount = 0;
            this.stylesSetCount = 0;
            this.ranges = null;
            this.styles = null;
            this.stylesSet = null;
            return;
        }
        if (nArray == null) {
            nArray = new int[styleRangeArray.length << 1];
            StyleRange[] styleRangeArray2 = new StyleRange[styleRangeArray.length];
            if (this.stylesSet == null) {
                this.stylesSet = new StyleRange[4];
            }
            n4 = 0;
            for (n3 = 0; n3 < styleRangeArray.length; ++n3) {
                StyleRange styleRange = styleRangeArray[n3];
                nArray[n4++] = styleRange.start;
                nArray[n4++] = styleRange.length;
                for (n2 = 0; n2 < this.stylesSetCount && !this.stylesSet[n2].similarTo(styleRange); ++n2) {
                }
                if (n2 == this.stylesSetCount) {
                    if (this.stylesSetCount == this.stylesSet.length) {
                        StyleRange[] styleRangeArray3 = new StyleRange[this.stylesSetCount + 4];
                        System.arraycopy(this.stylesSet, 0, styleRangeArray3, 0, this.stylesSetCount);
                        this.stylesSet = styleRangeArray3;
                    }
                    this.stylesSet[this.stylesSetCount++] = styleRange;
                }
                styleRangeArray2[n3] = this.stylesSet[n2];
            }
            styleRangeArray = styleRangeArray2;
        }
        if (this.styleCount == 0) {
            if (nArray != null) {
                this.ranges = new int[nArray.length];
                System.arraycopy(nArray, 0, this.ranges, 0, this.ranges.length);
            }
            this.styles = new StyleRange[styleRangeArray.length];
            System.arraycopy(styleRangeArray, 0, this.styles, 0, this.styles.length);
            this.styleCount = styleRangeArray.length;
            return;
        }
        if (nArray != null && this.ranges == null) {
            this.ranges = new int[this.styles.length << 1];
            n3 = 0;
            for (int i2 = 0; i2 < this.styleCount; ++i2) {
                this.ranges[n3++] = this.styles[i2].start;
                this.ranges[n3++] = this.styles[i2].length;
            }
        }
        if (nArray == null && this.ranges != null) {
            nArray = new int[styleRangeArray.length << 1];
            n3 = 0;
            for (int i3 = 0; i3 < styleRangeArray.length; ++i3) {
                nArray[n3++] = styleRangeArray[i3].start;
                nArray[n3++] = styleRangeArray[i3].length;
            }
        }
        if (this.ranges != null) {
            n3 = nArray[0];
            int n5 = this.styleCount << 1;
            n4 = this.getRangeIndex(n3, -1, n5);
            int n6 = n2 = n4 == n5 ? 1 : 0;
            if (n2 == 0) {
                int n7 = nArray[nArray.length - 2] + nArray[nArray.length - 1];
                int n8 = this.getRangeIndex(n7, n4 - 1, n5);
                int n9 = n2 = n4 == n8 && this.ranges[n4] >= n7 ? 1 : 0;
            }
            if (n2 != 0) {
                this.addMerge(nArray, styleRangeArray, nArray.length, n4, n4);
                return;
            }
            int n10 = n4;
            int[] nArray2 = new int[6];
            StyleRange[] styleRangeArray4 = new StyleRange[3];
            for (int i4 = 0; i4 < nArray.length; i4 += 2) {
                int n11 = nArray[i4];
                int n12 = n11 + nArray[i4 + 1];
                if (n11 == n12) continue;
                int n13 = 0;
                int n14 = 0;
                while (n10 < n5) {
                    if (n11 >= this.ranges[n4] + this.ranges[n4 + 1]) {
                        n4 += 2;
                    }
                    if (this.ranges[n10] + this.ranges[n10 + 1] > n12) break;
                    n10 += 2;
                }
                if (this.ranges[n4] < n11 && n11 < this.ranges[n4] + this.ranges[n4 + 1]) {
                    styleRangeArray4[n14 >> 1] = this.styles[n4 >> 1];
                    nArray2[n14] = this.ranges[n4];
                    nArray2[n14 + 1] = n11 - this.ranges[n4];
                    n14 += 2;
                }
                styleRangeArray4[n14 >> 1] = styleRangeArray[i4 >> 1];
                nArray2[n14] = n11;
                nArray2[n14 + 1] = nArray[i4 + 1];
                n14 += 2;
                if (n10 < n5 && this.ranges[n10] < n12 && n12 < this.ranges[n10] + this.ranges[n10 + 1]) {
                    styleRangeArray4[n14 >> 1] = this.styles[n10 >> 1];
                    nArray2[n14] = n12;
                    nArray2[n14 + 1] = this.ranges[n10] + this.ranges[n10 + 1] - n12;
                    n14 += 2;
                    n13 = 2;
                }
                int n15 = this.addMerge(nArray2, styleRangeArray4, n14, n4, n10 + n13);
                n5 += n15;
                n4 = n10 += n15;
            }
        } else {
            boolean bl;
            int n16 = styleRangeArray[0].start;
            n3 = this.getRangeIndex(n16, -1, this.styleCount);
            boolean bl2 = bl = n3 == this.styleCount;
            if (!bl) {
                n2 = styleRangeArray[styleRangeArray.length - 1].start + styleRangeArray[styleRangeArray.length - 1].length;
                n4 = this.getRangeIndex(n2, n3 - 1, this.styleCount);
                boolean bl3 = bl = n3 == n4 && this.styles[n3].start >= n2;
            }
            if (bl) {
                this.addMerge(styleRangeArray, styleRangeArray.length, n3, n3);
                return;
            }
            n4 = n3;
            StyleRange[] styleRangeArray5 = new StyleRange[3];
            for (int i5 = 0; i5 < styleRangeArray.length; ++i5) {
                StyleRange styleRange = styleRangeArray[i5];
                int n17 = styleRange.start;
                int n18 = n17 + styleRange.length;
                if (n17 == n18) continue;
                int n19 = 0;
                int n20 = 0;
                while (n4 < this.styleCount) {
                    if (n17 >= this.styles[n3].start + this.styles[n3].length) {
                        ++n3;
                    }
                    if (this.styles[n4].start + this.styles[n4].length > n18) break;
                    ++n4;
                }
                StyleRange styleRange2 = this.styles[n3];
                if (styleRange2.start < n17 && n17 < styleRange2.start + styleRange2.length) {
                    int n21 = n20++;
                    StyleRange styleRange3 = (StyleRange)styleRange2.clone();
                    styleRangeArray5[n21] = styleRange3;
                    styleRange2 = styleRange3;
                    styleRange2.length = n17 - styleRange2.start;
                }
                styleRangeArray5[n20++] = styleRange;
                if (n4 < this.styleCount) {
                    styleRange2 = this.styles[n4];
                    if (styleRange2.start < n18 && n18 < styleRange2.start + styleRange2.length) {
                        int n22 = n20++;
                        StyleRange styleRange4 = (StyleRange)styleRange2.clone();
                        styleRangeArray5[n22] = styleRange4;
                        styleRange2 = styleRange4;
                        styleRange2.length += styleRange2.start - n18;
                        styleRange2.start = n18;
                        n19 = 1;
                    }
                }
                int n23 = this.addMerge(styleRangeArray5, n20, n3, n4 + n19);
                n3 = n4 += n23;
            }
        }
    }

    void textChanging(TextChangingEvent textChangingEvent) {
        int n2 = textChangingEvent.start;
        int n3 = textChangingEvent.newCharCount;
        int n4 = textChangingEvent.replaceCharCount;
        int n5 = textChangingEvent.newLineCount;
        int n6 = textChangingEvent.replaceLineCount;
        this.updateRanges(n2, n4, n3);
        int n7 = this.content.getLineAtOffset(n2);
        if (n4 == this.content.getCharCount()) {
            this.lines = null;
        }
        if (n6 == this.lineCount) {
            this.lineCount = n5;
            this.lineWidth = new int[this.lineCount];
            this.lineHeight = new int[this.lineCount];
            this.reset(0, this.lineCount);
        } else {
            int n8;
            int n9;
            Object[] objectArray;
            int n10 = n5 - n6;
            if (this.lineCount + n10 > this.lineWidth.length) {
                objectArray = new int[this.lineCount + n10 + 32];
                System.arraycopy(this.lineWidth, 0, objectArray, 0, this.lineCount);
                this.lineWidth = objectArray;
                int[] nArray = new int[this.lineCount + n10 + 32];
                System.arraycopy(this.lineHeight, 0, nArray, 0, this.lineCount);
                this.lineHeight = nArray;
            }
            if (this.lines != null && this.lineCount + n10 > this.lines.length) {
                objectArray = new LineInfo[this.lineCount + n10 + 32];
                System.arraycopy(this.lines, 0, objectArray, 0, this.lineCount);
                this.lines = (LineInfo[])objectArray;
            }
            int n11 = n7 + n6 + 1;
            int n12 = n7 + n5 + 1;
            System.arraycopy(this.lineWidth, n11, this.lineWidth, n12, this.lineCount - n11);
            System.arraycopy(this.lineHeight, n11, this.lineHeight, n12, this.lineCount - n11);
            for (n9 = n7; n9 < n12; ++n9) {
                this.lineHeight[n9] = -1;
                this.lineWidth[n9] = -1;
            }
            for (n9 = this.lineCount + n10; n9 < this.lineCount; ++n9) {
                this.lineHeight[n9] = -1;
                this.lineWidth[n9] = -1;
            }
            if (this.layouts != null) {
                int n13;
                n9 = n7 - this.topIndex;
                n8 = n9 + n6 + 1;
                for (n13 = n9; n13 < n8; ++n13) {
                    if (0 > n13 || n13 >= this.layouts.length) continue;
                    if (this.layouts[n13] != null) {
                        this.layouts[n13].dispose();
                    }
                    this.layouts[n13] = null;
                    if (this.bullets == null || this.bulletsIndices == null) continue;
                    this.bullets[n13] = null;
                }
                if (n10 > 0) {
                    for (n13 = this.layouts.length - 1; n13 >= n8; --n13) {
                        if (0 > n13 || n13 >= this.layouts.length) continue;
                        n12 = n13 + n10;
                        if (0 <= n12 && n12 < this.layouts.length) {
                            this.layouts[n12] = this.layouts[n13];
                            this.layouts[n13] = null;
                            if (this.bullets == null || this.bulletsIndices == null) continue;
                            this.bullets[n12] = this.bullets[n13];
                            this.bulletsIndices[n12] = this.bulletsIndices[n13];
                            this.bullets[n13] = null;
                            continue;
                        }
                        if (this.layouts[n13] != null) {
                            this.layouts[n13].dispose();
                        }
                        this.layouts[n13] = null;
                        if (this.bullets == null || this.bulletsIndices == null) continue;
                        this.bullets[n13] = null;
                    }
                } else if (n10 < 0) {
                    for (n13 = n8; n13 < this.layouts.length; ++n13) {
                        if (0 > n13 || n13 >= this.layouts.length) continue;
                        n12 = n13 + n10;
                        if (0 <= n12 && n12 < this.layouts.length) {
                            this.layouts[n12] = this.layouts[n13];
                            this.layouts[n13] = null;
                            if (this.bullets == null || this.bulletsIndices == null) continue;
                            this.bullets[n12] = this.bullets[n13];
                            this.bulletsIndices[n12] = this.bulletsIndices[n13];
                            this.bullets[n13] = null;
                            continue;
                        }
                        if (this.layouts[n13] != null) {
                            this.layouts[n13].dispose();
                        }
                        this.layouts[n13] = null;
                        if (this.bullets == null || this.bulletsIndices == null) continue;
                        this.bullets[n13] = null;
                    }
                }
            }
            if (n6 != 0 || n5 != 0) {
                n9 = this.content.getOffsetAtLine(n7);
                if (n9 != n2) {
                    ++n7;
                }
                this.updateBullets(n7, n6, n5, true);
                if (this.lines != null) {
                    n11 = n7 + n6;
                    n12 = n7 + n5;
                    System.arraycopy(this.lines, n11, this.lines, n12, this.lineCount - n11);
                    for (n8 = n7; n8 < n12; ++n8) {
                        this.lines[n8] = null;
                    }
                    for (n8 = this.lineCount + n10; n8 < this.lineCount; ++n8) {
                        this.lines[n8] = null;
                    }
                }
            }
            this.lineCount += n10;
            if (this.maxWidthLineIndex != -1 && n7 <= this.maxWidthLineIndex && this.maxWidthLineIndex <= n7 + n6) {
                this.maxWidth = 0;
                this.maxWidthLineIndex = -1;
                for (n9 = 0; n9 < this.lineCount; ++n9) {
                    if (this.lineWidth[n9] <= this.maxWidth) continue;
                    this.maxWidth = this.lineWidth[n9];
                    this.maxWidthLineIndex = n9;
                }
            }
        }
    }

    void updateBullets(int n2, int n3, int n4, boolean bl) {
        int n5;
        if (this.bullets == null) {
            return;
        }
        if (this.bulletsIndices != null) {
            return;
        }
        for (n5 = 0; n5 < this.bullets.length; ++n5) {
            Bullet bullet = this.bullets[n5];
            int[] nArray = bullet.removeIndices(n2, n3, n4, bl);
            if (nArray == null) continue;
            if (this.redrawLines == null) {
                this.redrawLines = nArray;
                continue;
            }
            int[] nArray2 = new int[this.redrawLines.length + nArray.length];
            System.arraycopy(this.redrawLines, 0, nArray2, 0, this.redrawLines.length);
            System.arraycopy(nArray, 0, nArray2, this.redrawLines.length, nArray.length);
            this.redrawLines = nArray2;
        }
        n5 = 0;
        for (int i2 = 0; i2 < this.bullets.length; ++i2) {
            if (this.bullets[i2].size() != 0) continue;
            ++n5;
        }
        if (n5 > 0) {
            if (n5 == this.bullets.length) {
                this.bullets = null;
            } else {
                Bullet[] bulletArray = new Bullet[this.bullets.length - n5];
                int n6 = 0;
                for (int i3 = 0; i3 < this.bullets.length; ++i3) {
                    Bullet bullet = this.bullets[i3];
                    if (bullet.size() <= 0) continue;
                    bulletArray[n6++] = bullet;
                }
                this.bullets = bulletArray;
            }
        }
    }

    void updateRanges(int n2, int n3, int n4) {
        if (this.styleCount == 0 || n3 == 0 && n4 == 0) {
            return;
        }
        if (this.ranges != null) {
            int n5 = this.styleCount << 1;
            int n6 = this.getRangeIndex(n2, -1, n5);
            if (n6 == n5) {
                return;
            }
            int n7 = n2 + n3;
            int n8 = this.getRangeIndex(n7, n6 - 1, n5);
            int n9 = n4 - n3;
            if (n6 == n8 && this.ranges[n6] < n2 && n7 < this.ranges[n8] + this.ranges[n8 + 1]) {
                if (n4 == 0) {
                    int n10 = n6 + 1;
                    this.ranges[n10] = this.ranges[n10] - n3;
                    n8 += 2;
                } else {
                    if (n5 + 2 > this.ranges.length) {
                        int[] nArray = new int[this.ranges.length + 64];
                        System.arraycopy(this.ranges, 0, nArray, 0, n5);
                        this.ranges = nArray;
                        StyleRange[] styleRangeArray = new StyleRange[this.styles.length + 32];
                        System.arraycopy(this.styles, 0, styleRangeArray, 0, this.styleCount);
                        this.styles = styleRangeArray;
                    }
                    System.arraycopy(this.ranges, n6 + 2, this.ranges, n6 + 4, n5 - (n6 + 2));
                    System.arraycopy(this.styles, n6 + 2 >> 1, this.styles, n6 + 4 >> 1, this.styleCount - (n6 + 2 >> 1));
                    this.ranges[n6 + 3] = this.ranges[n6] + this.ranges[n6 + 1] - n7;
                    this.ranges[n6 + 2] = n2 + n4;
                    this.ranges[n6 + 1] = n2 - this.ranges[n6];
                    this.styles[(n6 >> 1) + 1] = this.styles[n6 >> 1];
                    n5 += 2;
                    ++this.styleCount;
                    n8 += 4;
                }
                if (n9 != 0) {
                    for (int i2 = n8; i2 < n5; i2 += 2) {
                        int n11 = i2;
                        this.ranges[n11] = this.ranges[n11] + n9;
                    }
                }
            } else {
                if (this.ranges[n6] < n2 && n2 < this.ranges[n6] + this.ranges[n6 + 1]) {
                    this.ranges[n6 + 1] = n2 - this.ranges[n6];
                    n6 += 2;
                }
                if (n8 < n5 && this.ranges[n8] < n7 && n7 < this.ranges[n8] + this.ranges[n8 + 1]) {
                    this.ranges[n8 + 1] = this.ranges[n8] + this.ranges[n8 + 1] - n7;
                    this.ranges[n8] = n7;
                }
                if (n9 != 0) {
                    for (int i3 = n8; i3 < n5; i3 += 2) {
                        int n12 = i3;
                        this.ranges[n12] = this.ranges[n12] + n9;
                    }
                }
                System.arraycopy(this.ranges, n8, this.ranges, n6, n5 - n8);
                System.arraycopy(this.styles, n8 >> 1, this.styles, n6 >> 1, this.styleCount - (n8 >> 1));
                this.styleCount -= n8 - n6 >> 1;
            }
        } else {
            int n13 = this.getRangeIndex(n2, -1, this.styleCount);
            if (n13 == this.styleCount) {
                return;
            }
            int n14 = n2 + n3;
            int n15 = this.getRangeIndex(n14, n13 - 1, this.styleCount);
            int n16 = n4 - n3;
            if (n13 == n15 && this.styles[n13].start < n2 && n14 < this.styles[n15].start + this.styles[n15].length) {
                if (n4 == 0) {
                    this.styles[n13].length -= n3;
                    ++n15;
                } else {
                    if (this.styleCount + 1 > this.styles.length) {
                        StyleRange[] styleRangeArray = new StyleRange[this.styles.length + 32];
                        System.arraycopy(this.styles, 0, styleRangeArray, 0, this.styleCount);
                        this.styles = styleRangeArray;
                    }
                    System.arraycopy(this.styles, n13 + 1, this.styles, n13 + 2, this.styleCount - (n13 + 1));
                    this.styles[n13 + 1] = (StyleRange)this.styles[n13].clone();
                    this.styles[n13 + 1].length = this.styles[n13].start + this.styles[n13].length - n14;
                    this.styles[n13 + 1].start = n2 + n4;
                    this.styles[n13].length = n2 - this.styles[n13].start;
                    ++this.styleCount;
                    n15 += 2;
                }
                if (n16 != 0) {
                    for (int i4 = n15; i4 < this.styleCount; ++i4) {
                        this.styles[i4].start += n16;
                    }
                }
            } else {
                if (this.styles[n13].start < n2 && n2 < this.styles[n13].start + this.styles[n13].length) {
                    this.styles[n13].length = n2 - this.styles[n13].start;
                    ++n13;
                }
                if (n15 < this.styleCount && this.styles[n15].start < n14 && n14 < this.styles[n15].start + this.styles[n15].length) {
                    this.styles[n15].length = this.styles[n15].start + this.styles[n15].length - n14;
                    this.styles[n15].start = n14;
                }
                if (n16 != 0) {
                    for (int i5 = n15; i5 < this.styleCount; ++i5) {
                        this.styles[i5].start += n16;
                    }
                }
                System.arraycopy(this.styles, n15, this.styles, n13, this.styleCount - n15);
                this.styleCount -= n15 - n13;
            }
        }
    }

    static class LineInfo {
        int flags;
        Color background;
        int alignment;
        int indent;
        boolean justify;
        int[] segments;

        public LineInfo() {
        }

        public LineInfo(LineInfo info) {
            this.flags = info.flags;
            this.background = info.background;
            this.alignment = info.alignment;
            this.indent = info.indent;
            this.justify = info.justify;
            this.segments = info.segments;
        }
    }
}

