/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import com.ibm.icu.text.DateFormat;
import java.net.URI;
import java.util.Date;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.StorageTypedElement;

public class FileRevisionTypedElement
extends StorageTypedElement {
    IFileRevision fileRevision;
    IFile file;

    public FileRevisionTypedElement(IFileRevision fileRevision) {
        this(fileRevision, null);
    }

    public FileRevisionTypedElement(IFile file) {
        this(file, null);
    }

    public FileRevisionTypedElement(IFileRevision fileRevision, String localEncoding) {
        super(localEncoding);
        this.fileRevision = fileRevision;
        this.file = null;
    }

    public FileRevisionTypedElement(IFile file, String localEncoding) {
        super(localEncoding);
        this.file = file;
        this.fileRevision = null;
    }

    public String getName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return this.fileRevision.getName();
    }

    protected IStorage getElementStorage(IProgressMonitor monitor) throws CoreException {
        if (this.file != null) {
            return this.file;
        }
        return this.fileRevision.getStorage(monitor);
    }

    public boolean isEditable() {
        return false;
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        return null;
    }

    public String getContentIdentifier() {
        if (this.file != null) {
            return this.file.getName();
        }
        return this.fileRevision.getContentIdentifier();
    }

    public String getTimestamp() {
        long date = 0L;
        date = this.file != null ? this.file.getModificationStamp() : this.fileRevision.getTimestamp();
        Date dateFromLong = new Date(date);
        return DateFormat.getDateTimeInstance().format(dateFromLong);
    }

    public String getComment() {
        if (this.file != null) {
            return "";
        }
        return this.fileRevision.getComment();
    }

    public Object getFileRevision() {
        if (this.file != null) {
            return this.file;
        }
        return this.fileRevision;
    }

    public String getPath() {
        URI uri;
        if (this.file != null) {
            return this.file.getFullPath().toString();
        }
        if (this.fileRevision != null && (uri = this.fileRevision.getURI()) != null) {
            return uri.getPath();
        }
        return this.getName();
    }
}

