/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.jarprocessor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.eclipse.update.internal.jarprocessor.IProcessStep;
import org.eclipse.update.internal.jarprocessor.PackStep;
import org.eclipse.update.internal.jarprocessor.UnpackStep;
import org.eclipse.update.internal.jarprocessor.Utils;

public class JarProcessor {
    private List steps = new ArrayList();
    private String workingDirectory = "";
    private int depth = -1;
    private boolean verbose = false;
    private boolean processAll = false;

    public static JarProcessor getUnpackProcessor(Properties properties) {
        if (!JarProcessor.canPerformUnpack()) {
            throw new UnsupportedOperationException();
        }
        JarProcessor processor = new JarProcessor();
        processor.addProcessStep(new UnpackStep(properties));
        return processor;
    }

    public static JarProcessor getPackProcessor(Properties properties) {
        if (!JarProcessor.canPerformPack()) {
            throw new UnsupportedOperationException();
        }
        JarProcessor processor = new JarProcessor();
        processor.addProcessStep(new PackStep(properties));
        return processor;
    }

    public static boolean canPerformPack() {
        return PackStep.canPack();
    }

    public static boolean canPerformUnpack() {
        return UnpackStep.canUnpack();
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String dir) {
        this.workingDirectory = dir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setProcessAll(boolean all) {
        this.processAll = all;
    }

    public void addProcessStep(IProcessStep step) {
        this.steps.add(step);
    }

    public void clearProcessSteps() {
        this.steps.clear();
    }

    public void process(File input, FileFilter filter) throws FileNotFoundException {
        if (!input.exists()) {
            throw new FileNotFoundException();
        }
        File[] files = null;
        if (input.isDirectory()) {
            files = input.listFiles();
        } else if (filter.accept(input)) {
            files = new File[]{input};
        }
        int i = 0;
        while (i < files.length) {
            block10: {
                if (files[i].isDirectory()) {
                    String dir = this.getWorkingDirectory();
                    this.setWorkingDirectory(String.valueOf(dir) + "/" + files[i].getName());
                    this.process(files[i], filter);
                    this.setWorkingDirectory(dir);
                } else if (filter.accept(files[i])) {
                    try {
                        this.processJar(files[i]);
                    }
                    catch (IOException e) {
                        if (!this.verbose) break block10;
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recreateJar(JarFile jar, JarOutputStream outputJar, Map replacements, File directory, Properties inf) throws IOException {
        BufferedInputStream in = null;
        boolean marked = false;
        try {
            Enumeration<JarEntry> entries = jar.entries();
            JarEntry entry = entries.nextElement();
            while (true) {
                block10: {
                    if (entry != null) break block10;
                    if (!marked) {
                        entry = new JarEntry("META-INF/eclipse.inf");
                        outputJar.putNextEntry(entry);
                        Utils.storeProperties(inf, outputJar);
                        outputJar.closeEntry();
                    }
                    break;
                }
                File replacement = null;
                JarEntry newEntry = null;
                if (replacements.containsKey(entry.getName())) {
                    String name = (String)replacements.get(entry.getName());
                    replacement = new File(directory, name);
                    in = new BufferedInputStream(new FileInputStream(replacement));
                    newEntry = new JarEntry(name);
                } else {
                    in = new BufferedInputStream(jar.getInputStream(entry));
                    newEntry = new JarEntry(entry.getName());
                }
                newEntry.setTime(entry.getTime());
                outputJar.putNextEntry(newEntry);
                if (entry.getName().equals("META-INF/eclipse.inf")) {
                    Utils.storeProperties(inf, outputJar);
                    marked = true;
                } else {
                    Utils.transferStreams(in, outputJar, false);
                }
                outputJar.closeEntry();
                ((InputStream)in).close();
                if (replacement != null) {
                    replacement.delete();
                }
                entry = entries.hasMoreElements() ? entries.nextElement() : null;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            Utils.close(outputJar);
            Utils.close(jar);
            Utils.close(in);
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        Utils.close(outputJar);
        Utils.close(jar);
        Utils.close(in);
    }

    private String recursionEffect(String entryName) {
        String result = null;
        Iterator iter = this.steps.iterator();
        while (iter.hasNext()) {
            IProcessStep step = (IProcessStep)iter.next();
            result = step.recursionEffect(entryName);
            if (result == null) continue;
            entryName = result;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractEntries(JarFile jar, File tempDir, Map data) throws IOException {
        Enumeration<JarEntry> entries = jar.entries();
        if (!entries.hasMoreElements()) return;
        JarEntry entry = entries.nextElement();
        while (entry != null) {
            String name = entry.getName();
            String newName = this.recursionEffect(name);
            if (newName != null) {
                Object var12_13;
                File extracted;
                File parentDir;
                if (this.verbose) {
                    int i = 0;
                    while (true) {
                        if (i > this.depth) {
                            System.out.println("Processing nested file: " + name);
                            break;
                        }
                        System.out.print("  ");
                        ++i;
                    }
                }
                if (!(parentDir = (extracted = new File(tempDir, name)).getParentFile()).exists()) {
                    parentDir.mkdirs();
                }
                InputStream in = null;
                BufferedOutputStream out = null;
                try {
                    in = jar.getInputStream(entry);
                    out = new BufferedOutputStream(new FileOutputStream(extracted));
                    Utils.transferStreams(in, out, true);
                }
                catch (Throwable throwable) {
                    var12_13 = null;
                    Utils.close(in);
                    Utils.close(out);
                    throw throwable;
                }
                {
                    var12_13 = null;
                }
                Utils.close(in);
                Utils.close(out);
                extracted.setLastModified(entry.getTime());
                data.put(name, newName);
                String dir = this.getWorkingDirectory();
                this.setWorkingDirectory(parentDir.getCanonicalPath());
                this.processJar(extracted);
                this.setWorkingDirectory(dir);
                if (!name.equals(newName)) {
                    extracted.delete();
                }
            }
            if (!entries.hasMoreElements()) return;
            JarEntry jarEntry = entries.nextElement();
            entry = jarEntry;
        }
    }

    private File preProcess(File input, File tempDir) {
        File result = null;
        Iterator iter = this.steps.iterator();
        while (iter.hasNext()) {
            IProcessStep step = (IProcessStep)iter.next();
            result = step.preProcess(input, tempDir);
            if (result == null) continue;
            input = result;
        }
        return input;
    }

    private File postProcess(File input, File tempDir) {
        File result = null;
        Iterator iter = this.steps.iterator();
        while (iter.hasNext()) {
            IProcessStep step = (IProcessStep)iter.next();
            result = step.postProcess(input, tempDir);
            if (result == null) continue;
            input = result;
        }
        return input;
    }

    private void adjustInf(File input, Properties inf) {
        Iterator iter = this.steps.iterator();
        while (iter.hasNext()) {
            IProcessStep step = (IProcessStep)iter.next();
            step.adjustInf(input, inf);
        }
    }

    public void processJar(File input) throws IOException {
        File result;
        ++this.depth;
        long lastModified = input.lastModified();
        File workingDir = new File(this.getWorkingDirectory());
        if (!workingDir.exists()) {
            workingDir.mkdirs();
        }
        boolean skip = Utils.shouldSkipJar(input, this.processAll, this.verbose);
        if (this.depth == 0 && this.verbose) {
            if (skip) {
                System.out.println("Skipping " + input.getPath());
            } else {
                System.out.print("Running ");
                Iterator iter = this.steps.iterator();
                while (iter.hasNext()) {
                    IProcessStep step = (IProcessStep)iter.next();
                    System.out.print(String.valueOf(step.getStepName()) + " ");
                }
                System.out.println("on " + input.getPath());
            }
        }
        if (skip) {
            --this.depth;
            return;
        }
        File workingFile = this.preProcess(input, workingDir);
        File tempDir = null;
        if (this.depth == 0) {
            tempDir = new File(workingDir, "temp." + workingFile.getName());
        } else {
            File parent = workingDir.getParentFile();
            tempDir = new File(parent, "temp_" + this.depth + '_' + workingFile.getName());
        }
        JarFile jar = new JarFile(workingFile, false);
        HashMap replacements = new HashMap();
        this.extractEntries(jar, tempDir, replacements);
        Properties inf = Utils.getEclipseInf(workingFile);
        if (inf != null) {
            this.adjustInf(workingFile, inf);
        }
        File tempJar = null;
        tempJar = new File(tempDir, workingFile.getName());
        File parent = tempJar.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        JarOutputStream jarOut = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(tempJar)));
        this.recreateJar(jar, jarOut, replacements, tempDir, inf);
        jar.close();
        if (tempJar != null) {
            if (!workingFile.equals(input)) {
                workingFile.delete();
            }
            workingFile = tempJar;
        }
        if (!(result = this.postProcess(workingFile, workingDir)).equals(workingFile) && !workingFile.equals(input)) {
            workingFile.delete();
        }
        if (!result.getParentFile().equals(workingDir)) {
            File finalFile = new File(workingDir, result.getName());
            if (finalFile.exists()) {
                finalFile.delete();
            }
            result.renameTo(finalFile);
        }
        if (tempDir.exists()) {
            Utils.clear(tempDir);
        }
        result.setLastModified(lastModified);
        --this.depth;
    }
}

