/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.template.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.jdt.internal.ui.text.template.contentassist.VariablePosition;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class MultiVariableGuess {
    private final List fSlaves = new ArrayList();
    private MultiVariable fMaster;

    public MultiVariableGuess(MultiVariable mv) {
        this.fMaster = mv;
    }

    public ICompletionProposal[] getProposals(MultiVariable variable, int offset, int length) {
        if (((Object)((Object)variable)).equals((Object)this.fMaster)) {
            String[] choices = variable.getValues();
            ICompletionProposal[] ret = new ICompletionProposal[choices.length];
            int i = 0;
            while (i < ret.length) {
                ret[i] = new Proposal(choices[i], offset, length, offset + length){

                    public void apply(IDocument document) {
                        super.apply(document);
                        try {
                            Object old = MultiVariableGuess.this.fMaster.getSet();
                            MultiVariableGuess.this.fMaster.setSet(this.fReplacementString);
                            if (!this.fReplacementString.equals(old)) {
                                Iterator it = MultiVariableGuess.this.fSlaves.iterator();
                                while (it.hasNext()) {
                                    VariablePosition pos = (VariablePosition)((Object)it.next());
                                    String[] values = pos.getVariable().getValues(this.fReplacementString);
                                    if (values == null) continue;
                                    document.replace(pos.getOffset(), pos.getLength(), values[0]);
                                }
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                };
                ++i;
            }
            return ret;
        }
        String[] choices = variable.getValues(this.fMaster.getSet());
        if (choices == null || choices.length < 2) {
            return null;
        }
        ICompletionProposal[] ret = new ICompletionProposal[choices.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = new Proposal(choices[i], offset, length, offset + length);
            ++i;
        }
        return ret;
    }

    public void addSlave(VariablePosition position) {
        this.fSlaves.add(position);
    }

    class Proposal
    implements ICompletionProposal,
    ICompletionProposalExtension2 {
        private String fDisplayString;
        String fReplacementString;
        private int fReplacementOffset;
        private int fReplacementLength;
        private int fCursorPosition;
        private Image fImage;
        private IContextInformation fContextInformation;
        private String fAdditionalProposalInfo;

        public Proposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
            this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
        }

        public Proposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
            Assert.isNotNull((Object)replacementString);
            Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
            Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
            Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
            this.fReplacementString = replacementString;
            this.fReplacementOffset = replacementOffset;
            this.fReplacementLength = replacementLength;
            this.fCursorPosition = cursorPosition;
            this.fImage = image;
            this.fDisplayString = displayString;
            this.fContextInformation = contextInformation;
            this.fAdditionalProposalInfo = additionalProposalInfo;
        }

        public void apply(IDocument document) {
            try {
                document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            }
            catch (BadLocationException badLocationException) {}
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }

        public IContextInformation getContextInformation() {
            return this.fContextInformation;
        }

        public Image getImage() {
            return this.fImage;
        }

        public String getDisplayString() {
            if (this.fDisplayString != null) {
                return this.fDisplayString;
            }
            return this.fReplacementString;
        }

        public String getAdditionalProposalInfo() {
            return this.fAdditionalProposalInfo;
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            this.apply(viewer.getDocument());
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            try {
                String content = document.get(this.fReplacementOffset, this.fReplacementLength);
                if (content.startsWith(this.fReplacementString)) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
            return false;
        }
    }
}

