/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class NativeLibrariesConfigurationBlock {
    private StringDialogField fPathField;
    private SelectionButtonDialogField fBrowseWorkspace;
    private SelectionButtonDialogField fBrowseExternal;
    private final CPListElement fEntry;
    private Shell fShell;
    private final IStatusChangeListener fListener;
    private final String fOrginalValue;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NativeLibrariesConfigurationBlock(IStatusChangeListener listener, Shell parent, CPListElement selElement) {
        this.fListener = listener;
        this.fEntry = selElement;
        NativeLibrariesAdapter adapter = new NativeLibrariesAdapter();
        this.fPathField = new StringDialogField();
        this.fPathField.setLabelText(NewWizardMessages.NativeLibrariesDialog_location_label);
        this.fPathField.setDialogFieldListener(adapter);
        this.fBrowseWorkspace = new SelectionButtonDialogField(8);
        this.fBrowseWorkspace.setLabelText(NewWizardMessages.NativeLibrariesDialog_workspace_browse);
        this.fBrowseWorkspace.setDialogFieldListener(adapter);
        this.fBrowseExternal = new SelectionButtonDialogField(8);
        this.fBrowseExternal.setLabelText(NewWizardMessages.NativeLibrariesDialog_external_browse);
        this.fBrowseExternal.setDialogFieldListener(adapter);
        String val = (String)selElement.getAttribute(CPListElement.NATIVE_LIB_PATH);
        if (val != null) {
            this.fPathField.setText(Path.fromPortableString((String)val).toString());
            this.fOrginalValue = val;
        } else {
            this.fOrginalValue = "";
        }
    }

    public Control createContents(Composite parent) {
        this.fShell = parent.getShell();
        Composite inner = new Composite(parent, 0);
        inner.setFont(parent.getFont());
        inner.setLayoutData((Object)new GridData(4, 4, true, true));
        int nColumns = 3;
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        PixelConverter converter = new PixelConverter((Control)parent);
        Label desc = new Label(inner, 64);
        desc.setFont(inner.getFont());
        desc.setText(Messages.format(NewWizardMessages.NativeLibrariesDialog_description, new String[]{this.fEntry.getPath().lastSegment()}));
        GridData gridData = new GridData(4, 2, false, false, 3, 1);
        gridData.widthHint = converter.convertWidthInCharsToPixels(80);
        desc.setLayoutData((Object)gridData);
        this.fPathField.doFillIntoGrid(inner, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fPathField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fPathField.getTextControl(null), converter.convertWidthInCharsToPixels(50));
        this.fBrowseExternal.doFillIntoGrid(inner, 1);
        DialogField.createEmptySpace(inner, 2);
        this.fBrowseWorkspace.doFillIntoGrid(inner, 1);
        this.fPathField.setFocus();
        return parent;
    }

    public String getNativeLibraryPath() {
        String val = this.fPathField.getText();
        if (val.length() == 0) {
            return null;
        }
        return new Path(val).toPortableString();
    }

    final void doFieldChanged(DialogField field) {
        if (field == this.fBrowseExternal) {
            String res = this.chooseExternal();
            if (res != null) {
                this.fPathField.setText(res);
            }
        } else if (field == this.fBrowseWorkspace) {
            String res = this.chooseInternal();
            if (res != null) {
                this.fPathField.setText(res);
            }
        } else if (field == this.fPathField) {
            this.fListener.statusChanged(this.validatePath());
        }
    }

    private IStatus validatePath() {
        StatusInfo status = new StatusInfo();
        String val = this.fPathField.getText();
        if (val.length() == 0) {
            return status;
        }
        Path path = new Path(val);
        if (path.isAbsolute()) {
            if (!path.toFile().isDirectory()) {
                status.setWarning(NewWizardMessages.NativeLibrariesDialog_error_external_not_existing);
                return status;
            }
        } else if (!(ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path) instanceof IContainer)) {
            status.setWarning(NewWizardMessages.NativeLibrariesDialog_error_internal_not_existing);
            return status;
        }
        return status;
    }

    private String chooseExternal() {
        Path currPath = new Path(this.fPathField.getText());
        currPath = currPath.isEmpty() ? this.fEntry.getPath() : currPath.removeLastSegments(1);
        DirectoryDialog dialog = new DirectoryDialog(this.fShell);
        dialog.setMessage(NewWizardMessages.NativeLibrariesDialog_external_message);
        dialog.setText(NewWizardMessages.NativeLibrariesDialog_extfiledialog_text);
        dialog.setFilterPath(currPath.toOSString());
        String res = dialog.open();
        if (res != null) {
            return res;
        }
        return null;
    }

    private String chooseInternal() {
        String initSelection = this.fPathField.getText();
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses);
        IResource initSel = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (initSelection.length() > 0) {
            initSel = root.findMember((IPath)new Path(initSelection));
        }
        if (initSel == null) {
            initSel = root.findMember(this.fEntry.getPath());
        }
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.fShell, (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setAllowMultiple(false);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setTitle(NewWizardMessages.NativeLibrariesDialog_intfiledialog_title);
        dialog.setMessage(NewWizardMessages.NativeLibrariesDialog_intfiledialog_message);
        dialog.setInput((Object)root);
        dialog.setInitialSelection((Object)initSel);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            return res.getFullPath().makeRelative().toString();
        }
        return null;
    }

    public void performDefaults() {
        this.fPathField.setText(this.fOrginalValue);
    }

    private class NativeLibrariesAdapter
    implements IDialogFieldListener {
        private NativeLibrariesAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            NativeLibrariesConfigurationBlock.this.doFieldChanged(field);
        }
    }
}

