/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlink;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaElementHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;

    public JavaElementHyperlinkDetector(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fTextEditor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IRegion wordRegion;
        IJavaElement input;
        IAction openAction;
        block7: {
            if (region == null || canShowMultipleHyperlinks || !(this.fTextEditor instanceof JavaEditor)) {
                return null;
            }
            openAction = this.fTextEditor.getAction("OpenEditor");
            if (openAction == null) {
                return null;
            }
            int offset = region.getOffset();
            input = EditorUtility.getEditorInputJavaElement((IEditorPart)this.fTextEditor, false);
            if (input == null) {
                return null;
            }
            try {
                IDocument document = this.fTextEditor.getDocumentProvider().getDocument((Object)this.fTextEditor.getEditorInput());
                wordRegion = JavaWordFinder.findWord(document, offset);
                if (wordRegion != null) break block7;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        IJavaElement[] elements = null;
        elements = ((ICodeAssist)input).codeSelect(wordRegion.getOffset(), wordRegion.getLength());
        if (elements != null && elements.length > 0) {
            return new IHyperlink[]{new JavaElementHyperlink(wordRegion, openAction)};
        }
        return null;
    }
}

