/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.packageview.SelectionTransferDropAdapter;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;

class CallHierarchyTransferDropAdapter
extends SelectionTransferDropAdapter {
    private static final int OPERATION = 4;
    private CallHierarchyViewPart fCallHierarchyViewPart;

    public CallHierarchyTransferDropAdapter(CallHierarchyViewPart viewPart, StructuredViewer viewer) {
        super(viewer);
        this.setFullWidthMatchesItem(false);
        this.fCallHierarchyViewPart = viewPart;
    }

    public void validateDrop(Object target, DropTargetEvent event, int operation) {
        event.detail = 0;
        this.initializeSelection();
        if (target != null) {
            super.validateDrop(target, event, operation);
            return;
        }
        if (CallHierarchyTransferDropAdapter.getInputElement(this.getSelection()) != null) {
            event.detail = 4;
        }
    }

    public boolean isEnabled(DropTargetEvent event) {
        return true;
    }

    public void drop(Object target, DropTargetEvent event) {
        if (target != null || event.detail != 4) {
            super.drop(target, event);
            return;
        }
        IMethod input = CallHierarchyTransferDropAdapter.getInputElement(this.getSelection());
        this.fCallHierarchyViewPart.setMethod(input);
    }

    private static IMethod getInputElement(ISelection selection) {
        Object single = SelectionUtil.getSingleElement(selection);
        if (single == null) {
            return null;
        }
        return CallHierarchyTransferDropAdapter.getCandidate(single);
    }

    public static IMethod getCandidate(Object input) {
        if (!(input instanceof IMethod)) {
            return null;
        }
        return (IMethod)input;
    }
}

