/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.image.BufferedImage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Display;

class ImageList {
    int handle;
    int style;
    int refCount;
    Image[] images;

    public ImageList(int n2) {
        this.style = n2;
        int n3 = 1;
        if (OS.IsWinCE) {
            n3 |= 0;
        } else if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            n3 |= 0x20;
        } else {
            int n4 = OS.GetDC((int)0);
            int n5 = OS.GetDeviceCaps((int)n4, (int)12);
            int n6 = OS.GetDeviceCaps((int)n4, (int)14);
            OS.ReleaseDC((int)0, (int)n4);
            int n7 = n5 * n6;
            switch (n7) {
                case 4: {
                    n3 |= 4;
                    break;
                }
                case 8: {
                    n3 |= 8;
                    break;
                }
                case 16: {
                    n3 |= 0x10;
                    break;
                }
                case 24: {
                    n3 |= 0x18;
                    break;
                }
                case 32: {
                    n3 |= 0x20;
                    break;
                }
                default: {
                    n3 |= 0;
                }
            }
        }
        if ((n2 & 0x4000000) != 0) {
            n3 |= 0x2000;
        }
        this.handle = OS.ImageList_Create((int)32, (int)32, (int)n3, (int)16, (int)16);
        this.images = new Image[4];
    }

    public int add(Image image) {
        Image[] imageArray;
        int n2;
        int n3 = OS.ImageList_GetImageCount((int)this.handle);
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.images[n2] != null && this.images[n2].isDisposed()) {
                this.images[n2] = null;
            }
            if (this.images[n2] == null) break;
        }
        if (n3 == 0) {
            imageArray = image.getBounds();
            OS.ImageList_SetIconSize((int)this.handle, (int)imageArray.width, (int)imageArray.height);
        }
        this.set(n2, image, n3);
        if (n2 == this.images.length) {
            imageArray = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
            this.images = imageArray;
        }
        this.images[n2] = image;
        return n2;
    }

    int addRef() {
        return ++this.refCount;
    }

    int copyBitmap(int n2, int n3, int n4) {
        int n5;
        BITMAP bITMAP = new BITMAP();
        OS.GetObject((int)n2, (int)24, (BITMAP)bITMAP);
        int n6 = OS.GetDC((int)0);
        int n7 = OS.CreateCompatibleDC((int)n6);
        OS.SelectObject((int)n7, (int)n2);
        int n8 = OS.CreateCompatibleDC((int)n6);
        if (bITMAP.bmBitsPixel == 32 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
            bITMAPINFOHEADER.biSize = 40;
            bITMAPINFOHEADER.biWidth = n3;
            bITMAPINFOHEADER.biHeight = -n4;
            bITMAPINFOHEADER.biPlanes = 1;
            bITMAPINFOHEADER.biBitCount = (short)24;
            bITMAPINFOHEADER.biCompression = OS.IsWinCE ? 3 : 0;
            byte[] byArray = new byte[40 + (OS.IsWinCE ? 12 : 0)];
            OS.MoveMemory((byte[])byArray, (BITMAPINFOHEADER)bITMAPINFOHEADER, (int)40);
            if (OS.IsWinCE) {
                int n9 = 65280;
                int n10 = 0xFF0000;
                int n11 = -16777216;
                int n12 = 40;
                byArray[n12] = (byte)((n9 & 0xFF000000) >> 24);
                byArray[n12 + 1] = (byte)((n9 & 0xFF0000) >> 16);
                byArray[n12 + 2] = (byte)((n9 & 0xFF00) >> 8);
                byArray[n12 + 3] = (byte)((n9 & 0xFF) >> 0);
                byArray[n12 + 4] = (byte)((n10 & 0xFF000000) >> 24);
                byArray[n12 + 5] = (byte)((n10 & 0xFF0000) >> 16);
                byArray[n12 + 6] = (byte)((n10 & 0xFF00) >> 8);
                byArray[n12 + 7] = (byte)((n10 & 0xFF) >> 0);
                byArray[n12 + 8] = (byte)((n11 & 0xFF000000) >> 24);
                byArray[n12 + 9] = (byte)((n11 & 0xFF0000) >> 16);
                byArray[n12 + 10] = (byte)((n11 & 0xFF00) >> 8);
                byArray[n12 + 11] = (byte)((n11 & 0xFF) >> 0);
            }
            int[] nArray = new int[1];
            n5 = OS.CreateDIBSection((int)0, (byte[])byArray, (int)0, (int[])nArray, (int)0, (int)0);
        } else {
            n5 = OS.CreateCompatibleBitmap((int)n6, (int)n3, (int)n4);
        }
        OS.SelectObject((int)n8, (int)n5);
        if (n3 != bITMAP.bmWidth || n4 != bITMAP.bmHeight) {
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode((int)n8, (int)3);
            }
            OS.StretchBlt((int)n8, (int)0, (int)0, (int)n3, (int)n4, (int)n7, (int)0, (int)0, (int)bITMAP.bmWidth, (int)bITMAP.bmHeight, (int)0xCC0020);
        } else {
            OS.BitBlt((int)n8, (int)0, (int)0, (int)n3, (int)n4, (int)n7, (int)0, (int)0, (int)0xCC0020);
        }
        OS.DeleteDC((int)n7);
        OS.DeleteDC((int)n8);
        OS.ReleaseDC((int)0, (int)n6);
        return n5;
    }

    int copyIcon(int n2, int n3, int n4) {
        int n5;
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        return (n5 = OS.CopyImage((int)n2, (int)1, (int)n3, (int)n4, (int)0)) != 0 ? n5 : n2;
    }

    int copyWithAlpha(int n2, int n3, byte[] byArray, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        byte by;
        byte by2;
        int n9;
        BITMAP bITMAP = new BITMAP();
        OS.GetObject((int)n2, (int)24, (BITMAP)bITMAP);
        int n10 = bITMAP.bmWidth;
        int n11 = bITMAP.bmHeight;
        int n12 = OS.GetDC((int)0);
        int n13 = OS.CreateCompatibleDC((int)n12);
        int n14 = OS.SelectObject((int)n13, (int)n2);
        int n15 = OS.CreateCompatibleDC((int)n12);
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = 40;
        bITMAPINFOHEADER.biWidth = n10;
        bITMAPINFOHEADER.biHeight = -n11;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)32;
        bITMAPINFOHEADER.biCompression = 0;
        byte[] byArray2 = new byte[40];
        OS.MoveMemory((byte[])byArray2, (BITMAPINFOHEADER)bITMAPINFOHEADER, (int)40);
        int[] nArray = new int[1];
        int n16 = OS.CreateDIBSection((int)0, (byte[])byArray2, (int)0, (int[])nArray, (int)0, (int)0);
        if (n16 == 0) {
            SWT.error(2);
        }
        int n17 = OS.SelectObject((int)n15, (int)n16);
        BITMAP bITMAP2 = new BITMAP();
        OS.GetObject((int)n16, (int)24, (BITMAP)bITMAP2);
        int n18 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
        OS.BitBlt((int)n15, (int)0, (int)0, (int)n10, (int)n11, (int)n13, (int)0, (int)0, (int)0xCC0020);
        byte[] byArray3 = new byte[n18];
        OS.MoveMemory((byte[])byArray3, (int)bITMAP2.bmBits, (int)n18);
        if (byArray != null) {
            n9 = bITMAP2.bmWidthBytes - n10 * 4;
            by2 = 0;
            by = 3;
            for (n8 = 0; n8 < n11; ++n8) {
                for (n7 = 0; n7 < n10; ++n7) {
                    byte by3 = by2;
                    by2 = (byte)(by2 + 1);
                    byArray3[by] = byArray[by3];
                    by += 4;
                }
                by += n9;
            }
        } else {
            n9 = n3 & 0xFF;
            by2 = (byte)(n3 >> 8 & 0xFF);
            by = (byte)(n3 >> 16 & 0xFF);
            n8 = bITMAP2.bmWidthBytes - n10 * 4;
            n7 = 3;
            for (n6 = 0; n6 < n11; ++n6) {
                for (int i2 = 0; i2 < n10; ++i2) {
                    byArray3[n7] = byArray3[n7 - 1] == n9 && byArray3[n7 - 2] == by2 && byArray3[n7 - 3] == by ? 0 : -1;
                    n7 += 4;
                }
                n7 += n8;
            }
        }
        OS.MoveMemory((int)bITMAP2.bmBits, (byte[])byArray3, (int)n18);
        if (n10 != n4 || n11 != n5) {
            BITMAPINFOHEADER bITMAPINFOHEADER2 = new BITMAPINFOHEADER();
            bITMAPINFOHEADER2.biSize = 40;
            bITMAPINFOHEADER2.biWidth = n4;
            bITMAPINFOHEADER2.biHeight = -n5;
            bITMAPINFOHEADER2.biPlanes = 1;
            bITMAPINFOHEADER2.biBitCount = (short)32;
            bITMAPINFOHEADER2.biCompression = 0;
            byte[] byArray4 = new byte[40];
            OS.MoveMemory((byte[])byArray4, (BITMAPINFOHEADER)bITMAPINFOHEADER2, (int)40);
            int[] nArray2 = new int[1];
            n8 = OS.CreateDIBSection((int)0, (byte[])byArray4, (int)0, (int[])nArray2, (int)0, (int)0);
            n7 = OS.CreateCompatibleDC((int)n12);
            n6 = OS.SelectObject((int)n7, (int)n8);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode((int)n7, (int)3);
            }
            OS.StretchBlt((int)n7, (int)0, (int)0, (int)n4, (int)n5, (int)n15, (int)0, (int)0, (int)n10, (int)n11, (int)0xCC0020);
            OS.SelectObject((int)n7, (int)n6);
            OS.DeleteDC((int)n7);
            OS.SelectObject((int)n15, (int)n17);
            OS.DeleteDC((int)n15);
            OS.DeleteObject((int)n16);
            n16 = n8;
        } else {
            OS.SelectObject((int)n15, (int)n17);
            OS.DeleteDC((int)n15);
        }
        OS.SelectObject((int)n13, (int)n14);
        OS.DeleteDC((int)n13);
        OS.ReleaseDC((int)0, (int)n12);
        return n16;
    }

    int createMask(int n2, int n3, int n4, int n5, int n6) {
        BITMAP bITMAP = new BITMAP();
        OS.GetObject((int)n2, (int)24, (BITMAP)bITMAP);
        int n7 = bITMAP.bmWidth;
        int n8 = bITMAP.bmHeight;
        int n9 = OS.CreateBitmap((int)n3, (int)n4, (int)1, (int)1, null);
        int n10 = OS.GetDC((int)0);
        int n11 = OS.CreateCompatibleDC((int)n10);
        if (n5 != -1) {
            int n12;
            OS.SelectObject((int)n11, (int)n2);
            boolean bl = bITMAP.bmBits != 0;
            byte[] byArray = null;
            if (!OS.IsWinCE && n6 != -1 && bl && bITMAP.bmBitsPixel <= 8) {
                n12 = 1 << bITMAP.bmBitsPixel;
                byte[] byArray2 = new byte[n12 * 4];
                OS.GetDIBColorTable((int)n11, (int)0, (int)n12, (byte[])byArray2);
                int n13 = n6 * 4;
                byte[] byArray3 = new byte[byArray2.length];
                byArray3[n13] = -1;
                byArray3[n13 + 1] = -1;
                byArray3[n13 + 2] = -1;
                OS.SetDIBColorTable((int)n11, (int)0, (int)n12, (byte[])byArray3);
                byArray = byArray2;
                OS.SetBkColor((int)n11, (int)0xFFFFFF);
            } else {
                OS.SetBkColor((int)n11, (int)n5);
            }
            n12 = OS.CreateCompatibleDC((int)n10);
            OS.SelectObject((int)n12, (int)n9);
            if (n3 != n7 || n4 != n8) {
                if (!OS.IsWinCE) {
                    OS.SetStretchBltMode((int)n12, (int)3);
                }
                OS.StretchBlt((int)n12, (int)0, (int)0, (int)n3, (int)n4, (int)n11, (int)0, (int)0, (int)n7, (int)n8, (int)0xCC0020);
            } else {
                OS.BitBlt((int)n12, (int)0, (int)0, (int)n3, (int)n4, (int)n11, (int)0, (int)0, (int)0xCC0020);
            }
            OS.DeleteDC((int)n12);
            if (byArray != null) {
                OS.SetDIBColorTable((int)n11, (int)0, (int)(1 << bITMAP.bmBitsPixel), byArray);
            }
        } else {
            int n14 = OS.SelectObject((int)n11, (int)n9);
            OS.PatBlt((int)n11, (int)0, (int)0, (int)n3, (int)n4, (int)66);
            OS.SelectObject((int)n11, (int)n14);
        }
        OS.ReleaseDC((int)0, (int)n10);
        OS.DeleteDC((int)n11);
        return n9;
    }

    public void dispose() {
        if (this.handle != 0) {
            OS.ImageList_Destroy((int)this.handle);
        }
        this.handle = 0;
        this.images = null;
    }

    public Image get(int n2) {
        return this.images[n2];
    }

    public int getStyle() {
        return this.style;
    }

    public int getHandle() {
        return this.handle;
    }

    public Point getImageSize() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize((int)this.handle, (int[])nArray, (int[])nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public int indexOf(Image image) {
        int n2 = OS.ImageList_GetImageCount((int)this.handle);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.images[i2] == null) continue;
            if (this.images[i2].isDisposed()) {
                this.images[i2] = null;
            }
            if (this.images[i2] == null || !this.images[i2].equals(image)) continue;
            return i2;
        }
        return -1;
    }

    public void put(int n2, Image image) {
        int n3 = OS.ImageList_GetImageCount((int)this.handle);
        if (0 > n2 || n2 >= n3) {
            return;
        }
        if (image != null) {
            this.set(n2, image, n3);
        }
        this.images[n2] = image;
    }

    public void remove(int n2) {
        int n3 = OS.ImageList_GetImageCount((int)this.handle);
        if (0 > n2 || n2 >= n3) {
            return;
        }
        OS.ImageList_Remove((int)this.handle, (int)n2);
        System.arraycopy(this.images, n2 + 1, this.images, n2, --n3 - n2);
        this.images[n2] = null;
    }

    int removeRef() {
        return --this.refCount;
    }

    void set(int n2, Image image, int n3) {
        BufferedImage bufferedImage = image.handle;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize((int)this.handle, (int[])nArray, (int[])nArray2);
        switch (image.type) {
            case 0: {
                int n4 = 0;
                int n5 = 0;
                ImageData imageData = image.getImageData();
                switch (imageData.getTransparencyType()) {
                    case 1: {
                        if (OS.COMCTL32_MAJOR >= 6) {
                            n4 = this.copyWithAlpha((int)bufferedImage, -1, imageData.alphaData, nArray[0], nArray2[0]);
                            break;
                        }
                        n4 = this.copyBitmap((int)bufferedImage, nArray[0], nArray2[0]);
                        n5 = Display.createMaskFromAlpha((ImageData)imageData, (int)nArray[0], (int)nArray2[0]);
                        break;
                    }
                    case 4: {
                        Object object = -1;
                        Color color = image.getBackground();
                        if (color != null) {
                            object = color.handle;
                        }
                        n4 = this.copyBitmap((int)bufferedImage, nArray[0], nArray2[0]);
                        n5 = this.createMask((int)bufferedImage, nArray[0], nArray2[0], (int)object, imageData.transparentPixel);
                        break;
                    }
                    default: {
                        n4 = this.copyBitmap((int)bufferedImage, nArray[0], nArray2[0]);
                        if (n2 == n3) break;
                        n5 = this.createMask((int)bufferedImage, nArray[0], nArray2[0], -1, -1);
                    }
                }
                if (n2 == n3) {
                    OS.ImageList_Add((int)this.handle, (int)n4, (int)n5);
                } else {
                    OS.ImageList_Replace((int)this.handle, (int)n2, (int)n4, (int)n5);
                }
                if (n5 != 0) {
                    OS.DeleteObject((int)n5);
                }
                if (n4 == bufferedImage) break;
                OS.DeleteObject((int)n4);
                break;
            }
            case 1: {
                if (OS.IsWinCE) {
                    OS.ImageList_ReplaceIcon((int)this.handle, (int)(n2 == n3 ? -1 : n2), (int)bufferedImage);
                    break;
                }
                int n6 = this.copyIcon((int)bufferedImage, nArray[0], nArray2[0]);
                OS.ImageList_ReplaceIcon((int)this.handle, (int)(n2 == n3 ? -1 : n2), (int)n6);
                OS.DestroyIcon((int)n6);
            }
        }
    }

    public int size() {
        int n2 = 0;
        int n3 = OS.ImageList_GetImageCount((int)this.handle);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.images[i2] == null) continue;
            if (this.images[i2].isDisposed()) {
                this.images[i2] = null;
            }
            if (this.images[i2] == null) continue;
            ++n2;
        }
        return n2;
    }
}

