/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CGC;
import org.eclipse.swt.internal.swing.CShell;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.NullGraphics2D;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    Event[] eventQueue;
    EventTable eventTable;
    EventTable filterTable;
    Vector timerList = new Vector();
    Menu[] bars;
    Menu[] popups;
    ArrayList menuItemsList = new ArrayList();
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    ArrayList disposeList;
    Tray tray;
    Image errorIcon;
    Image workingIcon;
    Image infoIcon;
    Image questionIcon;
    Image warningIcon;
    Cursor[] cursors = new Cursor[22];
    Object data;
    String[] keys;
    Object[] values;
    static final int[][] KeyTable = new int[][]{{18, 65536}, {16, 131072}, {17, 262144}, {524, 0x400000}, {38, 0x1000001}, {40, 0x1000002}, {37, 0x1000003}, {39, 0x1000004}, {33, 0x1000005}, {34, 0x1000006}, {36, 0x1000007}, {35, 0x1000008}, {155, 0x1000009}, {8, 8}, {10, 13}, {127, 127}, {27, 27}, {10, 10}, {9, 9}, {112, 0x100000A}, {113, 0x100000B}, {114, 0x100000C}, {115, 0x100000D}, {116, 0x100000E}, {117, 0x100000F}, {118, 0x1000010}, {119, 0x1000011}, {120, 0x1000012}, {121, 0x1000013}, {122, 0x1000014}, {123, 0x1000015}, {61440, 0x1000016}, {61441, 0x1000017}, {61442, 0x1000018}, {106, 16777258}, {107, 16777259}, {10, 0x1000050}, {109, 16777261}, {110, 16777262}, {111, 16777263}, {96, 0x1000030}, {97, 0x1000031}, {98, 16777266}, {99, 0x1000033}, {100, 16777268}, {101, 16777269}, {102, 16777270}, {103, 16777271}, {104, 16777272}, {105, 16777273}, {20, 16777298}, {144, 16777299}, {145, 16777300}, {19, 0x1000055}, {3, 16777302}, {154, 16777303}, {156, 0x1000051}};
    static Display Default;
    static Display[] Displays;
    Shell[] modalShells;
    Shell modalDialogShell;
    static boolean TrimEnabled;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    HashMap componentToControlMap = new HashMap();
    AWTEvent event;

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(deviceData);
        boolean bl = Utils.isLightweightPopups();
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(bl);
        JPopupMenu.setDefaultLightWeightPopupEnabled(bl);
        Utils.installDefaultLookAndFeel();
    }

    public static void main(String[] stringArray) {
        UIThreadUtils.main(stringArray);
    }

    public static void swtExec(Runnable runnable) {
        UIThreadUtils.swtExec(runnable);
    }

    void addBar(Menu menu) {
        int n2;
        if (this.bars == null) {
            this.bars = new Menu[4];
        }
        int n3 = this.bars.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.bars[n2] != menu) continue;
            return;
        }
        for (n2 = 0; n2 < n3 && this.bars[n2] != null; ++n2) {
        }
        if (n2 == n3) {
            Menu[] menuArray = new Menu[n3 + 4];
            System.arraycopy(this.bars, 0, menuArray, 0, n3);
            this.bars = menuArray;
        }
        this.bars[n2] = menu;
    }

    void addControl(Component component, Control control) {
        if (component == null) {
            return;
        }
        this.componentToControlMap.put(component, control);
    }

    public void addFilter(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n2, listener);
    }

    public void addListener(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n2, listener);
    }

    void addMenuItem(MenuItem menuItem) {
        this.menuItemsList.add(menuItem);
    }

    void addPopup(Menu menu) {
        int n2;
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int n3 = this.popups.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.popups[n2] != menu) continue;
            return;
        }
        for (n2 = 0; n2 < n3 && this.popups[n2] != null; ++n2) {
        }
        if (n2 == n3) {
            Menu[] menuArray = new Menu[n3 + 4];
            System.arraycopy(this.popups, 0, menuArray, 0, n3);
            this.popups = menuArray;
        }
        this.popups[n2] = menu;
    }

    public void asyncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.asyncExec(runnable);
    }

    public void beep() {
        this.checkDevice();
        Toolkit.getDefaultToolkit().beep();
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread() && !SwingUtilities.isEventDispatchThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    static synchronized void checkDisplay(Thread thread, boolean bl) {
        for (int i2 = 0; i2 < Displays.length; ++i2) {
            if (Displays[i2] == null) continue;
            if (!bl) {
                SWT.error(20, null, " [multiple displays]");
            }
            if (Display.Displays[i2].thread != thread) continue;
            SWT.error(22);
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        UIThreadUtils.setMainThread(this.thread);
        Display.checkDisplay(this.thread, true);
        this.createDisplay(deviceData);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData deviceData) {
    }

    static synchronized void deregister(Display display) {
        for (int i2 = 0; i2 < Displays.length; ++i2) {
            if (display != Displays[i2]) continue;
            Display.Displays[i2] = null;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
        if (UIThreadUtils.isRealDispatch()) {
            UIThreadUtils.popQueue();
        }
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new ArrayList();
        }
        this.disposeList.add(runnable);
    }

    void error(int n2) {
        SWT.error(n2);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int n2) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n2);
    }

    Control findControl(Component component) {
        if (component == null) {
            return null;
        }
        do {
            Control control;
            if ((control = this.getControl(component)) == null) continue;
            return control;
        } while ((component = component.getParent()) != null);
        return null;
    }

    public static synchronized Display findDisplay(Thread thread) {
        if (Displays.length == 0) {
            return null;
        }
        if (Thread.currentThread() == thread && SwingUtilities.isEventDispatchThread()) {
            return Displays[0];
        }
        for (int i2 = 0; i2 < Displays.length; ++i2) {
            Display display = Displays[i2];
            if (display == null || display.thread != thread) continue;
            return display;
        }
        return null;
    }

    public Shell getActiveShell() {
        this.checkDevice();
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window == null) {
            return null;
        }
        return (Shell)this.findControl(window);
    }

    public org.eclipse.swt.graphics.Rectangle getBounds() {
        this.checkDevice();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        return new org.eclipse.swt.graphics.Rectangle(0, 0, dimension.width, dimension.height);
    }

    public static synchronized Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    public org.eclipse.swt.graphics.Rectangle getClientArea() {
        this.checkDevice();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    Control getControl(Component component) {
        return (Control)this.componentToControlMap.get(component);
    }

    public Control getCursorControl() {
        this.checkDevice();
        if (!Compatibility.IS_JAVA_5_OR_GREATER) {
            return Utils.getTrakedMouseControl();
        }
        java.awt.Point point = MouseInfo.getPointerInfo().getLocation();
        Frame[] frameArray = Frame.getFrames();
        for (int i2 = 0; i2 < frameArray.length; ++i2) {
            Control control;
            Frame frame = frameArray[i2];
            Component component = frame.findComponentAt(point);
            if (component == null || (control = this.findControl(component)) == null) continue;
            return control;
        }
        return null;
    }

    public Point getCursorLocation() {
        this.checkDevice();
        if (!Compatibility.IS_JAVA_5_OR_GREATER) {
            java.awt.Point point = Utils.getTrakedMouseLocation();
            return new Point(point.x, point.y);
        }
        java.awt.Point point = MouseInfo.getPointerInfo().getLocation();
        return new Point(point.x, point.y);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        HashSet<Dimension> hashSet = new HashSet<Dimension>();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        for (int i2 = 8; i2 < 64; ++i2) {
            hashSet.add(toolkit.getBestCursorSize(i2, i2));
        }
        hashSet.remove(new Dimension(0, 0));
        Point[] pointArray = new Point[hashSet.size()];
        int n2 = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Dimension dimension = (Dimension)iterator.next();
            pointArray[n2++] = new Point(dimension.width, dimension.height);
        }
        return pointArray;
    }

    public static synchronized Display getDefault() {
        if (Default == null) {
            Default = new Display();
        }
        return Default;
    }

    static boolean isValidClass(Class clazz) {
        String string = clazz.getName();
        int n2 = string.lastIndexOf(46);
        return string.substring(0, n2 + 1).equals(PACKAGE_PREFIX);
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            if (!this.keys[i2].equals(string)) continue;
            return this.values[i2];
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return 200;
    }

    public Control getFocusControl() {
        this.checkDevice();
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == null) {
            return null;
        }
        return this.findControl(component);
    }

    public boolean getHighContrast() {
        this.checkDevice();
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.highContrast.on");
        return bl != null ? bl : false;
    }

    public int getIconDepth() {
        this.checkDevice();
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(32, 32), new Point(64, 64)};
    }

    MenuItem getMenuItem(JComponent jComponent) {
        for (int i2 = 0; i2 < this.menuItemsList.size(); ++i2) {
            MenuItem menuItem = (MenuItem)this.menuItemsList.get(i2);
            if (menuItem.handle != jComponent) continue;
            return menuItem;
        }
        return null;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        ArrayList<Monitor> arrayList = new ArrayList<Monitor>();
        HashSet<Rectangle> hashSet = new HashSet<Rectangle>();
        for (int i2 = 0; i2 < graphicsDeviceArray.length; ++i2) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i2];
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
            for (int i3 = 0; i3 < graphicsConfigurationArray.length; ++i3) {
                GraphicsConfiguration graphicsConfiguration = graphicsConfigurationArray[i3];
                Monitor monitor = new Monitor();
                monitor.handle = graphicsConfiguration;
                Rectangle rectangle = graphicsConfiguration.getBounds();
                if (!hashSet.add(rectangle)) continue;
                monitor.x = rectangle.x;
                monitor.y = rectangle.y;
                monitor.width = rectangle.width;
                monitor.height = rectangle.height;
                Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
                monitor.clientX = rectangle.x + insets.left;
                monitor.clientY = rectangle.y + insets.top;
                monitor.clientWidth = rectangle.width - insets.left - insets.right;
                monitor.clientHeight = rectangle.height - insets.top - insets.bottom;
                arrayList.add(monitor);
            }
        }
        return arrayList.toArray(new Monitor[0]);
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Monitor monitor = new Monitor();
        monitor.handle = graphicsConfiguration;
        Rectangle rectangle = graphicsConfiguration.getBounds();
        monitor.x = rectangle.x;
        monitor.y = rectangle.y;
        monitor.width = rectangle.width;
        monitor.height = rectangle.height;
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        monitor.clientX = rectangle.x + insets.left;
        monitor.clientY = rectangle.y + insets.top;
        monitor.clientWidth = rectangle.width - insets.left - insets.right;
        monitor.clientHeight = rectangle.height - insets.top - insets.bottom;
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        ArrayList<Control> arrayList = new ArrayList<Control>();
        Iterator iterator = this.componentToControlMap.keySet().iterator();
        while (iterator.hasNext()) {
            Control control;
            Component component = (Component)iterator.next();
            if (!(component instanceof Window) || !((control = this.findControl(component)) instanceof Shell)) continue;
            arrayList.add(control);
        }
        return arrayList.toArray(new Shell[0]);
    }

    public Thread getSyncThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.synchronizer.syncThread;
    }

    public org.eclipse.swt.graphics.Color getSystemColor(int n2) {
        this.checkDevice();
        Color color = LookAndFeelUtils.getSystemColor(n2);
        if (color == null) {
            return super.getSystemColor(n2);
        }
        return org.eclipse.swt.graphics.Color.swing_new(this, color);
    }

    public Cursor getSystemCursor(int n2) {
        this.checkDevice();
        if (0 > n2 || n2 >= this.cursors.length) {
            return null;
        }
        if (this.cursors[n2] == null) {
            this.cursors[n2] = new Cursor(this, n2);
        }
        return this.cursors[n2];
    }

    public org.eclipse.swt.graphics.Image getSystemImage(int n2) {
        this.checkDevice();
        Image image = null;
        switch (n2) {
            case 1: {
                if (this.errorIcon == null) {
                    this.errorIcon = Display.getImage(LookAndFeelUtils.getSystemIcon(n2));
                }
                image = this.errorIcon;
                break;
            }
            case 2: {
                if (this.infoIcon == null) {
                    this.infoIcon = Display.getImage(LookAndFeelUtils.getSystemIcon(n2));
                }
                image = this.infoIcon;
                break;
            }
            case 16: {
                if (this.workingIcon == null) {
                    this.workingIcon = Display.getImage(LookAndFeelUtils.getSystemIcon(n2));
                }
                image = this.workingIcon;
                break;
            }
            case 4: {
                if (this.questionIcon == null) {
                    this.questionIcon = Display.getImage(LookAndFeelUtils.getSystemIcon(n2));
                }
                image = this.questionIcon;
                break;
            }
            case 8: {
                if (this.warningIcon == null) {
                    this.warningIcon = Display.getImage(LookAndFeelUtils.getSystemIcon(n2));
                }
                image = this.warningIcon;
            }
        }
        if (image == null) {
            return null;
        }
        return org.eclipse.swt.graphics.Image.swing_new(this, 1, image);
    }

    static Image getImage(Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(Utils.getDefaultComponent(), graphics, 0, 0);
        graphics.dispose();
        return bufferedImage;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        if (!Compatibility.IS_JAVA_6_OR_GREATER || !SystemTray.isSupported()) {
            return null;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    public Thread getThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.thread;
    }

    public CGC internal_new_GC(GCData gCData) {
        int n2;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if (gCData != null) {
            gCData.device = this;
        }
        Frame[] frameArray = Frame.getFrames();
        Graphics2D graphics2D = null;
        for (n2 = 0; n2 < frameArray.length; ++n2) {
            if (!frameArray[n2].isActive()) continue;
            graphics2D = (Graphics2D)frameArray[n2].getGraphics();
            break;
        }
        if (graphics2D == null) {
            for (n2 = 0; n2 < frameArray.length; ++n2) {
                if (!frameArray[n2].isShowing()) continue;
                graphics2D = (Graphics2D)frameArray[n2].getGraphics();
            }
        }
        for (n2 = 0; n2 < frameArray.length && graphics2D == null; ++n2) {
            graphics2D = (Graphics2D)frameArray[n2].getGraphics();
        }
        if (graphics2D == null) {
            graphics2D = new NullGraphics2D();
        }
        Graphics2D graphics2D2 = graphics2D;
        return new CGC.CGCGraphics2D(){

            public Graphics2D getGraphics() {
                return g2D;
            }

            public Dimension getDeviceSize() {
                org.eclipse.swt.graphics.Rectangle bounds = Display.this.getBounds();
                return new Dimension(bounds.width, bounds.height);
            }
        };
    }

    protected void init() {
        super.init();
    }

    public void internal_dispose_GC(CGC cGC, GCData gCData) {
        cGC.dispose();
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread() || SwingUtilities.isEventDispatchThread();
    }

    public Point map(Control control, Control control2, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(control, control2, point.x, point.y);
    }

    public Point map(Control control, Control control2, int n2, int n3) {
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        org.eclipse.swt.graphics.Rectangle rectangle = this.map(control, control2, n2, n3, 0, 0);
        return new Point(rectangle.x, rectangle.y);
    }

    public org.eclipse.swt.graphics.Rectangle map(Control control, Control control2, org.eclipse.swt.graphics.Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public org.eclipse.swt.graphics.Rectangle map(Control control, Control control2, int n2, int n3, int n4, int n5) {
        this.checkDevice();
        java.awt.Point point = new java.awt.Point(n2, n3);
        if (control == null) {
            if (control2 == null) {
                return new org.eclipse.swt.graphics.Rectangle(n2, n3, n4, n5);
            }
            Point point2 = control2.parent == null ? new Point(0, 0) : control2.parent.getInternalOffset();
            point.x -= point2.x;
            point.y -= point2.y;
            SwingUtilities.convertPointFromScreen(point, ((CControl)((Object)control2.handle)).getClientArea());
        } else {
            Point point3 = control.parent == null ? new Point(0, 0) : control.parent.getInternalOffset();
            point.x -= point3.x;
            point.y -= point3.y;
            if (control2 == null) {
                SwingUtilities.convertPointToScreen(point, ((CControl)((Object)control.handle)).getClientArea());
            } else {
                point3 = control2.parent == null ? new Point(0, 0) : control2.parent.getInternalOffset();
                point.x -= point3.x;
                point.y -= point3.y;
                point = SwingUtilities.convertPoint(((CControl)((Object)control.handle)).getClientArea(), point, ((CControl)((Object)control2.handle)).getClientArea());
            }
        }
        return new org.eclipse.swt.graphics.Rectangle(point.x, point.y, n4, n5);
    }

    static int getPreviousInputState() {
        return Display.convertModifiersEx(Utils.previousModifiersEx);
    }

    static int getInputState() {
        return Display.convertModifiersEx(Utils.modifiersEx);
    }

    static int convertModifiersEx(int n2) {
        int n3 = 0;
        if ((n2 & 0x40) != 0) {
            n3 |= 0x20000;
        }
        if ((n2 & 0x200) != 0) {
            n3 |= 0x10000;
        }
        if ((n2 & 0x80) != 0) {
            n3 |= 0x40000;
        }
        if ((n2 & 0x400) != 0) {
            n3 |= 0x80000;
        }
        if ((n2 & 0x800) != 0) {
            n3 |= 0x100000;
        }
        if ((n2 & 0x1000) != 0) {
            n3 |= 0x200000;
        }
        return n3;
    }

    public boolean post(Event event) {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (event == null) {
            this.error(4);
        }
        try {
            int n2 = event.type;
            switch (n2) {
                case 1: {
                    int n3;
                    int n4 = n3 = event.keyCode == 0 ? Display.untranslateChar(event.character) : Display.untranslateKey(event.keyCode);
                    if (n3 == 0) {
                        return false;
                    }
                    new Robot().keyPress(n3);
                    return true;
                }
                case 2: {
                    int n5;
                    int n6 = n5 = event.keyCode == 0 ? Display.untranslateChar(event.character) : Display.untranslateKey(event.keyCode);
                    if (n5 == 0) {
                        return false;
                    }
                    new Robot().keyRelease(n5);
                    return true;
                }
                case 5: {
                    new Robot().mouseMove(event.x, event.y);
                    return true;
                }
                case 3: 
                case 4: {
                    int n7;
                    switch (event.button) {
                        case 1: {
                            n7 = 16;
                            break;
                        }
                        case 2: {
                            n7 = 8;
                            break;
                        }
                        case 3: {
                            n7 = 4;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (n2 == 3) {
                        new Robot().mousePress(n7);
                    } else {
                        new Robot().mouseRelease(n7);
                    }
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    void postEvent(Event event) {
        int n2;
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n3 = this.eventQueue.length;
        for (n2 = 0; n2 < n3 && this.eventQueue[n2] != null; ++n2) {
        }
        if (n2 == n3) {
            Event[] eventArray = new Event[n3 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n3);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n2] = event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readAndDispatch() {
        this.checkDevice();
        if (UIThreadUtils.isRealDispatch()) {
            boolean bl = UIThreadUtils.swingEventQueue.dispatchEvent();
            UIThreadUtils.throwStoredException();
            this.runDeferredEvents();
            return bl || this.isDisposed();
        }
        if (this.event != null) {
            AWTEvent aWTEvent = this.event;
            this.event = null;
            try {
                Object object = aWTEvent.getSource();
                if (aWTEvent instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)aWTEvent)).dispatch();
                } else if (object instanceof Component) {
                    ((Component)object).dispatchEvent(aWTEvent);
                } else if (object instanceof MenuComponent) {
                    ((MenuComponent)object).dispatchEvent(aWTEvent);
                }
            }
            catch (Throwable throwable) {
                UIThreadUtils.storeException(throwable);
            }
            UIThreadUtils.throwStoredException();
            return true;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return this.isDisposed();
        }
        Object object = UIThreadUtils.UI_LOCK;
        synchronized (object) {
            if (UIThreadUtils.exclusiveSectionCount == 0) {
                return this.isDisposed();
            }
            try {
                UIThreadUtils.UI_LOCK.notify();
                UIThreadUtils.UI_LOCK.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
            UIThreadUtils.throwStoredException();
        }
        this.runDeferredEvents();
        return true;
    }

    static synchronized void register(Display display) {
        for (int i2 = 0; i2 < Displays.length; ++i2) {
            if (Displays[i2] != null) continue;
            Display.Displays[i2] = display;
            return;
        }
        Display[] displayArray = new Display[Displays.length + 4];
        System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
        displayArray[Display.Displays.length] = display;
        Displays = displayArray;
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shellArray = this.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            Shell shell = shellArray[i2];
            if (shell.isDisposed()) continue;
            shell.dispose();
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            Iterator iterator = this.disposeList.iterator();
            while (iterator.hasNext()) {
                ((Runnable)iterator.next()).run();
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        this.warningIcon = null;
        this.questionIcon = null;
        this.infoIcon = null;
        this.warningIcon = null;
        this.errorIcon = null;
        this.popups = null;
        this.bars = null;
    }

    public void removeFilter(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n2, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n2, listener);
    }

    void removeBar(Menu menu) {
        if (this.bars == null) {
            return;
        }
        for (int i2 = 0; i2 < this.bars.length; ++i2) {
            if (this.bars[i2] != menu) continue;
            this.bars[i2] = null;
            return;
        }
    }

    Control removeControl(Component component) {
        if (component == null) {
            return null;
        }
        return (Control)this.componentToControlMap.remove(component);
    }

    void removeMenuItem(MenuItem menuItem) {
        this.menuItemsList.remove(menuItem);
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        for (int i2 = 0; i2 < this.popups.length; ++i2) {
            if (this.popups[i2] != menu) continue;
            this.popups[i2] = null;
            return;
        }
    }

    boolean runAsyncMessages(boolean bl) {
        if (this.synchronizer == null) {
            return false;
        }
        return this.synchronizer.runAsyncMessages(bl);
    }

    boolean runDeferredEvents() {
        Event event;
        while (this.eventQueue != null && (event = this.eventQueue[0]) != null) {
            Widget widget;
            int n2 = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n2);
            this.eventQueue[n2] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            widget2.sendEvent(event);
        }
        this.eventQueue = null;
        return true;
    }

    void sendEvent(int n2, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n2;
        if (event.time == 0) {
            event.time = Utils.getCurrentTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    public void setCursorLocation(int n2, int n3) {
        this.checkDevice();
        try {
            new Robot().mouseMove(n2, n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String string, Object object) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (object == null) {
            int n2;
            if (this.keys == null) {
                return;
            }
            for (n2 = 0; n2 < this.keys.length && !this.keys[n2].equals(string); ++n2) {
            }
            if (n2 == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] stringArray = new String[this.keys.length - 1];
                Object[] objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, stringArray, 0, n2);
                System.arraycopy(this.keys, n2 + 1, stringArray, n2, stringArray.length - n2);
                System.arraycopy(this.values, 0, objectArray, 0, n2);
                System.arraycopy(this.values, n2 + 1, objectArray, n2, objectArray.length - n2);
                this.keys = stringArray;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            if (!this.keys[i2].equals(string)) continue;
            this.values[i2] = object;
            return;
        }
        String[] stringArray = new String[this.keys.length + 1];
        Object[] objectArray = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray;
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    public static void setAppName(String string) {
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (this.synchronizer != null) {
            this.synchronizer.runAsyncMessages(true);
        }
        this.synchronizer = synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sleep() {
        this.checkDevice();
        if (UIThreadUtils.isRealDispatch()) {
            return UIThreadUtils.swingEventQueue.sleep();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            boolean bl = true;
            UIThreadUtils.fakeDispatchingEDT = Thread.currentThread();
            try {
                this.event = Toolkit.getDefaultToolkit().getSystemEventQueue().getNextEvent();
            }
            catch (InterruptedException interruptedException) {
                bl = false;
            }
            UIThreadUtils.fakeDispatchingEDT = null;
            return bl;
        }
        Object object = UIThreadUtils.UI_LOCK;
        synchronized (object) {
            if (UIThreadUtils.exclusiveSectionCount == 0) {
                try {
                    UIThreadUtils.UI_LOCK.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return UIThreadUtils.exclusiveSectionCount > 0;
        }
    }

    public void syncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.isValidThread()) {
            this.synchronizer.runAsyncMessages(true);
            runnable.run();
        } else {
            this.synchronizer.syncExec(runnable);
        }
    }

    public void timerExec(int n2, Runnable runnable) {
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (n2 < 0) {
            this.timerList.remove(runnable);
            return;
        }
        this.timerList.add(runnable);
        new Thread("Display.timerExecThread"){

            public void run() {
                try {
                    4.sleep(milliseconds);
                    boolean isRemoved = Display.this.timerList.remove(runnable);
                    if (isRemoved) {
                        SwingUtilities.invokeLater(runnable);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    static int translateKey(int n2) {
        for (int i2 = 0; i2 < KeyTable.length; ++i2) {
            if (KeyTable[i2][0] != n2) continue;
            return KeyTable[i2][1];
        }
        return 0;
    }

    static int untranslateKey(int n2) {
        for (int i2 = 0; i2 < KeyTable.length; ++i2) {
            if (KeyTable[i2][1] != n2) continue;
            return KeyTable[i2][0];
        }
        return Display.untranslateChar((char)n2);
    }

    static int untranslateChar(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2;
        }
        char c3 = Character.toUpperCase(c2);
        if (c3 >= 'A' && c3 <= 'Z') {
            return c3;
        }
        switch (c2) {
            case '\n': {
                return 10;
            }
            case '\b': {
                return 8;
            }
            case '\t': {
                return 9;
            }
            case ' ': {
                return 32;
            }
            case ',': {
                return 44;
            }
            case '-': {
                return 45;
            }
            case '.': {
                return 46;
            }
            case ';': {
                return 59;
            }
            case '=': {
                return 61;
            }
            case '[': {
                return 91;
            }
            case '\\': {
                return 92;
            }
            case ']': {
                return 93;
            }
            case '`': {
                return 192;
            }
            case '\u00b4': {
                return 222;
            }
            case '&': {
                return 150;
            }
            case '*': {
                return 151;
            }
            case '\"': {
                return 152;
            }
            case '<': {
                return 153;
            }
            case '>': {
                return 160;
            }
            case '{': {
                return 161;
            }
            case '}': {
                return 162;
            }
            case '@': {
                return 512;
            }
            case ':': {
                return 513;
            }
            case '^': {
                return 514;
            }
            case '$': {
                return 515;
            }
            case '\u20ac': {
                return 516;
            }
            case '!': {
                return 517;
            }
            case '\u00a1': {
                return 518;
            }
            case '(': {
                return 519;
            }
            case '#': {
                return 520;
            }
            case '+': {
                return 521;
            }
            case ')': {
                return 522;
            }
            case '_': {
                return 523;
            }
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        Shell[] shellArray = this.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            Shell shell = shellArray[i2];
            if (shell.isDisposed()) continue;
            shell.update();
        }
    }

    public void wake() {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.thread == Thread.currentThread()) {
            return;
        }
        UIThreadUtils.wakeUIThread();
    }

    void wakeThread() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UIThreadUtils.startExclusiveSection(Display.this);
                try {
                    Display.this.runAsyncMessages(true);
                }
                catch (Throwable t2) {
                    UIThreadUtils.storeException(t2);
                }
                UIThreadUtils.stopExclusiveSection();
                UIThreadUtils.throwStoredException();
            }
        });
    }

    static {
        Displays = new Display[4];
        TrimEnabled = false;
        Utils.initializeProperties();
        CShell.ModalityHandler.initialize();
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            protected Window hoveredWindow;

            public void eventDispatched(AWTEvent event) {
                int dumpModifiers;
                InputEvent ie = (InputEvent)event;
                Utils.storeModifiersEx(ie.getModifiersEx());
                if (ie instanceof MouseEvent) {
                    Component component;
                    if (!Compatibility.IS_JAVA_5_OR_GREATER) {
                        Utils.trackMouseProperties((MouseEvent)ie);
                    }
                    if ((component = ie.getComponent()) == null) {
                        return;
                    }
                    Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
                    switch (ie.getID()) {
                        case 507: {
                            if (window == this.hoveredWindow || this.hoveredWindow == null || window == null) break;
                            MouseWheelEvent mwe = (MouseWheelEvent)ie;
                            mwe.consume();
                            java.awt.Point mouseLocation = mwe.getPoint();
                            mouseLocation = SwingUtilities.convertPoint(component, mouseLocation, this.hoveredWindow);
                            Component c2 = this.hoveredWindow.findComponentAt(mouseLocation.x, mouseLocation.y);
                            mouseLocation = SwingUtilities.convertPoint(this.hoveredWindow, mouseLocation, c2);
                            if (c2 == null) break;
                            c2.dispatchEvent(new MouseWheelEvent(c2, mwe.getID(), mwe.getWhen(), mwe.getModifiers(), mouseLocation.x, mouseLocation.y, mwe.getClickCount(), mwe.isPopupTrigger(), mwe.getScrollType(), mwe.getScrollAmount(), mwe.getWheelRotation()));
                            break;
                        }
                        case 504: {
                            break;
                        }
                        case 505: {
                            if (this.hoveredWindow == null) break;
                            MouseEvent me = (MouseEvent)ie;
                            java.awt.Point mouseLocation = me.getPoint();
                            if (this.hoveredWindow.contains(mouseLocation = SwingUtilities.convertPoint(component, mouseLocation, this.hoveredWindow))) break;
                            this.hoveredWindow = null;
                            break;
                        }
                        default: {
                            if (window == null) break;
                            this.hoveredWindow = window;
                        }
                    }
                    return;
                }
                if (ie.getID() == 401 && (Utils.modifiersEx & (dumpModifiers = 192)) == dumpModifiers && ((KeyEvent)ie).getKeyCode() == 113) {
                    Window window;
                    Component component = ie.getComponent();
                    Window window2 = window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
                    if (window instanceof CShell) {
                        Component targetComponent;
                        if (Compatibility.IS_JAVA_5_OR_GREATER) {
                            java.awt.Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
                            SwingUtilities.convertPointFromScreen(mouseLocation, window);
                            targetComponent = window.findComponentAt(mouseLocation);
                        } else {
                            targetComponent = null;
                        }
                        while (targetComponent != null && !(targetComponent instanceof CControl)) {
                            targetComponent = targetComponent.getParent();
                        }
                        Control control = targetComponent != null ? ((CControl)((Object)targetComponent)).getSWTHandle() : ((CShell)((Object)window)).getSWTHandle();
                        Utils.dumpTree(control);
                    }
                }
            }
        }, 131128L);
        DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }
}

