/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.ImageIcon;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Canvas
extends Composite {
    Caret caret;

    Canvas() {
    }

    public Canvas(Composite composite, int n2) {
        super(composite, n2);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    void releaseChildren(boolean bl) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        super.releaseChildren(bl);
    }

    public void drawBackground(GC gC, int n2, int n3, int n4, int n5) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        Graphics2D graphics2D = gC.handle.getGraphics();
        if (this.backgroundImage != null) {
            Shape shape = graphics2D.getClip();
            graphics2D.clipRect(n2, n3, n4, n5);
            Dimension dimension = this.handle.getSize();
            Utils.paintTiledImage(graphics2D, new ImageIcon(this.backgroundImage.handle), 0, 0, dimension.width, dimension.height);
            graphics2D.setClip(shape);
        } else {
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.getBackground().handle);
            graphics2D.fillRect(n2, n3, n4, n5);
            graphics2D.setColor(color);
        }
    }

    public void scroll(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        boolean bl2;
        this.checkWidget();
        boolean bl3 = bl2 = this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        Container container = ((CControl)((Object)this.handle)).getClientArea();
        Graphics graphics = container.getGraphics();
        int n8 = n2 - n4;
        int n9 = n3 - n5;
        graphics.copyArea(n4, n5, n6, n7, n8, n9);
        Dimension dimension = container.getSize();
        if (n8 < 0) {
            container.repaint(dimension.width + n8, 0, -n8, dimension.height);
        } else if (n8 > 0) {
            container.repaint(0, 0, n8, dimension.height);
        }
        if (n9 < 0) {
            container.repaint(0, dimension.height + n9, dimension.width, -n9);
        } else if (n9 > 0) {
            container.repaint(0, 0, dimension.width, n9);
        }
        int n10 = n2 - n4;
        int n11 = n3 - n5;
        if (bl) {
            Control[] controlArray = this._getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                Control control = controlArray[i2];
                Rectangle rectangle = control.getBounds();
                if (Math.min(n4 + n6, rectangle.x + rectangle.width) < Math.max(n4, rectangle.x) || Math.min(n5 + n7, rectangle.y + rectangle.height) < Math.max(n5, rectangle.y)) continue;
                control.setLocation(rectangle.x + n10, rectangle.y + n11);
            }
        }
        if (bl2) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.isFocusControl()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }
}

