/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CGroup;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

class CGroupImplementation
extends JPanel
implements CGroup {
    protected TitledBorder titledBorder;
    protected Container contentPane;
    protected JScrollPane scrollPane;
    protected Group handle;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected ImageIcon backgroundImageIcon;

    public Container getSwingComponent() {
        return this;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CGroupImplementation(Group group, int n2) {
        super(new BorderLayout(0, 0));
        this.handle = group;
        this.userAttributeHandler = new CControl.UserAttributeHandler(this);
        this.init(n2);
    }

    protected void init(int n2) {
        this.titledBorder = BorderFactory.createTitledBorder("");
        this.setBorder(this.titledBorder);
        if ((n2 & 0x300) != 0) {
            JScrollPane jScrollPane;
            this.scrollPane = jScrollPane = new JScrollPane((n2 & 0x200) != 0 ? 20 : 21, (n2 & 0x100) != 0 ? 30 : 31);
            this.add((Component)jScrollPane, "Center");
            this.contentPane = jScrollPane.getViewport();
        } else {
            this.contentPane = new JPanel(null);
            ((JComponent)this.contentPane).setOpaque(false);
            this.add((Component)this.contentPane, "Center");
        }
        Utils.installMouseListener(this.contentPane, this.handle);
        Utils.installKeyListener(this.contentPane, this.handle);
        Utils.installFocusListener(this.contentPane, this.handle);
        Utils.installComponentListener(this, this.handle);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Utils.paintTiledImage(this, graphics, this.backgroundImageIcon);
    }

    public Container getClientArea() {
        return this.contentPane;
    }

    public String getText() {
        return this.titledBorder.getTitle();
    }

    public void setText(String string) {
        this.titledBorder.setTitle(string);
        this.repaint();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.scrollPane == null ? null : this.scrollPane.getVerticalScrollBar();
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.scrollPane == null ? null : this.scrollPane.getHorizontalScrollBar();
    }

    public Color getBackground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.background != null ? this.userAttributeHandler.background : super.getBackground();
    }

    public Color getForeground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.foreground != null ? this.userAttributeHandler.foreground : super.getForeground();
    }

    public Font getFont() {
        return this.userAttributeHandler != null && this.userAttributeHandler.font != null ? this.userAttributeHandler.font : super.getFont();
    }

    public Cursor getCursor() {
        if (Utils.globalCursor != null) {
            return Utils.globalCursor;
        }
        return this.userAttributeHandler != null && this.userAttributeHandler.cursor != null ? this.userAttributeHandler.cursor : super.getCursor();
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: {
                this.setOpaque(true);
                if (this.scrollPane == null) break;
                this.scrollPane.setOpaque(true);
                this.scrollPane.getViewport().setOpaque(true);
                break;
            }
            case 1: 
            case 2: {
                this.setOpaque(false);
                if (this.scrollPane == null) break;
                this.scrollPane.setOpaque(false);
                this.scrollPane.getViewport().setOpaque(false);
            }
        }
    }
}

