/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public final class CCombo
extends Composite {
    Text text;
    List list;
    int visibleItemCount;
    Shell popup;
    Button arrow;
    boolean hasFocus;
    Listener listener;
    Listener filter;
    Color foreground;
    Color background;
    Font font;

    public CCombo(Composite composite, int n2) {
        n2 = CCombo.checkStyle(n2);
        super(composite, n2);
        this.visibleItemCount = 5;
        int n3 = 4;
        if ((n2 & 8) != 0) {
            n3 |= 8;
        }
        if ((n2 & 0x800000) != 0) {
            n3 |= 0x800000;
        }
        this.text = new Text(this, n3);
        int n4 = 1028;
        if ((n2 & 0x800000) != 0) {
            n4 |= 0x800000;
        }
        this.arrow = new Button(this, n4);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (CCombo.this.popup == event.widget) {
                    CCombo.this.popupEvent(event);
                    return;
                }
                if (CCombo.this.text == event.widget) {
                    CCombo.this.textEvent(event);
                    return;
                }
                if (CCombo.this.list == event.widget) {
                    CCombo.this.listEvent(event);
                    return;
                }
                if (CCombo.this.arrow == event.widget) {
                    CCombo.this.arrowEvent(event);
                    return;
                }
                if (CCombo.this == event.widget) {
                    CCombo.this.comboEvent(event);
                    return;
                }
                if (CCombo.this.getShell() == event.widget) {
                    CCombo.this.handleFocus(16);
                }
            }
        };
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == CCombo.this.getShell()) {
                    CCombo.this.handleFocus(16);
                }
            }
        };
        int[] nArray = new int[]{12, 10, 11};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.addListener(nArray[i2], this.listener);
        }
        int[] nArray2 = new int[]{1, 2, 35, 24, 3, 4, 31, 15};
        for (int i3 = 0; i3 < nArray2.length; ++i3) {
            this.text.addListener(nArray2[i3], this.listener);
        }
        int[] nArray3 = new int[]{13, 15};
        for (int i4 = 0; i4 < nArray3.length; ++i4) {
            this.arrow.addListener(nArray3[i4], this.listener);
        }
        this.createPopup(null, -1);
        this.initAccessible();
    }

    static int checkStyle(int n2) {
        int n3 = 0x6800808;
        return n2 & n3;
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        this.list.add(string);
    }

    public void add(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        this.list.add(string, n2);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 13: {
                this.dropDown(!this.isDropped());
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        this.text.clearSelection();
        this.list.deselectAll();
    }

    void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.list.removeListener(12, this.listener);
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.popup = null;
                this.text = null;
                this.list = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout(false);
            }
        }
    }

    public Point computeSize(int n2, int n3, boolean bl) {
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        String[] stringArray = this.list.getItems();
        int n6 = 0;
        GC gC = new GC(this.text);
        int n7 = gC.stringExtent((String)" ").x;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            n6 = Math.max(gC.stringExtent((String)stringArray[i2]).x, n6);
        }
        gC.dispose();
        Point point = this.text.computeSize(-1, -1, bl);
        Point point2 = this.arrow.computeSize(-1, -1, bl);
        Point point3 = this.list.computeSize(-1, -1, bl);
        int n8 = this.getBorderWidth();
        n5 = Math.max(point.y, point2.y);
        n4 = Math.max(n6 + 2 * n7 + point2.x + 2 * n8, point3.x);
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n5 = n3;
        }
        return new Point(n4 + 2 * n8, n5 + 2 * n8);
    }

    void createPopup(String[] stringArray, int n2) {
        this.popup = new Shell(this.getShell(), 16392);
        int n3 = this.getStyle();
        int n4 = 516;
        if ((n3 & 0x800000) != 0) {
            n4 |= 0x800000;
        }
        if ((n3 & 0x4000000) != 0) {
            n4 |= 0x4000000;
        }
        if ((n3 & 0x2000000) != 0) {
            n4 |= 0x2000000;
        }
        this.list = new List(this.popup, n4);
        if (this.font != null) {
            this.list.setFont(this.font);
        }
        if (this.foreground != null) {
            this.list.setForeground(this.foreground);
        }
        if (this.background != null) {
            this.list.setBackground(this.background);
        }
        int[] nArray = new int[]{21, 9, 27};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.popup.addListener(nArray[i2], this.listener);
        }
        int[] nArray2 = new int[]{4, 13, 31, 1, 2, 15, 12};
        for (int i3 = 0; i3 < nArray2.length; ++i3) {
            this.list.addListener(nArray2[i3], this.listener);
        }
        if (stringArray != null) {
            this.list.setItems(stringArray);
        }
        if (n2 != -1) {
            this.list.setSelection(n2);
        }
    }

    public void deselect(int n2) {
        this.checkWidget();
        this.list.deselect(n2);
    }

    public void deselectAll() {
        this.checkWidget();
        this.list.deselectAll();
    }

    void dropDown(boolean bl) {
        int n2;
        String[] stringArray;
        if (bl == this.isDropped()) {
            return;
        }
        if (!bl) {
            this.popup.setVisible(false);
            if (!this.isDisposed() && this.arrow.isFocusControl()) {
                this.text.setFocus();
            }
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            stringArray = this.list.getItems();
            n2 = this.list.getSelectionIndex();
            this.list.removeListener(12, this.listener);
            this.popup.dispose();
            this.popup = null;
            this.list = null;
            this.createPopup(stringArray, n2);
        }
        stringArray = this.getSize();
        n2 = this.list.getItemCount();
        n2 = n2 == 0 ? this.visibleItemCount : Math.min(this.visibleItemCount, n2);
        int n3 = this.list.getItemHeight() * n2;
        Point point = this.list.computeSize(-1, n3, false);
        this.list.setBounds(1, 1, Math.max(stringArray.x - 2, point.x), point.y);
        int n4 = this.list.getSelectionIndex();
        if (n4 != -1) {
            this.list.setTopIndex(n4);
        }
        Display display = this.getDisplay();
        Rectangle rectangle = this.list.getBounds();
        Rectangle rectangle2 = display.map((Control)this.getParent(), null, this.getBounds());
        Point point2 = this.getSize();
        Rectangle rectangle3 = this.getMonitor().getClientArea();
        int n5 = Math.max(point2.x, rectangle.width + 2);
        int n6 = rectangle.height + 2;
        int n7 = rectangle2.x;
        int n8 = rectangle2.y + point2.y;
        if (n8 + n6 > rectangle3.y + rectangle3.height) {
            n8 = rectangle2.y - n6;
        }
        if (n7 + n5 > rectangle3.x + rectangle3.width) {
            n7 = rectangle3.x + rectangle3.width - rectangle.width;
        }
        this.popup.setBounds(n7, n8, n5, n6);
        this.popup.setVisible(true);
        this.list.setFocus();
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return '\u0000';
            }
            if (string.charAt(n2) != '&') {
                return Character.toLowerCase(string.charAt(n2));
            }
            if (++n2 >= n3) break;
        }
        return '\u0000';
    }

    Label getAssociatedLabel() {
        Control[] controlArray = this.getParent().getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            if (controlArray[i2] != this || i2 <= 0 || !(controlArray[i2 - 1] instanceof Label)) continue;
            return (Label)controlArray[i2 - 1];
        }
        return null;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public String getItem(int n2) {
        this.checkWidget();
        return this.list.getItem(n2);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.list.getItemCount();
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.list.getItemHeight();
    }

    public String[] getItems() {
        this.checkWidget();
        return this.list.getItems();
    }

    public Menu getMenu() {
        return this.text.getMenu();
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.list.getSelectionIndex();
    }

    public int getStyle() {
        int n2 = super.getStyle();
        n2 &= 0xFFFFFFF7;
        if (!this.text.getEditable()) {
            n2 |= 8;
        }
        return n2;
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleItemCount;
    }

    void handleFocus(int n2) {
        if (this.isDisposed()) {
            return;
        }
        switch (n2) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event event = new Event();
                this.notifyListeners(15, event);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control control = this.getDisplay().getFocusControl();
                if (control == this.arrow || control == this.list || control == this.text) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                Event event = new Event();
                this.notifyListeners(16, event);
                break;
            }
        }
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return this.list.indexOf(string);
    }

    public int indexOf(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return this.list.indexOf(string, n2);
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent e2) {
                String name = null;
                Label label = CCombo.this.getAssociatedLabel();
                if (label != null) {
                    name = CCombo.this.stripMnemonic(label.getText());
                }
                e2.result = name;
            }

            public void getKeyboardShortcut(AccessibleEvent e2) {
                char mnemonic;
                String text;
                String shortcut = null;
                Label label = CCombo.this.getAssociatedLabel();
                if (label != null && (text = label.getText()) != null && (mnemonic = CCombo.this._findMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e2.result = shortcut;
            }

            public void getHelp(AccessibleEvent e2) {
                e2.result = CCombo.this.getToolTipText();
            }
        };
        this.getAccessible().addAccessibleListener(accessibleAdapter);
        this.text.getAccessible().addAccessibleListener(accessibleAdapter);
        this.list.getAccessible().addAccessibleListener(accessibleAdapter);
        this.arrow.getAccessible().addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent e2) {
                e2.result = CCombo.this.isDropped() ? SWT.getMessage("SWT_Close") : SWT.getMessage("SWT_Open");
            }

            public void getKeyboardShortcut(AccessibleEvent e2) {
                e2.result = "Alt+Down Arrow";
            }

            public void getHelp(AccessibleEvent e2) {
                e2.result = CCombo.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleTextListener(new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e2) {
                e2.offset = CCombo.this.text.getCaretPosition();
            }

            public void getSelectionRange(AccessibleTextEvent e2) {
                Point sel = CCombo.this.text.getSelection();
                e2.offset = sel.x;
                e2.length = sel.y - sel.x;
            }
        });
        this.getAccessible().addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e2) {
                Point testPoint = CCombo.this.toControl(e2.x, e2.y);
                if (CCombo.this.getBounds().contains(testPoint)) {
                    e2.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e2) {
                Rectangle location = CCombo.this.getBounds();
                Point pt = CCombo.this.toDisplay(location.x, location.y);
                e2.x = pt.x;
                e2.y = pt.y;
                e2.width = location.width;
                e2.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e2) {
                e2.detail = 0;
            }

            public void getRole(AccessibleControlEvent e2) {
                e2.detail = 46;
            }

            public void getState(AccessibleControlEvent e2) {
                e2.detail = 0;
            }

            public void getValue(AccessibleControlEvent e2) {
                e2.result = CCombo.this.getText();
            }
        });
        this.text.getAccessible().addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e2) {
                e2.detail = CCombo.this.text.getEditable() ? 42 : 41;
            }
        });
        this.arrow.getAccessible().addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getDefaultAction(AccessibleControlEvent e2) {
                e2.result = CCombo.this.isDropped() ? SWT.getMessage("SWT_Close") : SWT.getMessage("SWT_Open");
            }
        });
    }

    boolean isDropped() {
        return this.popup.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.text.isFocusControl() || this.arrow.isFocusControl() || this.list.isFocusControl() || this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    void internalLayout(boolean bl) {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rectangle = this.getClientArea();
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        Point point = this.arrow.computeSize(-1, n3, bl);
        this.text.setBounds(0, 0, n2 - point.x, n3);
        this.arrow.setBounds(n2 - point.x, 0, point.x, point.y);
    }

    void listEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.getShell() == this.popup.getParent()) break;
                String[] stringArray = this.list.getItems();
                int n2 = this.list.getSelectionIndex();
                this.popup = null;
                this.list = null;
                this.createPopup(stringArray, n2);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                this.dropDown(false);
                break;
            }
            case 13: {
                int n3 = this.list.getSelectionIndex();
                if (n3 == -1) {
                    return;
                }
                this.text.setText(this.list.getItem(n3));
                this.text.selectAll();
                this.list.setSelection(n3);
                Event event2 = new Event();
                event2.time = event.time;
                event2.stateMask = event.stateMask;
                event2.doit = event.doit;
                this.notifyListeners(13, event2);
                event.doit = event2.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event event3 = new Event();
                event3.time = event.time;
                event3.detail = event.detail;
                event3.doit = event.doit;
                event3.character = event.character;
                event3.keyCode = event.keyCode;
                this.notifyListeners(31, event3);
                event.doit = event3.doit;
                event.detail = event3.detail;
                break;
            }
            case 2: {
                Event event4 = new Event();
                event4.time = event.time;
                event4.character = event.character;
                event4.keyCode = event.keyCode;
                event4.stateMask = event.stateMask;
                this.notifyListeners(2, event4);
                break;
            }
            case 1: {
                Event event5;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if ((event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    event5 = new Event();
                    event5.time = event.time;
                    event5.stateMask = event.stateMask;
                    this.notifyListeners(14, event5);
                }
                if (this.isDisposed()) break;
                event5 = new Event();
                event5.time = event.time;
                event5.character = event.character;
                event5.keyCode = event.keyCode;
                event5.stateMask = event.stateMask;
                this.notifyListeners(1, event5);
                break;
            }
        }
    }

    void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle rectangle = this.list.getBounds();
                Color color = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(color);
                event.gc.drawRectangle(0, 0, rectangle.width + 1, rectangle.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                this.dropDown(false);
            }
        }
    }

    public void redraw() {
        super.redraw();
        this.text.redraw();
        this.arrow.redraw();
        if (this.popup.isVisible()) {
            this.list.redraw();
        }
    }

    public void redraw(int n2, int n3, int n4, int n5, boolean bl) {
        super.redraw(n2, n3, n4, n5, true);
    }

    public void remove(int n2) {
        this.checkWidget();
        this.list.remove(n2);
    }

    public void remove(int n2, int n3) {
        this.checkWidget();
        this.list.remove(n2, n3);
    }

    public void remove(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        this.list.remove(string);
    }

    public void removeAll() {
        this.checkWidget();
        this.text.setText("");
        this.list.removeAll();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void select(int n2) {
        this.checkWidget();
        if (n2 == -1) {
            this.list.deselectAll();
            this.text.setText("");
            return;
        }
        if (0 <= n2 && n2 < this.list.getItemCount() && n2 != this.getSelectionIndex()) {
            this.text.setText(this.list.getItem(n2));
            this.text.selectAll();
            this.list.select(n2);
            this.list.showSelection();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background = color;
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.list != null) {
            this.list.setBackground(color);
        }
        if (this.arrow != null) {
            this.arrow.setBackground(color);
        }
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.text.setEditable(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        if (this.text != null) {
            this.text.setEnabled(bl);
        }
        if (this.arrow != null) {
            this.arrow.setEnabled(bl);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.text.setFont(font);
        this.list.setFont(font);
        this.internalLayout(true);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.list != null) {
            this.list.setForeground(color);
        }
        if (this.arrow != null) {
            this.arrow.setForeground(color);
        }
    }

    public void setItem(int n2, String string) {
        this.checkWidget();
        this.list.setItem(n2, string);
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        this.list.setItems(stringArray);
        if (!this.text.getEditable()) {
            this.text.setText("");
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMenu(Menu menu) {
        this.text.setMenu(menu);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.text.setSelection(point.x, point.y);
    }

    public void setText(String string) {
        int n2;
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if ((n2 = this.list.indexOf(string)) == -1) {
            this.list.deselectAll();
            this.text.setText(string);
            return;
        }
        this.text.setText(string);
        this.text.selectAll();
        this.list.setSelection(n2);
        this.list.showSelection();
    }

    public void setTextLimit(int n2) {
        this.checkWidget();
        this.text.setTextLimit(n2);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.arrow.setToolTipText(string);
        this.text.setToolTipText(string);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.popup.setVisible(false);
        }
    }

    public void setVisibleItemCount(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        this.visibleItemCount = n2;
    }

    String stripMnemonic(String string) {
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return string;
            }
            if (string.charAt(n2) != '&') {
                return string.substring(0, n2 - 1) + string.substring(n2, n3);
            }
            if (++n2 >= n3) break;
        }
        return string;
    }

    void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 1: {
                Event event2;
                if (event.character == '\r') {
                    this.dropDown(false);
                    event2 = new Event();
                    event2.time = event.time;
                    event2.stateMask = event.stateMask;
                    this.notifyListeners(14, event2);
                }
                if (this.isDisposed()) break;
                if (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
                    event.doit = false;
                    if ((event.stateMask & 0x10000) != 0) {
                        boolean bl = this.isDropped();
                        this.text.selectAll();
                        if (!bl) {
                            this.setFocus();
                        }
                        this.dropDown(!bl);
                        break;
                    }
                    int n2 = this.getSelectionIndex();
                    if (event.keyCode == 0x1000001) {
                        this.select(Math.max(n2 - 1, 0));
                    } else {
                        this.select(Math.min(n2 + 1, this.getItemCount() - 1));
                    }
                    if (n2 != this.getSelectionIndex()) {
                        Event event3 = new Event();
                        event3.time = event.time;
                        event3.stateMask = event.stateMask;
                        this.notifyListeners(13, event3);
                    }
                    if (this.isDisposed()) break;
                }
                event2 = new Event();
                event2.time = event.time;
                event2.character = event.character;
                event2.keyCode = event.keyCode;
                event2.stateMask = event.stateMask;
                this.notifyListeners(1, event2);
                break;
            }
            case 2: {
                Event event4 = new Event();
                event4.time = event.time;
                event4.character = event.character;
                event4.keyCode = event.keyCode;
                event4.stateMask = event.stateMask;
                this.notifyListeners(2, event4);
                break;
            }
            case 35: {
                Event event5 = new Event();
                event5.time = event.time;
                this.notifyListeners(35, event5);
                break;
            }
            case 24: {
                this.list.deselectAll();
                Event event6 = new Event();
                event6.time = event.time;
                this.notifyListeners(24, event6);
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                boolean bl = this.isDropped();
                this.text.selectAll();
                if (!bl) {
                    this.setFocus();
                }
                this.dropDown(!bl);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                this.text.selectAll();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event event7 = new Event();
                event7.time = event.time;
                event7.detail = event.detail;
                event7.doit = event.doit;
                event7.character = event.character;
                event7.keyCode = event.keyCode;
                this.notifyListeners(31, event7);
                event.doit = event7.doit;
                event.detail = event7.detail;
                break;
            }
        }
    }
}

