
package JavaDive;

/**
 * 	[En]	Direct interface to the hardware I/O and COM/LPT ports		[En]
 * 	[Ru]	頥   ⠬ -뢮  COM/LPT	[Ru]
 */

public final class Dive
{	
	static int rateForCOM1 = 9600; static int rateForCOM2 = 9600;
	static int rateForCOM3 = 9600; static int rateForCOM4 = 9600;
	static int rateForCOM5 = 9600; static int rateForCOM6 = 9600;
	static int rateForCOM7 = 9600; static int rateForCOM8 = 9600;

	static int rateForLPT1 = 9600; static int rateForLPT2 = 9600;
	static int rateForLPT3 = 9600; static int rateForLPT4 = 9600;
	static int rateForLPT5 = 9600; static int rateForLPT6 = 9600;
	static int rateForLPT7 = 9600; static int rateForLPT8 = 9600;

	static
	{
		System.loadLibrary( "JavaDive.dll" );
	}	

/**
 * 	[En]	Returns rate for COM/LPT port					[En]
 * 	[Ru]	頥 ᪮   COM/LPT		[Ru]
 */

public static int getRate ( int port )
{
	switch( port )
	{
		case Ports.COM1: return rateForCOM1; case Ports.COM2: return rateForCOM2;
		case Ports.COM3: return rateForCOM3; case Ports.COM4: return rateForCOM4;
		case Ports.COM5: return rateForCOM5; case Ports.COM6: return rateForCOM6;
		case Ports.COM7: return rateForCOM7; case Ports.COM8: return rateForCOM8;

		case Ports.LPT1: return rateForLPT1; case Ports.LPT2: return rateForLPT2;
		case Ports.LPT3: return rateForLPT3; case Ports.LPT4: return rateForLPT4;
		case Ports.LPT5: return rateForLPT5; case Ports.LPT6: return rateForLPT6;
		case Ports.LPT7: return rateForLPT7; case Ports.LPT8: return rateForLPT8;
	}
	
	return 0;
}
/**
 * 	[En]	Reads byte from I/O or COM/LPT port					[En]
 * 	[Ru]	⠥    -뢮  COM/LPT		[Ru]
 */

public static int inp ( int port )
{
	if( Ports.isHardwarePort( port ) ) return readByteFromHardwarePort( port );
	if( Ports.isCommunicationPort( port ) ) return readByteFromCommunicationPort( port );	
	
	return 0;
}
/**
 * 	[En]	Reads word from I/O port					[En]
 * 	[Ru]	⠥ ᫮   -뢮 	[Ru]
 */

public static int inpw ( int port )
{
	if( Ports.isHardwarePort( port ) ) return readWordFromHardwarePort( port );
	
	return 0;
}
/**
 * 	[En]	Writes byte to the I/O or COM/LPT port					[En]
 * 	[Ru]	뢠    -뢮  COM/LPT	[Ru]
 */

public static void outp ( int port, int value )
{
	if( Ports.isHardwarePort( port ) ) writeByteToHardwarePort( port, value );
	if( Ports.isCommunicationPort( port ) ) writeByteToCommunicationPort( port, value );
}
/**
 * 	[En]	Writes word to the I/O 						[En]
 * 	[Ru]	뢠 ᫮   -뢮 	[Ru]
 */

public static void outpw ( int port, int value )
{
	if( Ports.isHardwarePort( port ) ) writeWordToHardwarePort( port, value );
}


native static int readByteFromCommunicationPort ( long port );



native static int readByteFromHardwarePort ( long port );



native static int readWordFromHardwarePort ( long port );

/**
 * 	[En]	Sets rate for COM/LPT port					[En]
 * 	[Ru]	 ᪮   COM/LPT	[Ru]
 */

public static void setRate ( int port, int rate )
{
	if( !Ports.isCommunicationPort( port ) ) return;
	
	switch( port )
	{
		case Ports.COM1: rateForCOM1 = rate; case Ports.COM2: rateForCOM2 = rate;
		case Ports.COM3: rateForCOM3 = rate; case Ports.COM4: rateForCOM4 = rate;
		case Ports.COM5: rateForCOM5 = rate; case Ports.COM6: rateForCOM6 = rate;
		case Ports.COM7: rateForCOM7 = rate; case Ports.COM8: rateForCOM8 = rate;

		case Ports.LPT1: rateForLPT1 = rate; case Ports.LPT2: rateForLPT2 = rate;
		case Ports.LPT3: rateForLPT3 = rate; case Ports.LPT4: rateForLPT4 = rate;
		case Ports.LPT5: rateForLPT5 = rate; case Ports.LPT6: rateForLPT6 = rate;
		case Ports.LPT7: rateForLPT7 = rate; case Ports.LPT8: rateForLPT8 = rate;
	}
}
/**
 * 	[En]	Writes a string to the COM/LPT port and waits for result	[En]
 * 	[Ru]	뢠 ப   COM/LPT	  ⢥			[Ru]
 */

public static String talk ( int port, String command, String markers )
{	
	if( !Ports.isCommunicationPort( port ) ) return null;
	if( command == null || command.length() == 0 ) return null;
	if( markers == null ) markers = "";

	int queueHandle = Java2C.createQueue();	
	Java2C.writeString( queueHandle, command );
	Java2C.writeString( queueHandle, markers );
	Java2C.writeStopper( queueHandle );
		
	talkWithDeviceViaCommunicationPort( port, getRate( port ), queueHandle );

	Java2C.readStopper( queueHandle );
	return Java2C.readString( queueHandle );
}


native static void talkWithDeviceViaCommunicationPort( long port, long rate, long queueHandle );



native static void writeByteToCommunicationPort ( long port, long value );



native static void writeByteToHardwarePort ( long port, long value );



native static void writeWordToHardwarePort ( long port, long value );

}
