// --------------------------------------------------------------------------
// The jSyncManager Project -- Source File.
// Copyright (c) 1998 - 2003 Brad BARCLAY <bbarclay@jsyncmanager.org>
// --------------------------------------------------------------------------
// OSI Certified Open Source Software
// --------------------------------------------------------------------------
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published 
// by the Free Software Foundation; either version 2.1 of the License, or 
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public 
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
// --------------------------------------------------------------------------
// $Id: TerminalUI.java,v 1.3 2003/11/20 17:50:58 yaztromo Exp $
// --------------------------------------------------------------------------

package org.jSyncManager.JSerial.TestSuite;

/**
 * This class represents a simple termainl program.
 * TerminalUI is a simple terminal program, which allows any port at any speed
 * using 8-N-1 communications with RTS/CTS flow control.
 * @author Brad Barclay.
 * @version 1.0
 */
public class TerminalUI extends java.awt.Frame implements java.awt.event.ActionListener, java.awt.event.ItemListener, java.awt.event.WindowListener {
	public boolean connectFlag = false;
	public Thread inputThread = null;
	public java.io.DataInputStream is = null;
	private AboutBox ivjAboutBox1 = null;
	private java.awt.CheckboxMenuItem ivjCheckboxMenuItem1 = null;
	private CommSettingsPanel ivjCommSettingsPanel1 = null;
	private java.awt.Menu ivjMenu1 = null;
	private java.awt.MenuItem ivjMenuItem1 = null;
	private java.awt.MenuItem ivjMenuItem2 = null;
	private java.awt.MenuItem ivjMenuItem3 = null;
	private java.awt.MenuItem ivjMenuItem4 = null;
	private java.awt.Panel ivjPanel1 = null;
	private java.awt.Button ivjstartButton = null;
	private java.awt.MenuBar ivjTerminalUIMenuBar = null;
	private java.awt.TextArea ivjterminalViewer = null;
	private java.awt.TextField ivjTextField1 = null;
	public boolean localEcho = false;
	public java.io.DataOutputStream os = null;
	public org.jSyncManager.JSerial.SerialInterface serial = null;
	public TerminalThread t = null;

/**
 * Creates a new instance of the TerminalUI object.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public TerminalUI() {
	super();
	initialize();
}

/**
 * Method to handle events for the ActionListener interface.
 * @param e java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void actionPerformed(java.awt.event.ActionEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == getMenuItem3()) ) {
		conn1(e);
	}
	if ((e.getSource() == getMenuItem4()) ) {
		conn2(e);
	}
	if ((e.getSource() == getTextField1()) ) {
		conn4(e);
	}
	if ((e.getSource() == getstartButton()) ) {
		conn6(e);
	}
	if ((e.getSource() == getTextField1()) ) {
		conn7(e);
	}
	if ((e.getSource() == getMenuItem1()) ) {
		conn3(e);
	}
	// user code begin {2}
	// user code end
}

/**
 * conn0:  (TerminalUI.window.windowClosing(java.awt.event.WindowEvent) --> TerminalUI.dispose())
 * @param arg1 java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn0(java.awt.event.WindowEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.dispose();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn1:  (MenuItem3.action.actionPerformed(java.awt.event.ActionEvent) --> AboutBox1.show())
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn1(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getAboutBox1().show();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn2:  (MenuItem4.action.actionPerformed(java.awt.event.ActionEvent) --> TerminalUI.dispose())
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn2(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.dispose();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn3:  (MenuItem1.action.actionPerformed(java.awt.event.ActionEvent) --> terminalViewer.text)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn3(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getterminalViewer().setText(new java.lang.String());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn4:  (TextField1.action.actionPerformed(java.awt.event.ActionEvent) --> TerminalUI.sendString(Ljava.lang.String;)V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn4(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.sendString(getTextField1().getText());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn6:  (startButton.action.actionPerformed(java.awt.event.ActionEvent) --> TerminalUI.connectToPort()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn6(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.connectToPort();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn7:  (TextField1.action.actionPerformed(java.awt.event.ActionEvent) --> TextField1.text)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn7(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getTextField1().setText(new java.lang.String());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn8:  (CheckboxMenuItem1.item.itemStateChanged(java.awt.event.ItemEvent) --> TerminalUI.setLocalEcho(Z)V)
 * @param arg1 java.awt.event.ItemEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn8(java.awt.event.ItemEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.setLocalEcho(getCheckboxMenuItem1().getState());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * This method was created by a SmartGuide.
 */
private void connectToPort() {
	// This method will connect to the given port when requested, directing any error messages to
	// The terminal display.
	
	if(connectFlag) {
		try {
			serial.releasePort();
		} catch (org.jSyncManager.JSerial.SerialReleaseException e) {
			getterminalViewer().append("*** Unable to release port!\n");
			return;
		}
		
		t.setRunning(false);
		
		try {
			inputThread.interrupt();
		} catch (SecurityException e) {
			// Only done for niceness' sake
			System.out.println("*** Unable to stop thread!");
		}	

		inputThread=null;
		
		getstartButton().setLabel("Initialize Port");
		getCommSettingsPanel1().setEnabled(true);
		serial=null;

		try {
			is.close();
			os.close();
		} catch (java.io.IOException e) {
			// Oh well - only doing this to be clean
		}		
		is=null;
		os=null;
		connectFlag=false;
		return;
	}	
	
	int speed=0, port=0;
	
	port=getCommSettingsPanel1().getPortSelect().getSelectedIndex();
	
	try {
		speed=Integer.parseInt(getCommSettingsPanel1().getSpeedSelect().getSelectedItem());
	} catch (Exception e) {
		getterminalViewer().append("*** Error parsing speed value.\n");
		getterminalViewer().append("*** Exception: "+e.toString());
		getterminalViewer().append("*** Value selected: "+getCommSettingsPanel1().getSpeedSelect().getSelectedItem());
		return;
	}
	
	try {
		serial=new org.jSyncManager.JSerial.SerialInterface((byte)port, speed);
	} catch (org.jSyncManager.JSerial.SerialInitializationException e1) {
		// Exception thrown because we're unable to initialize the specified port
		getterminalViewer().append("*** Unable to initialize port (may already be in use).\n");
		return;
	} catch(org.jSyncManager.JSerial.SerialSpeedException e2) {
		getterminalViewer().append("***Unable to set Speed to "+speed+".\n");
		return;
	} catch (org.jSyncManager.JSerial.SerialDataBitException e3) {
		getterminalViewer().append("*** Error initializing with default databit size.\n");
		return;
	} catch (org.jSyncManager.JSerial.SerialParityException e4) {
		getterminalViewer().append("*** Error initializing with default parity.\n");
		return;
	} catch (org.jSyncManager.JSerial.SerialStopBitException e5) {
		getterminalViewer().append("*** Error initializing with default stop bit value.\n");
		return;
	} catch (org.jSyncManager.JSerial.SerialGrabException e6) {
		getterminalViewer().append("*** Unable to grab port (may already be in use).\n");
		return;
	}
	
	getstartButton().setLabel("Disconnect");
	getCommSettingsPanel1().setEnabled(false);

	getterminalViewer().append("*** Connected:\n"+serial.getPlatformName()+"\n"+serial.getPeerVersion()+"\n\n");
	os=new java.io.DataOutputStream(serial.getOutputStream());
	is=new java.io.DataInputStream(serial.getInputStream());

	t=new TerminalThread(is, this);
	inputThread=new Thread(t);
	try {
		inputThread.setPriority(Thread.MIN_PRIORITY);
	} catch (Exception e) {
		// So what
	}		
	connectFlag=true;
	
	try {
		serial.setRTSCTS(true);
	} catch (org.jSyncManager.JSerial.SerialHandshakingException e) {
		// Do nothing
	}	
		
	t.setRunning(true);	
	inputThread.start();
}
/**
 * Return the AboutBox1 property value.
 * @return AboutBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private AboutBox getAboutBox1() {
	if (ivjAboutBox1 == null) {
		try {
			ivjAboutBox1 = new org.jSyncManager.JSerial.TestSuite.AboutBox(this);
			ivjAboutBox1.setName("AboutBox1");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjAboutBox1;
}

/**
 * Return the CheckboxMenuItem1 property value.
 * @return java.awt.CheckboxMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.CheckboxMenuItem getCheckboxMenuItem1() {
	if (ivjCheckboxMenuItem1 == null) {
		try {
			ivjCheckboxMenuItem1 = new java.awt.CheckboxMenuItem();
			ivjCheckboxMenuItem1.setLabel("Local Echo Enabled");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjCheckboxMenuItem1;
}

/**
 * Return the CommSettingsPanel1 property value.
 * @return CommSettingsPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private CommSettingsPanel getCommSettingsPanel1() {
	if (ivjCommSettingsPanel1 == null) {
		try {
			ivjCommSettingsPanel1 = new org.jSyncManager.JSerial.TestSuite.CommSettingsPanel();
			ivjCommSettingsPanel1.setName("CommSettingsPanel1");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjCommSettingsPanel1;
}

/**
 * This method was created by a SmartGuide.
 * @return boolean
 */
private boolean getLocalEcho() {
	return localEcho;
}
/**
 * Return the Menu1 property value.
 * @return java.awt.Menu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Menu getMenu1() {
	if (ivjMenu1 == null) {
		try {
			ivjMenu1 = new java.awt.Menu();
			ivjMenu1.setLabel("Options");
			ivjMenu1.add(getMenuItem1());
			ivjMenu1.add(getCheckboxMenuItem1());
			ivjMenu1.add(getMenuItem4());
			ivjMenu1.add(getMenuItem2());
			ivjMenu1.add(getMenuItem3());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjMenu1;
}

/**
 * Return the MenuItem1 property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getMenuItem1() {
	if (ivjMenuItem1 == null) {
		try {
			ivjMenuItem1 = new java.awt.MenuItem();
			ivjMenuItem1.setLabel("Clear Terminal Window");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjMenuItem1;
}

/**
 * Return the MenuItem2 property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getMenuItem2() {
	if (ivjMenuItem2 == null) {
		try {
			ivjMenuItem2 = new java.awt.MenuItem();
			ivjMenuItem2.setLabel("-");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjMenuItem2;
}

/**
 * Return the MenuItem3 property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getMenuItem3() {
	if (ivjMenuItem3 == null) {
		try {
			ivjMenuItem3 = new java.awt.MenuItem();
			ivjMenuItem3.setLabel("About...");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjMenuItem3;
}

/**
 * Return the MenuItem4 property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getMenuItem4() {
	if (ivjMenuItem4 == null) {
		try {
			ivjMenuItem4 = new java.awt.MenuItem();
			ivjMenuItem4.setLabel("Return to Main Menu");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjMenuItem4;
}

/**
 * Return the Panel1 property value.
 * @return java.awt.Panel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Panel getPanel1() {
	java.awt.GridBagConstraints constraintsCommSettingsPanel1 = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsstartButton = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsTextField1 = new java.awt.GridBagConstraints();
	if (ivjPanel1 == null) {
		try {
			ivjPanel1 = new java.awt.Panel();
			ivjPanel1.setName("Panel1");
			ivjPanel1.setLayout(new java.awt.GridBagLayout());
			ivjPanel1.setBackground(java.awt.Color.lightGray);

			constraintsCommSettingsPanel1.gridx = 0; constraintsCommSettingsPanel1.gridy = 3;
			constraintsCommSettingsPanel1.gridwidth = 1; constraintsCommSettingsPanel1.gridheight = 1;
			constraintsCommSettingsPanel1.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsCommSettingsPanel1.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsCommSettingsPanel1.weightx = 0.8;
			constraintsCommSettingsPanel1.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getCommSettingsPanel1(), constraintsCommSettingsPanel1);
			getPanel1().add(getCommSettingsPanel1());

			constraintsstartButton.gridx = 1; constraintsstartButton.gridy = 3;
			constraintsstartButton.gridwidth = 1; constraintsstartButton.gridheight = 1;
			constraintsstartButton.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsstartButton.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsstartButton.weightx = 0.2;
			constraintsstartButton.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getstartButton(), constraintsstartButton);
			getPanel1().add(getstartButton());

			constraintsTextField1.gridx = 0; constraintsTextField1.gridy = 0;
			constraintsTextField1.gridwidth = 0; constraintsTextField1.gridheight = 1;
			constraintsTextField1.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsTextField1.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsTextField1.weightx = 0.0;
			constraintsTextField1.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getTextField1(), constraintsTextField1);
			getPanel1().add(getTextField1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjPanel1;
}

/**
 * Return the startButton property value.
 * @return java.awt.Button
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Button getstartButton() {
	if (ivjstartButton == null) {
		try {
			ivjstartButton = new java.awt.Button();
			ivjstartButton.setName("startButton");
			ivjstartButton.setLabel("Initialize Port");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjstartButton;
}

/**
 * Return the TerminalUIMenuBar property value.
 * @return java.awt.MenuBar
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuBar getTerminalUIMenuBar() {
	if (ivjTerminalUIMenuBar == null) {
		try {
			ivjTerminalUIMenuBar = new java.awt.MenuBar();
			ivjTerminalUIMenuBar.add(getMenu1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjTerminalUIMenuBar;
}

/**
 * Return the terminalViewer property value.
 * @return java.awt.TextArea
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.TextArea getterminalViewer() {
	if (ivjterminalViewer == null) {
		try {
			ivjterminalViewer = new java.awt.TextArea();
			ivjterminalViewer.setName("terminalViewer");
			ivjterminalViewer.setText("Not Connected.");
			ivjterminalViewer.setBackground(java.awt.Color.black);
			ivjterminalViewer.setForeground(java.awt.Color.green);
			ivjterminalViewer.setEditable(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjterminalViewer;
}

/**
 * Return the TextField1 property value.
 * @return java.awt.TextField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.TextField getTextField1() {
	if (ivjTextField1 == null) {
		try {
			ivjTextField1 = new java.awt.TextField();
			ivjTextField1.setName("TextField1");
			ivjTextField1.setBackground(java.awt.Color.white);
			ivjTextField1.setForeground(new java.awt.Color(0, 0, 93));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjTextField1;
}

/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	// System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	// exception.printStackTrace(System.out);
}

/**
 * Initializes connections
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() {
	// user code begin {1}
	// user code end
	this.addWindowListener(this);
	getMenuItem3().addActionListener(this);
	getMenuItem4().addActionListener(this);
	getTextField1().addActionListener(this);
	getstartButton().addActionListener(this);
	getMenuItem1().addActionListener(this);
	getCheckboxMenuItem1().addItemListener(this);
}

/**
 * Initialize class
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	// user code begin {1}
	// user code end
	setName("TerminalUI");
	setName("TerminalUI");
	setMenuBar(getTerminalUIMenuBar());
	setLayout(new java.awt.BorderLayout());
	setSize(626, 420);
	setTitle("Simple Java Terminal - By Brad Barclay");
	this.add("South", getPanel1());
	this.add("Center", getterminalViewer());
	initConnections();
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the ItemListener interface.
 * @param e java.awt.event.ItemEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void itemStateChanged(java.awt.event.ItemEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == getCheckboxMenuItem1()) ) {
		conn8(e);
	}
	// user code begin {2}
	// user code end
}

/**
 * Main Entrypoint - starts the TerminalUI when it is run as an application.
 * @param args This application requires no arguments.
 */
public static void main(java.lang.String[] args) {
	try {
		org.jSyncManager.JSerial.TestSuite.TerminalUI aTerminalUI = new org.jSyncManager.JSerial.TestSuite.TerminalUI();
		try {
			Class aCloserClass = Class.forName("uvm.abt.edit.WindowCloser");
			Class parmTypes[] = { java.awt.Window.class };
			Object parms[] = { aTerminalUI };
			java.lang.reflect.Constructor aCtor = aCloserClass.getConstructor(parmTypes);
			aCtor.newInstance(parms);
		} catch (java.lang.Throwable exc) {};
		aTerminalUI.setVisible(true);
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of java.awt.Frame");
	}
}

/**
 * This method was created by a SmartGuide.
 * @param msg java.lang.String
 */
private void sendString(String msg) {
	if (connectFlag) {
		try {
			os.writeBytes(msg+"\r");
		} catch (java.io.IOException e) {
			getterminalViewer().append("*** Unable to write string to buffer.\n");
		}
		if (getLocalEcho()) {
			getterminalViewer().append(msg+"\n");	
		}	
	} else {
		getterminalViewer().append("*** Port is not open.\n");
	}	
}
/**
 * This method was created by a SmartGuide.
 * @param b boolean
 */
private void setLocalEcho(boolean b) {
	localEcho=b;
}
/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowActivated(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowClosed(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowClosing(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == this) ) {
		conn0(e);
	}
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowDeactivated(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowDeiconified(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowIconified(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowOpened(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * This method was created by a SmartGuide.
 */
protected void writeChar(char c) {
	getterminalViewer().append(""+c);
}
}