// --------------------------------------------------------------------------
// The jSyncManager Project -- Source File.
// Copyright (c) 1998 - 2003 Brad BARCLAY <bbarclay@jsyncmanager.org>
// --------------------------------------------------------------------------
// OSI Certified Open Source Software
// --------------------------------------------------------------------------
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published 
// by the Free Software Foundation; either version 2.1 of the License, or 
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public 
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
// --------------------------------------------------------------------------
// $Id: PortTestUI.java,v 1.2 2003/11/20 17:50:58 yaztromo Exp $
// --------------------------------------------------------------------------

package org.jSyncManager.JSerial.TestSuite;

/**
 * This class represents the Port Tester Utility.
 * This application is a small utility to test that a given Serial Port can be initialized correctly.
 * It performs a variety of tests to make certain that the native handler performs
 * correctly.  This test requires a local loopback connector.  Please see the TestSuite documentation
 * for local loopback connector schematics.
 * @author Brad Barclay
 * @version 1.0
 */
public class PortTestUI extends java.awt.Frame implements java.awt.event.ActionListener, java.awt.event.WindowListener {
	private AboutBox ivjAboutBox1 = null;
	private CommSettingsPanel ivjCommSettingsPanel1 = null;
	private java.awt.Checkbox ivjdatabitsFail = null;
	private java.awt.Checkbox ivjdatabitsPass = null;
	private java.awt.Checkbox ivjinitFail = null;
	private java.awt.Checkbox ivjinitPass = null;
	private java.awt.Label ivjLabel1 = null;
	private java.awt.Label ivjLabel2 = null;
	private java.awt.Label ivjLabel3 = null;
	private java.awt.Label ivjLabel4 = null;
	private java.awt.Label ivjLabel5 = null;
	private java.awt.Label ivjLabel6 = null;
	private java.awt.Label ivjLabel7 = null;
	private java.awt.Label ivjLabel8 = null;
	private java.awt.Label ivjLabel9 = null;
	private java.awt.Menu ivjMenu1 = null;
	private java.awt.MenuItem ivjMenuItem1 = null;
	private java.awt.MenuItem ivjMenuItem2 = null;
	private java.awt.MenuItem ivjMenuItem3 = null;
	private java.awt.Panel ivjPanel1 = null;
	private java.awt.Panel ivjPanel2 = null;
	private java.awt.Checkbox ivjparityFail = null;
	private java.awt.Checkbox ivjparityPass = null;
	private java.awt.MenuBar ivjPortTestUIMenuBar = null;
	private java.awt.Checkbox ivjspeedFail = null;
	private java.awt.Checkbox ivjspeedPass = null;
	private java.awt.Checkbox ivjsrFail = null;
	private java.awt.Checkbox ivjsrPass = null;
	private java.awt.Button ivjstartButton = null;
	private java.awt.Checkbox ivjstopbitsFail = null;
	private java.awt.Checkbox ivjstopbitsPass = null;
	public org.jSyncManager.JSerial.SerialInterface serial = null;

/**
 * A constructor to create a new instance of the Port Tester.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public PortTestUI() {
	super();
	initialize();
}

/**
 * Method to handle events for the ActionListener interface.
 * @param e java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void actionPerformed(java.awt.event.ActionEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == getMenuItem3()) ) {
		conn1(e);
	}
	if ((e.getSource() == getMenuItem1()) ) {
		conn2(e);
	}
	if ((e.getSource() == getstartButton()) ) {
		conn3(e);
	}
	if ((e.getSource() == getstartButton()) ) {
		conn4(e);
	}
	if ((e.getSource() == getstartButton()) ) {
		conn5(e);
	}
	// user code begin {2}
	// user code end
}

/**
 * conn0:  (PortTestUI.window.windowClosing(java.awt.event.WindowEvent) --> PortTestUI.dispose())
 * @param arg1 java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn0(java.awt.event.WindowEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.dispose();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn1:  (MenuItem3.action.actionPerformed(java.awt.event.ActionEvent) --> AboutBox1.show())
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn1(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getAboutBox1().show();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn2:  (MenuItem1.action.actionPerformed(java.awt.event.ActionEvent) --> PortTestUI.dispose())
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn2(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.dispose();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn3:  (startButton.action.actionPerformed(java.awt.event.ActionEvent) --> CommSettingsPanel1.enabled)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn3(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getCommSettingsPanel1().setEnabled(false);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn4:  (startButton.action.actionPerformed(java.awt.event.ActionEvent) --> startButton.enabled)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn4(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getstartButton().setEnabled(false);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn5:  (startButton.action.actionPerformed(java.awt.event.ActionEvent) --> PortTestUI.startPressed()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn5(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.startPressed();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * Return the AboutBox1 property value.
 * @return AboutBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private AboutBox getAboutBox1() {
	if (ivjAboutBox1 == null) {
		try {
			ivjAboutBox1 = new org.jSyncManager.JSerial.TestSuite.AboutBox(this);
			ivjAboutBox1.setName("AboutBox1");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjAboutBox1;
}

/**
 * Return the CommSettingsPanel1 property value.
 * @return CommSettingsPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private CommSettingsPanel getCommSettingsPanel1() {
	if (ivjCommSettingsPanel1 == null) {
		try {
			ivjCommSettingsPanel1 = new org.jSyncManager.JSerial.TestSuite.CommSettingsPanel();
			ivjCommSettingsPanel1.setName("CommSettingsPanel1");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjCommSettingsPanel1;
}

/**
 * Return the databitsFail property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getdatabitsFail() {
	if (ivjdatabitsFail == null) {
		try {
			ivjdatabitsFail = new java.awt.Checkbox();
			ivjdatabitsFail.setName("databitsFail");
			ivjdatabitsFail.setBounds(345, 142, 26, 30);
			ivjdatabitsFail.setEnabled(false);
			ivjdatabitsFail.setLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjdatabitsFail;
}

/**
 * Return the databitsPass property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getdatabitsPass() {
	if (ivjdatabitsPass == null) {
		try {
			ivjdatabitsPass = new java.awt.Checkbox();
			ivjdatabitsPass.setName("databitsPass");
			ivjdatabitsPass.setBounds(269, 142, 26, 30);
			ivjdatabitsPass.setEnabled(false);
			ivjdatabitsPass.setLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjdatabitsPass;
}

/**
 * Return the initFail property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getinitFail() {
	if (ivjinitFail == null) {
		try {
			ivjinitFail = new java.awt.Checkbox();
			ivjinitFail.setName("initFail");
			ivjinitFail.setBounds(345, 37, 26, 30);
			ivjinitFail.setEnabled(false);
			ivjinitFail.setLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjinitFail;
}

/**
 * Return the initPass property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getinitPass() {
	if (ivjinitPass == null) {
		try {
			ivjinitPass = new java.awt.Checkbox();
			ivjinitPass.setName("initPass");
			ivjinitPass.setBounds(269, 38, 26, 28);
			ivjinitPass.setEnabled(false);
			ivjinitPass.setLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjinitPass;
}

/**
 * Return the Label1 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel1() {
	if (ivjLabel1 == null) {
		try {
			ivjLabel1 = new java.awt.Label();
			ivjLabel1.setName("Label1");
			ivjLabel1.setAlignment(java.awt.Label.CENTER);
			ivjLabel1.setFont(new java.awt.Font("Dialog", 1, 12));
			ivjLabel1.setText("Test");
			ivjLabel1.setBounds(19, 5, 43, 27);
			ivjLabel1.setForeground(new java.awt.Color(0, 0, 117));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel1;
}

/**
 * Return the Label2 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel2() {
	if (ivjLabel2 == null) {
		try {
			ivjLabel2 = new java.awt.Label();
			ivjLabel2.setName("Label2");
			ivjLabel2.setAlignment(java.awt.Label.CENTER);
			ivjLabel2.setFont(new java.awt.Font("Dialog", 1, 12));
			ivjLabel2.setText("Pass");
			ivjLabel2.setBounds(261, 5, 43, 27);
			ivjLabel2.setForeground(new java.awt.Color(0, 0, 117));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel2;
}

/**
 * Return the Label3 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel3() {
	if (ivjLabel3 == null) {
		try {
			ivjLabel3 = new java.awt.Label();
			ivjLabel3.setName("Label3");
			ivjLabel3.setAlignment(java.awt.Label.CENTER);
			ivjLabel3.setFont(new java.awt.Font("Dialog", 1, 12));
			ivjLabel3.setText("Fail");
			ivjLabel3.setBounds(337, 5, 43, 27);
			ivjLabel3.setForeground(new java.awt.Color(0, 0, 117));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel3;
}

/**
 * Return the Label4 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel4() {
	if (ivjLabel4 == null) {
		try {
			ivjLabel4 = new java.awt.Label();
			ivjLabel4.setName("Label4");
			ivjLabel4.setText("Initialize Port");
			ivjLabel4.setBounds(18, 37, 125, 30);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel4;
}

/**
 * Return the Label5 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel5() {
	if (ivjLabel5 == null) {
		try {
			ivjLabel5 = new java.awt.Label();
			ivjLabel5.setName("Label5");
			ivjLabel5.setText("Set Speed");
			ivjLabel5.setBounds(18, 72, 125, 30);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel5;
}

/**
 * Return the Label6 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel6() {
	if (ivjLabel6 == null) {
		try {
			ivjLabel6 = new java.awt.Label();
			ivjLabel6.setName("Label6");
			ivjLabel6.setText("Set Parity");
			ivjLabel6.setBounds(20, 107, 125, 30);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel6;
}

/**
 * Return the Label7 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel7() {
	if (ivjLabel7 == null) {
		try {
			ivjLabel7 = new java.awt.Label();
			ivjLabel7.setName("Label7");
			ivjLabel7.setText("Set Stop Bits");
			ivjLabel7.setBounds(21, 177, 125, 30);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel7;
}

/**
 * Return the Label8 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel8() {
	if (ivjLabel8 == null) {
		try {
			ivjLabel8 = new java.awt.Label();
			ivjLabel8.setName("Label8");
			ivjLabel8.setText("Set Data Bits");
			ivjLabel8.setBounds(22, 142, 125, 30);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel8;
}

/**
 * Return the Label9 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel9() {
	if (ivjLabel9 == null) {
		try {
			ivjLabel9 = new java.awt.Label();
			ivjLabel9.setName("Label9");
			ivjLabel9.setText("Send/Receive Bytes");
			ivjLabel9.setBounds(20, 212, 154, 30);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel9;
}

/**
 * Return the Menu1 property value.
 * @return java.awt.Menu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Menu getMenu1() {
	if (ivjMenu1 == null) {
		try {
			ivjMenu1 = new java.awt.Menu();
			ivjMenu1.setLabel("Options");
			ivjMenu1.add(getMenuItem1());
			ivjMenu1.add(getMenuItem2());
			ivjMenu1.add(getMenuItem3());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjMenu1;
}

/**
 * Return the MenuItem1 property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getMenuItem1() {
	if (ivjMenuItem1 == null) {
		try {
			ivjMenuItem1 = new java.awt.MenuItem();
			ivjMenuItem1.setLabel("Return to Main Menu");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjMenuItem1;
}

/**
 * Return the MenuItem2 property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getMenuItem2() {
	if (ivjMenuItem2 == null) {
		try {
			ivjMenuItem2 = new java.awt.MenuItem();
			ivjMenuItem2.setLabel("-");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjMenuItem2;
}

/**
 * Return the MenuItem3 property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getMenuItem3() {
	if (ivjMenuItem3 == null) {
		try {
			ivjMenuItem3 = new java.awt.MenuItem();
			ivjMenuItem3.setLabel("About");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjMenuItem3;
}

/**
 * Return the Panel1 property value.
 * @return java.awt.Panel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Panel getPanel1() {
	java.awt.GridBagConstraints constraintsCommSettingsPanel1 = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsstartButton = new java.awt.GridBagConstraints();
	if (ivjPanel1 == null) {
		try {
			ivjPanel1 = new java.awt.Panel();
			ivjPanel1.setName("Panel1");
			ivjPanel1.setLayout(new java.awt.GridBagLayout());

			constraintsCommSettingsPanel1.gridx = -1; constraintsCommSettingsPanel1.gridy = -1;
			constraintsCommSettingsPanel1.gridwidth = 1; constraintsCommSettingsPanel1.gridheight = 1;
			constraintsCommSettingsPanel1.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsCommSettingsPanel1.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsCommSettingsPanel1.weightx = 0.8;
			constraintsCommSettingsPanel1.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getCommSettingsPanel1(), constraintsCommSettingsPanel1);
			getPanel1().add(getCommSettingsPanel1());

			constraintsstartButton.gridx = -1; constraintsstartButton.gridy = -1;
			constraintsstartButton.gridwidth = 1; constraintsstartButton.gridheight = 1;
			constraintsstartButton.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsstartButton.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsstartButton.weightx = 0.2;
			constraintsstartButton.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getstartButton(), constraintsstartButton);
			getPanel1().add(getstartButton());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjPanel1;
}

/**
 * Return the Panel2 property value.
 * @return java.awt.Panel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Panel getPanel2() {
	if (ivjPanel2 == null) {
		try {
			ivjPanel2 = new java.awt.Panel();
			ivjPanel2.setName("Panel2");
			ivjPanel2.setLayout(null);
			ivjPanel2.add(getLabel1(), getLabel1().getName());
			ivjPanel2.add(getLabel2(), getLabel2().getName());
			ivjPanel2.add(getLabel3(), getLabel3().getName());
			ivjPanel2.add(getLabel4(), getLabel4().getName());
			ivjPanel2.add(getLabel5(), getLabel5().getName());
			ivjPanel2.add(getLabel6(), getLabel6().getName());
			ivjPanel2.add(getLabel7(), getLabel7().getName());
			ivjPanel2.add(getLabel8(), getLabel8().getName());
			ivjPanel2.add(getLabel9(), getLabel9().getName());
			ivjPanel2.add(getinitPass(), getinitPass().getName());
			ivjPanel2.add(getspeedPass(), getspeedPass().getName());
			ivjPanel2.add(getparityPass(), getparityPass().getName());
			ivjPanel2.add(getdatabitsPass(), getdatabitsPass().getName());
			ivjPanel2.add(getstopbitsPass(), getstopbitsPass().getName());
			ivjPanel2.add(getsrPass(), getsrPass().getName());
			ivjPanel2.add(getinitFail(), getinitFail().getName());
			ivjPanel2.add(getspeedFail(), getspeedFail().getName());
			ivjPanel2.add(getparityFail(), getparityFail().getName());
			ivjPanel2.add(getdatabitsFail(), getdatabitsFail().getName());
			ivjPanel2.add(getstopbitsFail(), getstopbitsFail().getName());
			ivjPanel2.add(getsrFail(), getsrFail().getName());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjPanel2;
}

/**
 * Return the parityFail property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getparityFail() {
	if (ivjparityFail == null) {
		try {
			ivjparityFail = new java.awt.Checkbox();
			ivjparityFail.setName("parityFail");
			ivjparityFail.setBounds(345, 107, 26, 30);
			ivjparityFail.setEnabled(false);
			ivjparityFail.setLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjparityFail;
}

/**
 * Return the parityPass property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getparityPass() {
	if (ivjparityPass == null) {
		try {
			ivjparityPass = new java.awt.Checkbox();
			ivjparityPass.setName("parityPass");
			ivjparityPass.setBounds(269, 107, 26, 30);
			ivjparityPass.setEnabled(false);
			ivjparityPass.setLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjparityPass;
}

/**
 * Return the PortTestUIMenuBar property value.
 * @return java.awt.MenuBar
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuBar getPortTestUIMenuBar() {
	if (ivjPortTestUIMenuBar == null) {
		try {
			ivjPortTestUIMenuBar = new java.awt.MenuBar();
			ivjPortTestUIMenuBar.add(getMenu1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjPortTestUIMenuBar;
}

/**
 * Return the speedFail property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getspeedFail() {
	if (ivjspeedFail == null) {
		try {
			ivjspeedFail = new java.awt.Checkbox();
			ivjspeedFail.setName("speedFail");
			ivjspeedFail.setBounds(345, 72, 26, 30);
			ivjspeedFail.setEnabled(false);
			ivjspeedFail.setLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjspeedFail;
}

/**
 * Return the speedPass property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getspeedPass() {
	if (ivjspeedPass == null) {
		try {
			ivjspeedPass = new java.awt.Checkbox();
			ivjspeedPass.setName("speedPass");
			ivjspeedPass.setBounds(269, 72, 26, 30);
			ivjspeedPass.setEnabled(false);
			ivjspeedPass.setLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjspeedPass;
}

/**
 * Return the srFail property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getsrFail() {
	if (ivjsrFail == null) {
		try {
			ivjsrFail = new java.awt.Checkbox();
			ivjsrFail.setName("srFail");
			ivjsrFail.setBounds(345, 212, 26, 30);
			ivjsrFail.setEnabled(false);
			ivjsrFail.setLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjsrFail;
}

/**
 * Return the srPass property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getsrPass() {
	if (ivjsrPass == null) {
		try {
			ivjsrPass = new java.awt.Checkbox();
			ivjsrPass.setName("srPass");
			ivjsrPass.setBounds(269, 212, 26, 30);
			ivjsrPass.setEnabled(false);
			ivjsrPass.setLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjsrPass;
}

/**
 * Return the startButton property value.
 * @return java.awt.Button
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Button getstartButton() {
	if (ivjstartButton == null) {
		try {
			ivjstartButton = new java.awt.Button();
			ivjstartButton.setName("startButton");
			ivjstartButton.setLabel("Start Test");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjstartButton;
}

/**
 * Return the stopbitsFail property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getstopbitsFail() {
	if (ivjstopbitsFail == null) {
		try {
			ivjstopbitsFail = new java.awt.Checkbox();
			ivjstopbitsFail.setName("stopbitsFail");
			ivjstopbitsFail.setBounds(345, 177, 26, 30);
			ivjstopbitsFail.setEnabled(false);
			ivjstopbitsFail.setLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjstopbitsFail;
}

/**
 * Return the stopbitsPass property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getstopbitsPass() {
	if (ivjstopbitsPass == null) {
		try {
			ivjstopbitsPass = new java.awt.Checkbox();
			ivjstopbitsPass.setName("stopbitsPass");
			ivjstopbitsPass.setBounds(269, 177, 26, 30);
			ivjstopbitsPass.setEnabled(false);
			ivjstopbitsPass.setLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjstopbitsPass;
}

/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	// System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	// exception.printStackTrace(System.out);
}

/**
 * Initializes connections
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() {
	// user code begin {1}
	// user code end
	this.addWindowListener(this);
	getMenuItem3().addActionListener(this);
	getMenuItem1().addActionListener(this);
	getstartButton().addActionListener(this);
}

/**
 * Initialize class
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	// user code begin {1}
	// user code end
	setName("PortTestUI");
	setName("PortTestUI");
	setMenuBar(getPortTestUIMenuBar());
	setLayout(new java.awt.BorderLayout());
	setBackground(java.awt.Color.lightGray);
	setSize(434, 319);
	setTitle("Port Test UI - Written by Brad Barclay");
	this.add("South", getPanel1());
	this.add("Center", getPanel2());
	initConnections();
	// user code begin {2}
	// user code end
}

/**
 * Main Entrypoint - starts the Port Tester when it is run as an application.
 * @param args This application requires no arguments.
 */
public static void main(java.lang.String[] args) {
	try {
		org.jSyncManager.JSerial.TestSuite.PortTestUI aPortTestUI = new org.jSyncManager.JSerial.TestSuite.PortTestUI();
		try {
			Class aCloserClass = Class.forName("uvm.abt.edit.WindowCloser");
			Class parmTypes[] = { java.awt.Window.class };
			Object parms[] = { aPortTestUI };
			java.lang.reflect.Constructor aCtor = aCloserClass.getConstructor(parmTypes);
			aCtor.newInstance(parms);
		} catch (java.lang.Throwable exc) {};
		aPortTestUI.setVisible(true);
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of java.awt.Frame");
	}
}

/**
 * This method was created by a SmartGuide.
 */
private void startPressed() {
	// This method is called when the user presses the "Start" button

	java.io.DataInputStream is= null;	
	int temp=0, port=0, speed=0, i=0;
	
	// Start by clearing all of the CheckBoxes:
	
	getdatabitsFail().setEnabled(false);
	getdatabitsPass().setEnabled(false);
	getinitFail().setEnabled(false);
	getinitPass().setEnabled(false);
	getparityFail().setEnabled(false);
	getparityPass().setEnabled(false);
	getspeedFail().setEnabled(false);
	getspeedPass().setEnabled(false);
	getsrFail().setEnabled(false);
	getsrPass().setEnabled(false);
	getstopbitsFail().setEnabled(false);
	getstopbitsPass().setEnabled(false);
	
	port=getCommSettingsPanel1().getPortSelect().getSelectedIndex();
	try {
		speed=Integer.parseInt(getCommSettingsPanel1().getSpeedSelect().getSelectedItem());
	} catch (Exception e) {
		System.out.println("*** Error parsing speed value");
		return;
	}
	
	try {
		serial=new org.jSyncManager.JSerial.SerialInterface((byte)port, speed);	
	} catch (org.jSyncManager.JSerial.SerialInitializationException e1) {
		// Exception thrown because we're unable to initialize the specified port
		getinitFail().setState(true);
		getstartButton().setEnabled(true);
		getCommSettingsPanel1().setEnabled(true);
		return;
	} catch(org.jSyncManager.JSerial.SerialSpeedException e2) {
		getinitFail().setState(true);
		getspeedFail().setState(true);
		getstartButton().setEnabled(true);
		getCommSettingsPanel1().setEnabled(true);
		return;
	} catch (org.jSyncManager.JSerial.SerialDataBitException e3) {
		getinitFail().setState(true);
		getdatabitsFail().setState(true);
		getstartButton().setEnabled(true);
		getCommSettingsPanel1().setEnabled(true);
		return;
	} catch (org.jSyncManager.JSerial.SerialParityException e4) {
		getinitFail().setState(true);
		getparityFail().setState(true);
		getstartButton().setEnabled(true);
		getCommSettingsPanel1().setEnabled(true);
		return;
	} catch (org.jSyncManager.JSerial.SerialStopBitException e5) {
		getinitFail().setState(true);
		getstopbitsFail().setState(true);
		getstartButton().setEnabled(true);
		getCommSettingsPanel1().setEnabled(true);
		return;
	} catch (org.jSyncManager.JSerial.SerialGrabException e6) {
		getinitFail().setState(true);
		getstartButton().setEnabled(true);
		getCommSettingsPanel1().setEnabled(true);
		return;
	}
	
	// If we made it here, then the port has passed all of the above tests.
	// (Assuming that the underlying native handler isn't lying by withholding exceptions)
	
	getdatabitsPass().setState(true);
	getinitPass().setState(true);
	getparityPass().setState(true);
	getspeedPass().setState(true);
	getstopbitsPass().setState(true);
	
	is=new java.io.DataInputStream(serial.getInputStream());
	
	try {
		serial.setRTSCTS(true);
	} catch (org.jSyncManager.JSerial.SerialHandshakingException e9) {
		// Unable to setup handshaking mode
		getinitPass().setEnabled(false);
		getinitFail().setEnabled(true);
		getstartButton().setEnabled(true);
		getCommSettingsPanel1().setEnabled(true);
		return;
	}	
	
	// Next we'll attempt the write/read test
	// We'll simply send the bits between 0 and 255 inclusive,
	// And then check to see if they've arrived in the input buffer
	
	for (i=0;i<256;i++) {
		try {
			serial.getOutputStream().write(i);
		} catch (java.io.IOException e7) {
			// If the byte can't be sent, then this test has failed.
			getsrFail().setState(true);
			getstartButton().setEnabled(true);
			getCommSettingsPanel1().setEnabled(true);			
			return;
		}
	}

	for(i=0;i<256;i++) {
		try {
			temp=is.readByte();
			if (temp!=(byte)i) {
				getsrFail().setState(true);
				getstartButton().setEnabled(true);
				getCommSettingsPanel1().setEnabled(true);				
				return;
			}
		} catch (java.io.IOException e8) {
			getsrFail().setState(true);
			getstartButton().setEnabled(true);
			getCommSettingsPanel1().setEnabled(true);			
			return;
		}
	}	
			
	getsrPass().setState(true);			
	getstartButton().setEnabled(true);
	getCommSettingsPanel1().setEnabled(true);
	
	try {
		serial.getInputStream().close();
		serial.getOutputStream().close();
		serial.releasePort();
	} catch (Exception e)	{
		System.out.println("*** Unable to release port!");
	}	
	serial=null;					  
}
/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowActivated(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowClosed(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowClosing(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == this) ) {
		conn0(e);
	}
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowDeactivated(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowDeiconified(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowIconified(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowOpened(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

}