/*
 * @(#)MetalScrollBarUI.java 1.20 98/05/28
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.swing.plaf.mac;

import java.awt.*;
import java.awt.event.*;

import java.beans.*;

import javax.swing.*;
import javax.swing.event.*;

import javax.swing.plaf.*;
import javax.swing.plaf.basic.BasicScrollBarUI;


/**
 * Implementation of ScrollBarUI for the Mac Look and Feel
 * <p>
 *
 * @version 1.20 05/28/98
 * @author Tom Santos
 */
public class MacScrollBarUI extends BasicScrollBarUI {
    private static Color pressedThumbLightHighlightColor; 
    private static Color pressedThumbHighlightColor;
    private static Color pressedThumbLightShadowColor;
    private static Color pressedThumbDarkShadowColor;
    private static Color pressedThumbColor;

    private static Color thumbLightHighlightColor; 
/*  Inherited data members
    protected Color thumbHighlightColor;
    protected Color thumbLightShadowColor;
    protected Color thumbDarkShadowColor;
    protected Color thumbColor;
    protected Color trackColor;
    protected Color trackHighlightColor;
*/
    private static Color trackLightHighlightColor;
    private static Color trackShadowColor;
    private static Color trackDarkShadowColor;

    protected MacScrollButton increaseButton;
    protected MacScrollButton decreaseButton;

    protected int thumbLength;
    protected int scrollBarWidth;

    MouseListener thumbListener;
    boolean thumbPressed = false;

    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    protected boolean isFreeStanding = true;

    public static ComponentUI createUI( JComponent c )
    {
        return new MacScrollBarUI();
    }

    protected void installDefaults() {
        scrollBarWidth = ((Integer)(UIManager.get( "ScrollBar.width" ))).intValue();
        thumbLength = scrollBarWidth + 3;  // to take into account the black border
        super.installDefaults();
        if ( scrollbar.getBackground() == null || scrollbar.getBackground() instanceof UIResource )
            scrollbar.setBackground(UIManager.getColor("ScrollBar.background"));
    }

    protected void installListeners(){
        super.installListeners();
//      ((ScrollBarListener)propertyChangeListener).handlePropertyChange( scrollbar.getClientProperty( FREE_STANDING_PROP ) );

        if ( (thumbListener = createThumbListener()) != null ) {
            scrollbar.addMouseListener( thumbListener );
        }
    }   

    protected void uninstallListeners() {
        super.uninstallListeners();
        if ( thumbListener != null ) {
            scrollbar.removeMouseListener( thumbListener );
        }
    }

    protected MouseListener createThumbListener() {
        return new ThumbListener();
    }
/*   protected PropertyChangeListener createPropertyChangeListener(){
        return new ScrollBarListener();    
    }
*/
    protected void configureScrollBarColors()
    {
        thumbLightHighlightColor = UIManager.getColor("ScrollBar.thumbLightHighlight"); 
        thumbHighlightColor      = UIManager.getColor("ScrollBar.thumbHighlight");
        thumbLightShadowColor    = UIManager.getColor("ScrollBar.thumbShadow");
        thumbDarkShadowColor     = UIManager.getColor("ScrollBar.thumbDarkShadow");
        thumbColor               = UIManager.getColor("ScrollBar.thumb");

        pressedThumbLightHighlightColor = UIManager.getColor("ScrollBar.pressedThumbLightHighlight"); 
        pressedThumbHighlightColor      = UIManager.getColor("ScrollBar.pressedThumbHighlight");
        pressedThumbLightShadowColor    = UIManager.getColor("ScrollBar.pressedThumbShadow");
        pressedThumbDarkShadowColor     = UIManager.getColor("ScrollBar.pressedThumbDarkShadow");
        pressedThumbColor               = UIManager.getColor("ScrollBar.pressedThumb");

        trackColor               = UIManager.getColor("ScrollBar.track");
        trackHighlightColor      = UIManager.getColor("ScrollBar.trackHighlight");
        trackLightHighlightColor = UIManager.getColor("ScrollBar.trackLightHighlight");
        trackShadowColor         = UIManager.getColor("ScrollBar.trackShadow");
        trackDarkShadowColor     = UIManager.getColor("ScrollBar.trackDarkShadow");
    } 

    public Dimension getPreferredSize( JComponent c )
    {
        Insets insets = scrollbar.getInsets();
        if ( scrollbar.getOrientation() == JScrollBar.VERTICAL ) {
            return new Dimension( scrollBarWidth + insets.left + insets.right,
                                  scrollBarWidth * 3 + 10 );
        }
        else {  // Horizontal
            return new Dimension( scrollBarWidth * 3 + 10,
                                  scrollBarWidth  + insets.top + insets.bottom );
        }
    }

    /** Returns the view that represents the decrease view. 
      */
    protected JButton createDecreaseButton( int orientation )
    {
        decreaseButton = new MacScrollButton( orientation, scrollBarWidth );
        return decreaseButton;
    }

    /** Returns the view that represents the increase view. */
    protected JButton createIncreaseButton( int orientation )
    {
        increaseButton =  new MacScrollButton( orientation, scrollBarWidth );
        return increaseButton;
    }

    protected void paintTrack( Graphics g, JComponent c, Rectangle trackBounds )
    {
        if ( !scrollbar.isEnabled() ) {
            g.setColor( MacLookAndFeel.getGray0() );
            g.fillRect( trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height );
            return;
        }

        int orientation = scrollbar.getOrientation();
        int width = trackBounds.width;
        int height = trackBounds.height;
        Rectangle thumbBounds = getThumbBounds();
        int thumbBottom = (thumbBounds.y + thumbBounds.height - 1) - trackBounds.y;
        int thumbRight = (thumbBounds.x + thumbBounds.width - 1) - trackBounds.x;

        g.translate( trackBounds.x, trackBounds.y );

        g.setColor( trackColor );
        g.fillRect( 0, 0, width, height );

        if ( orientation == JScrollBar.VERTICAL ) {
            g.setColor( MacLookAndFeel.getBlack() );
            g.drawLine( 0, 0, width - 1, 0 );
            g.drawLine( 0, height - 1, width - 1, height - 1 );

            g.setColor( trackLightHighlightColor );
            g.drawLine( width - 1, 1, width - 1, height - 2 );

            g.setColor( trackHighlightColor );
            g.drawLine( width - 2, 2, width - 2, height - 2 );

            g.setColor( trackShadowColor );
            g.drawLine( 1, 2, width - 3, 2 );
            g.drawLine( 1, 2, 1, height - 2 );
            g.drawLine( 1, thumbBottom + 2, width - 3, thumbBottom + 2 );

            g.setColor( trackDarkShadowColor);
            g.drawLine( 0, 1, width - 2, 1 );
            g.drawLine( 0, 1, 0, height - 2 );
            g.drawLine( 0, thumbBottom + 1, width - 2, thumbBottom + 1 );
        }
        else {
            g.setColor( MacLookAndFeel.getBlack() );
            g.drawLine( 0, 0, 0, height - 1 );
            g.drawLine( width - 1, 0, width - 1, height - 1 );

            g.setColor( trackLightHighlightColor );
            g.drawLine( 1, height - 1, width - 2, height - 1 );

            g.setColor( trackHighlightColor );
            g.drawLine( 2, height - 2, width - 2, height - 2 );

            g.setColor( trackShadowColor );
            g.drawLine( 2, 1, width - 2, 1 );
            g.drawLine( 2, 1, 2, height - 3 );
            g.drawLine( thumbRight + 2, 1, thumbRight + 2, height - 3 );

            g.setColor( trackDarkShadowColor);
            g.drawLine( 1, 0, 1, height - 2 );
            g.drawLine( 1, 0, width - 2, 0 );
            g.drawLine( thumbRight + 1, 0, thumbRight + 1, height - 2 );
        }

/*
        g.setColor( trackShadowColor );
        g.drawLine( 1, 1, 1, height - 3 );
        g.drawLine( 1, 1, width - 3, 1 );
        if ( orientation == JScrollBar.VERTICAL ) {
           g.drawLine( 1, thumbBottom + 1, width - 2, thumbBottom + 1 );
        }
        else {
           g.drawLine( thumbRight + 2, 1, thumbRight + 2, height - 2 );
        }
*/
        g.translate( -trackBounds.x, -trackBounds.y );
    }

    protected void paintThumb( Graphics g, JComponent c, Rectangle thumbBounds )
    {
        if ( scrollbar.isEnabled() ) {
            int orientation = scrollbar.getOrientation();
            int width = orientation == JScrollBar.VERTICAL ? thumbBounds.width : thumbBounds.width  - 2;
            int height = orientation == JScrollBar.VERTICAL ? thumbBounds.height - 2 : thumbBounds.height;

            if ( orientation == JScrollBar.VERTICAL ) {
                g.translate( thumbBounds.x, thumbBounds.y + 1 );
            }
            else {
                g.translate( thumbBounds.x + 1, thumbBounds.y );
            }

            g.setColor( thumbPressed ? pressedThumbColor : thumbColor );
            g.fillRect( 0, 0, width, height );

            g.setColor( thumbPressed ? pressedThumbHighlightColor : thumbHighlightColor );
            g.drawLine( 1, 0, width - 2, 0 );
            g.drawLine( 0, 1, 0, height - 2 );

            g.setColor( thumbPressed ? pressedThumbLightShadowColor : thumbLightShadowColor );
            g.drawLine( 1, height - 1, width - 1, height - 1 );
            g.drawLine( width - 1, 1, width - 1, height - 1 );

            g.setColor( thumbPressed ? pressedThumbLightHighlightColor : thumbLightHighlightColor );
            g.drawLine( 0, 0, 0, 0 );

            if ( orientation == JScrollBar.VERTICAL ) {
                // Groove dots
                g.drawLine( 3, 3, 3, 3 );
                g.drawLine( 3, 5, 3, 5 );
                g.drawLine( 3, 7, 3, 7 );
                g.drawLine( 3, 9, 3, 9 );

                // Groove highlights
                g.setColor( thumbPressed ? pressedThumbHighlightColor : thumbHighlightColor );
                g.drawLine( 4, 3, 9, 3 );
                g.drawLine( 4, 5, 9, 5 );
                g.drawLine( 4, 7, 9, 7 );
                g.drawLine( 4, 9, 9, 9 );

                // Groove shadows
                g.setColor( thumbPressed ? pressedThumbDarkShadowColor : thumbDarkShadowColor );
                g.drawLine( 4, 4, 10, 4 );
                g.drawLine( 4, 6, 10, 6 );
                g.drawLine( 4, 8, 10, 8 );
                g.drawLine( 4, 10, 10, 10 );

                g.setColor( MacLookAndFeel.getBlack() );
                g.drawLine( 0, -1, width - 1, -1 );
                g.drawLine( 0, height, width - 1, height );
            }
            else {  // HORIZONTAL
                // Groove dots
                g.drawLine( 3, 3, 3, 3 );
                g.drawLine( 5, 3, 5, 3 );
                g.drawLine( 7, 3, 7, 3 );
                g.drawLine( 9, 3, 9, 3 );

                // Groove highlights
                g.setColor( thumbPressed ? pressedThumbHighlightColor : thumbHighlightColor );
                g.drawLine( 3, 4, 3, 9 );
                g.drawLine( 5, 4, 5, 9 );
                g.drawLine( 7, 4, 7, 9 );
                g.drawLine( 9, 4, 9, 9 );

                // Groove shadows
                g.setColor( thumbPressed ? pressedThumbDarkShadowColor : thumbDarkShadowColor );
                g.drawLine( 4, 4, 4, 10 );
                g.drawLine( 6, 4, 6, 10 );
                g.drawLine( 8, 4, 8, 10 );
                g.drawLine( 10 , 4, 10, 10 );

                g.setColor( MacLookAndFeel.getBlack() );
                g.drawLine( -1, 0, -1, height - 1 );
                g.drawLine( width, 0, width, height - 1 );
            }
            if ( orientation == JScrollBar.VERTICAL ) {
                g.translate( -thumbBounds.x, -(thumbBounds.y + 1) );
            }
            else {
                g.translate( -(thumbBounds.x + 1), -thumbBounds.y );
            }
        }
    }

    /**
      * This is overridden only to increase the invalid area.  This
      * ensures that the "Shadow" below the thumb is invalidated
      */
    protected void setThumbBounds(int x, int y, int width, int height)
    {
        /* If the thumbs bounds haven't changed, we're done.
         */
        if ( (thumbRect.x == x) && 
             (thumbRect.y == y) && 
             (thumbRect.width == width) && 
             (thumbRect.height == height) ) {
            return;
        }

        /* Update thumbRect, and repaint the union of x,y,w,h and 
         * the old thumbRect.
         */
        int minX = Math.min(x, thumbRect.x);
        int minY = Math.min(y, thumbRect.y);
        int maxX = Math.max(x + width, thumbRect.x + thumbRect.width);
        int maxY = Math.max(y + height, thumbRect.y + thumbRect.height);

        thumbRect.setBounds(x, y, width, height);
        scrollbar.repaint(minX, minY, (maxX - minX)+3, (maxY - minY)+3);
    }

    protected Dimension getMaximumThumbSize()
    {
        if ( scrollbar.getOrientation() == JScrollBar.VERTICAL ) {
            return new Dimension( scrollBarWidth, thumbLength );
        }
        else {
            return new Dimension( thumbLength, scrollBarWidth );
        }
    }       

    protected Dimension getMinimumThumbSize()
    {
        return getMaximumThumbSize();
    }       

/*
    class ScrollBarListener extends BasicScrollBarUI.PropertyChangeHandler {
        public void propertyChange(PropertyChangeEvent e)
        {
            String name = e.getPropertyName();
            if ( name.equals( FREE_STANDING_PROP ) ) {
                handlePropertyChange( e.getNewValue() );
            }
            else {
                super.propertyChange( e );
            }
        }

        public void handlePropertyChange( Object newValue )
        {
            if ( newValue != null ) {
                isFreeStanding = ((Boolean)newValue).booleanValue();
            }
            else {

                if ( !isFreeStanding ) {
                    isFreeStanding = true;
                }
            }
        }
    } // end class ScrollBarListener
*/
    class ThumbListener extends MouseAdapter {
        public void mousePressed( MouseEvent e ) {
            if ( macGetThumbBounds().contains( e.getX(), e.getY() ) ) {
                thumbPressed = true;
                macGetScrollBar().repaint();
            }
        }

        public void mouseReleased( MouseEvent e ) {
            thumbPressed = false;
            macGetScrollBar().repaint();
        }
    }

    Rectangle macGetThumbBounds() {
        return getThumbBounds();
    }
    JScrollBar macGetScrollBar() {
        return scrollbar;
    }
}

      
