/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class MetalThemeMenu
extends JMenu
implements ActionListener {
    MetalTheme[] themes;

    public MetalThemeMenu(String string, MetalTheme[] metalThemeArray) {
        super(string);
        this.themes = metalThemeArray;
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < this.themes.length) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.themes[n].getName());
            buttonGroup.add(jRadioButtonMenuItem);
            this.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setActionCommand(String.valueOf(n));
            jRadioButtonMenuItem.addActionListener(this);
            if (n == 0) {
                jRadioButtonMenuItem.setSelected(true);
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        MetalTheme metalTheme = this.themes[Integer.parseInt(string)];
        MetalLookAndFeel.setCurrentTheme(metalTheme);
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            return;
        }
        catch (Exception exception) {
            System.out.println("Failed loading Metal");
            System.out.println(exception);
            return;
        }
    }
}

