/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.plaf.mac.MacLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class MacSliderUI
extends BasicSliderUI {
    protected boolean filledSlider = false;
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static int trackWidth;
    protected int majorTickLength;
    protected int minorTickLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;
    MouseListener thumbPressedListener;
    boolean thumbPressed = false;
    protected final String SLIDER_FILL = "JSlider.isFilled";

    public MacSliderUI() {
        super(null);
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return new MetalPropertyListener();
    }

    protected MouseListener createThumbPressedListener() {
        return new ThumbListener();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MacSliderUI();
    }

    protected int getThumbOverhang() {
        return 6;
    }

    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = vertThumbIcon.getIconWidth();
            dimension.height = vertThumbIcon.getIconHeight();
        } else {
            dimension.width = horizThumbIcon.getIconWidth();
            dimension.height = horizThumbIcon.getIconHeight();
        }
        return dimension;
    }

    public int getTickLength() {
        int n = 4;
        int n2 = 0;
        int n3 = this.slider.getMajorTickSpacing();
        int n4 = this.slider.getMinorTickSpacing();
        if (this.slider.getPaintTicks() && (n3 != 0 || n4 != 0)) {
            n2 += n3 != 0 ? this.majorTickLength : this.minorTickLength;
        }
        if (this.slider.getPaintLabels()) {
            n2 += 4;
        }
        return n2;
    }

    protected int getTrackLength() {
        if (this.slider.getOrientation() == 0) {
            return this.trackRect.width;
        }
        return this.trackRect.height;
    }

    protected int getTrackWidth() {
        return 7;
    }

    protected void installListeners(JSlider jSlider) {
        super.installListeners(jSlider);
        this.thumbPressedListener = this.createThumbPressedListener();
        if (this.thumbPressedListener != null) {
            jSlider.addMouseListener(this.thumbPressedListener);
        }
    }

    public void installUI(JComponent jComponent) {
        trackWidth = (Integer)UIManager.get("Slider.trackWidth");
        this.majorTickLength = (Integer)UIManager.get("Slider.majorTickLength");
        this.minorTickLength = (Integer)UIManager.get("Slider.minorTickLength");
        horizThumbIcon = UIManager.getIcon("Slider.horizontalThumbIcon");
        vertThumbIcon = UIManager.getIcon("Slider.verticalThumbIcon");
        super.installUI(jComponent);
        thumbColor = UIManager.getColor("Slider.thumb");
        highlightColor = UIManager.getColor("Slider.highlight");
        darkShadowColor = UIManager.getColor("Slider.darkShadow");
        this.scrollListener.setScrollByBlock(false);
        Object object = jComponent.getClientProperty("JSlider.isFilled");
        if (object != null) {
            this.filledSlider = (Boolean)object;
        }
    }

    JSlider macGetSlider() {
        return this.slider;
    }

    Rectangle macGetThumbBounds() {
        return this.thumbRect;
    }

    public void paintFocus(Graphics graphics) {
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        this.paintTickForHorizSlider(graphics, n, this.majorTickLength);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        this.paintTickForVertSlider(graphics, n, this.majorTickLength);
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        this.paintTickForHorizSlider(graphics, n, this.minorTickLength);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        this.paintTickForVertSlider(graphics, n, this.minorTickLength);
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        graphics.translate(rectangle.x, rectangle.y);
        if (this.slider.getOrientation() == 0) {
            horizThumbIcon.paintIcon(this.slider, graphics, 0, 0);
        } else {
            vertThumbIcon.paintIcon(this.slider, graphics, 0, 0);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected void paintTickForHorizSlider(Graphics graphics, int n, int n2) {
        graphics.translate(n, 0);
        graphics.setColor(MacLookAndFeel.getWhite());
        graphics.drawLine(-1, 0, 0, 0);
        graphics.drawLine(-1, 0, -1, n2 - 2);
        graphics.setColor(this.slider.isEnabled() ? MacLookAndFeel.getBlack() : MacLookAndFeel.getGray5());
        graphics.drawLine(0, 1, 0, n2 - 2);
        graphics.setColor(this.slider.isEnabled() ? MacLookAndFeel.getGray4() : MacLookAndFeel.getGray2());
        graphics.drawLine(1, 1, 1, n2 - 1);
        graphics.drawLine(0, n2 - 1, 1, n2 - 1);
        graphics.translate(-n, 0);
    }

    protected void paintTickForVertSlider(Graphics graphics, int n, int n2) {
        graphics.translate(0, n);
        graphics.setColor(MacLookAndFeel.getWhite());
        graphics.drawLine(0, -1, 0, 0);
        graphics.drawLine(0, -1, n2 - 2, -1);
        graphics.setColor(this.slider.isEnabled() ? MacLookAndFeel.getBlack() : MacLookAndFeel.getGray5());
        graphics.drawLine(1, 0, n2 - 2, 0);
        graphics.setColor(this.slider.isEnabled() ? MacLookAndFeel.getGray4() : MacLookAndFeel.getGray2());
        graphics.drawLine(1, 1, n2 - 1, 1);
        graphics.drawLine(n2 - 1, 0, n2 - 1, 1);
        graphics.translate(0, -n);
    }

    public void paintTrack(Graphics graphics) {
        ColorUIResource colorUIResource = MacLookAndFeel.getGray4();
        ColorUIResource colorUIResource2 = MacLookAndFeel.getGray11();
        ColorUIResource colorUIResource3 = MacLookAndFeel.getWhite();
        graphics.translate(this.trackRect.x, this.trackRect.y);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.slider.getOrientation() == 0) {
            n4 = this.trackRect.height - 1 - this.getThumbOverhang();
            n2 = n4 - (this.getTrackWidth() - 1);
            n3 = this.trackRect.width - 1;
            graphics.setColor(colorUIResource3);
            graphics.drawLine(n + 1, n4 - 1, n + 1, n4 - 1);
            graphics.drawLine(n + 2, n4, n3 - 2, n4);
            graphics.drawLine(n3 - 1, n2 + 1, n3 - 1, n4);
            graphics.drawLine(n3, n2 + 2, n3, n4 - 1);
            graphics.setColor(this.slider.isEnabled() ? colorUIResource : MacLookAndFeel.getGray2());
            graphics.fillRect(n + 1, n2, this.getTrackLength() - 3, this.getTrackWidth() - 2);
            graphics.drawLine(n, n2 + 1, n, n4 - 2);
            graphics.setColor(colorUIResource2);
            graphics.drawLine(n + 2, n2 + 1, n3 - 2, n2 + 1);
            graphics.drawLine(n + 2, n4 - 1, n3 - 2, n4 - 1);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n4 - 2);
            graphics.drawLine(n3 - 1, n2 + 2, n3 - 1, n4 - 2);
        } else {
            n = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
            n3 = this.trackRect.width - this.getThumbOverhang() - 1;
            n4 = this.trackRect.height - 1;
            graphics.setColor(colorUIResource3);
            graphics.drawLine(n + 1, n4 - 1, n + 1, n4 - 1);
            graphics.drawLine(n + 2, n4, n3 - 2, n4);
            graphics.drawLine(n3 - 1, n2 + 1, n3 - 1, n4);
            graphics.drawLine(n3, n2 + 2, n3, n4 - 1);
            graphics.setColor(this.slider.isEnabled() ? colorUIResource : MacLookAndFeel.getGray2());
            graphics.fillRect(n + 1, n2, this.getTrackWidth() - 2, this.getTrackLength() - 2);
            graphics.drawLine(n, n2 + 1, n, n4 - 2);
            graphics.setColor(colorUIResource2);
            graphics.drawLine(n + 2, n2 + 1, n3 - 2, n2 + 1);
            graphics.drawLine(n + 2, n4 - 1, n3 - 2, n4 - 1);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n4 - 2);
            graphics.drawLine(n3 - 1, n2 + 2, n3 - 1, n4 - 2);
        }
        graphics.translate(-this.trackRect.x, -this.trackRect.y);
    }

    protected void uninstallListeners(JSlider jSlider) {
        if (this.thumbPressedListener != null) {
            jSlider.removeMouseListener(this.thumbPressedListener);
            this.thumbPressedListener = null;
        }
        super.uninstallListeners(jSlider);
    }

    protected class MetalPropertyListener
    extends BasicSliderUI.PropertyChangeHandler {
        protected MetalPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("JSlider.isFilled")) {
                MacSliderUI.this.filledSlider = propertyChangeEvent.getNewValue() != null ? (Boolean)propertyChangeEvent.getNewValue() : false;
            }
        }
    }

    class ThumbListener
    extends MouseAdapter {
        ThumbListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (MacSliderUI.this.macGetThumbBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
                MacSliderUI.this.thumbPressed = true;
                MacSliderUI.this.macGetSlider().repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MacSliderUI.this.thumbPressed = false;
            MacSliderUI.this.macGetSlider().repaint();
        }
    }
}

