﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
	 Creation date: 2004-12-06
	 Author: Gleam
	 Main style sheet it genetrates the page structure and call renderers.
	 v1.6.0: add animation feature
	 -->
	<xsl:import href="thumbnailRenderer.xsl"/>
	<xsl:import href="mainImageRenderer.xsl"/>
	<xsl:import href="navigationBarRenderer.xsl"/>
	<xsl:import href="builtWithRenderer.xsl"/>
	<xsl:import href="properties.xsl"/>
	<xsl:import href="util.xsl"/>
	<xsl:import href="googleMaps.xsl"/>
	<!-- -->
	<xsl:output method="xml" version="1.1" indent="yes" doctype-public="-//W3C//DTD XHTML 1.1//EN"  doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"/>
	<!-- -->
	<xsl:param name="encoding">UTF-8</xsl:param>
	<xsl:param name="contentFile"/>
	<xsl:param name="currentImage">index</xsl:param> <!-- name of the current image or index for the local index and animation -->
	<xsl:param name="imageWidth">500</xsl:param>
	<xsl:param name="imageHeight">550</xsl:param>
	<xsl:param name="web">web</xsl:param>            <!-- mode web of file to build links -->
	<xsl:param name="localIndex">false</xsl:param>   <!-- indicates if a local index exists to build navigation bar : false, default, personal, standard, google maps -->
	<xsl:param name="googleMapsKey"/>                <!-- google key in case of a local index build with google maps -->
	<xsl:param name="pathToRoot">none</xsl:param>    <!-- relative path to the root -->
	<xsl:param name="skinPath">/skins/xissweb</xsl:param>
	<xsl:param name="builtwith">none</xsl:param>
	<xsl:param name="builtwith-icon-path">skins/images</xsl:param>
	<xsl:param name="builtwith-icon-type">normal</xsl:param>
	<xsl:param name="date"/>
	<xsl:param name="lang"/>
	<xsl:param name="copyright-years"/>
	<xsl:param name="copyright-organization"/>
	<!--
	 -->
	<xsl:variable name="contentDoc" select="document($contentFile)"/>
	<!--
	 -->
	<xsl:template match="/">
		<!--xsl:message>Images count = <xsl:value-of select="count($contentDoc//image)"/></xsl:message-->
		<xsl:apply-templates select="slideshow-layout" mode="DOCUMENT"/>
	</xsl:template>
	<!--
	  -->
	<xsl:template match="slideshow-layout" mode="DOCUMENT">
		<html xml:lang="{$lang}">
			<xsl:apply-templates select="." mode="HEAD"/>
			<xsl:apply-templates select="." mode="BODY"/>
		</html>
	</xsl:template>
	<!--
	  -->
	<xsl:template match="slideshow-layout" mode="HEAD">
		<head>
			<xsl:comment>Generated by Xiss web 1.6, (c) 2004-2010 Xiss web</xsl:comment>
			<title>
			   <xsl:choose>
					<xsl:when test="$contentDoc/slideshow-content/info/@theme != ''">
						<xsl:value-of select="$contentDoc/slideshow-content/info/@theme"/>
					</xsl:when>
					<xsl:when test="$contentDoc/slideshow-content/info/@title != ''">
						<xsl:value-of select="$contentDoc/slideshow-content/info/@title"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$contentDoc/slideshow-content/@name"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="$currentImage != 'index'"> : <xsl:value-of select="$currentImage"/></xsl:if>
			</title>
			<meta>
				<xsl:attribute name="http-equiv">content-type</xsl:attribute>
				<xsl:attribute name="content"><xsl:value-of select="concat('text/html; charset=', $encoding)"/></xsl:attribute>
			</meta>
			<meta content="Xiss web" name="generator"/>
			<meta content="{$date}" name="date"/>
		    <meta name="description">
		      <xsl:attribute name="content">
			   <xsl:choose>
					<xsl:when test="$contentDoc/slideshow-content/info/@theme != ''">
						<xsl:value-of select="$contentDoc/slideshow-content/info/@theme"/>
					</xsl:when>
					<xsl:when test="$contentDoc/slideshow-content/info/@title != ''">
						<xsl:value-of select="$contentDoc/slideshow-content/info/@title"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$contentDoc/slideshow-content/@name"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="$contentDoc/slideshow-content/info/@theme and $contentDoc/slideshow-content/info/@title != ''">
						, <xsl:value-of select="$contentDoc/slideshow-content/info/@title"/>
					</xsl:when>
					<xsl:when test="$contentDoc/slideshow-content/info/@description != ''">, <xsl:value-of select="$contentDoc/slideshow-content/info/@description"/></xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="$currentImage = 'index'">, index</xsl:when>
					<xsl:otherwise>, <xsl:value-of select="$contentDoc//image[@filename = $currentImage]/@comment"/></xsl:otherwise>
				</xsl:choose>
	    		</xsl:attribute>
			</meta>
			<link href="{concat($skinPath, '/page.css')}" rel="stylesheet" media="screen" type="text/css"/>
			<link href="{concat($skinPath, '/layout.css')}" rel="stylesheet" media="screen" type="text/css"/>
			<link href="{concat($skinPath, '/component.css')}" rel="stylesheet" media="screen" type="text/css"/>
			<xsl:choose>
				<xsl:when test="$currentImage = 'index'">
					<xsl:apply-templates select="//image-area/local-index-google-maps" mode="HEAD"/>
					<xsl:if test="animation">
						<xsl:apply-templates select="//image-area/image-location-on-map" mode="HEAD">
							<xsl:with-param name="animation" select="animation/@transition"/>
						</xsl:apply-templates>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise> <!-- image on map if the current image has localization data or if animation -->
					<xsl:if test="$contentDoc//image[@filename = $currentImage]/meta-data/@latitude">
						<xsl:apply-templates select="//image-area/image-location-on-map" mode="HEAD"/>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="animation" mode="HEAD"/>
			<!-- script for initialization if needed like $(document).ready(function(){... -->
			<xsl:if test="$currentImage = 'index' and (animation or //image-area/local-index-google-maps)">
<script type="text/javascript">
$(document).ready(function() {
	<xsl:apply-templates select="//image-area/local-index-google-maps" mode="ON-LOAD">
		<xsl:with-param name="animation" select="animation/@transition"/>
	</xsl:apply-templates>
	<xsl:if test="animation">XWloadAndInitSlideShow('<xsl:value-of select="$localIndex"/>');</xsl:if>
});
</script>
			</xsl:if>
			<xsl:if test="not(animation) and $contentDoc//image[@filename = $currentImage]/meta-data/@latitude">
<script type="text/javascript">
$(document).ready(function() {
	<xsl:apply-templates select="//image-area/image-location-on-map" mode="ON-LOAD"/>;
});
</script>
			</xsl:if>
		</head>
	</xsl:template>
	<!--
	  -->
	<xsl:template match="animation" mode="HEAD">
		<!-- if one google map feature is used then the jquery.js script is already generated -->
		<xsl:if test="not(//image-area/local-index-google-maps) and (not(//image-area/image-location-on-map) or not($contentDoc//image[@filename = $currentImage]/meta-data/@latitude))">
			<script src="{concat($pathToRoot, '/js/jquery.js')}" type="text/javascript"><xsl:comment>empty</xsl:comment></script>
		</xsl:if>
		<script src="{concat($pathToRoot, '/js/slideshow.js')}" type="text/javascript"><xsl:comment>empty</xsl:comment></script>
	</xsl:template>
	<!--
	  -->
	<xsl:template match="slideshow-layout" mode="BODY">
		<!--xsl:message>BODY</xsl:message-->
		<body>
			<!--xsl:choose>
				<xsl:when test="$currentImage = 'index' and //image-area/local-index-google-maps">
					<xsl:attribute name="onload"><xsl:apply-templates select="//image-area/local-index-google-maps" mode="ON-LOAD"/></xsl:attribute>
					<xsl:attribute name="onunload">GUnload()</xsl:attribute>
				</xsl:when>
				<xsl:when test="$currentImage != 'index' and //image-area/image-location-on-map and $contentDoc//image[@filename = $currentImage]/meta-data/@latitude">
					<xsl:attribute name="onload"><xsl:apply-templates select="//image-area/image-location-on-map" mode="ON-LOAD"/></xsl:attribute>
					<xsl:attribute name="onunload">GUnload()</xsl:attribute>
				</xsl:when				
				<xsl:when test="$currentImage = 'index' and /slideshow-layout/animation">
					<xsl:attribute name="onload">XWinitSlideshow('<xsl:value-of select="$localIndex"/>')</xsl:attribute>
				</xsl:when>
			</xsl:choose-->
			<xsl:variable name="marginNum" select="count(*[name() = 'left-margin' or name='right-margin'])"/>
			<xsl:variable name="pageWidth">
				<xsl:call-template name="width-height-value-px">
					<xsl:with-param name="value" select="@page-width"/>
				</xsl:call-template>
			</xsl:variable>
			<!-- top level structure of the html page -->
			<div style="width: {$pageWidth};" id="page">
				<div id="content">
			   <xsl:apply-templates select="header"/>
					<xsl:apply-templates select="left-margin"/>
					<xsl:choose>
						<xsl:when test="$marginNum = 0">
							<!-- if no margin direct arrangement in content div -->
							<xsl:apply-templates select="arrangement">
								<xsl:with-param name="thumbnailsCount" select="count(.//thumbnails)"/>
							</xsl:apply-templates>
						</xsl:when>
						<xsl:otherwise>
							<!-- margin arrangement in another div to preserve an horizonal flow with margin -->
							<div id="content-with-margin">
								<xsl:apply-templates select="arrangement">
									<xsl:with-param name="thumbnailsCount" select="count(.//thumbnails)"/>
								</xsl:apply-templates>
							</div>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:apply-templates select="right-margin"/>
				<xsl:apply-templates select="footer"/>
				<xsl:if test="not(footer)"> <!-- if no footer generate a default footer -->
				   <div id="footer">
				   	<xsl:call-template name="built-with">
				   		<xsl:with-param name="builtwith" select="$builtwith"/>
				   		<xsl:with-param name="builtwith-icon-path" select="$builtwith-icon-path"/>
				   		<xsl:with-param name="builtwith-icon-type" select="$builtwith-icon-type"/>
				   		<xsl:with-param name="page" select="$currentImage"/>
				   	</xsl:call-template>
				   </div>
				</xsl:if>
				</div>
			</div>
		</body>
		<!--xsl:message>END BODY</xsl:message-->
	</xsl:template>
	<!--
	 
	 Template for the generation of the page decoration elements : header, left and right margin and footer.
	 -->
	<xsl:template match="header | left-margin | right-margin | footer">
		<div id="{name()}">
			<xsl:apply-templates select="*" mode="COPY"/>
		</div>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="title" mode="COPY">
		<xsl:choose>
			<xsl:when test="$contentDoc/slideshow-content/info/@title != ''">
				<xsl:value-of select="$contentDoc/slideshow-content/info/@title"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contentDoc/slideshow-content/@name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="description" mode="COPY">
		<xsl:choose>
			<xsl:when test="$contentDoc/slideshow-content/info/@description != ''">
				<xsl:apply-templates select="$contentDoc/slideshow-content/info/@description"/>
			</xsl:when>
			<xsl:when test="$contentDoc/slideshow-content/info/htmlDescription">
				<xsl:apply-templates select="$contentDoc/slideshow-content/info/htmlDescription"/>
			</xsl:when>
			<xsl:when test="$contentDoc/slideshow-content/info/@title != ''">
				<xsl:value-of select="$contentDoc/slideshow-content/info/@title"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contentDoc/slideshow-content/@name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="link-to-home" mode="COPY">
		<xsl:variable name="text">
			<xsl:choose>
				<xsl:when test="@text"><xsl:value-of select="@text"/></xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="properties">
						<xsl:with-param name="lang" select="$lang"/>
						<xsl:with-param name="key">link.home.text</xsl:with-param>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="title">
		   <xsl:choose>
		   	<xsl:when test="@title"><xsl:value-of select="@title"/></xsl:when>
		   	<xsl:otherwise>...<xsl:call-template name="properties">
								<xsl:with-param name="lang" select="$lang"/>
								<xsl:with-param name="key">link.home.title</xsl:with-param>
							</xsl:call-template></xsl:otherwise>
		   </xsl:choose>
		</xsl:variable>
		<xsl:variable name="href">
			<xsl:choose>
				<xsl:when test="$web = 'web'"><xsl:value-of select="$pathToRoot"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="concat($pathToRoot,'/index.html')"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<a href="{$href}" class="home" title="{$title}">
			<span><xsl:value-of select="$text"/></span>
		</a>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="copyright" mode="COPY">
	   <div class="copyright">Copyright &#169; <xsl:value-of select="$copyright-years"/>&#160;<xsl:value-of select="$copyright-organization"/></div>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="built-with" mode="COPY">
		<!--xsl:variable name="icon">
			<xsl:choose>
				<xsl:when test="@type"><xsl:value-of select="@type"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$builtwith-icon-type"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable-->
		<!--xsl:message>built-with built-with built-with</xsl:message-->
		<xsl:variable name="icon-type">
			<xsl:choose>
				<xsl:when test="@type"><xsl:value-of select="@type"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$builtwith-icon-type"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
	   <xsl:call-template name="built-with-link">
	   	<xsl:with-param name="icon-path" select="$builtwith-icon-path"/>
	   	<xsl:with-param name="icon-type" select="$icon-type"/>
	   </xsl:call-template>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="@*|node()" mode="COPY">
	   <xsl:copy>
	      <xsl:apply-templates select="@*|node()" mode="COPY"/>
	   </xsl:copy>
	</xsl:template>
	<!--
	FOLLOWING ARANGEMENTs TO BUILD SLIDESHOW ELEMENTS IN PAGE 
	 -->
	<xsl:template match="arrangement">
		<xsl:param name="thumbnailsCount"/>
		<xsl:param name="thumbnailsDone">0</xsl:param>
		<xsl:variable name="localThumbnails" select="count(thumbnails)"/>
		<xsl:variable name="others" select="count(*[name() != 'thumbnails'])"/>
		<!--xsl:message>
			<xsl:value-of select="concat('arrangement ',@orientation,' : ',$thumbnailsCount,' - ',$thumbnailsDone,' (',$localThumbnails,')')"/>
		</xsl:message-->
		<xsl:variable name="orientation" select="@orientation"/>
		<xsl:variable name="width">
		   <xsl:choose>
				<xsl:when test="name() = 'arrangement'">
					<xsl:call-template name="width-height-value-px">
						<xsl:with-param name="value" select="@width"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>auto</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:for-each select="*">
			<!--xsl:message>ARANGEMENT <xsl:value-of select="$orientation"/> : <xsl:value-of select="name()"/></xsl:message-->
			<div style="{concat('width: ',$width,';')}" class="{$orientation}"> <!-- each element of the arrangement is in a div which class correspond to the arrangement orientation -->
				<xsl:choose>
					<xsl:when test="name() = 'arrangement'">
						<xsl:apply-templates select=".">
							<xsl:with-param name="thumbnailsCount" select="$thumbnailsCount"/>
							<xsl:with-param name="thumbnailsDone" select="$thumbnailsDone + $localThumbnails"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:when test="name() = 'thumbnails'">
						<xsl:apply-templates select=".">
							<xsl:with-param name="thumbnailsCount" select="$thumbnailsCount"/>
							<xsl:with-param name="number" select="$thumbnailsDone + 1 + count(preceding-sibling::thumbnails)"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</div>
		</xsl:for-each>
	</xsl:template>
	<!--
    -->
	<!-- BUG in number when the first element in arrangement isn't a c thumbnais container :
		fixed in Xiss web 1.5.0 in the template above! -->
	<xsl:template match="thumbnails">
		<xsl:param name="thumbnailsCount"/> <!-- total number of thumbnails container -->
		<xsl:param name="number"/>          <!-- current thumbnails container number -->
		<xsl:variable name="gmaps" select="//image-area/local-index-google-maps"/>
		<xsl:variable name="animation" select="/slideshow-layout/animation/@transition"/>

		<!--xsl:message>THUMBNAILS CONTAINER '<xsl:value-of select="$animation"/>' #<xsl:value-of select="$number"/></xsl:message-->
		<xsl:choose>
			<xsl:when test="../@orientation = 'vertical'">
				<xsl:apply-templates select="$contentDoc/slideshow-content/images" mode="HORIZONTAL_THUMBNAILS">
					<xsl:with-param name="containerNum" select="$thumbnailsCount"/>
					<xsl:with-param name="currentContainer" select="$number"/>
					<xsl:with-param name="range" select="number(@range)"/>
					<xsl:with-param name="width" select="@width"/>
					<xsl:with-param name="gmaps" select="$gmaps"/>
					<xsl:with-param name="animation" select="$animation"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:when test="../@orientation = 'horizontal'">
				<xsl:apply-templates select="$contentDoc/slideshow-content/images" mode="VERTICAL_THUMBNAILS">
					<xsl:with-param name="containerNum" select="$thumbnailsCount"/>
					<xsl:with-param name="currentContainer" select="$number"/>
					<xsl:with-param name="range" select="number(@range)"/>
					<xsl:with-param name="gmaps" select="$gmaps"/>
					<xsl:with-param name="animation" select="$animation"/>
				</xsl:apply-templates>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
    -->
	<xsl:template match="navigation-bar">
		<!--xsl:message>navigation-bar</xsl:message-->
		<xsl:apply-templates select="$contentDoc/slideshow-content" mode="NAVIGATION_BAR">
			<xsl:with-param name="orientation" select="../@orientation"/>
			<xsl:with-param name="navigationBar" select="."/>
			<xsl:with-param name="animation" select="/slideshow-layout/animation/@transition"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
    -->
	<xsl:template match="image-area">
		<!--xsl:message>image-area</xsl:message-->
		<xsl:variable name="iWidth">
			<xsl:call-template name="width-height-value">
				<xsl:with-param name="value" select="@width"/>
				<xsl:with-param name="default" select="$imageWidth"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="iHeight">
			<xsl:call-template name="width-height-value">
				<xsl:with-param name="value" select="@height"/>
				<xsl:with-param name="default" select="$imageHeight"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="number-format" select="comment/@number-format"/>
		<xsl:choose>
			<xsl:when test="$currentImage = 'index'">
				<xsl:apply-templates select="$contentDoc/slideshow-content/images/section[1]/image[1]" mode="MAIN_IMAGE">
					<xsl:with-param name="comment-pos" select="comment/@position"/>
					<xsl:with-param name="number-format" select="$number-format"/>
					<xsl:with-param name="mainImageWidth" select="$iWidth"/>
					<xsl:with-param name="mainImageHeight" select="$iHeight"/>
					<xsl:with-param name="imageAreaNode" select="."/>
					<xsl:with-param name="animation" select="/slideshow-layout/animation/@transition"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="$contentDoc//image[@filename = $currentImage]" mode="MAIN_IMAGE">
					<xsl:with-param name="comment-pos" select="comment/@position"/>
					<xsl:with-param name="number-format" select="$number-format"/>
					<xsl:with-param name="mainImageWidth" select="$iWidth"/>
					<xsl:with-param name="mainImageHeight" select="$iHeight"/>
					<xsl:with-param name="imageAreaNode" select="."/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
    -->
 </xsl:stylesheet>
