<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="common4css.xsl"/>
	<xsl:output method="text" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
/* Tested with Mozilla 1.7 and IE 6.0 */
/*                                    */
/*    *** GENERATED BY XISS WEB ***   */	
/*                                    */
/* CSS PAGE FILE FOR <xsl:value-of select="skin/@name"/> SKIN  */

	<xsl:apply-templates select="skin"/>
	
	</xsl:template>

	<xsl:template match="skin">	
		<xsl:apply-templates select="page"/>
		<xsl:apply-templates select="comment"/>

img {
   border: 0px none;
}

a.icon {
   text-decoration: none;
   margin: 0;
   padding: 0;
   border: 0px none;
}

a.icon:hover {
   text-decoration: none;
   border: 0px none;
}
	</xsl:template>
	<!--
	 -->
	<xsl:template match="page">
body {
  <xsl:apply-templates select="font"/>
  color: <xsl:apply-templates select="../colors/foreground"/>;
  background: <xsl:apply-templates select="../colors/body-background"/>;
  <xsl:if test="@center = 'yes'">text-align: center;</xsl:if>
}

#page {
   background: <xsl:apply-templates select="../colors/page-background"/>;
	margin: 0;
<xsl:if test="@center = 'yes'">	margin-left: auto;
	margin-right: auto;
	text-align: left;</xsl:if>
	padding: 15px;
	text-align: left;
}

		<xsl:apply-templates select="link"/>
	</xsl:template>
	
	<xsl:template match="link">
a {
 text-decoration: none;
 color: <xsl:apply-templates select="../../colors/link-foreground"/>;
 padding-left: 1px;
 padding-right: 1px;
 border-bottom: <xsl:apply-templates select="normal"/> <xsl:apply-templates select="../../colors/link-foreground"/>;
}

a:hover {
 text-decoration: none;
 color: <xsl:apply-templates select="../../colors/link-hover"/>;
 padding-left: 1px;
 padding-right: 1px;
 border-bottom: <xsl:apply-templates select="hover"/> <xsl:apply-templates select="../../colors/link-hover"/>;
}

	</xsl:template>

</xsl:stylesheet>
