﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
		Rndering the display of the main corresponding to a displayed thumbnail
		Xiss web 1.4.0 : change HTML element for comment and metadata : span to div
    -->
	<xsl:template match="image" mode="MAIN_IMAGE">
		<xsl:param name="comment-pos"/>
		<xsl:param name="number-format"/>
		<xsl:param name="mainImageWidth"/>
		<xsl:param name="mainImageHeight"/>
		<xsl:param name="imageAreaNode"/>
		<xsl:param name="animation"/>
		<!--xsl:message>Current image : <xsl:value-of select="$currentImage"/>, animation = '<xsl:value-of select="$animation"/>'</xsl:message-->
		<div id="image-container" style="{concat('width: ', $mainImageWidth, 'px; height: ', $mainImageHeight, 'px;')}">
			<xsl:choose>
				<xsl:when test="$currentImage = 'index' and $imageAreaNode/local-index-standard">
					<xsl:apply-templates select="." mode="IMAGE-INDEX-STANDARD">
						<xsl:with-param name="mainImageWidth" select="$mainImageWidth"/>
						<xsl:with-param name="mainImageHeight" select="$mainImageHeight"/>
						<xsl:with-param name="index" select="$imageAreaNode/local-index-standard"/>
						<xsl:with-param name="animation" select="$animation"/>
					</xsl:apply-templates>
				</xsl:when>
				<xsl:when test="$currentImage = 'index' and $imageAreaNode/local-index-google-maps">
					<xsl:apply-templates select="." mode="IMAGE-INDEX-GOOGLE-MAPS">
						<xsl:with-param name="mainImageWidth" select="$mainImageWidth"/>
						<xsl:with-param name="mainImageHeight" select="$mainImageHeight"/>
						<xsl:with-param name="index" select="$imageAreaNode/local-index-google-maps"/>
						<xsl:with-param name="animation" select="$animation"/>
					</xsl:apply-templates>
				</xsl:when>
				<xsl:when test="$currentImage = 'index'"><!-- default index -->
					<div id="default-index">
						<xsl:if test="$animation != ''">
							<xsl:attribute name="style">display: none;</xsl:attribute>
						</xsl:if>
						<xsl:call-template name="explanation">
							<xsl:with-param name="animation" select="$animation"/>
						</xsl:call-template>
					</div>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="." mode="DISPLAY_IMAGE">
						<xsl:with-param name="comment-pos" select="$comment-pos"/>
						<xsl:with-param name="number-format" select="$number-format"/>
						<xsl:with-param name="mainImageSize" select="$mainImageHeight"/>
						<xsl:with-param name="imageAreaNode" select="$imageAreaNode"/>
					</xsl:apply-templates>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:if test="meta-data/@latitude and $currentImage != 'index'">
				<xsl:apply-templates select="$imageAreaNode/image-location-on-map" mode="IMAGE"/>
			</xsl:if>
		</div>
	</xsl:template>
	<!--
		Adding in Xiss web 1.3.5
   -->
   <xsl:template match="image-location-on-map" mode="IMAGE">
<div id="map" style="z-index:60000; width:200px; height:100px; position:absolute; top:0; left:0; display:none; background:white;">
<xsl:comment> area for maps </xsl:comment>
</div>
<div id="map-action" style="z-index:60005; position:absolute; top:0; left:0; display:block">
<a id="open" style="cursor: pointer">
	<xsl:attribute name="title">
		<xsl:call-template name="properties">
			<xsl:with-param name="lang" select="$lang"/>
			<xsl:with-param name="key">show.hide.map</xsl:with-param>
		</xsl:call-template>
	</xsl:attribute>
	<span><xsl:call-template name="properties"><xsl:with-param name="lang" select="$lang"/><xsl:with-param name="key">map.action</xsl:with-param></xsl:call-template></span>
</a>
</div>
   </xsl:template>
 	<!--
		Explanation displayed on a local index page
		v1.4.0 : remove class="comment" the style can be defined via the 'div#standard' element
		v1.6.0 : animation feature
    -->
	<xsl:template name="explanation">
		<xsl:param name="animation"/>
		<p class="explanation">
			<xsl:call-template name="properties">
				<xsl:with-param name="lang" select="$lang"/>
				<xsl:with-param name="key">page.index.text</xsl:with-param>
			</xsl:call-template>
			<br/>
			<br/>
			<br/>
			<a>
				<xsl:choose>
					<xsl:when test="string-length($animation) = 0">
						<xsl:attribute name="href"><xsl:value-of select="concat(@filename,'.html')"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="onclick">XWgotoImage(1)</xsl:attribute>
						<xsl:attribute name="style">cursor: pointer;</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="properties">
				<xsl:with-param name="lang" select="$lang"/>
				<xsl:with-param name="key">page.index.link</xsl:with-param>
				</xsl:call-template>
			</a>
		</p>
	</xsl:template>
    <!-- 
   
    -->
	<xsl:template match="image" mode="IMAGE-INDEX-STANDARD">
		<xsl:param name="index"/>
		<xsl:param name="mainImageWidth"/>
		<xsl:param name="mainImageHeight"/>
		<xsl:param name="animation"/>
		<xsl:variable name="top" select="($mainImageHeight - $index/@height) div 2"/>
		<xsl:variable name="left" select="($mainImageWidth - $index/@width) div 2"/>
		<div id="standard-index">
			<xsl:attribute name="style">
				<xsl:choose>
					<xsl:when test="string-length($animation) = 0">
						<xsl:value-of select="concat('position:relative; width:',$index/@width,'px; height:',$index/@height, 'px; top:', $top, 'px; left:', $left, 'px')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('position:relative; display: none; width:',$index/@width,'px; height:',$index/@height, 'px; top:', $top, 'px; left:', $left, 'px')"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="$index/@description = 'true' and ../../../info/@description != ''">
					<div class="description"><p><xsl:apply-templates select="../../../info/@description"/></p></div>
				</xsl:when>
				<xsl:when test="$index/@description = 'true' and ../../../info/htmlDescription">
					<div class="description"><xsl:apply-templates select="../../../info/htmlDescription"/></div>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="$index/@explanation = 'true'">
				<xsl:call-template name="explanation">
					<xsl:with-param name="animation" select="$animation"/>
				</xsl:call-template>
			</xsl:if>
		</div>
	</xsl:template>
	<!--
	-->
	<xsl:template match="@description">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="htmlDescription">
		<xsl:apply-templates select="@*|node()" mode="COPY"/>
	</xsl:template>
	<!--
	Since Xiss web 1.3.0
	-->
	<xsl:template match="image" mode="IMAGE-INDEX-GOOGLE-MAPS">
		<xsl:param name="index"/>
		<xsl:param name="mainImageWidth"/>
		<xsl:param name="mainImageHeight"/>
		<xsl:param name="animation"/>
		<xsl:variable name="top" select="($mainImageHeight - $index/@height) div 2"/>
		<xsl:variable name="left" select="($mainImageWidth - $index/@width) div 2"/>
		<div id="map-index" style="{concat('position: relative; top:',$top,'px; left:',$left,'px; width:',$index/@width,'px; height:',$index/@height,'px;')}">
			<xsl:attribute name="style">
				<xsl:choose>
					<xsl:when test="string-length($animation) = 0">
						<xsl:value-of select="concat('position: relative; top:',$top,'px; left:',$left,'px; width:',$index/@width,'px; height:',$index/@height,'px;')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('position: relative; display: none; top:',$top,'px; left:',$left,'px; width:',$index/@width,'px; height:',$index/@height,'px;')"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<div id="map" style="{concat('width:',$index/@width,'px; height:',$index/@height,'px;')}"><xsl:comment><![CDATA[ area for maps ]]></xsl:comment></div>
		</div>
	</xsl:template>
	<!--
     -->
	<xsl:template match="image" mode="DISPLAY_IMAGE">
		<xsl:param name="comment-pos"/>
		<xsl:param name="number-format"/>
		<xsl:param name="mainImageSize"/>
		<xsl:param name="imageAreaNode"/>
		<xsl:variable name="v-padding">
			<xsl:apply-templates select="." mode="TOP"><xsl:with-param name="mainImageSize" select="$mainImageSize"/></xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="nb-images" select="count(../..//image)"/>
		<div style="{concat('padding-top: ', $v-padding, 'px;')}">
			<xsl:if test="$comment-pos = 'top'">
				<div id="image-comment" class="top-comment">
					<xsl:apply-templates select="." mode="COMMENT">
						<xsl:with-param name="number-format" select="$number-format"/>
						<xsl:with-param name="nb-images" select="$nb-images"/>
					</xsl:apply-templates>
				</div>
			</xsl:if>
		   <xsl:if test="$imageAreaNode/meta-data/@position = 'top' and meta-data">
			   <xsl:apply-templates select="." mode="META_DATA">
			      <xsl:with-param name="imageAreaNode" select="$imageAreaNode"/>
			   </xsl:apply-templates>
			</xsl:if>
			<img class="mainImage" src="{concat(../../@images, '/', @filename, '.', main-image/@extention)}" alt="{@filename}" width="{main-image/@width}" height="{main-image/@height}"/>
			<xsl:if test="$comment-pos = 'bottom'">
				<div id="image-comment" class="bottom-comment">
					<xsl:apply-templates select="." mode="COMMENT">
						<xsl:with-param name="number-format" select="$number-format"/>
						<xsl:with-param name="nb-images" select="$nb-images"/>
					</xsl:apply-templates>
				</div>
			</xsl:if>
			<xsl:if test="$imageAreaNode/meta-data/@position = 'bottom' and meta-data">
				<xsl:apply-templates select="." mode="META_DATA">
					<xsl:with-param name="imageAreaNode" select="$imageAreaNode"/>
				</xsl:apply-templates>
			</xsl:if>
		</div>
	</xsl:template>
		<!--
		Since Xiss web 1.6.0
    -->
	<xsl:template match="image" mode="COMMENT">
		<xsl:param name="number-format"/>
		<xsl:param name="nb-images"/>
		<div>
			<xsl:apply-templates select="." mode="NUMBER">
				<xsl:with-param name="number-format" select="$number-format"/>
				<xsl:with-param name="nb-images" select="$nb-images"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="@comment"/>
			<xsl:apply-templates select="htmlComment"/>
		</div>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="image" mode="TOP">
		<xsl:param name="mainImageSize"/>
		<xsl:value-of select="(($mainImageSize - main-image/@height) div 2)-20"/>
	</xsl:template>

	<!--
	Since Xiss web 1.3.6
	-->
	<xsl:template match="@comment">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="htmlComment">
		<xsl:apply-templates select="@*|node()" mode="COPY_HTML"/>
	</xsl:template>
	<!--
	Bug fix: no html coment with animations
	 -->
	<xsl:template match="@*|node()" mode="COPY_HTML">
	   <xsl:copy>
	      <xsl:apply-templates select="@*|node()" mode="COPY_HTML"/>
	   </xsl:copy>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="image" mode="NUMBER">
	 	<xsl:param name="number-format"/>
	 	<xsl:param name="nb-images"/>
	 	<span class="image-num"><xsl:value-of select="translate(translate($number-format,'@#',@number), '%+', $nb-images)"/></span>
	</xsl:template>
	<!--
		Since Xiss web 1.1.0
	 -->
	<xsl:template match="image" mode="META_DATA">
	   <xsl:param name="imageAreaNode"/>
	   <xsl:variable name="position" select="$imageAreaNode/meta-data/@position"/>
	   <!--xsl:message>      META DATA <xsl:value-of select="@number"/> <xsl:value-of select="$position"/></xsl:message-->
	   <xsl:choose>
		   <xsl:when test="meta-data[not(@type) or @type = 'digital']">
	  			<xsl:apply-templates select="meta-data">
					<xsl:with-param name="position" select="$position"/>
	  				<xsl:with-param name="metaDataNode" select="$imageAreaNode/meta-data"/>
	  			</xsl:apply-templates>  
		   </xsl:when>
		   <xsl:when test="meta-data[@type = 'argentic' or @type = 'film']">
				<xsl:choose>
					<xsl:when test="$imageAreaNode/meta-data-argentic">
						<xsl:apply-templates select="meta-data">
							<xsl:with-param name="position" select="$position"/>
							<xsl:with-param name="metaDataNode" select="$imageAreaNode/meta-data-argentic"/>
						</xsl:apply-templates>  
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="meta-data">
							<xsl:with-param name="position" select="$position"/>
							<xsl:with-param name="metaDataNode" select="$imageAreaNode/meta-data-film"/>
						</xsl:apply-templates>  
					</xsl:otherwise>
				</xsl:choose>
		   </xsl:when>
		   <xsl:when test="meta-data[@type = 'processing']">
	  			<xsl:apply-templates select="meta-data">
					<xsl:with-param name="position" select="$position"/>
	  				<xsl:with-param name="metaDataNode" select="$imageAreaNode/meta-data-processing"/>
	  			</xsl:apply-templates>  
		   </xsl:when>
		   <xsl:when test="meta-data[@type = 'unknown']">
	  			<xsl:apply-templates select="meta-data">
					<xsl:with-param name="position" select="$position"/>
	  				<xsl:with-param name="metaDataNode" select="$imageAreaNode/meta-data-unknown"/>
	  			</xsl:apply-templates>  
		   </xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="meta-data">
		<xsl:param name="position"/>
		<xsl:param name="metaDataNode"/>
		<xsl:variable name="nb-mData" select="count($metaDataNode/*)"/>
		<xsl:if test="$nb-mData > 0"><div id="metaData" class="{concat($position, '-metadata')}"><div>[
		   <xsl:apply-templates select="$metaDataNode/*">
		      <xsl:with-param name="metaDataValue" select="."/>
		      <xsl:with-param name="nb-mData" select="$nb-mData"/>
		   </xsl:apply-templates>
		   ]</div></div>
	   </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="maker">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:value-of select="$metaDataValue/@maker"/><xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="model">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:value-of select="$metaDataValue/@model"/>
	  <xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="software">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:value-of select="$metaDataValue/@software"/>
	  <xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="date-time">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:value-of select="$metaDataValue/@date"/>
	  <xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="date">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:value-of select="$metaDataValue/@date"/>
	  <xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="film">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:value-of select="$metaDataValue/@film"/>
	  <xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="shutter-speed">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:value-of select="$metaDataValue/@shutter-speed"/>
	  <xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="exposure-time">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:value-of select="$metaDataValue/@exposure-time"/>
	  <xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="aperture">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:value-of select="$metaDataValue/@aperture"/>
	  <xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="iso-equivalent">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:value-of select="$metaDataValue/@iso-equivalent"/>
	  <xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="iso">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:value-of select="$metaDataValue/@iso"/>
	  <xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="white-balance">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:value-of select="$metaDataValue/@white-balance"/>
	  <xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="focal-length">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:value-of select="$metaDataValue/@focal-length"/>
	  <xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="flash">
	  <xsl:param name="metaDataValue"/>
	  <xsl:param name="nb-mData"/>
	  <xsl:choose>
		<xsl:when test="$metaDataValue/@flash = 'yes'">
			<xsl:call-template name="properties">
				<xsl:with-param name="lang" select="$lang"/>
				<xsl:with-param name="key">yes.flash</xsl:with-param>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$metaDataValue/@flash = 'no'">
			<xsl:call-template name="properties">
				<xsl:with-param name="lang" select="$lang"/>
				<xsl:with-param name="key">no.flash</xsl:with-param>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise><xsl:value-of select="$metaDataValue/@flash"/></xsl:otherwise>
	  </xsl:choose>
	  <xsl:if test="position() &lt; $nb-mData"> - </xsl:if>
	</xsl:template>
</xsl:stylesheet>
