﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
	 -->
	<xsl:import href="builtWithRenderer.xsl"/>
	<xsl:import href="properties.xsl"/>
	<!-- -->
	<xsl:output method="xml" version="1.1" indent="yes" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"/>
	<!-- -->
	<xsl:param name="encoding">UTF-8</xsl:param>
	<xsl:param name="skinPath"/>
	<xsl:param name="builtwith">none</xsl:param>
	<xsl:param name="builtwith-icon-path">skins/images</xsl:param>
	<xsl:param name="builtwith-icon-type">normal</xsl:param>
	<xsl:param name="date"/>
	<xsl:param name="lang"/>
	<!--
	 -->
	<xsl:template match="/">
		<!--xsl:message>Indexes page : <xsl:value-of select="count(//index)"/> indexes</xsl:message-->
		<xsl:apply-templates select="indexes" mode="DOCUMENT"/>
	</xsl:template>
	<!--
	  -->
	<xsl:template match="indexes" mode="DOCUMENT">
		<!--xsl:message>param skinPath = $skinPath</xsl:message-->
		<html lang="{$lang}">
			<xsl:apply-templates select="." mode="HEAD"/>
			<xsl:apply-templates select="." mode="BODY"/>
		</html>
	</xsl:template>
	<!--
	  -->
	<xsl:template match="indexes" mode="HEAD">
		<head>
			<xsl:comment>Generated by Xiss web, (c) 2004-2005 Xiss web</xsl:comment>
			<title><xsl:call-template name="properties">
			   		<xsl:with-param name="lang" select="$lang"/>
			   		<xsl:with-param name="key">main.index.title</xsl:with-param>
			   	</xsl:call-template></title>
			<meta>
				<xsl:attribute name="http-equiv">content-type</xsl:attribute>
				<xsl:attribute name="content"><xsl:value-of select="concat('text/html; charset=', $encoding)"/></xsl:attribute>
			</meta>
			<meta name="generator" content="Xiss web"/>
			<meta name="date" content="{$date}"/>
			<link href="{concat($skinPath, '/page.css')}" rel="stylesheet" type="text/css"/>
			<link href="{concat($skinPath, '/layout.css')}" rel="stylesheet" type="text/css"/>
		</head>
	</xsl:template>
	<!--
	  -->
	<xsl:template match="indexes" mode="BODY">
		<body>
			<div id="page">
			   <div id="header">
			      <p><xsl:call-template name="properties">
			      	<xsl:with-param name="lang" select="$lang"/>
			      	<xsl:with-param name="key">link.home.text</xsl:with-param>
			      </xsl:call-template></p>
			   </div>
				<div id="content">
					<ul>
					   <xsl:apply-templates select="index"/>
					</ul>
				</div>
			   <div id="footer">
			   	<xsl:call-template name="built-with">
			   		<xsl:with-param name="builtwith" select="$builtwith"/>
			   		<xsl:with-param name="builtwith-icon-path" select="$builtwith-icon-path"/>
			   		<xsl:with-param name="builtwith-icon-type" select="$builtwith-icon-type"/>
			   	</xsl:call-template>
			   </div>
			</div>
		</body>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="index">
		<li><a href="{@path}"><xsl:value-of select="@text"/></a></li>
	</xsl:template>
	<!--
    -->
</xsl:stylesheet>
