﻿var XW_GOOGLE_MAP = null;
var XW_MAP = null;
var XW_MARKERS = new Array();

function XWMapInit(iconMarker, mapType, zControl, mControl, ovControl, current, zLevel) {
	XW_MAP = new XWMap(iconMarker, mapType, zControl, mControl, ovControl, current, zLevel);
}
function XWMapInitAndLoad(iconMarker, mapType, zControl, mControl, ovControl, current, zLevel) {
	XW_MAP = new XWMap(iconMarker, mapType, zControl, mControl, ovControl, current, zLevel);
	XW_MAP.load();
}

function XWMap(iconMarker, mapType, zControl, mControl, ovControl, current, zLevel) {
	this.iconMarker = iconMarker;
	this.mapType = mapType;
	this.zControl = zControl;
	this.mControl = mControl;
	this.ovControl = ovControl;
	this.current = current;
	this.zLevel = zLevel;
	this.load = function() {
		if (GBrowserIsCompatible()) {
			var isIcon = this.iconMarker;
			var c = this.current;
			var zoom = this.zLevel;
			$("body").attr("onunload", "XWMapUnload()");
			XW_GOOGLE_MAP = new GMap2(document.getElementById("map"));
			XW_GOOGLE_MAP.addMapType(G_PHYSICAL_MAP);
			XW_GOOGLE_MAP.setCenter(new GLatLng(0, 0), 1);
			switch (this.mapType) {
				case 0: XW_GOOGLE_MAP.setMapType(G_NORMAL_MAP);break;
				case 1: XW_GOOGLE_MAP.setMapType(G_SATELLITE_MAP);break;
				case 2: XW_GOOGLE_MAP.setMapType(G_HYBRID_MAP);break;
				case 3: XW_GOOGLE_MAP.setMapType(G_PHYSICAL_MAP);break;
			}
			if (this.zControl == 1) {
				XW_GOOGLE_MAP.addControl(new GLargeMapControl3D());
			}
			if (this.mControl == 1) {
				XW_GOOGLE_MAP.addControl(new GMapTypeControl());
			}
			if (this.ovControl == 1) {
				XW_GOOGLE_MAP.addControl(new GOverviewMapControl());
			}

			GDownloadUrl("markers.xml", function(data) {
				var xml = GXml.parse(data);
				var mkrs = xml.documentElement.getElementsByTagName("marker");

				var s = 0;
				var w = 0;
				var n = 0;
				var e = 0;
				if (mkrs.length > 0) {
					s = parseFloat(mkrs[0].getAttribute("latitude"));
					w = parseFloat(mkrs[0].getAttribute("longitude"));
					n = s;
					e = w;
				}
				var serializer = new XMLSerializer();
				for (var i = 0; i < mkrs.length; i++) {
					var num = parseInt(mkrs[i].getAttribute("number"));
					var lat = parseFloat(mkrs[i].getAttribute("latitude"));
					var lng = parseFloat(mkrs[i].getAttribute("longitude"));
					var point = new GLatLng(lat, lng);
					var comment = serializer.serializeToString(mkrs[i].getElementsByTagName("div")[0]);
					var html = "";
					if (mkrs[i].hasAttribute("link")) {
						html = "<div class='marker-info'>"+comment+" <a href="+mkrs[i].getAttribute("link")+" class='thumbnailLink'><img src="+mkrs[i].getAttribute("thumbnail")+" /></a></div></div>";
					} else {
						html = "<div class='marker-info'>"+comment+" <a onclick='"+mkrs[i].getAttribute("click")+"' class='thumbnailLink' style='cursor: pointer'><img src="+mkrs[i].getAttribute("thumbnail")+" /></a></div></div>";
					}

					var marker;
					if (isIcon == 1) {
						marker = createIconMarker(point, html, num);
					} else {
						marker = createMarker(point, html);
					}
					XW_MARKERS[num] = marker;
					XW_GOOGLE_MAP.addOverlay(marker);
					
					if (lat < s) {
						s = lat;
					}
					if (lat > n) {
						n = lat;
					}
					if (lng < w) {
						w = lng;
					}
					if (lng > e) {
						e = lng;
					}
				}
				
				if (mkrs.length > 1) {
					if (c == -1) {
						var bounds = new GLatLngBounds(new GLatLng(s, w), new GLatLng(n, e));
						zoom = XW_GOOGLE_MAP.getBoundsZoomLevel(bounds);
						XW_GOOGLE_MAP.setCenter(bounds.getCenter(), zoom);
					} else {
						//alert("position "+XW_MARKERS[current].getLatLng())
						XW_GOOGLE_MAP.setCenter(XW_MARKERS[c].getLatLng(), zoom);
						//showMarker(current);
					}
				} else {
					XW_GOOGLE_MAP.setCenter(new GLatLng(s, w), 10);
				}
				XWMapSetOnMouseOverAction(true);
			});
		}
	};
}

function XWMapUnload() {
	XWMapSetOnMouseOverAction(false);
	GUnload();
}

function XWMapSetOnMouseOverAction(value) {
	if (value) {
		$(".currentThumbnail").attr("onMouseOver", function() {
			return "showMarker(" + $(this).attr("alt") + ")"
		});
		$("a.thumbnailLink").attr("onMouseOver", function() {
			return "showMarker(" + $("img", this).attr("alt") + ")"
		});
	} else {
		$("a.thumbnailLink").removeAttr("onMouseOver");
		$(".currentThumbnail").removeAttr("onMouseOver");
	}
}

function createIconMarker(point, text, n) {
	var m = new GMarker(point, {icon:XW_ICONS[n]});
	GEvent.addListener(m, "click", function() {
		m.openInfoWindowHtml(text);
	});
	return m;
}

function createMarker(point, text) {
	var m = new GMarker(point);
	GEvent.addListener(m, "click", function() {
		m.openInfoWindowHtml(text);
	});
	return m;
}

function showMarker(i) {
	if (GBrowserIsCompatible()) {
		GEvent.trigger(XW_MARKERS[i], "click");
	}
}	
