/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.prefs.ui;

import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import org.xissweb.prefs.PreferencesManager;

public class ComponentConfigurator {
    private static PreferencesManager defaultPreferencesManager;
    public static final String PREFS_POSITION_X_KEY = "position.x";
    public static final String PREFS_POSITION_Y_KEY = "position.y";
    public static final String PREFS_SIZE_WIDTH_KEY = "size.width";
    public static final String PREFS_SIZE_HEIGHT_KEY = "size.height";
    PreferencesManager prefs;
    Component component;
    String category;

    public static void setDefaultPreferenceManager(PreferencesManager preferences) {
        defaultPreferencesManager = preferences;
    }

    public static PreferencesManager getDefaultPreferenceManager() {
        return defaultPreferencesManager;
    }

    public static void configure(Component component) {
        ComponentConfigurator.configure(defaultPreferencesManager, component, component.getClass().getName());
    }

    public static void configure(Component component, String category) {
        ComponentConfigurator.configure(defaultPreferencesManager, component, category);
    }

    public static void configure(PreferencesManager preferences, Component component) {
        ComponentConfigurator.configure(preferences, component, component.getClass().getName());
    }

    public static void configure(PreferencesManager preferences, Component component, String category) {
        new ComponentConfigurator(preferences, component, category);
    }

    private ComponentConfigurator(PreferencesManager prefs, Component component, String category) {
        this.prefs = prefs;
        this.component = component;
        this.category = category;
        this.applyPreferences();
    }

    private void applyPreferences() {
        int x = this.component.getX();
        int y = this.component.getY();
        int w = this.component.getWidth();
        int h = this.component.getHeight();
        int xp = this.prefs.getInt(PREFS_POSITION_X_KEY, this.category, x);
        int yp = this.prefs.getInt(PREFS_POSITION_Y_KEY, this.category, y);
        int wp = this.prefs.getInt(PREFS_SIZE_WIDTH_KEY, this.category, w);
        int hp = this.prefs.getInt(PREFS_SIZE_HEIGHT_KEY, this.category, h);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int i = 0; i < gs.length; ++i) {
            Rectangle rect = gs[i].getConfigurations()[0].getBounds();
            if (!rect.contains(xp, yp)) continue;
            this.component.setLocation(xp, yp);
            this.component.setSize(wp, hp);
            this.component.addComponentListener(new ConfiguratorComponentListener());
            return;
        }
        Rectangle rect = ge.getScreenDevices()[0].getConfigurations()[0].getBounds();
        this.component.setLocation(rect.x, rect.y);
        this.applySize(rect.x, rect.y, rect.width, rect.height, wp, hp);
        this.component.addComponentListener(new ConfiguratorComponentListener());
    }

    private void applySize(int x, int y, int w, int h, int wp, int hp) {
        int w0 = wp;
        int h0 = hp;
        if (x + wp > w) {
            w0 = w - x;
        }
        if (y + hp > h) {
            h0 = h - y;
        }
        this.component.setSize(w0, h0);
    }

    private class ConfiguratorComponentListener
    implements ComponentListener {
        ConfiguratorComponentListener() {
        }

        public void componentMoved(ComponentEvent e) {
            ComponentConfigurator.this.prefs.putInt(ComponentConfigurator.PREFS_POSITION_X_KEY, ComponentConfigurator.this.category, ComponentConfigurator.this.component.getX());
            ComponentConfigurator.this.prefs.putInt(ComponentConfigurator.PREFS_POSITION_Y_KEY, ComponentConfigurator.this.category, ComponentConfigurator.this.component.getY());
        }

        public void componentResized(ComponentEvent e) {
            int w = ComponentConfigurator.this.component.getWidth();
            int h = ComponentConfigurator.this.component.getHeight();
            ComponentConfigurator.this.prefs.putInt(ComponentConfigurator.PREFS_SIZE_WIDTH_KEY, ComponentConfigurator.this.category, w);
            ComponentConfigurator.this.prefs.putInt(ComponentConfigurator.PREFS_SIZE_HEIGHT_KEY, ComponentConfigurator.this.category, h);
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }
    }
}

