/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.xissweb.file.UnzipObserver;

public class SteppedUnziper {
    private File archive;
    private File destination;
    private UnzipObserver observer;
    private BufferedOutputStream dest = null;
    private BufferedInputStream is = null;
    private ZipEntry entry = null;
    private ZipFile zipfile = null;
    private Enumeration enumeration = null;
    private int entryNumber = -1;
    private int count = -1;
    private long entryPosition;
    private byte[] data = new byte[1024];
    private FileOutputStream fos;
    private Set dirs = new HashSet();

    public SteppedUnziper(File archive) throws ZipException, IOException {
        this(archive, new File(System.getProperty("user.dir")));
    }

    public SteppedUnziper(File archive, File destination) throws ZipException, IOException {
        this.archive = archive;
        this.destination = destination;
        this.zipfile = new ZipFile(archive);
        this.entryNumber = 0;
    }

    public File getArchive() {
        return this.archive;
    }

    public File getDestination() {
        return this.destination;
    }

    public UnzipObserver getObserver() {
        return this.observer;
    }

    public synchronized void setObserver(UnzipObserver observer) {
        this.observer = observer;
    }

    public int getEntryNumber() {
        return this.entryNumber;
    }

    public int getEntriesCount() {
        return this.zipfile.size();
    }

    public double archiveProgression() {
        return (double)this.entryNumber / (double)this.getEntriesCount() * 100.0;
    }

    public long getEntrySize() {
        return this.entry != null ? this.entry.getSize() : -1L;
    }

    public long getEntryPosition() {
        return this.entryPosition;
    }

    public double entryProgression() {
        if (this.entry == null || this.entryPosition == -1L) {
            return -1.0;
        }
        return (double)(this.entryPosition / this.getEntrySize()) * 100.0;
    }

    public boolean step() throws IOException {
        if (this.enumeration == null) {
            this.enumeration = this.zipfile.entries();
            if (this.enumeration.hasMoreElements()) {
                this.destination.mkdirs();
                this.entry = (ZipEntry)this.enumeration.nextElement();
                return true;
            }
            return false;
        }
        if (this.entryNumber < this.getEntriesCount()) {
            if (this.entry.isDirectory()) {
                File f = new File(this.destination, this.entry.getName());
                if (!this.dirs.contains(f)) {
                    f.mkdirs();
                    this.dirs.add(f);
                }
                ++this.entryNumber;
                this.notifyArchiveProgress();
                this.entry = this.enumeration.hasMoreElements() ? (ZipEntry)this.enumeration.nextElement() : null;
                return true;
            }
            if (this.dest == null) {
                File f = new File(this.destination, this.entry.getName());
                File parent = f.getParentFile();
                if (!this.dirs.contains(parent)) {
                    parent.mkdirs();
                    this.dirs.add(parent);
                }
                this.is = new BufferedInputStream(this.zipfile.getInputStream(this.entry));
                this.count = -1;
                this.entryPosition = 0L;
                this.fos = new FileOutputStream(f);
                this.dest = new BufferedOutputStream(this.fos);
                this.notifyEntryProgress();
                return true;
            }
            if (this.entryPosition < this.getEntrySize()) {
                this.count = this.is.read(this.data, 0, 1024);
                this.dest.write(this.data, 0, this.count);
                this.entryPosition += (long)this.count;
                this.notifyEntryProgress();
                return true;
            }
            if (this.entryPosition == this.getEntrySize()) {
                this.dest.flush();
                this.dest.close();
                this.dest = null;
                this.is.close();
                this.is = null;
                this.notifyEntryDone();
                ++this.entryNumber;
                this.notifyArchiveProgress();
                this.entry = this.enumeration.hasMoreElements() ? (ZipEntry)this.enumeration.nextElement() : null;
                return true;
            }
        } else {
            this.notifyArchiveDone();
            return false;
        }
        return false;
    }

    public synchronized void stop() throws IOException {
        if (this.entryNumber != -1 && this.entryNumber < this.getEntriesCount()) {
            this.entryNumber = this.getEntriesCount();
            this.entryPosition = -1L;
            this.closeAll();
            this.notifyInterruptionToObserver();
        }
    }

    private void closeAll() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
        if (this.dest != null) {
            this.dest.close();
        }
    }

    private void notifyInterruptionToObserver() {
        if (this.observer != null) {
            this.observer.archiveInterrupted(this);
        }
    }

    private void notifyArchiveDone() {
        if (this.observer != null) {
            this.observer.archiveDone(this);
        }
    }

    private void notifyEntryDone() {
        if (this.observer != null) {
            this.observer.entryDone(this);
        }
    }

    private void notifyArchiveProgress() {
        if (this.observer != null) {
            this.observer.archiveProgress(this);
        }
    }

    private void notifyEntryProgress() {
        if (this.observer != null) {
            this.observer.entryProgress(this);
        }
    }
}

