/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.project.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.xerces.parsers.SAXParser;
import org.xissweb.project.CategoryInfo;
import org.xissweb.project.PropertyInfo;
import org.xissweb.project.xml.PropertyInfoSchema;
import org.xissweb.xml.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PropertyInfoDeserializer
extends DefaultHandler
implements PropertyInfoSchema {
    private Hashtable propertiesInfo = null;
    private CategoryInfo rootCategory = null;
    private CategoryInfo currentCategory = null;

    public Hashtable deserialize(File file) {
        try {
            return this.deserialize(new FileInputStream(file));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return this.propertiesInfo;
        }
    }

    public Hashtable deserialize(InputStream in) {
        this.propertiesInfo = null;
        this.rootCategory = null;
        this.currentCategory = null;
        try {
            SAXParser parser = XMLHelper.getSAXPerser(this);
            parser.parse(new InputSource(in));
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this.propertiesInfo;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("category".equals(localName)) {
            CategoryInfo category = new CategoryInfo(this.currentCategory, attributes.getValue("name"));
            if (this.rootCategory == null) {
                this.propertiesInfo = new Hashtable();
                this.rootCategory = category;
            }
            this.propertiesInfo.put(category.getKey(), category);
            this.currentCategory = category;
        } else if ("property".equals(localName)) {
            this.deserializeProperty(attributes);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if ("category".equals(localName)) {
            this.currentCategory = this.currentCategory.getParent();
        }
    }

    private void deserializeProperty(Attributes attributes) {
        PropertyInfo propInfo = new PropertyInfo(attributes.getValue("name"), this.currentCategory, attributes.getValue("type"), attributes.getValue("default"), this.possibleValues(attributes.getValue("values")));
        this.propertiesInfo.put(propInfo.getKey(), propInfo);
    }

    private String[] possibleValues(String values) {
        String[] result = null;
        if (values != null && values.length() > 0) {
            StringTokenizer token = new StringTokenizer(values, ",");
            int n = token.countTokens();
            result = new String[n];
            for (int i = 0; i < n; ++i) {
                result[i] = token.nextToken();
            }
        }
        return result;
    }
}

