/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.produce.build;

import java.awt.Dimension;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xissweb.data.content.ImageDescInfo;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.data.content.xml.ContentDeserializer;
import org.xissweb.data.content.xml.ContentSerializer;
import org.xissweb.data.index.global.IndexInfo;
import org.xissweb.data.index.global.IndexesInfo;
import org.xissweb.data.index.global.xml.IndexSerializer;
import org.xissweb.data.layout.AnimationInfo;
import org.xissweb.data.layout.GoogleMapsInfo;
import org.xissweb.data.layout.LocalIndexGoogleMapsInfo;
import org.xissweb.data.layout.LocalIndexInfo;
import org.xissweb.data.layout.SkinInfo;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.data.layout.xml.LayoutBuiltWithInfo;
import org.xissweb.data.layout.xml.MinimalLayoutDeserializer;
import org.xissweb.data.skin.AnimationLoadInfo;
import org.xissweb.data.skin.xml.AnimationSkinDeserializer;
import org.xissweb.file.DirectoryObserver;
import org.xissweb.file.DirectoryVisitor;
import org.xissweb.file.FileHelper;
import org.xissweb.file.SteppedDirectoryVisitor;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.image.ImageData;
import org.xissweb.image.ImageHelper;
import org.xissweb.produce.AbstractProducer;
import org.xissweb.produce.DirectoryActionEvent;
import org.xissweb.produce.SlideShowDirectory;
import org.xissweb.produce.SlideShowFileFilter;
import org.xissweb.produce.build.BuildEventListener;
import org.xissweb.produce.build.BuildException;
import org.xissweb.produce.build.Context;
import org.xissweb.produce.depend.AllDependencies;
import org.xissweb.produce.depend.Dependencies;
import org.xissweb.project.SlideShowProject;
import org.xissweb.project.SlideShowProperties;
import org.xissweb.xml.XMLHelper;

public class Builder
extends AbstractProducer {
    private static final FileFilter copyFileFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isFile() && !SlideShowProject.isContentFile(f) && !SlideShowProject.isLayoutFile(f);
        }
    };
    private static final FileFilter htmlNonIndexFilter = new FileFilter(){

        public boolean accept(File f) {
            boolean ok = f.isFile() && !f.getName().equals("index.html") && !f.getName().equals("slideshow.html") && f.getName().endsWith("html");
            return ok;
        }
    };
    public static final int LOCAL_INDEX_NONE = 0;
    public static final int LOCAL_INDEX_DEFAULT = 1;
    public static final int LOCAL_INDEX_PERSONAL = 2;
    public static final int LOCAL_INDEX_STANDARD = 3;
    public static final int LOCAL_INDEX_GOOGLE_MAPS = 4;
    private static final String[] LOCAL_INDEX_VALUES = new String[]{Boolean.toString(false), "default", "personal", "standard", "google maps"};
    File srcRootDir;
    File buildRootDir;
    private File repositoryDir;
    private Transformer transformer;
    private Transformer markersTrf;
    private Transformer mapIconsTrf;
    private File commonSkinDir;
    private File defaultSkinDir;
    private Transformer skinPageTransformer;
    private Transformer skinCompTransformer;
    private SkinInfo defaultSkin;
    private SkinInfo currentSkin;
    private ContentDeserializer contentDeserializer = new ContentDeserializer();
    private ContentSerializer contentSerializer = new ContentSerializer();
    private File buildSkinsDir;
    private File defaultLayoutFile;
    private SlideShowLayoutInfo defaultLayout;
    private ArrayList layoutFiles;
    private ArrayList layoutInfos;
    private MinimalLayoutDeserializer layoutDeserializer = new MinimalLayoutDeserializer();
    private LayoutBuiltWithInfo layoutInfo = new LayoutBuiltWithInfo();
    private ImageHelper thumbnailCreator = new ImageHelper();
    private String builtDate;
    private SteppedDirectoryVisitor visitor = null;
    private Context context;
    private boolean inProgress = false;

    public Builder() {
        this.layoutFiles = new ArrayList();
        this.layoutInfos = new ArrayList();
        this.context = new Context();
    }

    private Transformer getTransformer() {
        if (this.transformer == null) {
            File mainTransformerFile = new File(this.commonSkinDir, "xsl" + File.separator + "slideshow2html.xsl");
            try {
                this.transformer = XMLHelper.getTransformer(mainTransformerFile);
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
        }
        return this.transformer;
    }

    private SkinInfo setDefaultSkin(SlideShowLayoutInfo layoutInfo) {
        this.defaultSkinDir = new File(this.properties.getSkinsPath(), this.properties.getSkinName());
        if (layoutInfo.getSkin() != null) {
            this.defaultSkin = layoutInfo.getSkin();
        } else {
            this.defaultSkin = new SkinInfo();
            this.defaultSkin.setSkinName(this.properties.getSkinName());
            this.defaultSkin.setPath(this.properties.getSkinsPath());
        }
        return this.defaultSkin;
    }

    public boolean build() throws BuildException {
        if (this.visitor == null) {
            this.srcRootDir = this.project.getSrcDirectory();
            if (!this.srcRootDir.exists()) {
                throw new BuildException(TextDisplayer.getString("source.no.exists", this.getClass()));
            }
            this.buildRootDir = this.project.getBuildDirectory();
            this.commonSkinDir = new File(this.properties.getCommonSkinPath());
            this.repositoryDir = this.project.getRepositoryDirectory();
            File mainTransformerFile = new File(this.commonSkinDir, "xsl" + File.separator + "slideshow2html.xsl");
            try {
                this.transformer = XMLHelper.getTransformer(mainTransformerFile);
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            this.buildSkinsDir = FileHelper.checkDirectory(this.buildRootDir, "skins");
            try {
                File dir = new File(this.commonSkinDir, "xsl" + File.separator + "simple.css");
                File f = new File(dir, "page2css.xsl");
                this.skinPageTransformer = XMLHelper.getTransformer(f);
                f = new File(dir, "component2css.xsl");
                this.skinCompTransformer = XMLHelper.getTransformer(f);
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            this.defaultLayoutFile = new File(this.project.getLocation(), "layout.xml");
            if (!this.defaultLayoutFile.exists()) {
                this.defaultLayoutFile = new File(this.properties.getDefaultLayoutDir(), "layout.xml");
            }
            this.defaultLayout = this.layoutDeserializer.deserialize(this.defaultLayoutFile);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            this.builtDate = dateFormat.format(new Date());
            this.currentSkin = this.setDefaultSkin(this.defaultLayout);
            this.copyDefaultSkin();
            this.visitor = new SteppedDirectoryVisitor(this, new SlideShowFileFilter(this.properties));
            this.inProgress = true;
            this.visitor.visitInitialization(this.srcRootDir);
        }
        this.inProgress = this.visitor.step();
        if (!this.inProgress && this.properties.hasGlobalIndex()) {
            this.generateGlobalIndexPage();
        }
        if (!this.inProgress) {
            this.visitor = null;
        }
        return this.inProgress;
    }

    private IndexesInfo collectIndexes() {
        final SlideShowProperties props = this.properties;
        final IndexesInfo indexes = new IndexesInfo();
        DirectoryVisitor visitor = new DirectoryVisitor(new DirectoryObserver(){

            public boolean inDirectory(File directory) {
                File destDir;
                if (SlideShowDirectory.isSlideshowDirectory(directory, props) && (destDir = FileHelper.fileInTargetDir(Builder.this.srcRootDir, directory, Builder.this.buildRootDir)).exists()) {
                    File index;
                    File file = index = new File(destDir, "index.html");
                    IndexInfo iInfo = new IndexInfo();
                    if (index.exists()) {
                        iInfo.setPath(FileHelper.relativeURL(Builder.this.buildRootDir, index));
                    } else {
                        File[] ff = destDir.listFiles(SlideShowDirectory.htmlFileFilter);
                        if (ff != null && ff.length > 0) {
                            file = ff[0];
                            iInfo.setPath(FileHelper.relativeURL(Builder.this.buildRootDir, file));
                        }
                    }
                    if (iInfo.getPath() != null) {
                        iInfo.setText(FileHelper.relativeURL(Builder.this.buildRootDir, file.getParentFile()).replaceAll("/", " > "));
                        iInfo.setIndex(index.exists());
                        iInfo.setFile(file);
                        indexes.addIndex(iInfo);
                    }
                }
                return false;
            }

            public boolean outDirectory(File directory) {
                return false;
            }
        }, new SlideShowFileFilter(this.properties));
        visitor.visit(this.srcRootDir);
        return indexes;
    }

    private Dependencies globalIndexDependencies(File file, IndexesInfo indexes) {
        Dependencies depend = AllDependencies.get(file);
        depend.clear();
        Iterator i = indexes.getIndexes().iterator();
        while (i.hasNext()) {
            IndexInfo iInfo = (IndexInfo)i.next();
            depend.dependsOn(iInfo.getFile());
            depend.dependsOn(this.project.getProperties().getPropertiesFile());
        }
        return depend;
    }

    private void generateGlobalIndexPage() throws BuildException {
        File pageFile = new File(this.buildRootDir, "index.html");
        IndexesInfo indexes = this.collectIndexes();
        if (this.globalIndexDependencies(pageFile, indexes).isOutOfSync()) {
            Document indexesDoc = XMLHelper.createDocument();
            IndexSerializer serializer = new IndexSerializer();
            serializer.setWeb(this.properties.getFinalLocation() == "web");
            serializer.serialize(indexes, indexesDoc);
            File indexesTransformerFile = new File(this.commonSkinDir, "xsl" + File.separator + "indexes2html.xsl");
            Transformer iTransformer = null;
            try {
                iTransformer = XMLHelper.getTransformer(indexesTransformerFile);
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            this.copySkin(this.properties.getSlideshowIndexesSkin());
            String skinRelativePath = "skins/" + this.properties.getSlideshowIndexesSkin() + '/' + "css";
            iTransformer.setParameter("skinPath", skinRelativePath);
            iTransformer.setParameter("builtwith", this.properties.getBuildWith());
            String builtWithIconPath = this.checkBuiltWithIcon(this.buildRootDir, this.properties.getBuiltWithIconName());
            iTransformer.setParameter("builtwith-icon-path", builtWithIconPath);
            iTransformer.setParameter("builtwith-icon-type", this.properties.getBuiltWithIconType());
            iTransformer.setParameter("lang", this.properties.getSlideshowLanguage());
            iTransformer.setParameter("date", this.builtDate);
            this.notifyGenerateIndexPage(this.buildRootDir, pageFile);
            DOMSource in = new DOMSource(indexesDoc);
            try {
                XMLHelper.transform(iTransformer, in, pageFile, this.properties.getSlideshowEncoding());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean doInDirectory(File directory, boolean selected) {
        boolean doInContinue = true;
        if (!this.context.isInDirectory(directory)) {
            this.context.directory = directory;
            try {
                this.checkLayoutIn(directory);
            }
            catch (BuildException e) {
                e.printStackTrace();
                this.context.clear();
                return false;
            }
            File slideshowFile = new File(directory, this.properties.getSlideshowContentFileName());
            File targetDir = FileHelper.fileInTargetDir(this.srcRootDir, directory, this.buildRootDir);
            if (slideshowFile.exists() && selected) {
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                this.context.slideShowFile = slideshowFile;
                this.context.targetDir = targetDir;
                this.context.contentInfo = this.contentDeserializer.deserialize(slideshowFile);
                this.context.kindOfLocalIndex = this.kindOfLocalIndex();
            } else {
                this.copyDirectoryContent(directory, targetDir, copyFileFilter);
                this.context.clear();
                doInContinue = false;
            }
        } else {
            try {
                doInContinue = this.generateFiles();
                if (!doInContinue) {
                    this.copyDirectoryContent(directory, this.context.targetDir, copyFileFilter);
                    this.context.clear();
                }
            }
            catch (BuildException e) {
                e.printStackTrace();
                this.context.clear();
                return false;
            }
        }
        return doInContinue;
    }

    public boolean doOutDirectory(File directory, boolean selected) {
        this.checkLayoutOut(directory);
        return false;
    }

    private void setTransformerParameters() {
        this.context.skinRelativePath = FileHelper.relativePath(this.context.targetDir, new File(this.buildRootDir, "skins" + File.separatorChar + this.currentSkin.getSkinName() + File.separatorChar + "css"));
        if (File.separatorChar != '/') {
            this.context.skinRelativePath = this.context.skinRelativePath.replace(File.separatorChar, '/');
        }
        this.context.slideShowURL = "file:///" + this.context.slideShowFile.getAbsolutePath().replace('\\', '/');
        this.context.builtWithIconPath = this.checkBuiltWithIcon(this.context.targetDir, this.context.layoutFile);
        this.transformer.clearParameters();
        this.transformer.setOutputProperty("encoding", this.properties.getSlideshowEncoding());
        this.transformer.setParameter("encoding", this.properties.getSlideshowEncoding());
        this.transformer.setParameter("contentFile", this.context.slideShowURL);
        this.transformer.setParameter("skinPath", this.context.skinRelativePath);
        this.transformer.setParameter("web", this.properties.getFinalLocation());
        this.transformer.setParameter("localIndex", LOCAL_INDEX_VALUES[this.context.kindOfLocalIndex]);
        this.transformer.setParameter("pathToRoot", FileHelper.relativeURL(this.context.targetDir, this.buildRootDir));
        this.transformer.setParameter("builtwith", this.properties.getBuildWith());
        this.transformer.setParameter("builtwith-icon-path", this.context.builtWithIconPath);
        this.transformer.setParameter("builtwith-icon-type", this.properties.getBuiltWithIconType());
        this.transformer.setParameter("lang", this.properties.getSlideshowLanguage());
        this.transformer.setParameter("date", this.builtDate);
        this.transformer.setParameter("copyright-years", this.properties.getCopyrightYears());
        this.transformer.setParameter("copyright-organization", this.properties.getCopyrightOrganization());
    }

    private boolean generateFiles() throws BuildException {
        if (!this.context.imagesAndThumbsGenerated) {
            this.context.layoutFile = this.getLayoutFile();
            this.context.imagesAndThumbsGenerated = !this.generateImagesAndThumbnails();
            return true;
        }
        if (!this.context.localIndexGenerated && !this.context.htmlPagesGenerated) {
            this.context.animation = this.getAnimation();
            this.context.layoutIn = new StreamSource(this.context.layoutFile);
            this.context.skinRelativePath = FileHelper.relativePath(this.context.targetDir, new File(this.buildRootDir, "skins" + File.separatorChar + this.currentSkin.getSkinName() + File.separatorChar + "css"));
            if (File.separatorChar != '/') {
                this.context.skinRelativePath = this.context.skinRelativePath.replace(File.separatorChar, '/');
            }
            this.setTransformerParameters();
        }
        if (this.context.hasAnimation()) {
            return this.generateAnimatedHtmlFile();
        }
        return this.generateHtmlFiles();
    }

    private boolean generateAnimatedHtmlFile() throws BuildException {
        File jsFile = new File(this.buildRootDir, "js/slideshow.js");
        if (!jsFile.exists()) {
            jsFile.getParentFile().mkdirs();
        }
        FileHelper.copyFile(new File(this.commonSkinDir, "js/slideshow.js"), jsFile, true);
        File jqFile = new File(this.buildRootDir, "js/jquery.js");
        FileHelper.copyFile(this.properties.getJQueryFile(), jqFile, true);
        if (this.hasImageLocationOnMap()) {
            this.copyNeededFilesForLocationOnMap();
            if (this.context.kindOfLocalIndex != 4) {
                this.generateMarkerFilesForMap();
            }
        }
        FileHelper.deleteFiles(this.context.targetDir, htmlNonIndexFilter);
        try {
            Transformer content4animation = XMLHelper.getTransformer(new File(this.commonSkinDir, "xsl" + File.separator + "content4animation.xsl"));
            String layout = FileHelper.pathToURL(this.context.layoutFile);
            content4animation.setParameter("currentImage", "index");
            content4animation.setParameter("lang", this.properties.getSlideshowLanguage());
            content4animation.setParameter("web", this.properties.getFinalLocation());
            content4animation.setParameter("localIndex", LOCAL_INDEX_VALUES[this.context.kindOfLocalIndex]);
            content4animation.setParameter("layout", layout);
            StreamSource source = new StreamSource(this.context.contentInfo.getFile());
            File resultFile = new File(this.context.targetDir, "images.xml");
            StreamResult result = new StreamResult(new FileOutputStream(resultFile));
            if (!this.context.targetDir.exists()) {
                this.context.targetDir.mkdirs();
            }
            content4animation.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.generateLocalIndexFile();
        this.context.localIndexGenerated = true;
        this.context.htmlPagesGenerated = true;
        return false;
    }

    private File defaultIndexFile() {
        return new File(this.context.targetDir, "index.html");
    }

    private File animaitionSlideShowIndexFile() {
        return new File(this.context.targetDir, "slideshow.html");
    }

    private void generateLocalIndexFile() {
        switch (this.context.kindOfLocalIndex) {
            case 0: {
                if (this.context.hasAnimation()) {
                    this.generateLocalIndexDefault(this.defaultIndexFile());
                    break;
                }
                this.defaultIndexFile().delete();
                break;
            }
            case 2: {
                if (!this.context.hasAnimation()) break;
                this.generateLocalIndexDefault(this.animaitionSlideShowIndexFile());
                break;
            }
            case 3: {
                this.generateLocalIndexStandard(this.defaultIndexFile());
                break;
            }
            case 4: {
                this.generateLocalIndexGoogleMaps(this.defaultIndexFile());
                break;
            }
            case 1: {
                this.generateLocalIndexDefault(this.defaultIndexFile());
            }
        }
    }

    private boolean generateHtmlFiles() throws BuildException {
        if (!this.context.localIndexGenerated) {
            this.generateLocalIndexFile();
            this.context.localIndexGenerated = true;
            this.context.imgIterator = this.context.contentInfo.imageIterator();
            return true;
        }
        if (!this.context.htmlPagesGenerated) {
            if (this.context.imgIterator.hasNext()) {
                ImageInfo iInfo = (ImageInfo)this.context.imgIterator.next();
                Dependencies depend = this.htmlPageDependencies(iInfo);
                if (depend.isOutOfSync()) {
                    this.transformer.setParameter("currentImage", iInfo.getFileName());
                    this.generateOneHTMLPage(depend.getTargetFile());
                    if (this.hasImageLocationOnMap()) {
                        this.copyNeededFilesForLocationOnMap();
                        if (4 == this.context.kindOfLocalIndex) {
                            this.generateMarkerFilesForMap();
                        }
                    }
                    this.notifyGenerateImagePage(this.context.directory, depend.getTargetFile());
                }
                return true;
            }
            this.context.htmlPagesGenerated = true;
            return false;
        }
        return true;
    }

    private Dependencies htmlPageDependencies(ImageInfo iInfo) {
        File pageFile = new File(this.context.targetDir, iInfo.getFileName() + '.' + "html");
        Dependencies depend = AllDependencies.get(pageFile);
        if (depend.isEmpty()) {
            depend.dependsOn(this.imageFileSource(iInfo));
            depend.dependsOn(this.context.layoutFile);
            depend.dependsOn(this.context.slideShowFile);
            depend.dependsOn(this.project.getProperties().getPropertiesFile());
        }
        return depend;
    }

    private void copyNeededFilesForLocationOnMap() {
        File jsFile = new File(this.buildRootDir, "js/mapBox.js");
        File dir = jsFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileHelper.copyFileToDir(this.properties.getMapBoxJSFile(), dir);
        FileHelper.copyFileToDir(this.properties.getGoogleMapsJSFile(), dir);
        FileHelper.copyFileToDir(this.properties.getJQueryFile(), dir);
    }

    private int kindOfLocalIndex() {
        int localIndex = 0;
        File index = new File(this.context.directory, "index.html");
        if (index.exists()) {
            localIndex = 2;
        } else {
            try {
                String layoutIndex = this.getLayoutInfo().getLocalIndex();
                if ("standard".equals(layoutIndex)) {
                    localIndex = 3;
                } else if ("google maps".equals(layoutIndex)) {
                    localIndex = 4;
                }
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
            if (localIndex == 0 && this.properties.hasLocalIndex()) {
                localIndex = 1;
            }
        }
        return localIndex;
    }

    private AnimationInfo getAnimation() {
        try {
            return this.getLayoutInfo().getAnimation();
        }
        catch (BuildException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean hasImageLocationOnMap() {
        try {
            return this.getLayoutInfo().getImageLocationOnMap() != null;
        }
        catch (BuildException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isThumbnailMarkerNeeded() {
        LocalIndexInfo indexInfo = null;
        GoogleMapsInfo imgOnMap = null;
        try {
            indexInfo = this.getLayoutInfo().getLocalIndexInfo();
            imgOnMap = this.getLayoutInfo().getImageLocationOnMap();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        if (indexInfo == null && imgOnMap == null) {
            return false;
        }
        if (indexInfo != null && indexInfo.getType().equals("google maps")) {
            GoogleMapsInfo gMapsInfo = ((LocalIndexGoogleMapsInfo)indexInfo).getGMapsInfo();
            return gMapsInfo.isThumbnailMarker();
        }
        if (imgOnMap != null) {
            return imgOnMap.isThumbnailMarker();
        }
        return false;
    }

    private void generateLocalIndex(File file) {
        Dependencies depend = this.localIndexDependencies(file);
        if (depend.isOutOfSync()) {
            this.transformer.setParameter("currentImage", "index");
            this.generateOneHTMLPage(file);
            this.notifyGenerateIndexPage(this.context.directory, file);
        }
    }

    private Dependencies localIndexDependencies(File file) {
        Dependencies depend = AllDependencies.get(file);
        if (depend.isEmpty()) {
            depend.dependsOn(this.context.slideShowFile);
            depend.dependsOn(this.context.layoutFile);
            depend.dependsOn(this.project.getProperties().getPropertiesFile());
        }
        return depend;
    }

    private void generateLocalIndexDefault(File file) {
        this.generateLocalIndex(file);
    }

    private void generateLocalIndexStandard(File file) {
        this.generateLocalIndex(file);
    }

    private void generateMarkerFilesForMap() {
        block9: {
            try {
                if (this.markersTrf == null) {
                    try {
                        this.markersTrf = XMLHelper.getTransformer(this.properties.getMarkersTransformerFile());
                    }
                    catch (TransformerConfigurationException e) {
                        e.printStackTrace();
                    }
                }
                File markersFile = new File(this.context.targetDir, "markers.xml");
                FileOutputStream out = new FileOutputStream(markersFile);
                this.markersTrf.setParameter("icon-marker", Boolean.toString(this.isThumbnailMarkerNeeded()));
                this.markersTrf.setParameter("thumbDir", this.properties.getThumbnailDirName());
                this.markersTrf.setParameter("animation", Boolean.toString(this.getAnimation() != null));
                this.markersTrf.transform(new StreamSource(this.context.contentInfo.getFile()), new StreamResult(out));
                out.close();
                if (!this.isThumbnailMarkerNeeded()) break block9;
                File dir = FileHelper.checkDirectory(this.context.targetDir, "markers");
                File gmapsIconsJsFile = new File(dir, "gmapsIcons.js");
                if (this.mapIconsTrf == null) {
                    try {
                        this.mapIconsTrf = XMLHelper.getTransformer(this.properties.getMapIconsTransformerFile());
                    }
                    catch (TransformerConfigurationException e) {
                        e.printStackTrace();
                    }
                }
                out = new FileOutputStream(gmapsIconsJsFile);
                this.mapIconsTrf.transform(new StreamSource(this.context.slideShowFile), new StreamResult(out));
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
    }

    private void generateLocalIndexGoogleMaps(File file) {
        File gmapsJsFile = new File(this.buildRootDir, "js/gmaps.js");
        if (!gmapsJsFile.exists()) {
            gmapsJsFile.getParentFile().mkdirs();
        }
        FileHelper.copyFile(this.properties.getGoogleMapsJSFile(), gmapsJsFile, true);
        this.generateMarkerFilesForMap();
        this.transformer.setParameter("googleMapsKey", this.properties.getValue("google.maps.key"));
        this.generateLocalIndex(file);
    }

    private File retreiveLayout(File directory) {
        File layoutFile = new File(directory, "layout.xml");
        if (!layoutFile.exists()) {
            layoutFile = directory.equals(this.project.getLocation()) ? new File(this.properties.getDefaultLayoutDir(), "layout.xml") : this.retreiveLayout(directory.getParentFile());
        }
        return layoutFile;
    }

    private SkinInfo getSkinInfo(File layoutFile) {
        SlideShowLayoutInfo layout = this.layoutDeserializer.deserialize(layoutFile);
        return this.setDefaultSkin(layout);
    }

    public boolean buildOnePage(File contentFile, ImageInfo iInfo) {
        this.properties = this.project.getProperties();
        this.buildRootDir = this.project.getBuildDirectory();
        this.commonSkinDir = new File(this.properties.getCommonSkinPath());
        this.buildSkinsDir = FileHelper.checkDirectory(this.buildRootDir, "skins");
        this.context = new Context();
        this.context.directory = contentFile.getParentFile();
        this.context.slideShowFile = contentFile;
        this.context.layoutFile = this.retreiveLayout(this.context.directory);
        SlideShowLayoutInfo layoutInfo = new MinimalLayoutDeserializer().deserialize(this.context.layoutFile);
        this.layoutInfos.add(0, layoutInfo);
        this.currentSkin = this.getSkinInfo(this.context.layoutFile);
        this.context.layoutIn = new StreamSource(this.context.layoutFile);
        this.context.targetDir = FileHelper.fileInTargetDir(this.project.getSrcDirectory(), this.context.directory, this.project.getBuildDirectory());
        this.context.thumbDir = FileHelper.checkDirectory(this.context.targetDir, this.properties.getThumbnailDirName());
        this.context.imgInfoUpdated = false;
        if (!this.context.targetDir.exists()) {
            this.context.targetDir.mkdirs();
        }
        this.context.imageDir = SlideShowDirectory.imageDirectory(this.context.directory, this.properties);
        MinimalLayoutDeserializer deserializer = new MinimalLayoutDeserializer();
        SlideShowLayoutInfo layout = deserializer.deserialize(this.context.layoutFile);
        this.context.thumbInfo = layout.getThumbnailsInfo();
        try {
            this.setDefaultSkin(layout);
            this.copyDefaultSkin();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        this.getTransformer();
        this.setTransformerParameters();
        this.transformer.setParameter("currentImage", iInfo.getFileName());
        boolean change = this.generateOneImageAndThumbnail(iInfo);
        File pageFile = new File(this.context.targetDir, iInfo.getFileName() + '.' + "html");
        this.generateOneHTMLPage(pageFile);
        this.layoutInfos.remove(0);
        this.context = null;
        return change;
    }

    private void generateOneHTMLPage(File file) {
        StreamResult result = new StreamResult(file.getAbsolutePath());
        try {
            this.transformer.transform(this.context.layoutIn, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private String checkBuiltWithIcon(File destDir, File layout) {
        String iconType = this.layoutInfo.getBuiltWithName(layout);
        if (iconType.length() == 0) {
            iconType = this.properties.getBuiltWithIconType();
        }
        String iconName = iconType.equals("normal") ? "BuiltWith.gif" : "negBuiltWith.gif";
        return this.checkBuiltWithIcon(destDir, iconName);
    }

    private String checkBuiltWithIcon(File destDir, String iconName) {
        File iconDir = FileHelper.checkDirectory(this.buildRootDir, "skins" + File.separator + "images");
        File iconFile = new File(iconDir, iconName);
        FileHelper.copyFile(new File(this.properties.getCommonImagesSkinDir(), iconName), iconFile);
        return FileHelper.relativeURL(destDir, iconDir);
    }

    private boolean generateImagesAndThumbnails() throws BuildException {
        if (this.context.imageDir == null) {
            this.context.imageDir = SlideShowDirectory.imageDirectory(this.context.directory, this.properties);
            this.context.thumbInfo = this.getLayoutInfo().getThumbnailsInfo();
            this.context.thumbDir = FileHelper.checkDirectory(this.context.targetDir, this.properties.getThumbnailDirName());
            File mkrsDir = new File(this.context.targetDir, "markers");
            if (this.isThumbnailMarkerNeeded()) {
                this.context.markersDir = mkrsDir;
                mkrsDir.mkdirs();
                FileHelper.copyFileToDir(this.properties.getMarkerHshadowImageFile(), mkrsDir);
                FileHelper.copyFileToDir(this.properties.getMarkerVshadowImageFile(), mkrsDir);
            } else {
                this.context.markersDir = null;
                if (mkrsDir.exists()) {
                    FileHelper.recursDelete(mkrsDir);
                }
            }
            this.context.imgInfoUpdated = false;
            this.context.imgIterator = this.context.contentInfo.imageIterator();
        }
        if (this.context.imgIterator.hasNext()) {
            ImageInfo iInfo = (ImageInfo)this.context.imgIterator.next();
            boolean result = this.generateOneImageAndThumbnail(iInfo);
            this.context.imgInfoUpdated = this.context.imgInfoUpdated || result;
            return true;
        }
        if (this.context.imgInfoUpdated) {
            this.notifyWritingSlideshowContent(this.context.slideShowFile.getParentFile(), this.context.slideShowFile);
            this.contentSerializer.setEncoding(this.properties.getSlideshowEncoding());
            this.contentSerializer.serialize(this.context.slideShowFile, this.context.contentInfo);
            this.notifySlideshowContentWroten(this.context.slideShowFile.getParentFile(), this.context.slideShowFile);
        }
        return false;
    }

    private File imageFileSource(ImageInfo iInfo) {
        String imageFileName = iInfo.sourceFileForBuild(this.hasImageInRepository());
        if (this.hasImageInRepository() && !this.properties.isImportImage()) {
            File repository = FileHelper.fileInTargetDir(this.srcRootDir, this.context.imageDir, this.repositoryDir).getAbsoluteFile();
            return new File(repository, imageFileName);
        }
        return new File(this.context.imageDir.getAbsolutePath(), imageFileName);
    }

    private boolean generateOneImageAndThumbnail(ImageInfo iInfo) {
        File mkrFile;
        File thumbnailFile;
        boolean imageDescChanged = false;
        String imageFileName = iInfo.mainFileName();
        File imageFile = this.imageFileSource(iInfo);
        File destFile = new File(SlideShowDirectory.createImageDirectory(this.properties, this.context.targetDir), imageFileName);
        ImageData imageData = new ImageData(imageFile);
        if (FileHelper.isOutOfSync(imageFile, destFile)) {
            if (this.hasImageInRepository() && !this.properties.isImportImage()) {
                this.resizeOrCopy(iInfo, imageData, this.context.targetDir, destFile);
            } else {
                FileHelper.copyFile(imageFile, destFile, false);
                this.notifyCopyingImage(this.context.imageDir, imageFile);
            }
            ImageInfo info = new ImageInfo(iInfo.getFileName(), -1);
            this.readImageInfo(info, imageData, this.properties.getMaxImageWidth(), this.properties.getMaxImageHeight());
            if (!info.getMainImageDesc().equals(iInfo.getMainImageDesc()) || info.getOriginalImageDesc() != null && !info.getOriginalImageDesc().equals(iInfo.getOriginalImageDesc())) {
                iInfo.setMainImageDesc(info.getMainImageDesc());
                iInfo.setOriginalImageDesc(info.getOriginalImageDesc());
                imageDescChanged = true;
            }
        }
        if (this.thumbnailDependencies(thumbnailFile = new File(this.context.thumbDir, iInfo.getFileName() + '.' + "jpeg"), imageFile).isOutOfSync()) {
            this.createThumbnail(thumbnailFile, imageData, iInfo);
            this.context.imgInfoUpdated = true;
        }
        if (this.context.markersDir != null && this.thumbnailDependencies(mkrFile = new File(this.context.markersDir, iInfo.getFileName() + '.' + "png"), imageFile).isOutOfSync()) {
            this.createMarker(mkrFile, imageData, iInfo);
        }
        return imageDescChanged;
    }

    private Dependencies thumbnailDependencies(File targetFile, File imageFile) {
        Dependencies depend = AllDependencies.get(targetFile);
        if (depend.isEmpty()) {
            depend.dependsOn(imageFile);
            depend.dependsOn(this.context.layoutFile);
        }
        return depend;
    }

    private void createThumbnail(File thumbnailFile, ImageData imageData, ImageInfo iInfo) {
        Dimension dim = this.context.thumbInfo.thumbnailSize(iInfo.getMainImageDesc().getWidth(), iInfo.getMainImageDesc().getHeight());
        int width = dim.width;
        int height = dim.height;
        int quality = 1;
        if (this.context.thumbInfo.getQuality().equals("low")) {
            quality = 0;
        }
        try {
            this.thumbnailCreator.createImage(imageData.getFile(), thumbnailFile, "jpeg", width, height, quality);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        iInfo.setThumbnailDesc(new ImageDescInfo(thumbnailFile, dim));
        this.notifyCreatingThumbnail(this.context.thumbDir, thumbnailFile);
    }

    private void createMarker(File mkrFile, ImageData imageData, ImageInfo iInfo) {
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        ImageHelper imgBuilder = new ImageHelper();
        if (w > h) {
            Dimension dim = ImageHelper.imageSize(w, h, 39, 29);
            if (this.context.markerH == null) {
                this.context.markerH = this.properties.getMarkerHImageFile();
            }
            try {
                imgBuilder.createImage(this.context.markerH);
                float x = (float)(45 - dim.width) / 2.0f;
                float y = (float)(35 - dim.height) / 2.0f;
                imgBuilder.drawImage(imageData.getFile(), dim.width, dim.height, (int)x, (int)y);
                imgBuilder.save(mkrFile, "png");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Dimension dim = ImageHelper.imageSize(w, h, 29, 39);
            if (this.context.markerV == null) {
                this.context.markerV = this.properties.getMarkerVImageFile();
            }
            try {
                imgBuilder.createImage(this.context.markerV);
                float x = (float)(35 - dim.width) / 2.0f;
                float y = (float)(45 - dim.height) / 2.0f;
                imgBuilder.drawImage(imageData.getFile(), dim.width, dim.height, (int)x, (int)y);
                imgBuilder.save(mkrFile, "png");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File getLayoutFile() {
        File file = this.defaultLayoutFile;
        if (this.layoutFiles.size() > 0) {
            file = (File)this.layoutFiles.get(0);
        }
        return file;
    }

    private SlideShowLayoutInfo getLayoutInfo() throws BuildException {
        SlideShowLayoutInfo layout = this.defaultLayout;
        if (this.layoutInfos.size() > 0) {
            layout = (SlideShowLayoutInfo)this.layoutInfos.get(0);
        } else {
            this.copySkinForLayout(this.defaultLayout.getSkin());
        }
        return layout;
    }

    private void checkLayoutIn(File directory) throws BuildException {
        File layoutFile = new File(directory, this.properties.getSlideshowLayoutFileName());
        if (layoutFile.exists()) {
            this.manageLayoutIn(layoutFile);
        }
    }

    private void manageLayoutIn(File layoutFile) throws BuildException {
        SlideShowLayoutInfo layoutInfo = this.layoutDeserializer.deserialize(layoutFile);
        this.copySkinForLayout(layoutInfo.getSkin());
        if (layoutInfo.getSkin() != null && layoutInfo.getSkin().getSkinName() != null) {
            this.currentSkin = layoutInfo.getSkin();
        }
        this.layoutFiles.add(0, layoutFile);
        this.layoutInfos.add(0, layoutInfo);
    }

    private void checkLayoutOut(File directory) {
        if (this.layoutFiles.size() > 0) {
            this.manageLayoutOut(new File(directory, this.properties.getSlideshowLayoutFileName()));
        }
    }

    private void manageLayoutOut(File layoutFile) {
        if (layoutFile.equals(this.layoutFiles.get(0))) {
            SkinInfo skinI;
            this.layoutFiles.remove(0);
            this.layoutInfos.remove(0);
            this.currentSkin = this.defaultSkin;
            if (!this.layoutFiles.isEmpty() && (skinI = ((SlideShowLayoutInfo)this.layoutInfos.get(0)).getSkin()) != null && skinI.getSkinName() != null) {
                this.currentSkin = skinI;
            }
        }
    }

    private void copySkinFiles(File skinPath, String skinName) throws BuildException {
        File skinLocation = new File(skinPath, skinName);
        if (!skinLocation.exists()) {
            throw new BuildException(skinName + " " + ResourceBundle.getBundle(this.getClass().getName()).getString("skin.no.exists"));
        }
        boolean copy = false;
        File destinationSkinDir = FileHelper.checkDirectory(this.buildSkinsDir, skinName);
        File destCssDir = FileHelper.checkDirectory(destinationSkinDir, "css");
        File skinDefFile = SlideShowProject.getSkinEditableFile(skinLocation);
        if (skinDefFile.exists()) {
            File cssPageFile = new File(destCssDir, "page.css");
            File cssComponentFile = new File(destCssDir, "component.css");
            if (FileHelper.isOutOfSync(skinDefFile, cssPageFile) || FileHelper.isOutOfSync(skinDefFile, cssComponentFile)) {
                StreamSource source = new StreamSource(skinDefFile);
                XMLHelper.transform(this.skinPageTransformer, source, cssPageFile);
                XMLHelper.transform(this.skinCompTransformer, source, cssComponentFile);
                AnimationLoadInfo animationLoad = new AnimationSkinDeserializer().deserialize(skinDefFile);
                if (animationLoad != null) {
                    File dir = new File(this.commonSkinDir, "images" + File.separator + "simple.css" + File.separator + "wait");
                    final String icName = animationLoad.iconName();
                    FileHelper.copyFileToDir(new File(dir, icName), destCssDir);
                    FileHelper.deleteFiles(destCssDir, new FileFilter(){

                        public boolean accept(File file) {
                            String name = file.getName();
                            return name.endsWith(".gif") && !name.equals(icName);
                        }
                    });
                }
                copy = true;
            }
        } else {
            copy = FileHelper.copyFiles(new File(skinLocation, "css"), destCssDir, true) || copy;
        }
        copy = this.copyCommonSkinFiles(new File(this.commonSkinDir, "css"), skinLocation, destCssDir) || copy;
        File imgDir = new File(destinationSkinDir, "images");
        boolean bl = copy = FileHelper.copyFiles(new File(skinPath, skinName + File.separatorChar + "images"), imgDir, true) || copy;
        if (copy) {
            this.notifyCopySkin(destinationSkinDir);
        }
    }

    private boolean copyCommonSkinFiles(File commonSkin, File skinLocation, File cssDir) {
        boolean copy = false;
        File[] files = commonSkin.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File fi = new File(skinLocation, files[i].getName());
            if (fi.exists()) continue;
            copy = FileHelper.copyFile(files[i], new File(cssDir, files[i].getName()), true) || copy;
        }
        return copy;
    }

    private void copyDefaultSkin() throws BuildException {
        this.copySkinFiles(this.defaultSkinDir.getParentFile(), this.defaultSkinDir.getName());
    }

    private void copySkin(String skinName) throws BuildException {
        this.copySkinFiles(this.defaultSkinDir.getParentFile(), skinName);
    }

    private void copySkinForLayout(SkinInfo skinI) throws BuildException {
        if (skinI != null) {
            File skinDir = skinI.getPath() == null ? this.defaultSkinDir.getParentFile() : this.createSkinFile(skinI.getPath());
            this.copySkinFiles(skinDir, skinI.getSkinName());
        }
    }

    private File createSkinFile(String path) {
        File skinDir = new File(path);
        if (!skinDir.exists()) {
            skinDir = new File(SlideShowProperties.getXissWebHomeDir(), path);
        }
        if (!skinDir.exists()) {
            skinDir = new File(this.project.getLocation(), path);
        }
        return skinDir;
    }

    private void notifyGenerateImagePage(File directory, File file) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, directory, file);
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            ((BuildEventListener)l.next()).generateImagePage(event);
        }
    }

    private void notifyGenerateIndexPage(File directory, File file) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, directory, file);
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            ((BuildEventListener)l.next()).generateIndexPage(event);
        }
    }

    private void notifyCopySkin(File skinDir) {
        DirectoryActionEvent event = new DirectoryActionEvent(this, skinDir);
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            ((BuildEventListener)l.next()).copySkin(event);
        }
    }

    private void notifyCreatingThumbnail(File dir, File file) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, dir, file);
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            ((BuildEventListener)l.next()).creatingThumbnail(event);
        }
    }

    public void stop() {
        super.stop();
        this.context.clear();
        this.visitor = null;
    }
}

