/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.project;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.xissweb.gui.Main;
import org.xissweb.prefs.PreferencesManager;

public class ProjectPrefs {
    public static final String fileName = ".project";
    private static final String REVERSE_IS_SELECTED_KEY = "reverse.is.selected";
    private static final String REPOSITORY_IS_SELECTED_KEY = "repository.is.selected";
    private static final String PREFS_SOW_OPTION = "sow.option";
    private static final String CURRENT_DOC_KEY = "current.doc";
    private static final String DOCUMENT_KEY = "documents";
    private static final String PREFS_EDITOR = "editor";
    private static final String SELECTION_KEY = "selection";
    private static final String PREFS_FILE = "file";
    private static final String PREFS_FILE_FILTER_OPTION = "file.filter.option";
    private static final String SHOW_ALL_FILE_KEY = "show.all.file";
    private static final String SHOW_IMAGE_SLIDE_SHOW_KEY = "show.image.slide.show";
    PreferencesManager prefs = new PreferencesManager();

    public ProjectPrefs(File projectDir) {
        this.prefs.setFile(new File(projectDir, fileName));
        if (this.prefs.getFile().exists()) {
            String currentPaser = System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            try {
                this.prefs.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (currentPaser == null) {
                Properties pSys = System.getProperties();
                pSys.remove("javax.xml.parsers.DocumentBuilderFactory");
                System.setProperties(pSys);
            } else {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", currentPaser);
            }
        }
    }

    public void store() {
        try {
            this.prefs.store();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void storeFileSelection(String selection) {
        this.prefs.put(SELECTION_KEY, PREFS_FILE, selection);
    }

    public String getFileSelection() {
        return this.prefs.get(SELECTION_KEY, PREFS_FILE, "");
    }

    public void storeCurrentDocument(String current) {
        this.prefs.put(CURRENT_DOC_KEY, PREFS_EDITOR, current);
    }

    public String getCurrentDocument() {
        return this.prefs.get(CURRENT_DOC_KEY, PREFS_EDITOR, "null");
    }

    public void storeDocuments(String documents) {
        this.prefs.put(DOCUMENT_KEY, PREFS_EDITOR, documents);
    }

    public String getDocuments() {
        return this.prefs.get(DOCUMENT_KEY, PREFS_EDITOR, "");
    }

    public void storeRepositirySelected(boolean value) {
        this.prefs.putBoolean(REPOSITORY_IS_SELECTED_KEY, PREFS_SOW_OPTION, value);
    }

    public boolean getRepositorySelected(boolean val) {
        return this.prefs.getBoolean(REPOSITORY_IS_SELECTED_KEY, PREFS_SOW_OPTION, val);
    }

    public void storeReverseSelected(boolean value) {
        this.prefs.putBoolean(REVERSE_IS_SELECTED_KEY, PREFS_SOW_OPTION, value);
    }

    public boolean getReverseSelected(boolean val) {
        return this.prefs.getBoolean(REVERSE_IS_SELECTED_KEY, PREFS_SOW_OPTION, val);
    }

    public void storeFilterShowAllFiles(boolean val) {
        this.prefs.putBoolean(SHOW_ALL_FILE_KEY, PREFS_FILE_FILTER_OPTION, val);
    }

    public boolean getFilterShowAllFiles() {
        return this.prefs.getBoolean(SHOW_ALL_FILE_KEY, PREFS_FILE_FILTER_OPTION, Main.get().getXissWeb().getFileManager().isShowFilesTreeFilter());
    }

    public void storeFilterShowImageInSlideShow(boolean val) {
        this.prefs.putBoolean(SHOW_IMAGE_SLIDE_SHOW_KEY, PREFS_FILE_FILTER_OPTION, val);
    }

    public boolean getFilterShowImageInSlideShow() {
        return this.prefs.getBoolean(SHOW_IMAGE_SLIDE_SHOW_KEY, PREFS_FILE_FILTER_OPTION, Main.get().getXissWeb().getFileManager().isShowImageInSlideShowsTreeFilter());
    }
}

