/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.project;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWeb;
import org.xissweb.gui.project.basic.NewProjectDialog;
import org.xissweb.project.SlideShowProperties;

public class NewProjectAction
implements ActionListener {
    private XissWeb xissWeb;

    public NewProjectAction(XissWeb xissWeb) {
        this.xissWeb = xissWeb;
    }

    public void actionPerformed(ActionEvent event) {
        this.actionPerformed((File)null);
    }

    public void actionPerformed(File directory) {
        NewProjectDialog newProjectDialog = new NewProjectDialog(this.xissWeb);
        int newOption = newProjectDialog.showDialog(directory);
        switch (newOption) {
            case -1: 
            case 0: {
                SlideShowProperties.copyPropertiesFileFor(newProjectDialog.getProjectLocation());
                this.xissWeb.openProject(newProjectDialog.getProjectLocation());
                Main.get().editProperties();
                break;
            }
            case 10: {
                try {
                    SlideShowProperties.copyPropertiesFileFor(newProjectDialog.getProjectLocation());
                    SlideShowProperties properties = new SlideShowProperties();
                    properties.loadProperties(newProjectDialog.getProjectLocation());
                    properties.setValue("src.root.dir", newProjectDialog.getSrcDirectory().getName());
                    properties.saveProperties();
                    this.xissWeb.openProject(newProjectDialog.getProjectLocation());
                    Main.get().editProperties();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 11: {
                File srcDir = newProjectDialog.getSrcDirectory();
                if (!srcDir.exists()) {
                    srcDir.mkdir();
                }
                File[] dirs = FileHelper.listDirectories(newProjectDialog.getProjectLocation());
                for (int i = 0; i < dirs.length; ++i) {
                    if (dirs[i].equals(srcDir)) continue;
                    dirs[i].renameTo(new File(srcDir, dirs[i].getName()));
                }
                SlideShowProperties.copyPropertiesFileFor(newProjectDialog.getProjectLocation());
                this.xissWeb.openProject(newProjectDialog.getProjectLocation());
                Main.get().editProperties();
                break;
            }
            case 12: {
                this.xissWeb.performNewRepositoryProject(newProjectDialog.getProjectLocation(), 0);
                break;
            }
            case 13: {
                this.xissWeb.performNewRepositoryProject(newProjectDialog.getProjectLocation(), 1);
            }
        }
    }
}

