/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.prefs;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import org.xissweb.gui.Main;
import org.xissweb.gui.prefs.ConfigurableEditable;
import org.xissweb.gui.prefs.data.PreferenceCategory;
import org.xissweb.gui.prefs.data.PreferenceElement;
import org.xissweb.gui.prefs.data.PreferenceInfo;
import org.xissweb.gui.prefs.data.xml.PreferencesDeserializer;
import org.xissweb.project.SlideShowProperties;

public class PreferencesEditionManager {
    private static final String preferencesResourceName = "preferences/gui-preferences.xml";
    private static final PreferencesEditionManager instance = new PreferencesEditionManager();
    private PreferenceCategory preferencesRoot;
    private Hashtable configurables = new Hashtable();

    public static PreferencesEditionManager get() {
        return instance;
    }

    private PreferencesEditionManager() {
        PreferencesDeserializer deserializer = new PreferencesDeserializer();
        File f = new File(SlideShowProperties.getRsrcDir(), preferencesResourceName);
        this.preferencesRoot = deserializer.deserialize(f);
    }

    public void registerConfigurable(ConfigurableEditable configurable) {
        this.registerConfigurable(this.preferencesRoot, configurable);
    }

    private void registerConfigurable(PreferenceCategory category, ConfigurableEditable configurable) {
        Iterator i = category.getElements().iterator();
        while (i.hasNext()) {
            PreferenceElement e = (PreferenceElement)i.next();
            if (e instanceof PreferenceInfo) {
                PreferenceInfo pInfo = (PreferenceInfo)e;
                if (!pInfo.getConfigurableKey().equals(configurable.getClass().getName())) continue;
                this.configurables.put(pInfo, configurable);
                continue;
            }
            this.registerConfigurable((PreferenceCategory)e, configurable);
        }
    }

    public ConfigurableEditable getConfigurable(PreferenceInfo pInfo) {
        return (ConfigurableEditable)this.configurables.get(pInfo);
    }

    public PreferenceCategory getPreferencesRoot() {
        return this.preferencesRoot;
    }

    public Object getPreferenceValue(PreferenceInfo preferenceInfo) {
        switch (preferenceInfo.getType()) {
            case 0: {
                return new Boolean(Main.preferences.getBoolean(preferenceInfo.getKey(), preferenceInfo.getConfigurableKey(), false));
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                return Main.preferences.get(preferenceInfo.getKey(), preferenceInfo.getConfigurableKey(), null);
            }
        }
        return null;
    }

    public PreferenceInfo getPreferenceInfo(String prefKey, String configurableKey) {
        return this.getPreferenceInfo(this.preferencesRoot, prefKey, configurableKey);
    }

    private PreferenceInfo getPreferenceInfo(PreferenceCategory category, String prefKey, String configurableKey) {
        category.getElements();
        Iterator i = category.getElements().iterator();
        while (i.hasNext()) {
            PreferenceInfo pInfo;
            PreferenceElement e = (PreferenceElement)i.next();
            if (!(e instanceof PreferenceInfo ? (pInfo = (PreferenceInfo)e).getKey().equals(prefKey) && configurableKey.equals(pInfo.getConfigurableKey()) : (pInfo = this.getPreferenceInfo((PreferenceCategory)e, prefKey, configurableKey)) != null)) continue;
            return pInfo;
        }
        return null;
    }

    public String getPreferenceDefault(PreferenceInfo preferenceInfo) {
        String value = preferenceInfo.getDefaultValue();
        if (value == null) {
            value = this.getConfigurable(preferenceInfo).getDefaultValue(preferenceInfo);
        }
        return value;
    }

    public void setPreferenceValue(PreferenceInfo preferenceInfo, Object value) {
        switch (preferenceInfo.getType()) {
            case 0: {
                Main.preferences.putBoolean(preferenceInfo.getKey(), preferenceInfo.getConfigurableKey(), ((Boolean)value).booleanValue());
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                Main.preferences.put(preferenceInfo.getKey(), preferenceInfo.getConfigurableKey(), (String)value);
                break;
            }
        }
    }

    public void notifyPreferenceChanged(PreferenceInfo pInfo, Object value) {
        ConfigurableEditable confE = this.getConfigurable(pInfo);
        if (confE != null) {
            confE.prefrerenceEdited(pInfo, value);
        }
    }

    public static final String displayLabel(PreferenceElement preferenceElement) {
        return preferenceElement.internationalizedDisplay();
    }
}

