/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xissweb.gui.graphic.GraphicElement;
import org.xissweb.gui.graphic.GraphicElementRenderer;
import org.xissweb.gui.graphic.GraphicSelectionEvent;
import org.xissweb.gui.graphic.GraphicSelectionListener;
import org.xissweb.gui.graphic.GraphicSelectionModel;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.LayoutGraphicDrawer;

public class LayoutGraphicSelectionModel
implements GraphicSelectionModel,
GraphicSelectionListener {
    private GraphicElement selection = null;
    private List listeners = new ArrayList();
    private LayoutEditor editor;
    LayoutGraphicDrawer drawer;

    public LayoutGraphicSelectionModel(LayoutEditor editor) {
        this.editor = editor;
        this.addGraphicSelectionListener(this);
    }

    public void valueChanged(GraphicSelectionEvent event) {
        if (this.getSelection() != null) {
            GraphicElement e = this.getSelection();
            this.editor.setElementSelection(e.getUserObject(), this);
        } else {
            this.editor.unsetElementSelection(this);
        }
    }

    public void setSelection(GraphicElement element) {
        if (this.selection != element) {
            GraphicElement child;
            int i;
            GraphicElementRenderer renderer = this.drawer.getElementRenderer();
            Graphics2D g = (Graphics2D)this.drawer.getGraphics();
            if (this.selection != null) {
                renderer.draw(g, this.selection, false);
                for (i = 0; i < this.selection.getChildren().length; ++i) {
                    child = this.selection.getChildAt(i);
                    renderer.draw(g, child, false);
                }
            }
            this.selection = element;
            if (this.selection != null) {
                renderer.draw(g, element, true);
                for (i = 0; i < element.getChildren().length; ++i) {
                    child = element.getChildAt(i);
                    renderer.draw(g, child, false);
                }
            }
            this.notifyListeners(new GraphicSelectionEvent(this, element));
        }
    }

    public void clearSelection() {
        this.setSelection(null);
    }

    public GraphicElement getSelection() {
        return this.selection;
    }

    public synchronized void addGraphicSelectionListener(GraphicSelectionListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeGraphicSelectionListener(GraphicSelectionListener l) {
        this.listeners.remove(l);
    }

    private void notifyListeners(GraphicSelectionEvent event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((GraphicSelectionListener)i.next()).valueChanged(event);
        }
    }
}

