/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout;

import java.util.Iterator;
import java.util.List;
import org.xissweb.data.layout.AnimationInfo;
import org.xissweb.data.layout.Arrangeable;
import org.xissweb.data.layout.ArrangementInfo;
import org.xissweb.data.layout.ImageAreaInfo;
import org.xissweb.data.layout.LocalIndexInfo;
import org.xissweb.data.layout.LocationOnMapInfo;
import org.xissweb.data.layout.PageDecorationInfo;
import org.xissweb.data.layout.SkinInfo;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.data.layout.ThumbnailsInfoInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.graphic.DefaultGraphicElement;
import org.xissweb.gui.graphic.DefaultGraphicModel;
import org.xissweb.gui.graphic.GraphicElement;
import org.xissweb.gui.graphic.GraphicIconElement;

public class LayoutGraphicModel
extends DefaultGraphicModel {
    private SlideShowLayoutInfo layoutInfo;

    public void init() {
        this.rootElement = new DefaultGraphicElement(this.layoutInfo);
        if (this.layoutInfo.getSkin() != null) {
            this.rootElement.add(this.createElement(this.layoutInfo.getSkin()));
        }
        if (this.layoutInfo.getAnimation() != null) {
            this.rootElement.add(this.createElement(this.layoutInfo.getAnimation()));
        }
        this.rootElement.add(this.createElement(this.layoutInfo.getThumbnailsInfo()));
        if (this.layoutInfo.hasHeader()) {
            this.rootElement.add(this.createElement(this.layoutInfo.getHeader()));
        }
        if (this.layoutInfo.hasLeftMargin()) {
            this.rootElement.add(this.createElement(this.layoutInfo.getLeftMargin()));
        }
        if (this.layoutInfo.hasRightMargin()) {
            this.rootElement.add(this.createElement(this.layoutInfo.getRightMargin()));
        }
        if (this.layoutInfo.hasFooter()) {
            this.rootElement.add(this.createElement(this.layoutInfo.getFooter()));
        }
        this.rootElement.add(this.createElement(this.layoutInfo.getArrangement()));
    }

    GraphicElement createElement(Object a) {
        if (a instanceof Arrangeable) {
            return this.createElement((Arrangeable)a);
        }
        if (a instanceof PageDecorationInfo) {
            return this.createElement((PageDecorationInfo)a);
        }
        if (a instanceof LocationOnMapInfo) {
            return this.createElement((LocationOnMapInfo)a);
        }
        if (a instanceof LocalIndexInfo) {
            return this.createElement((LocalIndexInfo)a);
        }
        if (a instanceof AnimationInfo) {
            return this.createElement((AnimationInfo)a);
        }
        if (a instanceof SkinInfo) {
            return this.createElement((SkinInfo)a);
        }
        if (a instanceof ThumbnailsInfoInfo) {
            return this.createElement((ThumbnailsInfoInfo)a);
        }
        return null;
    }

    GraphicElement createElement(SkinInfo skInfo) {
        GraphicIconElement e = new GraphicIconElement(skInfo);
        e.setIcon(XissWebUI.getIcon("/images/layout/skin.png"));
        return e;
    }

    GraphicElement createElement(ImageAreaInfo imageAreaInfo) {
        DefaultGraphicElement e = new DefaultGraphicElement(imageAreaInfo);
        if (imageAreaInfo.hasLocalIndex()) {
            e.add(this.createElement(imageAreaInfo.getLocalIndexInfo()));
        }
        if (imageAreaInfo.hasImageLocationOnMap()) {
            e.add(this.createElement(imageAreaInfo.getLocationOnMap()));
        }
        return e;
    }

    GraphicElement createElement(LocationOnMapInfo locationOnMapInfo) {
        GraphicIconElement e = new GraphicIconElement(locationOnMapInfo);
        e.setIcon(XissWebUI.getIcon("/images/layout/imageLocationOnMap.png"));
        return e;
    }

    GraphicElement createElement(LocalIndexInfo localIndexInfo) {
        GraphicIconElement e = new GraphicIconElement(localIndexInfo);
        e.setIcon(XissWebUI.getIcon("/images/layout/localIndex.png"));
        return e;
    }

    GraphicElement createElement(AnimationInfo aInfo) {
        GraphicIconElement e = new GraphicIconElement(aInfo);
        e.setIcon(XissWebUI.getIcon("/images/layout/animation.png"));
        return e;
    }

    GraphicElement createElement(ThumbnailsInfoInfo tInfo) {
        GraphicIconElement e = new GraphicIconElement(tInfo);
        e.setIcon(XissWebUI.getIcon("/images/layout/thumbnailsInfo.gif"));
        return e;
    }

    GraphicElement createElement(PageDecorationInfo deco) {
        return new DefaultGraphicElement(deco);
    }

    GraphicElement createElement(Arrangeable a) {
        if (a instanceof ImageAreaInfo) {
            return this.createElement((ImageAreaInfo)a);
        }
        return a instanceof ArrangementInfo ? this.createElement((ArrangementInfo)a) : new DefaultGraphicElement(a);
    }

    GraphicElement createElement(ArrangementInfo arrangement) {
        DefaultGraphicElement element = new DefaultGraphicElement(arrangement);
        List la = arrangement.getComponents();
        Iterator i = la.iterator();
        while (i.hasNext()) {
            Arrangeable a = (Arrangeable)i.next();
            element.add(this.createElement(a));
        }
        return element;
    }

    public SlideShowLayoutInfo getLayoutInfo() {
        return this.layoutInfo;
    }

    public void setLayoutInfo(SlideShowLayoutInfo layoutInfo) {
        this.layoutInfo = layoutInfo;
        if (layoutInfo == null) {
            this.rootElement = new DefaultGraphicElement();
        } else {
            this.init();
        }
    }
}

