/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.file;

import java.io.File;
import java.io.FileFilter;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.xissweb.file.DirectoryObserver;
import org.xissweb.file.DirectoryVisitor;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.file.FileManager;
import org.xissweb.gui.util.tree.TreeModel;
import org.xissweb.image.ImageFileHelper;
import org.xissweb.produce.SlideShowDirectory;
import org.xissweb.produce.SlideShowFileFilter;
import org.xissweb.project.SlideShowProject;
import org.xissweb.project.SlideShowProperties;

public class FileTreeModel
extends TreeModel
implements DirectoryObserver {
    private static final long serialVersionUID = -6442770260626455406L;
    private File rootDirectory;
    SlideShowProject project;
    private File baseDirOfVisit;
    private FileManager fileManager;
    private FileFilter notInBuild = new FileFilter(){

        public boolean accept(File file) {
            return !FileTreeModel.this.project.isInBuild(file);
        }
    };

    public FileTreeModel() {
        super(new DefaultMutableTreeNode(null));
    }

    public FileTreeModel(FileManager fileManager, SlideShowProject project) {
        super(new DefaultMutableTreeNode("XissWeb"));
        this.project = project;
        this.fileManager = fileManager;
        this.rootDirectory = project.getLocation();
        if (this.rootDirectory != null) {
            this.init();
        }
    }

    public void repositoryNodesChanged() {
        DefaultMutableTreeNode node = this.getNodeFromUserObject(this.project.getRepositoryDirectory());
        this.nodeChanged(node);
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            this.nodeChanged((DefaultMutableTreeNode)e.nextElement());
        }
        node = this.getNodeFromUserObject(this.project.getSrcDirectory());
        this.nodeChanged(node);
    }

    public void originNodeChanged() {
        DefaultMutableTreeNode node = this.getNodeFromUserObject(this.project.getOriginDiretory());
        this.nodeChanged(node);
        node = this.getNodeFromUserObject(this.project.getSrcDirectory());
        this.nodeChanged(node);
    }

    private void init() {
        File origin;
        File repository;
        if (this.rootDirectory != null) {
            this.addDirHierarchy(this.rootDirectory);
            if (!this.project.getSrcDirectory().exists()) {
                this.addNodeForUserObject(this.getNodeFromUserObject(this.project.getLocation()), (Object)this.project.getSrcDirectory());
            }
        }
        if ((repository = this.project.getRepositoryDirectory()) != null) {
            this.addExternalHierarchy(repository);
        }
        if ((origin = this.project.getOriginDiretory()) != null) {
            this.addExternalHierarchy(origin);
        }
    }

    public DefaultMutableTreeNode addDirHierarchy(File directory) {
        if (directory.exists()) {
            File baseDirSaved = this.baseDirOfVisit;
            this.baseDirOfVisit = directory.getParentFile();
            DirectoryVisitor visitor = new DirectoryVisitor(this, this.notInBuild, new SlideShowFileFilter(this.project.getProperties()));
            visitor.visit(directory);
            this.baseDirOfVisit = baseDirSaved;
        }
        return this.getNodeFromUserObject(directory);
    }

    private void addSkins(DefaultMutableTreeNode parent, File skinsDir) {
        DefaultMutableTreeNode node = this.addNodeForUserObject(parent, (Object)skinsDir);
        Object[] listF = skinsDir.listFiles();
        this.addNodeForUserObject(node, listF);
    }

    private void addExternalHierarchy(File hierarchyRoot) {
        if (hierarchyRoot.exists()) {
            this.addDirHierarchy(hierarchyRoot);
        } else {
            DefaultMutableTreeNode parent = this.getNodeFromUserObject(this.project.getLocation());
            parent.insert(new DefaultMutableTreeNode(hierarchyRoot), 0);
        }
    }

    public DefaultMutableTreeNode createNeededNodes(File file) {
        File baseDir = this.baseDirOfVisit == null ? this.rootDirectory : this.baseDirOfVisit;
        String[] path = FileHelper.decomposePath(FileHelper.relativePath(baseDir, file));
        File f = baseDir;
        DefaultMutableTreeNode node = this.getNodeFromUserObject(this.rootDirectory);
        for (int i = 0; i < path.length; ++i) {
            DefaultMutableTreeNode n = this.getChildNodeFromUserObject(node, f = new File(f, path[i]));
            if (n == null) {
                n = f.equals(file) && file.isDirectory() ? this.addDirHierarchy(f) : this.addNodeForUserObject(node, (Object)f);
            }
            node = n;
        }
        return node;
    }

    public boolean inDirectory(File directory) {
        if (SlideShowProject.isSkinFile(directory)) {
            return false;
        }
        SlideShowProperties properties = this.project.getProperties();
        File parent = directory.getParentFile();
        if (parent != null) {
            DefaultMutableTreeNode node;
            DefaultMutableTreeNode pNode = null;
            pNode = this.getNodeFromUserObject(parent);
            if (pNode == null) {
                node = this.getNodeFromUserObject(this.project.getLocation());
                DefaultMutableTreeNode defaultMutableTreeNode = pNode = node == null ? (DefaultMutableTreeNode)this.root : node;
            }
            if (SlideShowProject.isSkinsRootDirectory(directory)) {
                this.addSkins(pNode, directory);
                return false;
            }
            node = this.addNodeForUserObject(pNode, (Object)directory);
            boolean slideshowDir = SlideShowDirectory.isSlideshowDirectory(directory, this.project.getProperties());
            if (slideshowDir) {
                File fC;
                if (this.fileManager.isShowImageInSlideShowsTreeFilter()) {
                    File imgDir = SlideShowDirectory.imageDirectory(directory, this.project.getProperties());
                    DefaultMutableTreeNode imgNode = node;
                    if (!imgDir.equals(directory)) {
                        imgNode = this.addNodeForUserObject(node, (Object)imgDir);
                    }
                    this.addNodeForUserObject(imgNode, ImageFileHelper.listImageFiles(imgDir));
                }
                if (!this.fileManager.isShowFilesTreeFilter() && (fC = new File(directory, properties.getSlideshowContentFileName())).exists()) {
                    this.addNodeForUserObject(node, (Object)fC);
                }
            }
            if (this.fileManager.isShowFilesTreeFilter()) {
                Object[] files = directory.listFiles(slideshowDir ? ImageFileHelper.nonImageFileFilter : FileHelper.onlyFile);
                if (files != null) {
                    this.addNodeForUserObject(node, files);
                }
            } else {
                File file;
                if (directory.equals(this.project.getLocation())) {
                    this.addNodeForUserObject(node, (Object)this.project.getProperties().getPropertiesFile());
                }
                if ((file = SlideShowProject.getLayoutFileInDir(directory)).exists()) {
                    this.addNodeForUserObject(node, (Object)file);
                }
            }
        }
        return false;
    }

    public boolean outDirectory(File directory) {
        return false;
    }
}

