/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.editor.valid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.ValidProcessHandler;
import org.xissweb.gui.editor.valid.EditorValidInfo;
import org.xissweb.i18n.TextDisplayer;
import org.xml.sax.SAXParseException;

public class EditorValidHandler
implements ValidProcessHandler {
    public static final String ERROR = "error";
    public static final String FATAL_ERROR = "fatal.error";
    public static final String WARNING = "warning";
    private Editor editor;
    private List errors = new ArrayList();
    static /* synthetic */ Class class$org$xissweb$gui$editor$valid$EditorValidHandler;

    public EditorValidHandler(Editor editor) {
        this.editor = editor;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public Object getValidInfos() {
        return this.errors;
    }

    public void addErrorInfo(String errorType, Exception error) {
        EditorValidInfo sErr = new EditorValidInfo(errorType, error);
        this.errors.add(sErr);
    }

    public StringBuffer appendText(StringBuffer buff) {
        if (this.errors.isEmpty()) {
            return buff;
        }
        buff.append(this.editor.getDocumentName()).append(" ").append(TextDisplayer.getString("no.valid", this.getClass()));
        Iterator i = this.errors.iterator();
        while (i.hasNext()) {
            EditorValidHandler.appendMessage(buff, (EditorValidInfo)i.next()).append("\n");
        }
        return buff.append("---\n");
    }

    public static StringBuffer appendMessage(StringBuffer buff, EditorValidInfo validInfo) {
        buff.append(TextDisplayer.getString(validInfo.getErrotType(), class$org$xissweb$gui$editor$valid$EditorValidHandler == null ? (class$org$xissweb$gui$editor$valid$EditorValidHandler = EditorValidHandler.class$("org.xissweb.gui.editor.valid.EditorValidHandler")) : class$org$xissweb$gui$editor$valid$EditorValidHandler));
        buff.append(" ");
        Exception ex = validInfo.getException();
        if (ex instanceof SAXParseException) {
            SAXParseException saxE = (SAXParseException)ex;
            buff.append(TextDisplayer.getString("error.line", class$org$xissweb$gui$editor$valid$EditorValidHandler == null ? (class$org$xissweb$gui$editor$valid$EditorValidHandler = EditorValidHandler.class$("org.xissweb.gui.editor.valid.EditorValidHandler")) : class$org$xissweb$gui$editor$valid$EditorValidHandler));
            buff.append(" ").append(saxE.getLineNumber());
            buff.append(" ").append(ex.getLocalizedMessage());
        } else {
            buff.append(ex.getLocalizedMessage());
        }
        return buff;
    }

    public void startValidating(Editor e) {
        this.errors.clear();
    }

    public void validError(Editor editor, Exception e) {
        this.addErrorInfo(ERROR, e);
    }

    public void validFatalError(Editor editor, Exception e) {
        this.addErrorInfo(FATAL_ERROR, e);
    }

    public void validWarning(Editor editor, Exception e) {
        this.addErrorInfo(WARNING, e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

