/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.skin.xml;

import java.io.File;
import java.io.IOException;
import org.apache.xerces.parsers.SAXParser;
import org.xissweb.data.skin.AnimationLoadInfo;
import org.xissweb.data.skin.ColorInfo;
import org.xissweb.data.skin.ColorsInfo;
import org.xissweb.data.skin.ComponentInfo;
import org.xissweb.data.skin.ComponentStyleInfo;
import org.xissweb.data.skin.FontInfo;
import org.xissweb.data.skin.ImageAreaInfo;
import org.xissweb.data.skin.LineInfo;
import org.xissweb.data.skin.LinkInfo;
import org.xissweb.data.skin.LocalIndexInfo;
import org.xissweb.data.skin.PageInfo;
import org.xissweb.data.skin.SlideShowSkinInfo;
import org.xissweb.data.skin.ThumbnailInfo;
import org.xissweb.data.skin.xml.SkinSchema;
import org.xissweb.xml.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SkinDeserializer
extends DefaultHandler
implements SkinSchema {
    private SlideShowSkinInfo skinInfo;
    private PageInfo pageInfo;
    private LinkInfo linkInfo;
    private ComponentInfo componentInfo;
    private ComponentStyleInfo componentStyle;
    private ImageAreaInfo imageAreaInfo;
    private LocalIndexInfo localIndexInfo;
    private ThumbnailInfo thumbnailInfo;

    public SlideShowSkinInfo deserialize(File file) {
        this.skinInfo = null;
        try {
            SAXParser parser = XMLHelper.getSAXPerser(this);
            parser.parse(file.toURI().toURL().toExternalForm());
            if (this.skinInfo.getComponent().getImageArea().getLocalIndex() == null) {
                LocalIndexInfo localIndexInfo = new LocalIndexInfo();
                ColorInfo colorInfo = new ColorInfo();
                colorInfo.setName(this.skinInfo.getColors().getBodyBackground().getName());
                colorInfo.setR(this.skinInfo.getColors().getBodyBackground().getR());
                colorInfo.setG(this.skinInfo.getColors().getBodyBackground().getG());
                colorInfo.setB(this.skinInfo.getColors().getBodyBackground().getB());
                localIndexInfo.setBorderColor(colorInfo);
                colorInfo = new ColorInfo();
                colorInfo.setName(this.skinInfo.getColors().getDisabledForeground().getName());
                colorInfo.setR(this.skinInfo.getColors().getDisabledForeground().getR());
                colorInfo.setG(this.skinInfo.getColors().getDisabledForeground().getG());
                colorInfo.setB(this.skinInfo.getColors().getDisabledForeground().getB());
                localIndexInfo.setBackground(colorInfo);
                this.skinInfo.getComponent().getImageArea().setLocalIndex(localIndexInfo);
            }
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this.skinInfo;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("page")) {
            this.pageInfo = null;
        } else if (localName.equals("link")) {
            this.linkInfo = null;
        } else if (localName.equals("thumbnail")) {
            this.thumbnailInfo = null;
        } else if (localName.equals("component")) {
            this.componentInfo = null;
        } else if (localName.equals("copyright")) {
            this.componentStyle = null;
        } else if (localName.equals("local-index")) {
            this.localIndexInfo = null;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("skin")) {
            this.skinInfo = new SlideShowSkinInfo();
            this.skinInfo.setName(attributes.getValue("name"));
        } else if (localName.equals("colors")) {
            this.skinInfo.setColors(new ColorsInfo());
        } else if (localName.equals("body-background")) {
            this.skinInfo.getColors().setBodyBackground(this.createColor(attributes));
        } else if (localName.equals("page-background")) {
            this.skinInfo.getColors().setPageBackground(this.createColor(attributes));
        } else if (localName.equals("foreground")) {
            this.skinInfo.getColors().setForeground(this.createColor(attributes));
        } else if (localName.equals("link-foreground")) {
            this.skinInfo.getColors().setLinkForeground(this.createColor(attributes));
        } else if (localName.equals("link-hover")) {
            this.skinInfo.getColors().setLinkHover(this.createColor(attributes));
        } else if (localName.equals("disabled-foreground")) {
            this.skinInfo.getColors().setDisabledForeground(this.createColor(attributes));
        } else if (localName.equals("page")) {
            this.pageInfo = new PageInfo();
            this.skinInfo.setPage(this.pageInfo);
            String center = attributes.getValue("center");
            this.pageInfo.setCentered(center != null && center.equals("yes"));
        } else if (localName.equals("link")) {
            this.linkInfo = new LinkInfo();
            if (this.thumbnailInfo != null) {
                this.thumbnailInfo.setLink(this.linkInfo);
            } else if (this.pageInfo != null) {
                this.pageInfo.setLink(this.linkInfo);
            }
        } else if (localName.equals("normal")) {
            this.linkInfo.setNormal(this.createLine(attributes));
        } else if (localName.equals("hover")) {
            this.linkInfo.setHover(this.createLine(attributes));
        } else if (localName.equals("component")) {
            this.componentInfo = new ComponentInfo();
            this.skinInfo.setComponent(this.componentInfo);
        } else if (localName.equals("copyright")) {
            this.componentStyle = new ComponentStyleInfo();
            this.componentInfo.setCopyright(this.componentStyle);
        } else if (localName.equals("font")) {
            if (this.pageInfo != null) {
                this.pageInfo.setFont(this.createFont(attributes));
            } else if (this.componentStyle != null) {
                this.componentStyle.setFont(this.createFont(attributes));
            } else if (this.imageAreaInfo != null) {
                this.imageAreaInfo.setFont(this.createFont(attributes));
            }
        } else if (localName.equals("color")) {
            this.imageAreaInfo.setColor(this.createColor(attributes));
        } else if (localName.equals("background")) {
            if (this.localIndexInfo != null) {
                this.localIndexInfo.setBackground(this.createColor(attributes));
            } else {
                this.imageAreaInfo.setBackground(this.createColor(attributes));
            }
        } else if (localName.equals("image-area")) {
            this.imageAreaInfo = new ImageAreaInfo();
            FontInfo fInfo = new FontInfo();
            FontInfo pFInfo = this.skinInfo.getPage().getFont();
            fInfo.setNames((String[])pFInfo.getNames().clone());
            fInfo.setSize(pFInfo.getSize());
            fInfo.setStyle(pFInfo.getStyle());
            fInfo.setUnit(pFInfo.getUnit());
            fInfo.setWeight(pFInfo.getWeight());
            this.imageAreaInfo.setMetadataFont(fInfo);
            this.componentInfo.setImageArea(this.imageAreaInfo);
            String margin = attributes.getValue("margin");
            if (margin != null) {
                this.imageAreaInfo.setMargin(Integer.parseInt(margin));
            }
        } else if (localName.equals("current")) {
            this.thumbnailInfo.setCurrent(this.createLine(attributes));
        } else if (localName.equals("border")) {
            this.imageAreaInfo.setBorder(this.createLine(attributes));
        } else if (localName.equals("thumbnail")) {
            this.thumbnailInfo = new ThumbnailInfo();
            this.componentInfo.setThumbnail(this.thumbnailInfo);
        } else if (localName.equals("current")) {
            this.thumbnailInfo.setCurrent(this.createLine(attributes));
        } else if (localName.equals("meta-data")) {
            this.imageAreaInfo.setMetadataFont(this.createFont(attributes));
        } else if (localName.equals("local-index")) {
            this.localIndexInfo = new LocalIndexInfo();
            this.imageAreaInfo.setLocalIndex(this.localIndexInfo);
        } else if (localName.equals("border-color")) {
            this.localIndexInfo.setBorderColor(this.createColor(attributes));
        } else if (localName.equals("animation")) {
            this.imageAreaInfo.setAnimationLoad(SkinDeserializer.createAnimationLoad(attributes));
        }
    }

    static AnimationLoadInfo createAnimationLoad(Attributes attributes) {
        AnimationLoadInfo animationLoadInfo = new AnimationLoadInfo();
        String backg = attributes.getValue("background");
        if ("white".equals(backg)) {
            animationLoadInfo.setBackground(0);
        } else if ("black".equals(backg)) {
            animationLoadInfo.setBackground(1);
        }
        String icStyle = attributes.getValue("icon-style");
        if ("default".equals(icStyle)) {
            animationLoadInfo.setIconStyle(0);
        } else if ("bar".equals(icStyle)) {
            animationLoadInfo.setIconStyle(1);
        } else if ("flower".equals(icStyle)) {
            animationLoadInfo.setIconStyle(2);
        } else if ("pike".equals(icStyle)) {
            animationLoadInfo.setIconStyle(3);
        } else if ("roller".equals(icStyle)) {
            animationLoadInfo.setIconStyle(4);
        } else if ("wheel-sthrobber".equals(icStyle)) {
            animationLoadInfo.setIconStyle(5);
        } else if ("earth".equals(icStyle)) {
            animationLoadInfo.setIconStyle(6);
        } else if ("movie".equals(icStyle)) {
            animationLoadInfo.setIconStyle(7);
        }
        animationLoadInfo.setOpacity(Float.parseFloat(attributes.getValue("opacity")));
        return animationLoadInfo;
    }

    public LineInfo createLine(Attributes attributes) {
        LineInfo line = new LineInfo();
        String val = attributes.getValue("thin");
        line.setThin(val == null ? 1 : Integer.parseInt(val));
        val = attributes.getValue("line");
        line.setType(val == null ? "none" : val);
        return line;
    }

    public FontInfo createFont(Attributes attributes) {
        FontInfo font = new FontInfo();
        String names = attributes.getValue("name");
        String[] tabName = names.split(",");
        for (int i = 0; i < tabName.length; ++i) {
            tabName[i] = tabName[i].replace('\'', '\"');
        }
        font.setNames(tabName);
        if (XMLHelper.hasAttribute(attributes, "size")) {
            font.setSize(Integer.parseInt(attributes.getValue("size")));
            String val = attributes.getValue("unit");
            font.setUnit(val == null ? "%" : val);
        }
        font.setStyle(attributes.getValue("style"));
        if (font.getStyle() == null) {
            font.setStyle("normal");
        }
        font.setWeight(attributes.getValue("weight"));
        if (font.getWeight() == null) {
            font.setWeight("normal");
        }
        return font;
    }

    public ColorInfo createColor(Attributes attributes) {
        ColorInfo color = new ColorInfo();
        color.setR(Integer.parseInt(attributes.getValue("r")));
        color.setG(Integer.parseInt(attributes.getValue("g")));
        color.setB(Integer.parseInt(attributes.getValue("b")));
        return color;
    }
}

