/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.content;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.xissweb.data.content.ContentInfoIdentifiable;
import org.xissweb.data.content.HtmlContentEnabled;
import org.xissweb.data.content.HtmlContentHelper;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.data.content.ImageIterator;
import org.xissweb.data.content.SectionInfo;
import org.xissweb.data.content.SlideShowRefInfo;
import org.xissweb.xml.XMLHelper;

public class SlideShowContentInfo
implements ContentInfoIdentifiable {
    private File file;
    private String encoding;
    private String imagesDirName;
    private String thumbnailsDirName;
    private String name;
    private Title title;
    private SlideShowRefInfo previous;
    private SlideShowRefInfo next;
    private ArrayList sections;
    private Description description;

    public SlideShowContentInfo() {
        this.sections = new ArrayList();
        this.title = new Title();
    }

    public SlideShowContentInfo(String name, String imagesDirName, String thumbnailsDirName) {
        this.name = name;
        this.imagesDirName = imagesDirName;
        this.thumbnailsDirName = thumbnailsDirName;
        this.sections = new ArrayList();
        this.sections.add(new SectionInfo());
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public List getSections() {
        return this.sections;
    }

    public void setSections(List images) {
        this.sections.clear();
        this.sections.addAll(images);
    }

    public void addSection(SectionInfo section) {
        this.sections.add(section);
    }

    public void insertSectionAt(SectionInfo section, int index) {
        this.sections.add(index, section);
    }

    public int sectionIndex(SectionInfo section) {
        return this.sections.indexOf(section);
    }

    public void removeSection(SectionInfo section) {
        this.sections.remove(section);
    }

    public void moveSectionAfter(SectionInfo sectionToMove, SectionInfo sectionBefore) {
        int oldIndex = this.sectionIndex(sectionToMove);
        int index = sectionBefore == null ? 0 : this.sectionIndex(sectionBefore) + 1;
        this.insertSectionAt(sectionToMove, index);
        this.sections.remove(oldIndex);
    }

    public boolean resetImageNumber() {
        boolean updated = false;
        int n = 1;
        Iterator iter = this.imageIterator();
        while (iter.hasNext()) {
            ImageInfo iInfo = (ImageInfo)iter.next();
            if (iInfo.getNumber() != n) {
                iInfo.setNumber(n);
                updated = true;
            }
            ++n;
        }
        return updated;
    }

    public String getImagesDirName() {
        return this.imagesDirName;
    }

    public void setImagesDirName(String imagesDirName) {
        this.imagesDirName = imagesDirName;
    }

    public Object getIdentifier() {
        return this.getFile();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SlideShowRefInfo getNext() {
        return this.next;
    }

    public void setNext(SlideShowRefInfo nxt) {
        this.next = nxt;
    }

    public void setNext(String href, String text) {
        if (this.getNext() == null) {
            this.next = new SlideShowRefInfo(href, text, "NEXT");
        } else {
            this.next.setHref(href);
            this.next.setText(text);
        }
    }

    public SlideShowRefInfo getPrevious() {
        return this.previous;
    }

    public void setPrevious(SlideShowRefInfo prev) {
        this.previous = prev;
    }

    public void removeLink(SlideShowRefInfo link) {
        if (link.isNextLink()) {
            this.next = null;
        } else if (link.isPreviousLink()) {
            this.previous = null;
        }
    }

    public void setPrevious(String href, String text) {
        if (this.getPrevious() == null) {
            this.previous = new SlideShowRefInfo(href, text, "PREVIOUS");
        } else {
            this.previous.setHref(href);
            this.previous.setText(text);
        }
    }

    public String getThumbnailsDirName() {
        return this.thumbnailsDirName;
    }

    public void setThumbnailsDirName(String thumbnailsDirName) {
        this.thumbnailsDirName = thumbnailsDirName;
    }

    public Title getTitle() {
        if (this.title == null) {
            this.title = new Title();
        }
        return this.title;
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = new Description();
        }
        return this.description;
    }

    public boolean hasPreviousLink() {
        return this.previous != null;
    }

    public boolean hasNextLink() {
        return this.next != null;
    }

    public int linkCount() {
        int count = 0;
        if (this.hasNextLink()) {
            ++count;
        }
        if (this.hasPreviousLink()) {
            ++count;
        }
        return count;
    }

    public Iterator imageIterator() {
        return new ImageIterator(this);
    }

    public ImageInfo retrievesOrCreatesImageInfo(String name) {
        ImageInfo image = null;
        Iterator i = this.sections.iterator();
        while (i.hasNext() && image == null) {
            image = ((SectionInfo)i.next()).getImageInfoByName(name);
        }
        if (image == null) {
            image = new ImageInfo(name, -1);
            ((SectionInfo)this.sections.get(this.sections.size() - 1)).addImage(image);
        }
        return image;
    }

    public int maxNumber() {
        return ((SectionInfo)this.sections.get(this.sections.size() - 1)).maxNumber();
    }

    public boolean removeUnexistingImages() {
        boolean removed = false;
        Iterator i = this.sections.iterator();
        while (i.hasNext()) {
            boolean rm = ((SectionInfo)i.next()).removeUnexistingImages();
            removed = removed || rm;
        }
        if (removed) {
            int msgNum = 1;
            Iterator i2 = this.sections.iterator();
            while (i2.hasNext()) {
                msgNum = ((SectionInfo)i2.next()).countImages(msgNum);
            }
        }
        return removed;
    }

    public String toString() {
        if (this.getTitle().getValue() != null && this.getTitle().getValue().length() > 0) {
            return this.getTitle().getValue();
        }
        return this.name;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public class Description
    implements HtmlContentEnabled {
        private String description = "";
        private Document htmlDescription = null;

        Description() {
        }

        public String getStringValue() {
            return this.description;
        }

        public Document getHtmlValue() {
            return this.htmlDescription;
        }

        public boolean isHtmlContent() {
            return this.htmlDescription != null && this.description == null;
        }

        public void setHtmlContent(boolean htmlContent, String encoding) {
            if (htmlContent) {
                this.htmlDescription = HtmlContentHelper.toDocument("htmlDescription", this.description, encoding);
            } else {
                this.description = XMLHelper.valueOf(this.htmlDescription, encoding, false);
                this.htmlDescription = null;
            }
        }

        public void setHtmlValue(Document document) {
            this.htmlDescription = document;
            this.description = null;
        }

        public void setStringValue(String value) {
            this.description = value;
            this.htmlDescription = null;
        }
    }

    public class Title {
        private String value = "";

        Title() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

