/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.image;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ReplicateScaleFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import org.xissweb.image.ImageData;

public class ImageHelper
extends JApplet
implements ImageObserver {
    private static final long serialVersionUID = 7351595443838625253L;
    public static final int LOW_QUALITY = 0;
    public static final int HIGH_QUILITY = 1;
    public static final int RECTANGLE_SHAPE = 0;
    public static final int SQUARE_SHAPE = 1;
    public static final int PIXEL_UNIT = 0;
    public static final int PERCENT_UNIT = 1;
    private BufferedImage bImage;
    private Graphics2D graphics;

    public static BufferedImage readImage(File imageFile) {
        BufferedImage bImg = null;
        ImageData imgData = new ImageData(imageFile);
        if (imgData.isJPEG()) {
            ImageIcon imgIc = new ImageIcon(imageFile.getAbsolutePath());
            bImg = new BufferedImage(imgData.getWidth(), imgData.getHeight(), 1);
            bImg.getGraphics().drawImage(imgIc.getImage(), 0, 0, null);
        } else {
            try {
                bImg = ImageIO.read(imageFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bImg;
    }

    public static Dimension imageSize(int width, int height, int max) {
        Dimension dim = new Dimension(width, height);
        if (max != 0) {
            int maxDim = Math.max(width, height);
            float factor = (float)max * 1.0f / (float)maxDim;
            dim.setSize((float)width * factor, (float)height * factor);
        }
        return dim;
    }

    public static Dimension imageSize(int width, int height, int maxW, int maxH) {
        return height > width ? ImageHelper.imageSize(width, height, maxH) : ImageHelper.imageSize(width, height, maxW);
    }

    public void createEmptyImage(int width, int height, int type) {
        this.bImage = new BufferedImage(width, height, type);
        this.graphics = this.bImage.createGraphics();
        this.graphics.clearRect(0, 0, width, height);
    }

    public void createImage(File imageFile) throws IOException {
        this.bImage = ImageHelper.readImage(imageFile);
        this.graphics = this.bImage.createGraphics();
    }

    public void drawImage(File imageFile, int width, int height, int x, int y) throws IOException {
        this.drawImage(this.resize(imageFile, width, height, 1), x, y);
    }

    public void drawImage(Image image, int x, int y) {
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.drawImage(image, x, y, null);
    }

    public synchronized void createImage(File imgFile, File destination, String type, int width, int height, int quality) throws IOException {
        this.createEmptyImage(width, height, 1);
        this.drawImage(this.resize(imgFile, width, height, quality), 0, 0);
        this.save(destination, type);
    }

    public void save(File destination, String imageType) throws IOException {
        FileOutputStream fileOut = new FileOutputStream(destination);
        ImageOutputStream out = ImageIO.createImageOutputStream(fileOut);
        Iterator<ImageWriter> i = ImageIO.getImageWritersByFormatName(imageType);
        ImageWriter iw = i.next();
        iw.setOutput(out);
        iw.write(this.bImage);
        out.close();
        fileOut.close();
    }

    public synchronized Image resize(File imageFile, int width, int height, int quality) throws IOException {
        BufferedImage bImg = ImageHelper.readImage(imageFile);
        Image resultImage = null;
        ReplicateScaleFilter filter = null;
        switch (quality) {
            case 0: {
                filter = new ReplicateScaleFilter(width, height);
                break;
            }
            case 1: {
                filter = new AreaAveragingScaleFilter(width, height);
            }
        }
        resultImage = this.createImage(new FilteredImageSource(bImg.getSource(), filter));
        return resultImage;
    }
}

