/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.util.input;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.util.input.ValueChecker;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;

public class InputDialog
extends JDialog
implements CaretListener,
KeyListener {
    private static final long serialVersionUID = -1691624088131272608L;
    private static final String ERROR_ICON = "/images/common/error.png";
    public static final int CONFIRMATION_ACTION = 0;
    public static final int ABORT_ACTION = 1;
    private int actonPerformed = 1;
    private String value = null;
    private ValueChecker valueChecker;
    private TextDisplayer textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
    private JPanel jContentPane = null;
    private JLabel messageLabel = null;
    private JPanel commandPanel = null;
    private JButton okButton = null;
    private JButton abortButton = null;
    private JPanel inputPanel = null;
    private JTextField inputTextField = null;
    private JLabel errorLabel = null;

    public InputDialog(Frame frame) {
        super(frame);
        this.initialize();
    }

    public InputDialog(Frame frame, String title, String message, Icon icon, ValueChecker valueChecker, String errorMessage, String initialValue) {
        this(frame);
        this.initParams(title, message, icon, valueChecker, errorMessage, initialValue);
    }

    public void show(String title, String message, Icon icon, ValueChecker valueChecker, String errorMessage, String initialValue) {
        this.initParams(title, message, icon, valueChecker, errorMessage, initialValue);
        this.setVisible(true);
    }

    private void initParams(String title, String message, Icon icon, ValueChecker valueChecker, String errorMessage, String initialValue) {
        this.setTitle(title);
        this.setMessage(message);
        this.setIcon(icon);
        this.valueChecker = valueChecker;
        this.setErrorMessage(errorMessage);
        this.errorLabel.setVisible(false);
        this.getInputTextField().setText(initialValue);
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    public void setIcon(Icon icon) {
        this.messageLabel.setIcon(icon);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorLabel.setText(errorMessage);
    }

    public void setInitialtValue(String value) {
        this.getInputTextField().setText(value);
    }

    public int getActonPerformed() {
        return this.actonPerformed;
    }

    public ValueChecker getValueChecker() {
        return this.valueChecker;
    }

    public void setValueChecker(ValueChecker valueChecker) {
        this.valueChecker = valueChecker;
        this.checkValue(this.getInputTextField().getText());
    }

    public String getValue() {
        return this.value;
    }

    private void checkValue(String text) {
        if (this.valueChecker != null && !this.valueChecker.checkValue(text)) {
            this.errorLabel.setVisible(true);
            this.okButton.setEnabled(false);
        } else {
            this.errorLabel.setVisible(false);
            this.okButton.setEnabled(true);
        }
    }

    private void initialize() {
        this.setModal(true);
        this.setBounds(new Rectangle(0, 0, 350, 150));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getCommandPanel(), "South");
            this.jContentPane.add((Component)this.getInputPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getCommandPanel() {
        if (this.commandPanel == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setAlignment(2);
            this.commandPanel = new JPanel();
            this.commandPanel.setLayout(flowLayout1);
            this.commandPanel.add((Component)this.getOkButton(), null);
            this.commandPanel.add((Component)this.getAbortButton(), null);
        }
        return this.commandPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.textDisplayer.register(this.okButton, "ok.button");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InputDialog.this.doOk();
                }
            });
        }
        return this.okButton;
    }

    void doOk() {
        this.actonPerformed = 0;
        this.value = this.inputTextField.getText();
        this.setVisible(false);
    }

    private JButton getAbortButton() {
        if (this.abortButton == null) {
            this.abortButton = new JButton();
            this.textDisplayer.register(this.abortButton, "abort.button");
            this.abortButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InputDialog.this.doAbort();
                }
            });
        }
        return this.abortButton;
    }

    void doAbort() {
        this.actonPerformed = 1;
        this.value = null;
        this.setVisible(false);
    }

    private JPanel getInputPanel() {
        if (this.inputPanel == null) {
            this.messageLabel = new JLabel();
            this.errorLabel = new JLabel();
            this.errorLabel.setIcon(XissWebUI.getIcon(ERROR_ICON));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridheight = 1;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.anchor = 16;
            gridBagConstraints2.weighty = 10.0;
            gridBagConstraints2.insets = new Insets(5, 15, 5, 15);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridheight = 1;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints1.gridwidth = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weighty = 10.0;
            gridBagConstraints.gridwidth = 1;
            this.inputPanel = new JPanel();
            this.inputPanel.setLayout(new GridBagLayout());
            this.inputPanel.add((Component)this.messageLabel, gridBagConstraints);
            this.inputPanel.add((Component)this.errorLabel, gridBagConstraints1);
            this.inputPanel.add((Component)this.getInputTextField(), gridBagConstraints2);
        }
        return this.inputPanel;
    }

    private JTextField getInputTextField() {
        if (this.inputTextField == null) {
            this.inputTextField = new JTextField();
            this.inputTextField.setPreferredSize(new Dimension(150, 20));
            this.inputTextField.addCaretListener(this);
            this.inputTextField.addKeyListener(this);
        }
        return this.inputTextField;
    }

    public void caretUpdate(CaretEvent e) {
        this.checkValue(this.inputTextField.getText());
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent e) {
        this.checkValue(this.inputTextField.getText());
    }
}

