/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.tab;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import org.xissweb.gui.tab.CloseTabIcon;
import org.xissweb.gui.tab.event.CloseEvent;
import org.xissweb.gui.tab.event.CloseListener;

public class CloseTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 9187583581224001660L;
    private static final int CLOSE_ICON_GAP = 3;
    private int closeIcondGap = -1;
    static /* synthetic */ Class class$org$xissweb$gui$tab$event$CloseListener;

    public CloseTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.init();
    }

    public CloseTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.init();
    }

    public CloseTabbedPane() {
        this.init();
    }

    public void setExtraIconAt(int index, Icon icon) {
        super.setIconAt(index, new CloseTabIcon(icon, this));
    }

    public Icon getExtraIconAt(int index) {
        CloseTabIcon ic = (CloseTabIcon)super.getIconAt(index);
        return ic.getTabIcon();
    }

    public int getCloseIcondGap() {
        return this.closeIcondGap;
    }

    public void setCloseIcondGap(int closeIcondGap) {
        this.closeIcondGap = closeIcondGap;
    }

    public void addTab(String title, Component component) {
        this.addTab(title, component, null);
    }

    public void addTab(String title, Component component, Icon extraIcon) {
        CloseTabIcon cIcon = new CloseTabIcon(extraIcon, this);
        super.addTab(title, cIcon, component);
    }

    public void insertTab(String title, Component component, Icon extraIcon, int index) {
        super.insertTab(title, new CloseTabIcon(extraIcon, this), component, null, index);
    }

    public synchronized void addCloseListener(CloseListener l) {
        this.listenerList.add(class$org$xissweb$gui$tab$event$CloseListener == null ? (class$org$xissweb$gui$tab$event$CloseListener = CloseTabbedPane.class$("org.xissweb.gui.tab.event.CloseListener")) : class$org$xissweb$gui$tab$event$CloseListener, l);
    }

    public void addDefaultCloseListener() {
        this.addCloseListener(new CloseListener(){

            public void performClose(CloseEvent event) {
                CloseTabbedPane.this.removeTabAt(event.getTabIndex());
            }
        });
    }

    int closeIconGap() {
        int gap = this.getCloseIcondGap();
        if (gap == -1) {
            gap = 3;
        }
        return gap;
    }

    private void init() {
        this.setCloseIcondGap(-1);
        this.addCloseableIconListener();
    }

    private void addCloseableIconListener() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                CloseTabbedPane.this.onMouseClicked(e);
            }
        });
    }

    void onMouseClicked(MouseEvent e) {
        Rectangle rect;
        Icon ic;
        int tabIndex = this.getUI().tabForCoordinate(this, e.getX(), e.getY());
        if (tabIndex < 0) {
            return;
        }
        if (e.getButton() == 1 && e.getClickCount() == 1 && (ic = this.getIconAt(tabIndex)) instanceof CloseTabIcon && (rect = ((CloseTabIcon)ic).getBounds()).contains(e.getX(), e.getY())) {
            EventListener[] el = this.listenerList.getListeners(class$org$xissweb$gui$tab$event$CloseListener == null ? (class$org$xissweb$gui$tab$event$CloseListener = CloseTabbedPane.class$("org.xissweb.gui.tab.event.CloseListener")) : class$org$xissweb$gui$tab$event$CloseListener);
            for (int i = 0; i < el.length; ++i) {
                ((CloseListener)el[i]).performClose(new CloseEvent(e, tabIndex));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

