/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.skin.simple;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.xissweb.data.skin.FontInfo;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.font.CssFontChooser;
import org.xissweb.gui.editor.number.IntegerValueChecker;
import org.xissweb.gui.skin.simple.SkinEditor;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;

public class SkinFontPanel
extends JPanel {
    private static final long serialVersionUID = 220764305933899285L;
    static final int panelHeight = 90;
    private SkinEditor editor;
    private FontInfo fontInfo;
    private TextDisplayer textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$gui$skin$simple$SkinFontPanel == null ? (class$org$xissweb$gui$skin$simple$SkinFontPanel = SkinFontPanel.class$("org.xissweb.gui.skin.simple.SkinFontPanel")) : class$org$xissweb$gui$skin$simple$SkinFontPanel);
    private CssFontChooser cssFontChooser = null;
    private JLabel nameLabel = null;
    private JTextField sizeTextField = null;
    JComboBox unitComboBox = null;
    JComboBox styleComboBox = null;
    private JComboBox weightComboBox = null;
    private JLabel styleLabel = null;
    private JLabel weightLabel = null;
    private JLabel errorLabel = null;
    static /* synthetic */ Class class$org$xissweb$gui$skin$simple$SkinFontPanel;

    public SkinFontPanel() {
        this.initialize();
    }

    public void setEditor(SkinEditor editor) {
        this.editor = editor;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
        this.fillFields();
    }

    void unitComboBoxStateChanged() {
        if (this.editor != null && this.fontInfo != null) {
            String unit = null;
            switch (this.unitComboBox.getSelectedIndex()) {
                case 0: {
                    unit = "%";
                    break;
                }
                case 1: {
                    unit = "px";
                }
            }
            if (unit != null && !unit.equals(this.fontInfo.getUnit())) {
                this.fontInfo.setUnit(unit);
                this.editor.elementEdited(this.fontInfo);
            }
        }
    }

    void sizeTextModified() {
        if (this.fontInfo != null) {
            String txt = this.sizeTextField.getText();
            int check = IntegerValueChecker.checkValue(txt);
            if (check == 3) {
                this.errorLabel.setVisible(false);
                int value = Integer.parseInt(txt);
                if (value != this.fontInfo.getSize()) {
                    this.fontInfo.setSize(value);
                    this.editor.elementEdited(this.fontInfo);
                }
            } else {
                this.errorLabel.setText(IntegerValueChecker.getMessage(check));
                this.errorLabel.setVisible(true);
            }
        }
    }

    void chooseFont() {
        this.getCssFontChooser().setNames(this.fontInfo.getNames());
        this.getCssFontChooser().setVisible(true);
        String[] names = this.getCssFontChooser().getNames();
        if (names != null) {
            if (names.length != this.fontInfo.getNames().length) {
                this.fontInfo.setNames(names);
                this.setFontNameFiled();
                this.editor.elementEdited(this.fontInfo);
            } else {
                int i;
                ArrayList<String> list = new ArrayList<String>(names.length);
                for (i = 0; i < names.length; ++i) {
                    list.add(names[i]);
                }
                for (i = 0; i < names.length; ++i) {
                    if (list.contains(this.fontInfo.getNames()[i])) continue;
                    this.fontInfo.setNames(names);
                    this.setFontNameFiled();
                    this.editor.elementEdited(this.fontInfo);
                    break;
                }
            }
        }
    }

    void styleChanged() {
        if (this.editor != null && this.fontInfo != null) {
            String value = null;
            switch (this.styleComboBox.getSelectedIndex()) {
                case 0: {
                    value = "normal";
                    break;
                }
                case 1: {
                    value = "italic";
                }
            }
            if (value != null && !this.fontInfo.getStyle().equals(value)) {
                this.fontInfo.setStyle(value);
                this.editor.elementEdited(this.fontInfo);
            }
        }
    }

    void weightChanged() {
        if (this.editor != null && this.fontInfo != null) {
            String value = null;
            switch (this.weightComboBox.getSelectedIndex()) {
                case 0: {
                    value = "normal";
                    break;
                }
                case 1: {
                    value = "bold";
                }
            }
            if (value != null && !this.fontInfo.getWeight().equals(value)) {
                this.fontInfo.setWeight(value);
                this.editor.elementEdited(this.fontInfo);
            }
        }
    }

    private void setFontNameFiled() {
        StringBuffer buff = new StringBuffer();
        String[] names = this.fontInfo.getNames();
        for (int i = 0; i < names.length; ++i) {
            buff.append(names[i]);
            if (i >= names.length - 1) continue;
            buff.append(", ");
        }
        this.nameLabel.setText(buff.toString());
    }

    public void fillFields() {
        this.setFontNameFiled();
        this.sizeTextField.setText(Integer.toString(this.fontInfo.getSize()));
        if (this.fontInfo.getUnit().equals("%")) {
            this.unitComboBox.setSelectedIndex(0);
        } else if (this.fontInfo.getUnit().equals("px")) {
            this.unitComboBox.setSelectedIndex(1);
        }
        if (this.fontInfo.getStyle().equals("normal")) {
            this.styleComboBox.setSelectedIndex(0);
        } else if (this.fontInfo.getStyle().equals("italic")) {
            this.styleComboBox.setSelectedIndex(1);
        }
        if (this.fontInfo.getWeight().equals("normal")) {
            this.weightComboBox.setSelectedIndex(0);
        } else if (this.fontInfo.getWeight().equals("bold")) {
            this.weightComboBox.setSelectedIndex(1);
        }
    }

    private void initialize() {
        this.errorLabel = new JLabel();
        this.errorLabel.setIcon(XissWebUI.getIcon("/images/common/error.png"));
        this.errorLabel.setVisible(false);
        this.styleLabel = new JLabel();
        this.styleLabel.setText("style.label");
        this.textDisplayer.register(this.styleLabel, "style.label");
        this.weightLabel = new JLabel();
        this.weightLabel.setText("weight.label");
        this.textDisplayer.register(this.weightLabel, "weight.label");
        GridBagConstraints weightLabelConstraints = new GridBagConstraints();
        weightLabelConstraints.anchor = 13;
        weightLabelConstraints.gridx = 2;
        weightLabelConstraints.gridy = 2;
        weightLabelConstraints.insets = new Insets(5, 25, 5, 5);
        GridBagConstraints styleLabelConstraints = new GridBagConstraints();
        styleLabelConstraints.anchor = 13;
        styleLabelConstraints.gridx = 0;
        styleLabelConstraints.gridy = 2;
        styleLabelConstraints.insets = new Insets(5, 25, 5, 5);
        GridBagConstraints weightComboBoxConstraints = new GridBagConstraints();
        weightComboBoxConstraints.fill = 0;
        weightComboBoxConstraints.gridx = 3;
        weightComboBoxConstraints.gridy = 2;
        weightComboBoxConstraints.insets = new Insets(5, 5, 5, 25);
        weightComboBoxConstraints.anchor = 17;
        weightComboBoxConstraints.weightx = 1.0;
        GridBagConstraints styleComboBoxConstraints = new GridBagConstraints();
        styleComboBoxConstraints.fill = 0;
        styleComboBoxConstraints.insets = new Insets(5, 5, 5, 25);
        styleComboBoxConstraints.gridx = 1;
        styleComboBoxConstraints.gridy = 2;
        styleComboBoxConstraints.anchor = 17;
        styleComboBoxConstraints.weightx = 1.0;
        GridBagConstraints sizeTextFieldConstraints = new GridBagConstraints();
        sizeTextFieldConstraints.fill = 0;
        sizeTextFieldConstraints.anchor = 17;
        sizeTextFieldConstraints.gridheight = 1;
        sizeTextFieldConstraints.gridx = 2;
        sizeTextFieldConstraints.gridy = 0;
        sizeTextFieldConstraints.weightx = 1.0;
        sizeTextFieldConstraints.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints unitComboBoxConstraints = new GridBagConstraints();
        unitComboBoxConstraints.fill = 0;
        unitComboBoxConstraints.anchor = 17;
        unitComboBoxConstraints.gridheight = 1;
        unitComboBoxConstraints.gridx = 3;
        unitComboBoxConstraints.gridy = 0;
        unitComboBoxConstraints.weightx = 1.0;
        unitComboBoxConstraints.gridwidth = 1;
        unitComboBoxConstraints.weighty = 1.0;
        unitComboBoxConstraints.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints nameLabelConstraints = new GridBagConstraints();
        nameLabelConstraints.anchor = 13;
        nameLabelConstraints.gridheight = 1;
        nameLabelConstraints.gridwidth = 2;
        nameLabelConstraints.gridx = 0;
        nameLabelConstraints.gridy = 0;
        nameLabelConstraints.weighty = 0.0;
        nameLabelConstraints.weightx = 100.0;
        nameLabelConstraints.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints errorLabelConstraints = new GridBagConstraints();
        errorLabelConstraints.fill = 0;
        errorLabelConstraints.gridwidth = 4;
        errorLabelConstraints.gridx = 0;
        errorLabelConstraints.gridy = 1;
        errorLabelConstraints.insets = new Insets(5, 5, 5, 5);
        this.nameLabel = new JLabel();
        this.nameLabel.setText("Font family name");
        this.nameLabel.setHorizontalTextPosition(4);
        this.nameLabel.setFont(new Font("Dialog", 0, 12));
        this.nameLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                SkinFontPanel.this.chooseFont();
            }
        });
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(203, 105));
        this.add((Component)this.nameLabel, nameLabelConstraints);
        this.add((Component)this.getSizeTextField(), sizeTextFieldConstraints);
        this.add((Component)this.getUnitComboBox(), unitComboBoxConstraints);
        this.add((Component)this.errorLabel, errorLabelConstraints);
        this.add((Component)this.styleLabel, styleLabelConstraints);
        this.add((Component)this.getStyleComboBox(), styleComboBoxConstraints);
        this.add((Component)this.weightLabel, weightLabelConstraints);
        this.add((Component)this.getWeightComboBox(), weightComboBoxConstraints);
    }

    void setPanelSize(int width) {
        this.setPanelSize(width, 90);
    }

    void setPanelSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.setMaximumSize(new Dimension(width, height));
    }

    private CssFontChooser getCssFontChooser() {
        if (this.cssFontChooser == null) {
            this.cssFontChooser = new CssFontChooser(Main.get().getXissWeb());
        }
        return this.cssFontChooser;
    }

    private JTextField getSizeTextField() {
        if (this.sizeTextField == null) {
            this.sizeTextField = new JTextField();
            this.sizeTextField.setPreferredSize(new Dimension(40, 20));
            this.sizeTextField.setColumns(3);
            this.sizeTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    SkinFontPanel.this.sizeTextModified();
                }
            });
            this.sizeTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    SkinFontPanel.this.sizeTextModified();
                }
            });
        }
        return this.sizeTextField;
    }

    private JComboBox getUnitComboBox() {
        if (this.unitComboBox == null) {
            this.unitComboBox = new JComboBox();
            this.unitComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (SkinFontPanel.this.unitComboBox.isEnabled()) {
                        SkinFontPanel.this.unitComboBoxStateChanged();
                    }
                }
            });
            this.textDisplayer.registerCombo(this.unitComboBox, new String[]{"unit.percent", "unit.pixel"});
        }
        return this.unitComboBox;
    }

    private JComboBox getStyleComboBox() {
        if (this.styleComboBox == null) {
            this.styleComboBox = new JComboBox();
            this.styleComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (SkinFontPanel.this.styleComboBox.isEnabled()) {
                        SkinFontPanel.this.styleChanged();
                    }
                }
            });
            this.textDisplayer.registerCombo(this.styleComboBox, new String[]{"style.normal", "style.italic"});
        }
        return this.styleComboBox;
    }

    private JComboBox getWeightComboBox() {
        if (this.weightComboBox == null) {
            this.weightComboBox = new JComboBox();
            this.weightComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SkinFontPanel.this.weightChanged();
                }
            });
            this.textDisplayer.registerCombo(this.weightComboBox, new String[]{"weight.normal", "weight.bold"});
        }
        return this.weightComboBox;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

