/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.properties.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.number.IntegerValueChecker;
import org.xissweb.gui.properties.PropertyEditorObserver;
import org.xissweb.gui.properties.PropertyValueEditor;

public class PropertyNumberEditor
extends JPanel
implements PropertyValueEditor {
    private static final String ERROR_ICON = "/images/common/error.png";
    private static final long serialVersionUID = 2346087610315879948L;
    private JTextField valueField = null;
    private String propertyKey;
    private String initValue;
    private String defaultValue;
    private HashSet observers = new HashSet();
    private JLabel warningLabel = null;

    public PropertyNumberEditor() {
        this.initialize();
    }

    private void initialize() {
        this.warningLabel = new JLabel();
        this.warningLabel.setIcon(XissWebUI.getIcon(ERROR_ICON));
        this.warningLabel.setFont(new Font("Arial", 3, 12));
        this.warningLabel.setName("warningLabel");
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setVgap(10);
        this.setLayout(flowLayout);
        this.add((Component)this.getValueField(), null);
        this.add((Component)this.warningLabel, null);
        this.warningLabel.setVisible(false);
    }

    private JTextField getValueField() {
        if (this.valueField == null) {
            this.valueField = new JTextField();
            this.valueField.setPreferredSize(new Dimension(230, 20));
            this.valueField.setName("valueField");
            this.valueField.setBackground(new Color(225, 232, 240));
            this.valueField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    PropertyNumberEditor.this.textChanged();
                }
            });
            this.valueField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    PropertyNumberEditor.this.textChanged();
                }
            });
        }
        return this.valueField;
    }

    void textChanged() {
        int status = IntegerValueChecker.checkValue(this.valueField.getText());
        if (status == -1 || status == 0) {
            this.warningLabel.setText(IntegerValueChecker.getMessage(status));
            this.warningLabel.setVisible(true);
        } else {
            this.warningLabel.setVisible(false);
            this.notifyObservers(this.valueField.getText());
        }
    }

    public void registerEditorObserver(PropertyEditorObserver observer) {
        this.observers.add(observer);
    }

    private void notifyObservers(String value) {
        Iterator i = this.observers.iterator();
        while (i.hasNext()) {
            PropertyEditorObserver observer = (PropertyEditorObserver)i.next();
            observer.propertyValueEdited(this.propertyKey, value);
        }
    }

    public void initEdition(String propKey, String value, String defaultValue, String[] values) {
        this.propertyKey = propKey;
        this.initValue = value;
        this.defaultValue = defaultValue;
        this.reset();
    }

    public void reset() {
        if (this.initValue != null) {
            this.valueField.setText(this.initValue);
        } else {
            this.valueField.setText(this.defaultValue);
        }
    }
}

